/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BooleanListEntry
extends TooltipListEntry<Boolean>
implements IChildListEntry {
    protected boolean displayedValue;
    protected final Button buttonWidget;
    protected final List<GuiEventListener> widgets;
    protected final List<GuiEventListener> childWidgets;
    @NotNull
    protected Function<Boolean, Component> yesNoSupplier = bool -> Component.m_237115_((String)("simpleconfig.format.bool.yes_no." + bool));

    @Deprecated
    @ApiStatus.Internal
    public BooleanListEntry(Component fieldName, boolean value) {
        super(fieldName);
        this.setValue(value);
        this.setOriginal(value);
        this.displayedValue = value;
        this.buttonWidget = new Button.Builder(GameNarrator.f_93310_, widget -> {
            if (!this.m_93696_()) {
                this.preserveState();
                this.m_93692_(true);
            }
            this.displayedValue = !this.displayedValue;
        }).m_252987_(0, 0, 150, 20).m_253136_();
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.buttonWidget, this.sideButtonReference});
        this.childWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.buttonWidget});
        this.hotKeyActionTypes.add(HotKeyActionTypes.BOOLEAN_TOGGLE);
    }

    public void setYesNoSupplier(@NotNull Function<Boolean, Component> yesNoSupplier) {
        this.yesNoSupplier = yesNoSupplier;
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        if (!isFocused) {
            this.buttonWidget.m_93692_(false);
        }
    }

    @Override
    public Boolean getDisplayedValue() {
        return this.displayedValue;
    }

    @Override
    public void setDisplayedValue(Boolean value) {
        this.displayedValue = value;
    }

    @Override
    public boolean shouldRenderEditable() {
        if (this.isEditingHotKeyAction()) {
            return this.getHotKeyActionType() == HotKeyActionTypes.ASSIGN.cast();
        }
        return super.shouldRenderEditable();
    }

    @Override
    public void renderChildEntry(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.buttonWidget.f_93623_ = this.shouldRenderEditable();
        this.buttonWidget.m_252865_(x);
        this.buttonWidget.m_253211_(y);
        this.buttonWidget.m_93674_(w);
        this.buttonWidget.setHeight(h);
        this.buttonWidget.m_93666_(this.getYesNoText(this.displayedValue));
        this.buttonWidget.m_88315_(gg, mouseX, mouseY, delta);
    }

    public Component getYesNoText(boolean bool) {
        return this.yesNoSupplier.apply(bool);
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.buttonWidget.m_5953_((double)mouseX, (double)mouseY)) {
            return Optional.empty();
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isChildSubEntry() ? this.childWidgets : this.widgets;
    }

    @Override
    public String seekableValueText() {
        return BooleanListEntry.getUnformattedString(this.yesNoSupplier.apply(this.getDisplayedValue()));
    }
}

