/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.core.entry.BeanEntry;
import endorh.simpleconfig.core.entry.BeanProxy;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.entries.CaptionedSubCategoryListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanListEntry<B>
extends TooltipListEntry<B>
implements IExpandable,
IEntryHolder {
    CaptionedSubCategoryListEntry.CaptionWidget<BeanListEntry<B>> label;
    protected final BeanProxy<B> proxy;
    protected final List<AbstractConfigField<?>> heldEntries;
    protected final List<BeanPropertyCell> cells;
    protected final Map<String, AbstractConfigListEntry<?>> entries;
    protected final List<GuiEventListener> children;
    protected final List<GuiEventListener> expandedChildren;
    @Nullable
    protected AbstractConfigListEntry<?> captionEntry;
    protected final Rectangle captionEntryArea = new Rectangle();
    @Nullable
    protected Function<B, Icon> iconProvider;
    @Nullable
    protected Icon icon;
    protected boolean isOverrideEquals;
    protected ToggleAnimator expandAnimator = new ToggleAnimator();
    private boolean expanded;

    public BeanListEntry(Component fieldName, B value, BeanProxy<B> proxy2, Map<String, AbstractConfigListEntry<?>> entries2, @Nullable String caption, @Nullable Function<B, Icon> iconProvider) {
        super(fieldName);
        this.proxy = proxy2;
        this.entries = entries2;
        this.heldEntries = Lists.newArrayList(entries2.values());
        this.cells = Lists.newArrayList();
        this.label = new CaptionedSubCategoryListEntry.CaptionWidget<BeanListEntry>(this);
        if (caption != null && entries2.get(caption) instanceof IChildListEntry) {
            this.captionEntry = entries2.get(caption);
            this.captionEntry.setChildSubEntry(true);
            this.captionEntry.setParentEntry(this);
            this.heldEntries.remove(this.captionEntry);
            this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.captionEntry, this.sideButtonReference});
            this.expandedChildren = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.captionEntry, this.sideButtonReference});
            this.expandedChildren.addAll(this.heldEntries);
            this.heldEntries.add(0, this.captionEntry);
        } else {
            this.children = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.sideButtonReference});
            this.expandedChildren = Lists.newArrayList((Object[])new GuiEventListener[]{this.label, this.sideButtonReference});
            this.expandedChildren.addAll(this.heldEntries);
        }
        entries2.forEach((n, e) -> {
            e.setParentEntry(this);
            e.setSubEntry(true);
            e.setName((String)n);
            if (e != this.captionEntry) {
                BeanPropertyCell cell = new BeanPropertyCell(this, (AbstractConfigField<?>)e);
                e.setNavigableParent(cell);
                this.cells.add(cell);
            }
        });
        this.iconProvider = iconProvider;
        this.setValue(value);
        this.setDisplayedValue(value);
        this.isOverrideEquals = !proxy2.createFrom(value).equals(value);
    }

    public boolean isOverrideEquals() {
        return this.isOverrideEquals;
    }

    public void setOverrideEquals(boolean overrideEquals) {
        this.isOverrideEquals = overrideEquals;
    }

    @Override
    public B getDisplayedValue() {
        return this.proxy.createFromGUI(this.getDefaultValue(), Maps.transformValues(this.entries, AbstractConfigField::getDisplayedValue));
    }

    @Override
    public void setDisplayedValue(B value) {
        this.entries.forEach((name, entry) -> {
            try {
                AbstractConfigListEntry e = entry;
                e.setDisplayedValue(this.proxy.getGUI(value, (String)name));
            }
            catch (ClassCastException e) {
                throw new BeanEntry.ConfigBeanAccessException("Invalid Bean property type: " + this.proxy.getPropertyName((String)name), e);
            }
        });
    }

    @Override
    public void setOriginal(@Nullable B original) {
        super.setOriginal(original);
        if (original != null) {
            this.entries.forEach((name, entry) -> {
                try {
                    AbstractConfigListEntry e = entry;
                    e.setOriginal(this.proxy.getGUI(original, (String)name));
                }
                catch (ClassCastException e) {
                    throw new BeanEntry.ConfigBeanAccessException("Invalid Bean property type: " + this.proxy.getPropertyName((String)name), e);
                }
            });
        }
    }

    @Override
    public boolean areEqual(B value, B other) {
        if (this.isOverrideEquals) {
            for (Map.Entry<String, AbstractConfigListEntry<?>> e : this.entries.entrySet()) {
                AbstractConfigListEntry<?> entry = e.getValue();
                if (entry.areEqual(this.proxy.getGUI(value, e.getKey()), this.proxy.getGUI(other, e.getKey()))) continue;
                return false;
            }
            return true;
        }
        return super.areEqual(value, other);
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Icon icon;
        this.label.m_93692_(this.m_93696_() && this.m_7222_() == this.label);
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Icon icon2 = icon = this.icon != null ? this.icon : SimpleConfigIcons.Entries.EXPAND;
        icon.renderCentered(gg, x - 20, y, 18, 18, this.icon != null ? 0 : (this.label.area.contains(mouseX, mouseY) ? 2 : 0) + (this.isExpanded() ? 1 : 0));
        boolean animating = this.expandAnimator.isInProgress();
        if (this.isExpanded() || animating) {
            if (animating) {
                DynamicEntryListWidget<?> parent = this.getEntryList();
                ScissorsHandler.INSTANCE.pushScissor(new Rectangle(parent.left, this.entryArea.y, parent.right - parent.left, this.getItemHeight()));
            }
            int yy = y + 24;
            for (AbstractConfigListEntry<?> entry : this.entries.values()) {
                if (!entry.isShown() || entry == this.captionEntry) continue;
                entry.render(gg, -1, x + 14, yy, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered && this.m_7222_() == entry, delta);
                yy += entry.getItemHeight();
            }
            if (animating) {
                ScissorsHandler.INSTANCE.popScissor();
            }
        }
        this.label.render(gg, mouseX, mouseY, delta);
    }

    @Override
    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        super.renderField(gg, fieldX, fieldY, fieldWidth, fieldHeight, x, y, entryWidth, entryHeight, index, mouseX, mouseY, delta);
        this.label.area.setBounds(x - 24, y, this.captionEntry != null ? entryWidth - fieldWidth - 5 : entryWidth - 2, 20);
        if (this.captionEntry != null) {
            ((IChildListEntry)((Object)this.captionEntry)).renderChild(gg, fieldX, fieldY, fieldWidth, fieldHeight, mouseX, mouseY, delta);
            this.captionEntryArea.setBounds(fieldX, fieldY, fieldWidth, fieldHeight);
        } else {
            this.captionEntryArea.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.heldEntries;
    }

    @Override
    protected List<EntryError> computeErrors() {
        List<EntryError> errors = super.computeErrors();
        errors.addAll(IEntryHolder.super.getErrors());
        return errors;
    }

    @Override
    public void updateFocused(boolean isFocused) {
        super.updateFocused(isFocused);
        for (AbstractConfigField<?> entry : this.heldEntries) {
            entry.updateFocused((this.isExpanded() || entry == this.captionEntry) && isFocused && this.m_7222_() == entry);
        }
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded, boolean recurse, boolean animate) {
        if (this.expanded != expanded) {
            if (animate) {
                this.expandAnimator.setLength(Math.min(250L, (long)this.entries.size() * 25L));
                this.expandAnimator.setEaseOutTarget(expanded);
            } else {
                this.expandAnimator.stopAndSet(expanded);
            }
        }
        this.expanded = expanded;
        if (recurse) {
            this.heldEntries.stream().filter(e -> e instanceof IExpandable).forEach(e -> ((IExpandable)((Object)e)).setExpanded(expanded, true));
        }
    }

    @Override
    protected void doExpandParents(AbstractConfigField<?> entry) {
        boolean expanded = this.isExpanded();
        super.doExpandParents(entry);
        if (entry == this.captionEntry) {
            this.setExpanded(expanded);
        }
    }

    @Override
    public int getFocusedScroll() {
        GuiEventListener listener = this.m_7222_();
        if (!this.heldEntries.contains(listener)) {
            return 0;
        }
        int y = 24;
        int index = this.heldEntries.indexOf(listener);
        if (index >= 0) {
            for (AbstractConfigField<?> entry : this.heldEntries.subList(0, index)) {
                y += entry.getItemHeight();
            }
        }
        if (listener instanceof IExpandable) {
            y += ((IExpandable)listener).getFocusedScroll();
        }
        return y;
    }

    @Override
    public int getFocusedHeight() {
        GuiEventListener listener = this.m_7222_();
        if (listener instanceof IExpandable) {
            return ((IExpandable)listener).getFocusedHeight();
        }
        if (listener instanceof AbstractConfigListEntry) {
            return ((AbstractConfigListEntry)listener).getItemHeight();
        }
        return 20;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        String[] split = DOT.split(path, 2);
        AbstractConfigListEntry<?> entry = this.entries.get(split[0]);
        if (split.length == 1) {
            return entry;
        }
        if (entry instanceof IEntryHolder) {
            return ((IEntryHolder)((Object)entry)).getEntry(split[1]);
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        this.entries.values().forEach(AbstractConfigField::tick);
        this.icon = this.iconProvider != null ? this.iconProvider.apply(this.getDisplayedValue()) : null;
    }

    @Override
    protected int getPreviewCaptionOffset() {
        return this.captionEntry != null ? super.getPreviewCaptionOffset() : 0;
    }

    @Override
    public int getExtraScrollHeight() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        if (this.captionEntry != null) {
            list.add(i + this.captionEntry.getExtraScrollHeight());
        }
        if (this.isExpanded()) {
            for (AbstractConfigListEntry<?> entry : this.entries.values()) {
                if (entry == this.captionEntry) continue;
                i += entry.getItemHeight();
                if (entry.getExtraScrollHeight() <= 0) continue;
                list.add(i + entry.getExtraScrollHeight());
            }
            list.add(i);
        }
        return list.stream().max(Integer::compare).orElse(0) - i;
    }

    @Override
    public Rectangle getSelectionArea() {
        DynamicEntryListWidget<?> parent = this.getEntryList();
        return new Rectangle(parent.left, this.entryArea.y, parent.right - parent.left, 20);
    }

    @Override
    public int getItemHeight() {
        if (this.isExpanded() || this.expandAnimator.isInProgress()) {
            int i = 24;
            for (AbstractConfigListEntry<?> entry : this.entries.values()) {
                if (!entry.isShown() || entry == this.captionEntry) continue;
                i += entry.getItemHeight();
            }
            return Math.round(this.expandAnimator.getEaseOut() * (float)(i - 24)) + 24;
        }
        return 24;
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        List<ISeekableComponent> children = this.entries.values().stream().map(e -> e).collect(Collectors.toList());
        if (this.captionEntry != null) {
            children.add(0, this.captionEntry);
        }
        return children;
    }

    @Override
    public String seekableValueText() {
        return "";
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() == this.label && keyCode == 263 && this.isExpanded()) {
            this.setExpanded(false, Screen.m_96638_());
            BeanListEntry.playFeedbackTap(0.4f);
            return true;
        }
        if (keyCode == 262 && !this.isExpanded()) {
            this.setExpanded(true, Screen.m_96638_());
            BeanListEntry.playFeedbackTap(0.4f);
            return true;
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public Rectangle getNavigableArea() {
        return this.label.area;
    }

    @Override
    public List<INavigableTarget> getNavigableSubTargets() {
        return this.captionEntry != null ? Lists.newArrayList((Object[])new INavigableTarget[]{this, this.captionEntry}) : super.getNavigableSubTargets();
    }

    @Override
    public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
        return !onlyVisible || this.isExpanded() ? this.cells.stream().filter(c -> c.getEntry() != this.captionEntry).filter(c -> c.getEntry().isNavigable()).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.isExpanded() ? this.expandedChildren : this.children;
    }

    protected static class BeanPropertyCell
    implements INavigableTarget {
        private final INavigableTarget parent;
        private final AbstractConfigField<?> entry;
        private final List<GuiEventListener> listeners = new ArrayList<GuiEventListener>(1);

        public BeanPropertyCell(INavigableTarget parent, AbstractConfigField<?> entry) {
            this.parent = parent;
            this.entry = entry;
            this.listeners.add((GuiEventListener)entry);
        }

        @Override
        @Nullable
        public INavigableTarget getNavigableParent() {
            return this.parent;
        }

        public AbstractConfigField<?> getEntry() {
            return this.entry;
        }

        @Override
        public void navigate() {
            this.entry.navigate();
        }

        @Override
        @Nullable
        public INavigableTarget getLastSelectedNavigableSubTarget() {
            return this.entry.getLastSelectedNavigableSubTarget();
        }

        @Override
        public void setLastSelectedNavigableSubTarget(@Nullable INavigableTarget target) {
            this.entry.setLastSelectedNavigableSubTarget(target);
        }

        @Override
        public List<INavigableTarget> getNavigableSubTargets() {
            return this.entry.getNavigableSubTargets();
        }

        @Override
        public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
            return this.entry.getNavigableChildren(onlyVisible);
        }

        @Override
        public Rectangle getNavigableArea() {
            return this.entry.getNavigableArea();
        }

        @Override
        public Rectangle getRowArea() {
            return this.entry.getRowArea();
        }

        @Override
        public void applyFocusHighlight(int color, int length) {
            this.entry.applyFocusHighlight(color, length);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.listeners;
        }

        public boolean m_7282_() {
            return this.entry.m_7282_();
        }

        public void m_7897_(boolean dragging) {
            this.entry.m_7897_(dragging);
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.entry;
        }

        public void m_7522_(@Nullable GuiEventListener listener) {
        }
    }
}

