/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.entries.BaseListCell;
import endorh.simpleconfig.ui.gui.entries.CaptionedSubCategoryListEntry;
import endorh.simpleconfig.ui.gui.entries.TooltipListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.impl.EditHistory;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseListEntry<T, C extends BaseListCell<T>, Self extends BaseListEntry<T, C, Self>>
extends TooltipListEntry<List<T>>
implements IExpandable {
    @NotNull
    protected final List<C> cells;
    @NotNull
    protected List<GuiEventListener> widgets;
    @NotNull
    protected List<GuiEventListener> unexpandedWidgets;
    @NotNull
    protected List<GuiEventListener> expandedEmptyWidgets;
    protected boolean expanded;
    protected boolean deleteButtonEnabled;
    protected boolean insertInFront;
    protected int caret = -1;
    protected int cursor = -1;
    protected int hoverCursor = -1;
    protected int dragCursor = -1;
    protected int draggingOffset = -1;
    protected int cellControlsY = -1;
    protected ListCaptionWidget label;
    protected RedirectGuiEventListener labelReference;
    protected RedirectGuiEventListener sideButtonReferenceReference;
    protected EmptyPlaceholderWidget placeholder;
    @NotNull
    protected Function<Self, C> cellFactory;
    @Nullable
    protected Component[] addTooltip = new Component[]{Component.m_237115_((String)"simpleconfig.help.list.insert"), Component.m_237115_((String)"simpleconfig.help.list.insert:key")};
    @Nullable
    protected Component[] removeTooltip = new Component[]{Component.m_237115_((String)"simpleconfig.help.list.remove"), Component.m_237115_((String)"simpleconfig.help.list.remove:key")};
    protected Component[] moveTooltip = new Component[]{Component.m_237115_((String)"simpleconfig.help.list.move"), Component.m_237115_((String)"simpleconfig.help.list.move:drag"), Component.m_237115_((String)"simpleconfig.help.list.move:key")};
    protected int lastSelected = -1;
    protected Rectangle dragOverlayRectangle = new Rectangle();
    protected int dragMouseX;
    protected int dragMouseY;
    protected ToggleAnimator expandAnimator = new ToggleAnimator();
    protected ToggleAnimator heightAnimator = new ToggleAnimator();
    protected int lastHeight = -1;
    protected boolean captionControlsEnabled = false;
    protected int dragPlaceHolderColor = 0x42848484;
    protected int dragOverlayBackground = 0x64242424;

    public BaseListEntry(@NotNull Component fieldName, @NotNull Function<Self, C> cellFactory) {
        super(fieldName);
        this.setValue(Lists.newArrayList());
        this.cells = Lists.newArrayList();
        this.label = new ListCaptionWidget(this);
        this.labelReference = new RedirectGuiEventListener(this.label);
        this.sideButtonReferenceReference = new RedirectGuiEventListener(this.sideButtonReference);
        this.widgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.labelReference, this.sideButtonReferenceReference});
        this.placeholder = new EmptyPlaceholderWidget(this);
        this.unexpandedWidgets = Lists.newArrayList((Object[])new GuiEventListener[]{this.labelReference, this.sideButtonReferenceReference});
        this.expandedEmptyWidgets = (List)Util.m_137469_(new ArrayList<GuiEventListener>(this.widgets), l -> l.add(this.placeholder));
        this.cellFactory = cellFactory;
        this.acceptButton.setDefaultIcon(SimpleConfigIcons.Buttons.MERGE_ACCEPT_GROUP);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded, boolean recursive, boolean animate) {
        if (this.expanded != expanded) {
            if (animate) {
                this.expandAnimator.setLength(Math.min(250L, (long)this.cells.size() * 25L));
                this.expandAnimator.setEaseOutTarget(expanded);
            } else {
                this.expandAnimator.stopAndSet(expanded);
            }
            this.cells.forEach(expanded ? BaseListCell::onShown : BaseListCell::onHidden);
        }
        this.expanded = expanded;
        if (recursive) {
            this.cells.stream().filter(c -> c instanceof IExpandable).forEach(c -> ((IExpandable)((Object)c)).setExpanded(expanded, true));
        }
    }

    public boolean areCaptionControlsEnabled() {
        return this.captionControlsEnabled && this.isEditable();
    }

    public void setCaptionControlsEnabled(boolean enabled) {
        this.captionControlsEnabled = enabled;
    }

    @Override
    public void setHeadless(boolean headless) {
        super.setHeadless(headless);
        if (headless) {
            this.labelReference.setTarget(null);
            this.sideButtonReferenceReference.setTarget(null);
        } else {
            this.labelReference.setTarget(this.label);
            this.sideButtonReferenceReference.setTarget(this.sideButtonReference);
        }
    }

    @Override
    public void setValue(List<T> value) {
        if (!Objects.equals(this.getValue(), value)) {
            super.setValue(new ArrayList<T>(value));
        }
    }

    @Override
    public void setValueTransparently(List<T> value) {
        this.getScreen().getHistory().preserveState(EditHistory.EditRecord.of(this));
        this.setValue(value);
        if (this.isDisplayingValue()) {
            this.setDisplayedValue(value);
        }
    }

    @Override
    public void setOriginal(List<T> value) {
        super.setOriginal(new ArrayList<T>(value));
    }

    @Override
    public void setExternalValue(@Nullable List<T> value) {
        super.setExternalValue(value != null ? new ArrayList<T>(value) : null);
    }

    @Override
    public List<T> getDisplayedValue() {
        return this.cells.stream().map(BaseListCell::getValue).collect(Collectors.toList());
    }

    @Override
    public void setDisplayedValue(List<T> value) {
        this.cancelDrag();
        for (int i = 0; i < this.cells.size() && i < value.size(); ++i) {
            this.set(i, value.get(i));
        }
        while (this.cells.size() > value.size()) {
            this.remove(this.cells.size() - 1);
        }
        while (this.cells.size() < value.size()) {
            this.add(this.cells.size(), value.get(this.cells.size()));
        }
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public Self self() {
        return (Self)this;
    }

    public boolean isDeleteButtonEnabled() {
        return this.deleteButtonEnabled && this.isEditable();
    }

    public void setDeleteButtonEnabled(boolean enabled) {
        this.deleteButtonEnabled = enabled;
    }

    protected abstract C createCellWithValue(T var1);

    @NotNull
    public Function<Self, C> getCellFactory() {
        return this.cellFactory;
    }

    public void setCellFactory(@NotNull Function<Self, C> cellFactory) {
        this.cellFactory = cellFactory;
    }

    @Nullable
    public Component[] getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(@Nullable Component[] addTooltip) {
        this.addTooltip = addTooltip;
    }

    @Nullable
    public Component[] getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(@Nullable Component[] removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public int getItemHeight() {
        int c = this.getCaptionHeight() + 4;
        if (this.expanded || this.expandAnimator.isInProgress()) {
            int h = c + (this.cells.isEmpty() ? this.placeholder.h : this.cells.stream().mapToInt(BaseListCell::getCellHeight).sum());
            if (h != this.lastHeight) {
                this.heightAnimator.setOutputRange(this.lastHeight == -1 ? (float)h : (float)this.lastHeight, h);
                this.heightAnimator.resetTarget();
                this.lastHeight = h;
            }
            return Math.round(this.expandAnimator.getEaseOut() * (this.heightAnimator.getEaseOut() - (float)c)) + c;
        }
        return c;
    }

    @Override
    protected int getPreviewCaptionOffset() {
        return 0;
    }

    @Override
    @NotNull
    protected List<? extends GuiEventListener> getEntryListeners() {
        return this.expanded ? (this.cells.isEmpty() ? this.expandedEmptyWidgets : this.widgets) : this.unexpandedWidgets;
    }

    @Override
    public List<EntryError> getEntryErrors() {
        List<EntryError> errors = super.getEntryErrors();
        this.cells.stream().flatMap(c -> c.getErrors().stream()).forEach(errors::add);
        return errors;
    }

    public void addTransparently() {
        this.addTransparently(this.cells.size());
    }

    public void addTransparently(T element) {
        this.addTransparently(this.cells.size(), element);
    }

    public void addTransparently(int index) {
        this.addTransparently(index, null);
    }

    public void addTransparently(int index, T element) {
        if (index < 0 || index > this.cells.size()) {
            throw new IndexOutOfBoundsException("Cannot add element at position " + index + ", size: " + this.cells.size());
        }
        this.getScreen().getHistory().add(EditHistory.EditRecord.ListEditRecord.remove(this, (List)Util.m_137469_(new ArrayList(), l -> l.add(index))));
        this.add(index, element);
        this.preserveState();
    }

    public void add(int index, T element) {
        C cell;
        if (index < 0 || index > this.cells.size()) {
            throw new IndexOutOfBoundsException("Cannot add element at position " + index + ", size: " + this.cells.size());
        }
        Object object = cell = element == null ? (BaseListCell)this.cellFactory.apply(this.self()) : this.createCellWithValue(element);
        if (index < this.cells.size()) {
            int targetWidget = this.widgets.indexOf(this.cells.get(index));
            this.cells.add(index, cell);
            this.widgets.add(targetWidget, (GuiEventListener)cell);
        } else {
            this.cells.add(cell);
            this.widgets.add((GuiEventListener)cell);
        }
        ((BaseListCell)cell).onAdd();
    }

    public void remove(T element) {
        int index = this.getDisplayedValue().indexOf(element);
        if (index >= 0) {
            this.removeTransparently(index);
        }
    }

    public void removeTransparently(int index) {
        BaseListCell cell = (BaseListCell)this.cells.get(index);
        this.getScreen().getHistory().add(EditHistory.EditRecord.ListEditRecord.add(this, (Map)Util.m_137469_((Object)new Int2ObjectArrayMap(), m -> m.put(index, cell.getValue()))));
        this.remove(index);
        this.preserveState();
    }

    public void remove(int index) {
        if (index == this.dragCursor) {
            this.cancelDrag();
        }
        int prev = this.getSelectedIndex();
        BaseListCell cell = (BaseListCell)this.cells.get(index);
        cell.onDelete();
        this.cells.remove(cell);
        this.widgets.remove(cell);
        if (prev != -1 && !this.cells.isEmpty()) {
            this.m_7522_((GuiEventListener)this.cells.get(index == 0 ? 0 : index - 1));
        }
        if (index < this.cells.size()) {
            this.cells.subList(index, this.cells.size()).forEach(BaseListCell::onMove);
        }
    }

    public void setTransparently(int index, T element) {
        BaseListCell cell = (BaseListCell)this.cells.get(index);
        this.getScreen().getHistory().add(EditHistory.EditRecord.ListEditRecord.modify(this, (Map)Util.m_137469_((Object)new Int2ObjectArrayMap(), m -> m.put(index, cell.getValue()))));
        this.set(index, element);
        this.preserveState();
    }

    public void set(int index, T element) {
        ((BaseListCell)this.cells.get(index)).setValue(element);
    }

    public void markRestoredCell(int index, boolean forInsertion, boolean forRemoval) {
        if (index >= this.cells.size()) {
            return;
        }
        BaseListCell c = (BaseListCell)this.cells.get(index);
        if (forInsertion) {
            c.applyFocusHighlight(c.historyInsertColor);
            c.navigate();
        } else if (forRemoval) {
            c.applyFocusHighlight(c.historyRemoveColor);
        } else {
            c.applyFocusHighlight(c.historyApplyColor);
            c.navigate();
        }
    }

    @Override
    public Rectangle getSelectionArea() {
        DynamicEntryListWidget<?> parent = this.getEntryList();
        return new Rectangle(parent.left, this.entryArea.y, parent.right - parent.left, 20);
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return this.areCaptionControlsEnabled() && mouseX >= (double)(this.entryArea.x - 3) && mouseY >= (double)(this.entryArea.y + 3) && mouseX <= (double)(this.entryArea.x + 6) && mouseY <= (double)(this.entryArea.y + 14);
    }

    protected boolean isInsideDelete(double mouseX, double mouseY) {
        return this.areCaptionControlsEnabled() && this.isDeleteButtonEnabled() && mouseX >= (double)(this.entryArea.x + 10) && mouseY >= (double)(this.entryArea.y + 3) && mouseX <= (double)(this.entryArea.x + 19) && mouseY <= (double)(this.entryArea.y + 14);
    }

    protected boolean isInsideInsert(double mouseX, double mouseY) {
        return this.caret != -1 && mouseX >= (double)(this.entryArea.x - 26) && mouseX < (double)(this.entryArea.x - 14) && mouseY >= (double)this.cellControlsY && mouseY < (double)(this.cellControlsY + 9);
    }

    protected boolean isInsideRemove(double mouseX, double mouseY) {
        return this.cursor != -1 && mouseX >= (double)(this.entryArea.x - 26) && mouseX < (double)(this.entryArea.x - 14) && mouseY >= (double)this.cellControlsY && mouseY < (double)(this.cellControlsY + 9);
    }

    protected boolean isInsideUp(double mouseX, double mouseY) {
        return this.cursor != -1 && mouseX >= (double)(this.entryArea.x - 10) && mouseX < (double)(this.entryArea.x - 3) && mouseY >= (double)this.cellControlsY && mouseY < (double)(this.cellControlsY + 4);
    }

    protected boolean isInsideDown(double mouseX, double mouseY) {
        return this.cursor != -1 && mouseX >= (double)(this.entryArea.x - 10) && mouseX < (double)(this.entryArea.x - 3) && mouseY >= (double)(this.cellControlsY + 5) && mouseY < (double)(this.cellControlsY + 9);
    }

    @Override
    protected boolean shouldProvideTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        return super.shouldProvideTooltip(mouseX, mouseY, x, y, width, height) || !this.getScreen().m_7282_() && ClientConfig.advanced.show_ui_tips && (this.isInsideInsert(mouseX, mouseY) || this.isInsideCreateNew(mouseX, mouseY) || this.isInsideDelete(mouseX, mouseY) || this.isInsideRemove(mouseX, mouseY) || this.isInsideUp(mouseX, mouseY) || this.isInsideDown(mouseX, mouseY));
    }

    @Override
    public Optional<Component[]> getTooltip(int mouseX, int mouseY) {
        if (this.isEditable() && ClientConfig.advanced.show_ui_tips) {
            if (this.addTooltip != null && (this.isInsideInsert(mouseX, mouseY) || this.isInsideCreateNew(mouseX, mouseY))) {
                return Optional.of(this.addTooltip);
            }
            if (this.removeTooltip != null && (this.isInsideRemove(mouseX, mouseY) || this.isInsideDelete(mouseX, mouseY))) {
                return Optional.of(this.removeTooltip);
            }
            if (this.isInsideUp(mouseX, mouseY) || this.isInsideDown(mouseX, mouseY)) {
                return Optional.of(this.moveTooltip);
            }
        }
        if (mouseY < this.entryArea.y + 24) {
            return super.getTooltip(mouseX, mouseY);
        }
        return Optional.empty();
    }

    public List<BaseListCell<T>> getCells() {
        return Collections.unmodifiableList(this.cells);
    }

    @Override
    protected void renderTitle(GuiGraphics gg, Component title, float textX, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.renderTitle(gg, title, textX + (float)(this.areCaptionControlsEnabled() ? (this.isDeleteButtonEnabled() ? 26 : 13) : 0), index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public void tick() {
        this.updateValue(false);
        this.cells.forEach(BaseListCell::tick);
        super.tick();
        this.label.m_93692_(!this.isHeadless() && this.m_93696_() && this.m_7222_() == this.labelReference && this.dragCursor == -1 && (this.getListParent() == null || this.getListParent().dragCursor == -1));
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (this.m_7282_() && !this.isEditable()) {
            this.endDrag(mouseX, mouseY, -1);
        }
        if (!this.isHeadless()) {
            this.label.area.setBounds(x - 24, y, entryWidth - 2, 20);
        }
        if (this.dragCursor != -1) {
            mouseX = this.dragMouseX;
            mouseY = this.dragMouseY;
        }
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        BaseListCell focused = !this.expanded || this.m_7222_() == null || !(this.m_7222_() instanceof BaseListCell) ? null : (BaseListCell)this.m_7222_();
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        SimpleConfigIcons.Lists.EXPAND.renderCentered(gg, x - 15, y + 5, 9, 9, (this.label.m_5953_(mouseX, mouseY) && !insideCreateNew && !insideDelete ? 2 : 0) + (this.expanded ? 1 : 0));
        if (this.areCaptionControlsEnabled()) {
            SimpleConfigIcons.Lists.ADD.renderCentered(gg, x - 15 + 13, y + 5, 9, 9, insideCreateNew ? 2 : 1);
            if (this.isDeleteButtonEnabled()) {
                SimpleConfigIcons.Lists.REMOVE.renderCentered(gg, x - 15 + 26, y + 5, 9, 9, focused == null ? 0 : (insideDelete ? 2 : 1));
            }
        }
        this.hoverCursor = -1;
        this.cellControlsY = -1;
        this.cursor = -1;
        this.caret = -1;
        boolean animating = this.expandAnimator.isInProgress();
        if (this.expanded || animating) {
            int draggedHeight;
            if (animating) {
                ScissorsHandler.INSTANCE.pushScissor(new Rectangle(this.entryArea.x, this.entryArea.y, this.entryArea.width, this.getItemHeight()));
            }
            if (this.cells.isEmpty()) {
                this.placeholder.render(gg, mouseX, mouseY, delta);
            }
            int i = 0;
            int yy = y + 24;
            int o = this.cells.isEmpty() ? 0 : ((BaseListCell)this.cells.get(0)).getCellAreaOffset();
            int n = draggedHeight = this.dragCursor >= 0 && this.dragCursor < this.cells.size() ? ((BaseListCell)this.cells.get(this.dragCursor)).getCellHeight() : 0;
            if (mouseY < yy && (mouseY >= yy - 6 || this.dragCursor != -1)) {
                if (this.dragCursor != -1) {
                    this.renderDragPlaceHolder(gg, x, yy + o, entryWidth, draggedHeight - 4);
                    yy += draggedHeight;
                }
                if (this.dragCursor != 0) {
                    this.caret = 0;
                    this.cellControlsY = yy - 7 + (this.cells.isEmpty() ? 0 : ((BaseListCell)this.cells.get(0)).getCellAreaOffset());
                }
            }
            DynamicEntryListWidget<?> entryList = this.getEntryList();
            boolean childDrawsLine = false;
            for (BaseListCell cell : this.cells) {
                int ch = cell.getCellHeight();
                o = cell.getCellAreaOffset();
                int yo = 0;
                if (mouseY >= yy + o && mouseY < yy + o + ch) {
                    this.hoverCursor = i;
                    if (entryList instanceof SimpleConfigScreen.ListWidget) {
                        ((SimpleConfigScreen.ListWidget)entryList).thisTimeTarget = cell.getSelectionArea();
                    }
                    int mY = mouseY - yy;
                    if (this.dragCursor == -1) {
                        this.draggingOffset = mY;
                        if (mY < o + 4) {
                            this.caret = i;
                            this.cellControlsY = yy + o - 7;
                        } else if (mY < o + ch - 8) {
                            this.cursor = i;
                            this.cellControlsY = ch >= 24 ? yy + o + 5 : yy + o + (ch - 2) / 2 - 5;
                        } else {
                            this.caret = i + 1;
                            this.cellControlsY = yy + o + ch - 7;
                        }
                    } else if (i != this.dragCursor) {
                        if (mY - this.draggingOffset < o + ch / 2) {
                            this.caret = i;
                            this.renderDragPlaceHolder(gg, x, yy + o, entryWidth, draggedHeight - 4);
                            this.cellControlsY = (yy += draggedHeight) + o - 7;
                        } else if (mY - this.draggingOffset + draggedHeight > o + ch / 2) {
                            this.caret = i + 1;
                            this.renderDragPlaceHolder(gg, x, yy + o + ch, entryWidth, draggedHeight - 4);
                            yo += draggedHeight;
                            this.cellControlsY = yy + o + ch - 7;
                        }
                    }
                    childDrawsLine = cell.drawsLine(mouseX - 14, mouseY - yy);
                }
                if (this.dragCursor == i) {
                    int overlayY = Mth.m_14045_((int)(mouseY - this.draggingOffset), (int)(y + 12), (int)(y + entryHeight - ch + 12));
                    this.dragOverlayRectangle.setBounds(x, overlayY + Math.min(0, o), entryWidth, ch + Math.abs(o));
                } else {
                    cell.render(gg, i, x + 14, yy, yy - y, entryWidth - 14, ch, mouseX, mouseY, this.m_93696_() && this.m_7222_() == cell, delta);
                    yy += ch + yo;
                }
                ++i;
            }
            if (this.dragCursor != -1) {
                if (mouseY >= yy) {
                    this.renderDragPlaceHolder(gg, x, yy, entryWidth, draggedHeight - 4);
                    if (this.dragCursor < this.cells.size() - 1) {
                        this.caret = i;
                        this.cellControlsY = yy + o - 7;
                    }
                }
            } else if (this.isEditable() && mouseX >= x - 32 && mouseX < x + 80 && (this.getScreen().getDragged() == null || (Integer)this.getScreen().getDragged().getLeft() != 2)) {
                if (this.caret != -1) {
                    SimpleConfigIcons.Lists.INSERT_ARROW.renderCentered(gg, x - 26, this.cellControlsY, 12, 9, this.isInsideInsert(mouseX, mouseY) ? 1 : 0);
                    if (!childDrawsLine) {
                        gg.m_280509_(x - 14, this.cellControlsY + 3, x - 1 + entryWidth + 1, this.cellControlsY + 6, 0x24FFFFFF);
                        gg.m_280509_(x - 14, this.cellControlsY + 4, x - 1 + entryWidth + 1, this.cellControlsY + 5, 0x64FFFFFF);
                    }
                } else if (this.cursor != -1) {
                    SimpleConfigIcons.Lists.DELETE_ARROW.renderCentered(gg, x - 26, this.cellControlsY, 12, 9, this.isInsideRemove(mouseX, mouseY) ? 1 : 0);
                    if (this.cursor > 0) {
                        SimpleConfigIcons.Lists.UP_ARROW.renderCentered(gg, x - 10, this.cellControlsY, 7, 4, this.isInsideUp(mouseX, mouseY) ? 1 : 0);
                    }
                    if (this.cursor < this.cells.size() - 1) {
                        SimpleConfigIcons.Lists.DOWN_ARROW.renderCentered(gg, x - 10, this.cellControlsY + 5, 7, 4, this.isInsideDown(mouseX, mouseY) ? 1 : 0);
                    }
                }
            }
            if (animating) {
                ScissorsHandler.INSTANCE.popScissor();
            }
        }
        if (!this.isHeadless()) {
            this.label.render(gg, mouseX, mouseY, delta);
        }
    }

    protected void renderDragPlaceHolder(GuiGraphics gg, int x, int y, int width, int height) {
        gg.m_280509_(x, y, x + width, y + height, this.dragPlaceHolderColor);
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        if (area != this.dragOverlayRectangle) {
            return super.renderOverlay(gg, area, mouseX, mouseY, delta);
        }
        if (this.dragCursor < 0 || this.dragCursor >= this.cells.size()) {
            return false;
        }
        this.dragMouseX = mouseX;
        this.dragMouseY = mouseY;
        BaseListCell cell = (BaseListCell)this.cells.get(this.dragCursor);
        int cellHeight = cell.getCellHeight();
        int o = cell.getCellAreaOffset();
        int decorationY = area.y + Math.max(0, o);
        gg.m_280509_(area.x, decorationY, area.getMaxX(), decorationY + cellHeight - 4, this.dragOverlayBackground);
        cell.render(gg, this.dragCursor, area.x + 14, area.y + Math.max(0, -o), -1, area.width - 14, cellHeight, mouseX, mouseY, this.getEntryList().getFocusedItem() != null && this.getEntryList().getFocusedItem().equals(this) && this.m_7222_() != null && this.m_7222_().equals(cell), delta);
        return true;
    }

    @Override
    public boolean preserveState() {
        this.updateValue(true);
        List value = (List)this.getValue();
        int i = this.getSelectedIndex();
        if (i < 0 || i > value.size()) {
            return false;
        }
        EditHistory.EditRecord.ListEditRecord record = EditHistory.EditRecord.ListEditRecord.modify(this, (Map)Util.m_137469_((Object)new Int2ObjectArrayMap(), m -> m.put(i, value.get(i))));
        this.getScreen().getHistory().preserveState(record);
        return true;
    }

    protected @Range(from=-1L, to=0x7FFFFFFFL) int getSelectedIndex() {
        return this.cells.indexOf(this.m_7222_());
    }

    @Override
    public void updateFocused(boolean isFocused) {
        int selected;
        super.updateFocused(isFocused);
        for (BaseListCell cell : this.cells) {
            cell.updateSelected(isFocused && this.expanded && this.m_7222_() == cell);
        }
        int n = selected = isFocused ? this.getSelectedIndex() : -1;
        if (selected != this.lastSelected) {
            if (selected != -1) {
                this.preserveState();
            }
            this.lastSelected = selected;
        }
    }

    @Override
    public void save() {
        super.save();
    }

    public boolean insertInFront() {
        return this.insertInFront;
    }

    public void setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
    }

    public void moveTransparently(int from, int to) {
        if (from < 0 || to < 0 || from >= this.cells.size() || to >= this.cells.size()) {
            throw new IndexOutOfBoundsException("Cannot move " + from + " to " + to + ", size: " + this.cells.size());
        }
        if (from != to) {
            this.getScreen().getHistory().add(EditHistory.EditRecord.ListEditRecord.move(this, (Map)Util.m_137469_((Object)new Int2IntArrayMap(1), m -> m.put(to, from))));
        }
        this.move(from, to);
    }

    public void move(int from, int to) {
        if (from < 0 || to < 0 || from >= this.cells.size() || to >= this.cells.size()) {
            throw new IndexOutOfBoundsException("Cannot move " + from + " to " + to + ", size: " + this.cells.size());
        }
        BaseListCell cell = (BaseListCell)this.cells.get(from);
        int widgetTarget = this.widgets.indexOf(this.cells.get(to));
        cell.onDelete();
        this.cells.remove(cell);
        this.widgets.remove(cell);
        this.cells.add(to, cell);
        this.widgets.add(widgetTarget, (GuiEventListener)cell);
        cell.onAdd();
        this.cells.subList(Math.min(from, to), Math.max(from, to) + 1).forEach(BaseListCell::onMove);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEditable() && (!Screen.m_96639_() || button != 0) && button != 2) {
            if (this.isInsideInsert(mouseX, mouseY)) {
                this.addTransparently(this.caret);
                this.m_7522_((GuiEventListener)this.cells.get(this.caret));
                this.caret = -1;
                BaseListEntry.playFeedbackClick(1.0f);
                return true;
            }
            if (this.isInsideRemove(mouseX, mouseY)) {
                if (this.getSelectedIndex() == this.cursor) {
                    this.m_7522_(this.cells.isEmpty() ? (this.isHeadless() ? null : this.labelReference) : (GuiEventListener)this.cells.get(Math.max(0, this.cursor - 1)));
                }
                this.removeTransparently(this.cursor);
                this.cursor = -1;
                BaseListEntry.playFeedbackClick(1.0f);
                return true;
            }
            if (this.isInsideUp(mouseX, mouseY) && this.cursor > 0) {
                int target = this.cursor - 1;
                this.moveTransparently(this.cursor, target);
                this.cursor = -1;
                BaseListEntry.playFeedbackClick(1.0f);
                return true;
            }
            if (this.isInsideDown(mouseX, mouseY) && this.cursor < this.cells.size() - 1) {
                int target = this.cursor + 1;
                this.moveTransparently(this.cursor, target);
                this.cursor = -1;
                BaseListEntry.playFeedbackClick(1.0f);
                return true;
            }
        }
        if (super.onMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isEditable() && (button == 2 || button == 0 && Screen.m_96639_()) && this.hoverCursor != -1 && !this.m_7282_()) {
            this.dragMouseX = (int)mouseX;
            this.dragMouseY = (int)mouseY;
            this.dragCursor = this.hoverCursor;
            this.getScreen().addOverlay(this.dragOverlayRectangle, this, -1);
            BaseListEntry.playFeedbackTap(1.0f);
            return true;
        }
        return false;
    }

    public void cancelDrag() {
        if (this.dragCursor >= 0 && this.dragCursor < this.cells.size()) {
            BaseListCell dragged = (BaseListCell)this.cells.get(this.dragCursor);
            dragged.onDragged(this.dragOverlayRectangle.y - this.entryArea.y);
            this.dragCursor = -1;
            this.dragOverlayRectangle.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public void endDrag(double mouseX, double mouseY, int button) {
        if (this.dragCursor >= 0 && this.dragCursor < this.cells.size()) {
            int target;
            BaseListCell dragged = (BaseListCell)this.cells.get(this.dragCursor);
            int n = target = this.caret > this.dragCursor ? this.caret - 1 : this.caret;
            if (this.isEditable() && target >= 0 && target < this.cells.size()) {
                this.moveTransparently(this.dragCursor, target);
                dragged.onDragged(this.dragOverlayRectangle.y - this.entryArea.y);
            }
            this.dragCursor = -1;
            this.dragOverlayRectangle.setBounds(0, 0, 0, 0);
            BaseListEntry.playFeedbackTap(1.0f);
        } else {
            super.endDrag(mouseX, mouseY, button);
        }
    }

    @Override
    public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
        if (!onlyVisible || this.isExpanded()) {
            return Lists.newArrayList(this.cells);
        }
        return super.getNavigableChildren(true);
    }

    @Override
    public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        if (!this.isSubEntry() && this.isEditable() && Screen.m_96639_() && this.getSelectedIndex() == -1) {
            if (keyCode == 257 || keyCode == 260) {
                this.addTransparently(0);
                ((BaseListCell)this.cells.get(0)).navigate();
                BaseListEntry.playFeedbackTap(1.0f);
                return true;
            }
            if (!(this.cells.isEmpty() || keyCode != 259 && keyCode != 261)) {
                this.removeTransparently(0);
                BaseListEntry.playFeedbackTap(1.0f);
                return true;
            }
        }
        return super.handleNavigationKey(keyCode, scanCode, modifiers);
    }

    @Override
    public void navigate() {
        INavigableTarget parent;
        if (this.isHeadless() && (parent = this.getNavigableParent()) != null && !(parent instanceof BaseListCell)) {
            parent.navigate();
            return;
        }
        super.navigate();
    }

    @Override
    public int getFocusedScroll() {
        GuiEventListener listener = this.m_7222_();
        if (!this.cells.contains(listener)) {
            return 0;
        }
        int y = 24;
        for (BaseListCell entry : this.cells.subList(0, this.cells.indexOf(listener))) {
            y += entry.getCellHeight();
        }
        if (listener instanceof IExpandable) {
            y += ((IExpandable)listener).getFocusedScroll();
        }
        return y;
    }

    @Override
    public int getFocusedHeight() {
        GuiEventListener listener = this.m_7222_();
        if (listener instanceof IExpandable) {
            return ((IExpandable)listener).getFocusedHeight();
        }
        if (listener instanceof BaseListCell) {
            return ((BaseListCell)listener).getCellHeight();
        }
        return 20;
    }

    @Override
    public String seekableText() {
        if (this.isHeadless()) {
            return "";
        }
        return super.seekableText();
    }

    @Override
    public String seekableValueText() {
        return "";
    }

    @Override
    protected List<ISeekableComponent> seekableChildren() {
        return Lists.newArrayList(this.cells);
    }

    @Override
    public void m_7522_(GuiEventListener listener) {
        super.m_7522_(listener);
    }

    public static class ListCaptionWidget
    extends CaptionedSubCategoryListEntry.CaptionWidget<BaseListEntry<?, ?, ?>> {
        protected ListCaptionWidget(BaseListEntry<?, ?, ?> expandable) {
            super(expandable);
        }

        @Override
        protected BaseListEntry<?, ?, ?> getParent() {
            return (BaseListEntry)super.getParent();
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0 && Screen.m_96639_() || button == 2) {
                return false;
            }
            AbstractConfigField parent = this.getParent();
            ResetButton resetButton = parent.getResetButton();
            if (resetButton != null && resetButton.m_5953_(mouseX, mouseY)) {
                return false;
            }
            if (parent.isEditable() && button == 0) {
                if (((BaseListEntry)parent).isInsideCreateNew(mouseX, mouseY)) {
                    parent.setExpanded(true);
                    int idx = ((BaseListEntry)parent).insertInFront() ? 0 : ((BaseListEntry)parent).cells.size();
                    ((BaseListEntry)parent).addTransparently(idx);
                    ((BaseListEntry)parent).m_7522_((GuiEventListener)((BaseListEntry)parent).cells.get(idx));
                    BaseListEntry.playFeedbackClick(1.0f);
                    return true;
                }
                if (((BaseListEntry)parent).isDeleteButtonEnabled() && ((BaseListEntry)parent).isInsideDelete(mouseX, mouseY)) {
                    GuiEventListener focused = parent.m_7222_();
                    if (((BaseListEntry)parent).isExpanded() && focused instanceof BaseListCell) {
                        int index = ((BaseListEntry)parent).cells.indexOf(focused);
                        if (index >= 0) {
                            ((BaseListEntry)parent).removeTransparently(index);
                        }
                        BaseListEntry.playFeedbackClick(1.0f);
                    }
                    return true;
                }
                if (this.area.contains(mouseX, mouseY)) {
                    boolean recurse = Screen.m_96638_();
                    parent.setExpanded(!((BaseListEntry)parent).isExpanded(), recurse);
                    DynamicEntryListWidget<?> list = parent.getEntryList();
                    if (!recurse && list instanceof SimpleConfigScreen.ListWidget) {
                        ((SimpleConfigScreen.ListWidget)list).startDragAction(new SimpleConfigScreen.ListWidget.EntryDragAction.ExpandedDragAction(((BaseListEntry)parent).isExpanded()));
                    }
                    BaseListEntry.playFeedbackClick(1.0f);
                    return true;
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static class EmptyPlaceholderWidget
    implements GuiEventListener {
        protected boolean focused;
        protected BaseListEntry<?, ?, ?> listEntry;
        public int x;
        public int y;
        public int w;
        public int h;
        protected Component text = Component.m_237115_((String)"simpleconfig.help.list.insert");
        protected int textColor = -6226016;
        protected int borderColor = -8323200;
        protected int hoveredBgColor = -2139033472;
        protected int hoveredTextColor = -8323200;

        public EmptyPlaceholderWidget(BaseListEntry<?, ?, ?> listEntry) {
            this.listEntry = listEntry;
        }

        public void render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
            BaseListEntry<?, ?, ?> listEntry = this.getListEntry();
            Rectangle area = ((BaseListEntry)listEntry).entryArea;
            this.x = area.x + 16;
            this.y = area.y + 24;
            this.w = area.width - 16;
            this.h = 12;
            Font font = Minecraft.m_91087_().f_91062_;
            List lines = font.m_92923_((FormattedText)this.text, this.w);
            int tw = font.m_92724_((FormattedCharSequence)lines.get(0)) + 4;
            if (this.isMouseInside(mouseX, mouseY)) {
                gg.m_280509_(this.x + 1, this.y + 1, this.x + tw - 1, this.y + this.h - 1, this.hoveredBgColor);
            }
            if (this.focused) {
                gg.m_280509_(this.x, this.y, this.x + tw, this.y + 1, this.borderColor);
                gg.m_280509_(this.x, this.y + 1, this.x + 1, this.y + this.h - 1, this.borderColor);
                gg.m_280509_(this.x + tw - 1, this.y + 1, this.x + tw, this.y + this.h - 1, this.borderColor);
                gg.m_280509_(this.x, this.y + this.h - 1, this.x + tw, this.y + this.h, this.borderColor);
            }
            if (!lines.isEmpty()) {
                gg.m_280648_(font, (FormattedCharSequence)lines.get(0), this.x + 2, this.y + 2, this.isMouseInside(mouseX, mouseY) ? this.hoveredTextColor : this.textColor);
            }
        }

        public boolean isMouseInside(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + this.w) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.h);
        }

        public void m_93692_(boolean focus) {
            this.focused = focus;
        }

        public boolean m_93696_() {
            return this.focused;
        }

        protected BaseListEntry<?, ?, ?> getListEntry() {
            return this.listEntry;
        }

        public Component getText() {
            return this.text;
        }

        public void setText(Component text) {
            this.text = text;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.getListEntry().isEditable() && this.isMouseInside(mouseX, mouseY)) {
                this.getListEntry().addTransparently();
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.getListEntry().isEditable() && (keyCode == 257 || keyCode == 32 || keyCode == 260)) {
                this.getListEntry().addTransparently();
                return true;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
    }
}

