/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseListCell<T>
extends AbstractContainerEventHandler
implements ContainerEventHandlerEx,
ISeekableComponent,
INavigableTarget {
    protected Supplier<Optional<Component>> errorSupplier;
    protected Pair<Integer, GuiEventListener> dragged = null;
    protected final Rectangle cellArea = new Rectangle();
    protected boolean isSelected = false;
    private boolean isEdited = false;
    private List<EntryError> errors = Collections.emptyList();
    protected ToggleAnimator offsetAnimator = new ToggleAnimator();
    protected int lastListY = -1;
    protected long lastFocusHighlightTime;
    protected int focusHighlightLength;
    protected int focusHighlightColor;
    protected int errorHighlightColor = -2130755006;
    protected int historyApplyColor = -2143141121;
    protected int historyErrorColor = -2130755006;
    protected int historyInsertColor = -2143092926;
    protected int historyRemoveColor = -2130755006;

    public final int getPreferredTextColor() {
        return this.hasError() ? 0xFF5555 : 0xE0E0E0;
    }

    public void tick() {
        this.errors = this.computeErrors();
        this.isEdited = this.computeIsEdited();
    }

    public List<EntryError> getErrors() {
        return this.errors;
    }

    protected List<EntryError> computeErrors() {
        ArrayList<EntryError> errors = new ArrayList<EntryError>();
        if (this.errorSupplier != null) {
            this.errorSupplier.get().ifPresent(e -> errors.add(EntryError.of(e, this)));
        }
        this.getErrorMessage().ifPresent(e -> errors.add(EntryError.of(e, this)));
        return errors;
    }

    public boolean hasError() {
        return !this.getErrors().isEmpty();
    }

    public void setErrorSupplier(Supplier<Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    public abstract Optional<Component> getErrorMessage();

    public abstract int getCellHeight();

    public void applyErrorHighlight() {
        this.applyFocusHighlight(this.errorHighlightColor);
    }

    @Override
    public void applyFocusHighlight(int color, int length) {
        this.lastFocusHighlightTime = System.currentTimeMillis();
        this.focusHighlightLength = length;
        this.focusHighlightColor = color;
    }

    public int getCellAreaOffset() {
        return 0;
    }

    public void render(GuiGraphics gg, int index, int x, int y, int listY, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        if (listY >= 0 && listY != this.lastListY) {
            this.offsetAnimator.setOutputRange(this.lastListY != -1 ? this.offsetAnimator.getEaseOut() : (float)listY, listY);
            this.offsetAnimator.resetTarget();
            this.lastListY = listY;
        }
        int offset = listY >= 0 ? (int)this.offsetAnimator.getEaseOut() - listY : 0;
        this.cellArea.setBounds(x, y + this.getCellAreaOffset(), cellWidth, cellHeight - 4);
        this.renderCell(gg, index, x, y + offset, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
    }

    public void renderCell(GuiGraphics gg, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        long time;
        long t;
        Component label = this.getLabel();
        if (label != Component.m_237119_()) {
            Font font = Minecraft.m_91087_().f_91062_;
            int textX = font.m_92718_() ? x + cellWidth - font.m_92852_((FormattedText)label) : x;
            this.renderLabel(gg, label, textX, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
        }
        if ((t = (time = System.currentTimeMillis()) - this.lastFocusHighlightTime - (long)this.focusHighlightLength) < 1000L) {
            int color = this.focusHighlightColor;
            int offset = this.getCellAreaOffset();
            gg.m_280509_(16, y + offset, x + cellWidth, y + this.getCellHeight() + offset - 4, color & 0xFFFFFF | (int)((double)(color >> 24 & 0xFF) * ((double)Math.min(1000L, 1000L - t) / 1000.0)) << 24);
        }
    }

    public void renderLabel(GuiGraphics gg, Component label, int textX, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        Font font = Minecraft.m_91087_().f_91062_;
        int n = y + cellHeight / 2;
        Objects.requireNonNull(font);
        gg.m_280430_(font, label, textX, n - 9 / 2, this.getPreferredTextColor());
    }

    public Component getLabel() {
        return Component.m_237113_((String)"\u2022").m_130940_(ChatFormatting.GRAY);
    }

    public void updateSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (!isSelected) {
            this.m_7522_(null);
        }
    }

    @Override
    public Rectangle getRowArea() {
        return this.cellArea;
    }

    public Rectangle getSelectionArea() {
        return this.cellArea;
    }

    public boolean drawsLine(int mouseX, int mouseY) {
        return false;
    }

    public boolean isRequiresRestart() {
        return false;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    protected boolean computeIsEdited() {
        return this.hasError();
    }

    public void onAdd() {
    }

    public void onDelete() {
        this.updateSelected(false);
    }

    public void onShown() {
    }

    public void onHidden() {
        this.lastListY = -1;
    }

    public void onMove() {
    }

    public void onDragged(int listY) {
        this.offsetAnimator.setOutputRange(listY, listY);
        this.lastListY = listY;
    }

    public abstract T getValue();

    protected abstract void doSetValue(T var1);

    public void setValue(T value) {
        this.doSetValue(value);
        this.getErrorMessage();
    }

    public void setOriginal(T value) {
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    public boolean areEqual(T left, T right) {
        return Objects.equals(left, right);
    }
}

