/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import endorh.simpleconfig.ui.gui.entries.AbstractListListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.TextFieldWidgetEx;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractTextFieldListListEntry<T, C extends AbstractTextFieldListCell<T, C, Self>, Self extends AbstractTextFieldListListEntry<T, C, Self>>
extends AbstractListListEntry<T, C, Self> {
    @ApiStatus.Internal
    public AbstractTextFieldListListEntry(Component fieldName, List<T> value, Function<Self, C> cellFactory) {
        super(fieldName, value, cellFactory);
    }

    @ApiStatus.Internal
    public static abstract class AbstractTextFieldListCell<T, Self extends AbstractTextFieldListCell<T, Self, ListEntry>, ListEntry extends AbstractTextFieldListListEntry<T, Self, ListEntry>>
    extends AbstractListListEntry.AbstractListCell<T, Self, ListEntry> {
        protected TextFieldWidgetEx widget;

        public AbstractTextFieldListCell(ListEntry listListEntry) {
            super(listListEntry);
            this.widget = new TextFieldWidgetEx(Minecraft.m_91087_().f_91062_, 0, 0, 100, 18, GameNarrator.f_93310_){

                public void m_88315_(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
                    this.m_93692_(isSelected);
                    super.m_88315_(matrices, mouseX, mouseY, delta);
                }
            };
            this.widget.setFilter(this::isValidText);
            this.widget.setMaxLength(Integer.MAX_VALUE);
            this.widget.setBordered(false);
            this.widget.moveCaretToStart();
            this.widget.setResponder(s -> this.widget.setTextColor(this.getPreferredTextColor()));
        }

        @Override
        public void updateSelected(boolean isSelected) {
            super.updateSelected(isSelected);
            this.widget.m_93692_(isSelected);
        }

        protected abstract boolean isValidText(@NotNull String var1);

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public int getCellAreaOffset() {
            return -4;
        }

        @Override
        protected String seekableText() {
            return this.widget.getValue();
        }

        @Override
        public void renderCell(GuiGraphics gg, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            super.renderCell(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
            Font font = Minecraft.m_91087_().f_91062_;
            AbstractTextFieldListListEntry listEntry = (AbstractTextFieldListListEntry)this.getListEntry();
            boolean editable = listEntry.shouldRenderEditable();
            int fieldWidth = listEntry.getFieldWidth();
            int fieldX = font.m_92718_() ? x : x + cellWidth - fieldWidth;
            this.widget.m_93674_(fieldWidth);
            this.widget.m_252865_(fieldX);
            this.widget.m_253211_(y + 1);
            this.widget.setEditable(editable);
            this.widget.m_88315_(gg, mouseX, mouseY, delta);
            if (isSelected && editable) {
                gg.m_280509_(fieldX, y + 12, x + cellWidth, y + 13, this.hasError() ? -43691 : -2039584);
            }
            if (this.matchedText != null) {
                gg.m_280509_(fieldX, y - 2, x + fieldWidth, y + cellHeight - 2, this.isFocusedMatch() ? 1694481730 : 1694498626);
            }
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.widget);
        }

        @Override
        public void setFocusedMatch(boolean isFocusedMatch) {
            super.setFocusedMatch(isFocusedMatch);
            if (isFocusedMatch) {
                AbstractTextFieldListListEntry listEntry = (AbstractTextFieldListListEntry)this.getListEntry();
                listEntry.expandParents();
                listEntry.setExpanded(true);
                listEntry.claimFocus();
                this.scrollToSelf();
                listEntry.m_7522_((GuiEventListener)this);
                this.widget.m_93692_(true);
            }
        }

        @Override
        public void navigate() {
            AbstractTextFieldListListEntry listEntry = (AbstractTextFieldListListEntry)this.getListEntry();
            listEntry.expandParents();
            listEntry.claimFocus();
            listEntry.setExpanded(true);
            listEntry.m_7522_((GuiEventListener)this);
            this.m_7522_((GuiEventListener)this.widget);
            this.widget.m_93692_(true);
            this.scrollToSelf();
            listEntry.getEntryList().setSelectedTarget(this);
        }

        protected void scrollToSelf() {
            AbstractTextFieldListListEntry listEntry = (AbstractTextFieldListListEntry)this.getListEntry();
            int j = listEntry.cells.indexOf(this);
            int y = 24;
            for (int i = 0; i < j; ++i) {
                y += ((AbstractTextFieldListCell)listEntry.cells.get(i)).getCellHeight();
            }
            DynamicEntryListWidget<?> parent = listEntry.getEntryList();
            int listY = listEntry.getScrollY();
            double listTarget = parent.scrollFor(listY, listEntry.getItemHeight());
            double target = parent.scrollFor(listY + y, this.getCellHeight());
            parent.scrollTo(target);
        }
    }
}

