/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui.entries;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.gui.entries.BaseListCell;
import endorh.simpleconfig.ui.gui.entries.BaseListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicElementListWidget;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractListListEntry<T, C extends AbstractListCell<T, C, SELF>, SELF extends AbstractListListEntry<T, C, SELF>>
extends BaseListEntry<T, C, SELF> {
    protected BiFunction<Integer, T, Optional<Component>> cellErrorSupplier = (i, t) -> Optional.empty();
    protected Function<List<T>, @Nullable List<Optional<Component>>> multiCellErrorSupplier = l -> null;
    @Nullable
    protected List<Optional<Component>> multiCellErrors = null;

    @ApiStatus.Internal
    protected AbstractListListEntry(Component fieldName, List<T> value, Function<SELF, C> createNewCell) {
        super(fieldName, createNewCell);
        this.setOriginal(value);
        this.setValue(value);
        this.setDisplayedValue(value);
    }

    public BiFunction<Integer, T, Optional<Component>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public void setCellErrorSupplier(BiFunction<Integer, T, Optional<Component>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        List value = (List)this.getValue();
        this.setValue(value);
        this.setDisplayedValue(value);
    }

    public Function<List<T>, List<Optional<Component>>> getMultiCellErrorSupplier() {
        return this.multiCellErrorSupplier;
    }

    public void setMultiCellErrorSupplier(Function<List<T>, @Nullable List<Optional<Component>>> multiCellErrorSupplier) {
        this.multiCellErrorSupplier = multiCellErrorSupplier;
        List value = (List)this.getValue();
        this.setValue(value);
        this.setDisplayedValue(value);
    }

    @Override
    public void tick() {
        this.updateValue(false);
        this.multiCellErrors = this.multiCellErrorSupplier.apply((List)this.getValue());
        super.tick();
    }

    @Override
    protected C createCellWithValue(T value) {
        AbstractListCell cell = (AbstractListCell)this.cellFactory.apply((AbstractListListEntry)this.self());
        cell.setValue(value);
        cell.setOriginal(value);
        return (C)cell;
    }

    @ApiStatus.Internal
    public static abstract class AbstractListCell<V, Self extends AbstractListCell<V, Self, ListEntry>, ListEntry extends AbstractListListEntry<V, Self, ListEntry>>
    extends BaseListCell<V> {
        private final ListEntry listEntry;
        protected boolean isFocusedMatch = false;
        protected String matchedText = null;
        protected Rectangle rowArea = new Rectangle();
        private INavigableTarget lastSelectedSubTarget;
        private int index = -1;

        protected AbstractListCell(ListEntry listEntry) {
            this.listEntry = listEntry;
            this.setErrorSupplier(() -> Optional.ofNullable(listEntry.cellErrorSupplier).flatMap(cellErrorFn -> (Optional)cellErrorFn.apply(this.index, this.getValue())));
        }

        protected ListEntry getListEntry() {
            return this.listEntry;
        }

        @Override
        public List<ISeekableComponent> search(Pattern query) {
            this.matchedText = null;
            String text = this.seekableText();
            if (!text.isEmpty()) {
                Matcher m = query.matcher(text);
                while (m.find()) {
                    if (m.group().isEmpty()) continue;
                    this.matchedText = m.group();
                    break;
                }
            }
            List<ISeekableComponent> matches = this.seekableComponents().stream().flatMap(c -> c.search(query).stream()).collect(Collectors.toList());
            if (this.matchedText != null) {
                matches.add(0, this);
            }
            return matches;
        }

        @Override
        public Rectangle getSelectionArea() {
            return this.rowArea;
        }

        protected int getIndex() {
            return this.index;
        }

        @Override
        public final void onAdd() {
            super.onAdd();
            this.index = ((AbstractListListEntry)this.listEntry).cells.indexOf(this);
            this.onAdd(this.index);
        }

        public void onAdd(int index) {
        }

        @Override
        public final void onMove() {
            super.onMove();
            this.index = ((AbstractListListEntry)this.listEntry).cells.indexOf(this);
            this.onMove(this.index);
        }

        public void onMove(int index) {
        }

        @Override
        public Rectangle getNavigableArea() {
            return this.rowArea;
        }

        @Override
        @Nullable
        public INavigableTarget getLastSelectedNavigableSubTarget() {
            return this.lastSelectedSubTarget;
        }

        @Override
        public void setLastSelectedNavigableSubTarget(@Nullable INavigableTarget target) {
            this.lastSelectedSubTarget = target;
        }

        @Override
        protected List<EntryError> computeErrors() {
            List<EntryError> errors = super.computeErrors();
            List<Optional<Component>> multi = ((AbstractListListEntry)this.listEntry).multiCellErrors;
            if (multi != null && this.index >= 0 && this.index < multi.size()) {
                multi.get(this.index).ifPresent(e -> errors.add(EntryError.of(e, this)));
            }
            return errors;
        }

        @Override
        public void renderCell(GuiGraphics gg, int index, int x, int y, int cellWidth, int cellHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            super.renderCell(gg, index, x, y, cellWidth, cellHeight, mouseX, mouseY, isSelected, delta);
            ListEntry listEntry = this.getListEntry();
            DynamicEntryListWidget<?> entryList = ((AbstractConfigField)listEntry).getEntryList();
            this.rowArea.setBounds(entryList.left, this.cellArea.y, entryList.right - entryList.left, this.cellArea.height);
        }

        protected String seekableText() {
            Object value = this.getValue();
            return value != null ? value.toString() : "";
        }

        protected List<ISeekableComponent> seekableComponents() {
            return Lists.newLinkedList();
        }

        @Override
        public boolean isFocusedMatch() {
            return this.isFocusedMatch;
        }

        @Override
        public void setFocusedMatch(boolean isFocusedMatch) {
            this.isFocusedMatch = isFocusedMatch;
        }

        @Override
        @Nullable
        public INavigableTarget getNavigableParent() {
            return this.getListEntry();
        }

        @Override
        public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
            GuiEventListener listener;
            ListEntry listEntry = this.getListEntry();
            if (((AbstractConfigField)listEntry).isEditable() && Screen.m_96639_() && (listener = ((DynamicElementListWidget.ElementEntry)listEntry).m_7222_()) instanceof BaseListCell && ((AbstractListListEntry)listEntry).cells.contains(listener)) {
                int index = ((AbstractListListEntry)listEntry).cells.indexOf(listener);
                if (Screen.m_96637_()) {
                    if (keyCode == 264 && index < ((AbstractListListEntry)listEntry).cells.size() - 1) {
                        ((BaseListEntry)listEntry).moveTransparently(index, index + 1);
                        ((BaseListCell)listener).navigate();
                        return true;
                    }
                    if (keyCode == 265 && index > 0) {
                        ((BaseListEntry)listEntry).moveTransparently(index, index - 1);
                        ((BaseListCell)listener).navigate();
                        return true;
                    }
                }
                if (keyCode == 257 || keyCode == 260) {
                    ((BaseListEntry)listEntry).addTransparently(index + 1);
                    ((AbstractListCell)((AbstractListListEntry)listEntry).cells.get(index + 1)).navigate();
                    return true;
                }
                if (index != -1 && (keyCode == 259 || keyCode == 261)) {
                    ((BaseListEntry)listEntry).removeTransparently(index);
                    if (!((AbstractListListEntry)listEntry).cells.isEmpty()) {
                        ((AbstractListCell)((AbstractListListEntry)listEntry).cells.get(Mth.m_14045_((int)(keyCode == 259 ? index - 1 : index), (int)0, (int)(((AbstractListListEntry)listEntry).cells.size() - 1)))).navigate();
                    }
                    return true;
                }
            }
            return super.handleNavigationKey(keyCode, scanCode, modifiers);
        }
    }
}

