/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.ExternalChangesDialog;
import endorh.simpleconfig.ui.gui.InfoDialog;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusDisplayBar
extends AbstractWidget
implements IOverlayCapableContainer.IOverlayRenderer {
    protected SimpleConfigScreen screen;
    protected final NavigableSet<StatusState> states = new TreeSet(Comparator.naturalOrder());
    protected final MultiFunctionImageButton dialogButton;
    protected StatusState activeState = null;
    protected List<StatusState> activeStates = Collections.emptyList();
    protected int shadowColor = -16777216;
    protected Rectangle rect = new Rectangle();
    protected boolean claimed = false;
    public static final StatusState READ_ONLY = new StatusState(30){

        @Override
        public boolean isActive(SimpleConfigScreen screen) {
            return !screen.isEditable();
        }

        @Override
        public Component getTitle(SimpleConfigScreen screen) {
            return Component.m_237115_((String)"simpleconfig.ui.read_only").m_130940_(ChatFormatting.AQUA);
        }

        @Override
        public List<Component> getTooltip(SimpleConfigScreen screen, boolean menu2) {
            return SimpleConfigTextUtil.splitTtc("simpleconfig.ui.read_only:help", new Object[0]);
        }

        @Override
        public StatusState.StatusStyle getStyle(SimpleConfigScreen screen) {
            return new StatusState.StatusStyle(SimpleConfigIcons.Status.INFO, -260013840, -1609805183);
        }
    };
    public static final StatusState REQUIRES_RESTART = EditedStatusState.create(-5, "requires_restart", AbstractConfigField::isRequiresRestart, new StatusState.StatusStyle(SimpleConfigIcons.Entries.REQUIRES_RESTART, -257908608, -1604033464, -253697920));
    public static final StatusState EXPERIMENTAL = EditedStatusState.create(-10, "experimental", e -> e.getEntryTags().contains(EntryTag.EXPERIMENTAL), new StatusState.StatusStyle(SimpleConfigIcons.Entries.EXPERIMENTAL, -256855936, -1602198456, -253697920));
    public static final StatusState ADVANCED = EditedStatusState.create(-15, "advanced", e -> e.getEntryTags().contains(EntryTag.ADVANCED), new StatusState.StatusStyle(SimpleConfigIcons.Entries.WRENCH.withTint(ChatFormatting.GOLD), -256860032, -1601149880, -252649344));
    public static final StatusState EXTERNAL_CHANGES = new StatusState(10){

        @Override
        public boolean isActive(SimpleConfigScreen screen) {
            return screen.getAllMainEntries().stream().anyMatch(AbstractConfigField::hasConflictingExternalDiff);
        }

        @Override
        public void onClick(SimpleConfigScreen screen, double mouseX, double mouseY, int button) {
            if (button == 2) {
                screen.addDialog(this.getDialog(screen));
                screen.playFeedbackClick(1.0f);
                return;
            }
            screen.focusNextExternalConflict(Screen.m_96638_() ^ button != 1);
        }

        public String getTypeKey(SimpleConfigScreen screen) {
            return screen.isEditingServer() && screen.hasConflictingRemoteChanges() || !screen.hasConflictingExternalChanges() ? "remote" : "external";
        }

        @Override
        public Component getTitle(SimpleConfigScreen screen) {
            return Component.m_237115_((String)("simpleconfig.ui." + this.getTypeKey(screen) + "_changes_detected"));
        }

        @Override
        public List<Component> getTooltip(SimpleConfigScreen screen, boolean menu2) {
            return SimpleConfigTextUtil.splitTtc("simpleconfig.ui." + this.getTypeKey(screen) + "_changes_detected." + (menu2 ? "all" : "click"), SimpleConfigMod.KeyBindings.NEXT_ERROR.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA), SimpleConfigMod.KeyBindings.PREV_ERROR.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA));
        }

        @Override
        public boolean hasDialog(SimpleConfigScreen screen) {
            return true;
        }

        @Override
        public AbstractDialog getDialog(SimpleConfigScreen screen) {
            List conflicts = screen.getAllExternalConflicts();
            List<Component> lines = IntStream.range(0, conflicts.size()).mapToObj(i -> {
                AbstractConfigField entry = (AbstractConfigField)conflicts.get(i);
                MutableComponent title = entry.getTitle().m_6881_();
                title.m_7220_((Component)Component.m_237113_((String)(" [" + entry.getPath() + "]")).m_130940_(ChatFormatting.GRAY));
                title.m_130938_(s -> s.m_131140_(ChatFormatting.GOLD).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"simpleconfig.ui.changes.all.link:help"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "action:goto/" + i)));
                return title;
            }).collect(Collectors.toList());
            return InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.changes.all.title"), lines, d -> {
                d.setIcon(SimpleConfigIcons.Entries.MERGE_CONFLICT);
                d.setLinkActionHandler(s -> {
                    if (s.startsWith("goto/")) {
                        try {
                            int pos = Integer.parseInt(s.substring("goto/".length()));
                            if (pos >= 0 && pos < conflicts.size()) {
                                d.cancel(true);
                                INavigableTarget target = (INavigableTarget)conflicts.get(pos);
                                target.navigate();
                                target.applyFocusHighlight(INavigableTarget.HighlightColors.MERGE);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                });
                d.addButton((AbstractWidget)TintedButton.of((Component)Component.m_237115_((String)"simpleconfig.ui.action.accept_all_changes"), -2139007953, b -> {
                    d.cancel(true);
                    screen.handleExternalChangeResponse(ExternalChangesDialog.ExternalChangeResponse.ACCEPT_ALL);
                }));
                d.addButton((AbstractWidget)Util.m_137469_((Object)((Object)TintedButton.of((Component)Component.m_237115_((String)"simpleconfig.ui.action.accept_non_conflicting_changes"), -2140654440, b -> {
                    d.cancel(true);
                    screen.handleExternalChangeResponse(ExternalChangesDialog.ExternalChangeResponse.ACCEPT_NON_CONFLICTING);
                })), b -> {
                    b.f_93623_ = screen.getAllMainEntries().stream().anyMatch(e -> e.hasConflictingExternalDiff() && !e.isEdited());
                }));
            });
        }

        @Override
        public StatusState.StatusStyle getStyle(SimpleConfigScreen screen) {
            return new StatusState.StatusStyle(SimpleConfigIcons.Entries.MERGE_CONFLICT, -1594851088, -1117781920);
        }
    };
    public static final StatusState ERROR_STATE = new StatusState(20){

        @Override
        public boolean isActive(SimpleConfigScreen screen) {
            return screen.hasErrors();
        }

        @Override
        public void onClick(SimpleConfigScreen screen, double mouseX, double mouseY, int button) {
            if (button == 2) {
                screen.addDialog(this.getDialog(screen));
                screen.playFeedbackClick(1.0f);
                return;
            }
            screen.focusNextError(Screen.m_96638_() ^ button != 1);
        }

        @Override
        public Component getTitle(SimpleConfigScreen screen) {
            List<Component> errors = screen.getErrorsMessages();
            if (errors.isEmpty()) {
                return Component.m_237119_();
            }
            return (errors.size() == 1 ? errors.get(0).m_6881_() : Component.m_237110_((String)"simpleconfig.ui.errors.multiple", (Object[])new Object[]{errors.size(), errors.get(0).m_6881_().getString()})).m_130940_(ChatFormatting.RED);
        }

        @Override
        public boolean hasDialog(SimpleConfigScreen screen) {
            return true;
        }

        @Override
        public AbstractDialog getDialog(SimpleConfigScreen screen) {
            List<EntryError> errors = screen.getErrors();
            List<Component> lines = IntStream.range(0, errors.size()).mapToObj(i -> {
                MutableComponent goToError = Component.m_237115_((String)"simpleconfig.ui.errors.all.link:help");
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)goToError);
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, "action:goto/" + i);
                EntryError error = (EntryError)errors.get(i);
                AbstractConfigField<?> entry = error.getEntry();
                MutableComponent title = entry.getTitle().m_6881_();
                title.m_7220_((Component)Component.m_237113_((String)(" [" + entry.getPath() + "]")).m_130940_(ChatFormatting.DARK_RED));
                title.m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131144_(hoverEvent).m_131142_(clickEvent));
                MutableComponent err = Component.m_237113_((String)"  ").m_7220_((Component)error.getError().m_6881_().m_130938_(s -> s.m_131140_(ChatFormatting.RED).m_131144_(hoverEvent).m_131142_(clickEvent)));
                return new Component[]{title, err};
            }).flatMap(Arrays::stream).collect(Collectors.toList());
            return InfoDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.errors.all.title"), lines, d -> {
                d.setIcon(SimpleConfigIcons.Status.ERROR);
                d.titleColor = -32640;
                d.borderColor = -32640;
                d.subBorderColor = -8388608;
                d.setLinkActionHandler(s -> {
                    if (s.startsWith("goto/")) {
                        try {
                            int pos = Integer.parseInt(s.substring("goto/".length()));
                            if (pos >= 0 && pos < errors.size()) {
                                d.cancel(true);
                                INavigableTarget target = ((EntryError)errors.get(pos)).getSource();
                                target.navigate();
                                target.applyFocusHighlight(INavigableTarget.HighlightColors.ERROR);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                });
            });
        }

        @Override
        public List<Component> getTooltip(SimpleConfigScreen screen, boolean menu2) {
            return SimpleConfigTextUtil.splitTtc(menu2 ? "simpleconfig.ui.errors.extra:help" : "simpleconfig.ui.errors:help", SimpleConfigMod.KeyBindings.NEXT_ERROR.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA), SimpleConfigMod.KeyBindings.PREV_ERROR.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA));
        }

        @Override
        public StatusState.StatusStyle getStyle(SimpleConfigScreen screen) {
            return new StatusState.StatusStyle(SimpleConfigIcons.Status.ERROR, -1594851200, -1117782016);
        }
    };

    public StatusDisplayBar(SimpleConfigScreen screen) {
        super(0, 0, screen.f_96543_, 14, (Component)Component.m_237119_());
        this.screen = screen;
        this.dialogButton = new MultiFunctionImageButton(0, 0, 15, 15, SimpleConfigIcons.Status.H_DOTS, MultiFunctionImageButton.ButtonAction.of(() -> this.createDialog()).active(this::hasDialog).tooltip(this::getDialogTooltip));
        Stream.of(ERROR_STATE, READ_ONLY, REQUIRES_RESTART, EXPERIMENTAL, ADVANCED, EXTERNAL_CHANGES).forEach(this.states::add);
    }

    public void tick() {
        this.activeStates = this.states.descendingSet().stream().filter(s -> s.isActive(this.screen)).toList();
        this.activeState = this.activeStates.stream().findFirst().orElse(null);
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        this.f_93618_ = this.screen.f_96543_;
        this.f_93619_ = 19;
        this.m_252865_(0);
        this.m_253211_(this.screen.listWidget.bottom - this.f_93619_);
        this.rect.setBounds(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        if (!this.activeStates.isEmpty() && !this.claimed) {
            this.screen.addOverlay(this.rect, this);
            this.claimed = true;
            this.onShow();
        }
    }

    public void createDialog() {
        this.createDialog(this.activeState);
    }

    public void createDialog(StatusState state) {
        AbstractDialog dialog;
        if (state != null && (dialog = state.getDialog(this.screen)) != null) {
            this.screen.addDialog(dialog);
        }
    }

    public boolean hasDialog() {
        return this.activeState != null && this.activeState.hasDialog(this.screen);
    }

    public List<Component> getDialogTooltip() {
        return this.activeState != null ? this.activeState.getTooltip(this.screen, true) : Collections.emptyList();
    }

    @Override
    public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
        int i;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (this.hasDialog() && this.dialogButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.activeStates.size() > 1 && (i = ((int)mouseX - this.m_252754_()) / this.f_93619_) < this.activeStates.size() - 1) {
            StatusState state = this.activeStates.get(this.activeStates.size() - 1 - i);
            if (button == 2 && state.hasDialog(this.screen)) {
                this.createDialog(state);
            } else {
                state.onClick(this.screen, mouseX, mouseY, button);
            }
            return true;
        }
        if (this.activeState != null) {
            this.activeState.onClick(this.screen, mouseX, mouseY, button);
        }
        return true;
    }

    protected void onShow() {
        this.screen.listWidget.setExtraScroll(this.screen.listWidget.getExtraScroll() + this.f_93619_);
    }

    protected void onHide() {
        this.screen.listWidget.setExtraScroll(this.screen.listWidget.getExtraScroll() - this.f_93619_);
    }

    protected void renderBox(GuiGraphics gg, StatusState state, int boxX, int mouseX, int mouseY) {
        StatusState.StatusStyle style = state.getStyle(this.screen);
        Icon icon = style.icon();
        if (icon == null) {
            icon = Icon.EMPTY;
        }
        int y = this.m_252907_();
        gg.m_280509_(boxX, y, boxX + this.f_93619_, y + this.f_93619_, style.backgroundColor());
        gg.m_280509_(boxX, y, boxX + this.f_93619_, y + 1, style.borderColor());
        gg.m_280509_(boxX, y + this.f_93619_ - 1, boxX + this.f_93619_, y + this.f_93619_, style.borderColor());
        gg.m_280509_(boxX + this.f_93619_ - 1, y + 1, boxX + this.f_93619_, y + this.f_93619_ - 1, style.borderColor());
        icon.renderCentered(gg, boxX + 2, y + 2, 15, 15);
        if (this.m_5953_(mouseX, mouseY) && mouseX >= boxX && mouseX < boxX + this.f_93619_) {
            List<MutableComponent> tooltip = Stream.concat(Stream.of(state.getTitle(this.screen)), state.getTooltip(this.screen, false).stream().map(c -> c.m_6881_().m_130940_(ChatFormatting.GRAY))).toList();
            this.screen.addTooltip(Tooltip.of(this.rect, Point.of(mouseX, mouseY), tooltip));
        }
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        List<Component> tooltip;
        if (this.activeStates.isEmpty()) {
            this.claimed = false;
            this.onHide();
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        StatusState.StatusStyle style = this.activeState.getStyle(this.screen);
        int x = this.m_252754_();
        int y = this.m_252907_();
        gg.m_280024_(x, y - 4, x + this.f_93618_, y, 0, this.shadowColor);
        int l = x;
        for (int i = this.activeStates.size() - 1; i >= 1; --i) {
            StatusState state = this.activeStates.get(i);
            this.renderBox(gg, state, l, mouseX, mouseY);
            l += this.f_93619_;
        }
        gg.m_280509_(l, y, x + this.f_93618_, y + this.f_93619_, style.backgroundColor());
        gg.m_280509_(l, y, x + this.f_93618_, y + 1, style.borderColor());
        gg.m_280509_(l, y + this.f_93619_ - 1, x + this.f_93618_, y + this.f_93619_, style.borderColor());
        if (style.icon != null) {
            style.icon.renderCentered(gg, l + 2, y + 2, 15, 15);
        }
        Component title = this.activeState.getTitle(this.screen);
        gg.m_280430_(font, title, l + 19, y + 6, -2039584);
        if (this.hasDialog()) {
            this.dialogButton.m_252865_(x + this.f_93618_ - 17);
            this.dialogButton.m_253211_(y + 2);
            this.dialogButton.f_93624_ = true;
        } else {
            this.dialogButton.f_93624_ = false;
        }
        this.dialogButton.m_88315_(gg, mouseX, mouseY, delta);
        if (this.m_5953_(mouseX, mouseY) && mouseX >= l && !this.dialogButton.m_5953_(mouseX, mouseY) && !(tooltip = this.activeState.getTooltip(this.screen, false)).isEmpty()) {
            this.screen.addTooltip(Tooltip.of(area, Point.of(mouseX, mouseY), tooltip));
        }
        return true;
    }

    protected void m_168797_(@NotNull NarrationElementOutput out) {
    }

    public static abstract class StatusState
    implements Comparable<StatusState> {
        public final int priority;

        protected StatusState(int priority) {
            this.priority = priority;
        }

        public abstract boolean isActive(SimpleConfigScreen var1);

        public void onClick(SimpleConfigScreen screen, double mouseX, double mouseY, int button) {
        }

        public abstract Component getTitle(SimpleConfigScreen var1);

        public boolean hasDialog(SimpleConfigScreen screen) {
            return this.getDialog(screen) != null;
        }

        @Nullable
        public AbstractDialog getDialog(SimpleConfigScreen screen) {
            return null;
        }

        public List<Component> getTooltip(SimpleConfigScreen screen, boolean menu2) {
            return Collections.emptyList();
        }

        public abstract StatusStyle getStyle(SimpleConfigScreen var1);

        @Override
        public int compareTo(@NotNull StatusState o) {
            return Integer.compare(this.priority, o.priority);
        }

        public record StatusStyle(@Nullable Icon icon, int borderColor, int backgroundColor, int textColor, int highlightColor) {
            public StatusStyle(@Nullable Icon icon, int borderColor, int backgroundColor) {
                this(icon, borderColor, backgroundColor, borderColor, backgroundColor);
            }

            public StatusStyle(@Nullable Icon icon, int borderColor, int backgroundColor, int textColor) {
                this(icon, borderColor, backgroundColor, textColor, backgroundColor);
            }
        }
    }

    public static class EditedStatusState
    extends StatusState {
        private final String name;
        private final Predicate<SimpleConfigScreen> isActive;
        private final Predicate<AbstractConfigField<?>> entryPredicate;
        private final StatusState.StatusStyle style;

        public static EditedStatusState create(int priority, String name, Predicate<AbstractConfigField<?>> entryPredicate, StatusState.StatusStyle style) {
            return EditedStatusState.create(priority, name, s -> s.getAllMainEntries().stream().anyMatch(entryPredicate.and(AbstractConfigField::isEdited)), entryPredicate, style);
        }

        public static EditedStatusState create(int priority, String name, Predicate<SimpleConfigScreen> isActive, Predicate<AbstractConfigField<?>> entryPredicate, StatusState.StatusStyle style) {
            return new EditedStatusState(priority, name, isActive, entryPredicate, style);
        }

        protected EditedStatusState(int priority, String name, Predicate<SimpleConfigScreen> isActive, Predicate<AbstractConfigField<?>> entryPredicate, StatusState.StatusStyle style) {
            super(priority);
            this.name = name;
            this.isActive = isActive;
            this.entryPredicate = entryPredicate;
            this.style = style;
        }

        @Override
        public boolean isActive(SimpleConfigScreen screen) {
            return this.isActive.test(screen);
        }

        @Override
        public Component getTitle(SimpleConfigScreen screen) {
            return Component.m_237115_((String)("simpleconfig.ui.status." + this.name)).m_130938_(s -> s.m_178520_(this.style.textColor()));
        }

        @Override
        public StatusState.StatusStyle getStyle(SimpleConfigScreen screen) {
            return this.style;
        }

        @Override
        public List<Component> getTooltip(SimpleConfigScreen screen, boolean menu2) {
            return SimpleConfigTextUtil.splitTtc((String)(menu2 ? "simpleconfig.ui.status.all.view" : "simpleconfig.ui.status." + this.name + ".click"), new Object[0]);
        }

        @Override
        public void onClick(SimpleConfigScreen screen, double mouseX, double mouseY, int button) {
            if (button == 2) {
                screen.addDialog(this.getDialog(screen));
                screen.playFeedbackClick(1.0f);
                return;
            }
            screen.focusNextEntry(this.entryPredicate, !Screen.m_96638_() ^ button != 1, false, this.style.highlightColor());
        }

        @Override
        public boolean hasDialog(SimpleConfigScreen screen) {
            return true;
        }

        @Override
        @NotNull
        public AbstractDialog getDialog(SimpleConfigScreen screen) {
            List<AbstractConfigField> entries2 = screen.getAllMainEntries().stream().filter(e -> this.entryPredicate.test((AbstractConfigField<?>)e) && e.isEdited()).toList();
            List<Component> lines = IntStream.range(0, entries2.size()).mapToObj(i -> {
                AbstractConfigField entry = (AbstractConfigField)entries2.get(i);
                MutableComponent title = entry.getTitle().m_6881_();
                title.m_7220_((Component)Component.m_237113_((String)(" [" + entry.getPath() + "]")).m_130940_(ChatFormatting.GRAY));
                title.m_130938_(s -> s.m_178520_(this.style.textColor()).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"simpleconfig.ui.go_to_entry"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "action:goto/" + i)));
                return title;
            }).collect(Collectors.toList());
            return InfoDialog.create((Component)Component.m_237115_((String)("simpleconfig.ui.status." + this.name + ".all.title")), lines, d -> {
                d.setIcon(this.style.icon());
                d.setLinkActionHandler(s -> {
                    if (s.startsWith("goto/")) {
                        try {
                            int pos = Integer.parseInt(s.substring("goto/".length()));
                            if (pos >= 0 && pos < entries2.size()) {
                                d.cancel(true);
                                INavigableTarget target = (INavigableTarget)entries2.get(pos);
                                target.navigate();
                                target.applyFocusHighlight(this.style.highlightColor());
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                });
                d.addButton((AbstractWidget)TintedButton.of((Component)Component.m_237115_((String)"simpleconfig.ui.action.restore.all"), -2140897025, b -> {
                    d.cancel(true);
                    screen.runAtomicTransparentAction(() -> entries2.forEach(AbstractConfigField::restoreValue));
                }));
            });
        }
    }
}

