/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigGroup;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.SimpleConfigGUIManagerImpl;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.AbstractConfigListEntry;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.api.ScrollingHandler;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.ConfigCategoryButton;
import endorh.simpleconfig.ui.gui.ConfigModeButton;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.ControlsHelpDialog;
import endorh.simpleconfig.ui.gui.SelectionToolbar;
import endorh.simpleconfig.ui.gui.StatusDisplayBar;
import endorh.simpleconfig.ui.gui.entries.CaptionedSubCategoryListEntry;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.DynamicElementListWidget;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.HotKeyActionButton;
import endorh.simpleconfig.ui.gui.widget.KeyBindButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.PresetPickerWidget;
import endorh.simpleconfig.ui.gui.widget.SearchBarWidget;
import endorh.simpleconfig.ui.gui.widget.TextFieldWidgetEx;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import endorh.simpleconfig.ui.gui.widget.ToggleAnimator;
import endorh.simpleconfig.ui.gui.widget.ToggleImageButton;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyListDialog;
import endorh.simpleconfig.ui.impl.ConfigScreenBuilderImpl;
import endorh.simpleconfig.ui.impl.EasingMethod;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SimpleConfigScreen
extends AbstractConfigScreen
implements SearchBarWidget.ISearchHandler {
    private final ScrollingHandler tabsScroller = new ScrollingHandler(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, SimpleConfigScreen.this.f_96543_ - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)SimpleConfigScreen.this.tabsMaximumScrolled;
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.scrollAmount = this.clamp(this.scrollAmount, 0.0);
        }
    };
    protected List<? extends GuiEventListener> searchModeChildren;
    protected List<? extends GuiEventListener> reportedChildren = super.m_6702_();
    protected Map<ConfigCategory, ListWidget<AbstractConfigField<?>>> listWidgets;
    protected ListWidget<AbstractConfigField<?>> listWidget;
    protected Component displayTitle;
    protected TintedButton quitButton;
    protected SaveButton saveButton;
    protected List<MultiFunctionIconButton> modeButtons = Lists.newArrayList();
    protected int titleStartX = -1;
    protected int titleEndX = -1;
    protected EnumMap<SimpleConfig.EditType, MultiFunctionIconButton> modeButtonMap;
    protected MultiFunctionIconButton clientButton;
    protected MultiFunctionIconButton commonButton;
    protected MultiFunctionIconButton remoteCommonButton;
    protected MultiFunctionIconButton serverButton;
    protected PresetPickerWidget presetPickerWidget;
    protected AbstractWidget buttonLeftTab;
    protected AbstractWidget buttonRightTab;
    protected MultiFunctionImageButton undoButton;
    protected MultiFunctionImageButton redoButton;
    protected MultiFunctionImageButton editFileButton;
    protected MultiFunctionImageButton keyboardButton;
    protected MultiFunctionImageButton settingsButton;
    protected MultiFunctionImageButton selectAllButton;
    protected MultiFunctionImageButton invertSelectionButton;
    protected MultiFunctionImageButton navigateUpButton;
    protected MultiFunctionImageButton navigateDownButton;
    protected MultiFunctionIconButton hotKeyButton;
    protected KeyBindButton editedHotKeyButton;
    protected TextFieldWidgetEx editedHotKeyNameTextField;
    protected SelectionToolbar selectionToolbar;
    protected Rectangle tabsBounds;
    protected Rectangle tabsLeftBounds;
    protected Rectangle tabsRightBounds;
    protected double tabsMaximumScrolled = -1.0;
    protected final List<ConfigCategoryButton> tabButtons = Lists.newArrayList();
    protected TooltipSearchBarWidget searchBar;
    protected StatusDisplayBar statusDisplayBar;
    protected boolean scheduledLayout = false;
    protected final Set<AbstractConfigField<?>> selectedEntries = new HashSet();
    protected boolean isSelecting = false;
    protected EnumMap<SimpleConfig.EditType, ConfigCategory> lastCategories = new EnumMap(SimpleConfig.EditType.class);
    @Nullable
    protected ConfigScreenBuilder.IConfigScreenGUIState scheduledGUIState;
    @Nullable
    protected ConfigScreenBuilder.IConfigScreenGUIState lastRestoredGUIState;
    @Nullable
    protected INavigableTarget scheduledTarget;
    protected int scheduledTargetDelay = 0;
    protected boolean showingHelp = false;
    private List<EntryError> errors = new ArrayList<EntryError>();
    private boolean isEdited = false;
    protected static final Pattern DOT = Pattern.compile("\\.");
    protected static final Pattern NO_MATCH = Pattern.compile("$^");

    @ApiStatus.Internal
    public SimpleConfigScreen(Screen parent, String modId, Component title, Collection<ConfigCategory> clientCategories, Collection<ConfigCategory> commonCategories, Collection<ConfigCategory> serverCommonCategories, Collection<ConfigCategory> serverCategories, ResourceLocation backgroundLocation) {
        super(parent, modId, title, backgroundLocation, clientCategories, commonCategories, serverCommonCategories, serverCategories);
        this.displayTitle = Component.m_237113_((String)SimpleConfigScreen.getModNameOrId(modId));
        for (ConfigCategory category : this.sortedCategories) {
            for (AbstractConfigField<?> entry : category.getHeldEntries()) {
                entry.setCategory(category);
                entry.setScreen(this);
            }
        }
        this.selectedCategory = (ConfigCategory)this.sortedCategories.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No categories for config GUI"));
        this.sortedCategories.stream().filter(c -> !c.isLoaded()).forEach(c -> {
            CompletableFuture<Boolean> future = c.getLoadingFuture();
            if (future != null) {
                future.thenRun(() -> this.finishLoadingCategory((ConfigCategory)c));
            }
        });
        this.lastCategories.put(this.selectedCategory.getType(), this.selectedCategory);
        this.statusDisplayBar = new StatusDisplayBar(this);
        this.searchBar = new TooltipSearchBarWidget(this, 0, 0, 256, this);
        this.presetPickerWidget = new PresetPickerWidget(this, 0, 0, 70);
        this.editedHotKeyButton = KeyBindButton.of(() -> this, () -> this);
        this.editedHotKeyButton.setTintColor(1111654655);
        this.editedHotKeyNameTextField = TextFieldWidgetEx.of("");
        this.editedHotKeyNameTextField.setBordered(false);
        this.editedHotKeyNameTextField.setEmptyHint((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.unnamed_hotkey.hint"));
        this.f_96541_ = Minecraft.m_91087_();
        this.listWidgets = new HashMap();
        this.modeButtonMap = (EnumMap)Util.m_137469_(new EnumMap(SimpleConfig.EditType.class), m -> {
            this.clientButton = this.createModeButton(SimpleConfig.EditType.CLIENT);
            m.put(SimpleConfig.EditType.CLIENT, this.clientButton);
            this.commonButton = this.createModeButton(SimpleConfig.EditType.COMMON);
            m.put(SimpleConfig.EditType.COMMON, this.commonButton);
            this.remoteCommonButton = this.createModeButton(SimpleConfig.EditType.SERVER_COMMON);
            m.put(SimpleConfig.EditType.SERVER_COMMON, this.remoteCommonButton);
            this.serverButton = this.createModeButton(SimpleConfig.EditType.SERVER);
            m.put(SimpleConfig.EditType.SERVER, this.serverButton);
        });
        this.editFileButton = MultiFunctionImageButton.of(20, 20, SimpleConfigIcons.Buttons.EDIT_FILE, MultiFunctionImageButton.ButtonAction.of(() -> this.selectedCategory.getContainingFile().ifPresent(f -> this.addDialog(EditConfigFileDialog.create(this, f.toAbsolutePath())))).active(() -> this.selectedCategory.getContainingFile().isPresent()).tooltip((Component)Component.m_237115_((String)"simpleconfig.file.open")));
        this.undoButton = MultiFunctionImageButton.of(20, 20, SimpleConfigIcons.Buttons.UNDO, MultiFunctionImageButton.ButtonAction.of(() -> {
            this.undo();
            this.m_7522_((GuiEventListener)this.listWidget);
        }).active(() -> this.history.canUndo()));
        this.redoButton = MultiFunctionImageButton.of(20, 20, SimpleConfigIcons.Buttons.REDO, MultiFunctionImageButton.ButtonAction.of(() -> {
            this.redo();
            this.m_7522_((GuiEventListener)this.listWidget);
        }).active(() -> this.history.canRedo()));
        this.navigateUpButton = MultiFunctionImageButton.of(18, 18, SimpleConfigIcons.Buttons.NAVIGATE_UP, MultiFunctionImageButton.ButtonAction.of(() -> this.focusNextEdited(false)).active(this::isEdited).tooltip(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"simpleconfig.ui.navigate.edited.prev"), Component.m_237110_((String)"simpleconfig.ui.shortcut", (Object[])new Object[]{SimpleConfigMod.KeyBindings.PREV_EDITED.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)})})));
        this.navigateDownButton = MultiFunctionImageButton.of(18, 18, SimpleConfigIcons.Buttons.NAVIGATE_DOWN, MultiFunctionImageButton.ButtonAction.of(() -> this.focusNextEdited(true)).active(this::isEdited).tooltip(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"simpleconfig.ui.navigate.edited.next"), Component.m_237110_((String)"simpleconfig.ui.shortcut", (Object[])new Object[]{SimpleConfigMod.KeyBindings.NEXT_EDITED.m_90863_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)})})));
        this.hotKeyButton = MultiFunctionIconButton.of(SimpleConfigIcons.Buttons.KEYBOARD, 20, 20, MultiFunctionImageButton.ButtonAction.of(() -> this.addDialog(HotKeyListDialog.forModId(modId))).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.hotkey.edit")));
        this.buttonLeftTab = MultiFunctionImageButton.of(12, 18, SimpleConfigIcons.Buttons.LEFT_TAB, MultiFunctionImageButton.ButtonAction.of(() -> this.tabsScroller.offset(-48.0, true)).active(() -> this.tabsScroller.scrollAmount > 0.0));
        this.buttonRightTab = MultiFunctionImageButton.of(12, 18, SimpleConfigIcons.Buttons.RIGHT_TAB, MultiFunctionImageButton.ButtonAction.of(() -> this.tabsScroller.offset(48.0, true)).active(() -> this.tabsScroller.scrollAmount < this.tabsMaximumScrolled - (double)this.f_96543_ + 40.0));
        this.quitButton = TintedButton.of(CommonComponents.f_130656_, widget -> {
            if (this.isEditingConfigHotKey()) {
                this.discardHotkey();
            } else {
                this.quit();
            }
        });
        this.saveButton = new SaveButton(this);
        this.settingsButton = MultiFunctionImageButton.of(18, 18, SimpleConfigIcons.Buttons.GEAR, MultiFunctionImageButton.ButtonAction.of(() -> SimpleConfigGUIManagerImpl.INSTANCE.showConfigGUI("simpleconfig")).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.simple_config_settings")));
        this.keyboardButton = MultiFunctionImageButton.of(18, 18, SimpleConfigIcons.Buttons.KEYBOARD, MultiFunctionImageButton.ButtonAction.of(() -> this.addDialog(this.getControlsDialog())).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.controls")));
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.reportedChildren;
    }

    @NotNull
    private MultiFunctionIconButton createModeButton(SimpleConfig.EditType type) {
        return new ConfigModeButton(this, type);
    }

    protected static String getModNameOrId(String modId) {
        Optional<IModInfo> first = ModList.get().getMods().stream().filter(m -> modId.equals(m.getModId())).findFirst();
        if (first.isPresent()) {
            return first.get().getDisplayName();
        }
        return modId;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        String[] split = DOT.split(path, 3);
        if (split.length < 3) {
            return null;
        }
        Map map = (Map)this.categoryMap.get(split[0]);
        if (map == null) {
            return null;
        }
        ConfigCategory cat = (ConfigCategory)map.get(split[1]);
        if (cat == null) {
            return null;
        }
        return cat.getEntry(split[2]);
    }

    @Override
    public boolean isEditingServer() {
        return super.isEditingServer() || this.getEditedType().isOnlyRemote();
    }

    @Override
    public List<AbstractConfigField<?>> getHeldEntries() {
        return this.sortedCategories.stream().flatMap(c -> c.getHeldEntries().stream()).collect(Collectors.toList());
    }

    protected boolean hasUndoButtons() {
        return !this.isEditingConfigHotKey();
    }

    @Override
    public void setEditedConfigHotKey(@Nullable ConfigHotKey hotkey, Consumer<Boolean> hotKeySaver) {
        super.setEditedConfigHotKey(hotkey, hotKeySaver);
        if (hotkey != null) {
            this.editedHotKeyButton.setMapping(hotkey.getKeyMapping());
            this.editedHotKeyNameTextField.setValue(hotkey.getName());
            this.categoryMap.forEach((alias, map) -> this.loadConfigHotKeyActions(hotkey, SimpleConfig.EditType.fromAlias(alias), (Map<String, ConfigCategory>)map));
        }
        this.getAllMainEntries().forEach(e -> e.setEditingHotKeyAction(this.isEditingConfigHotKey()));
    }

    protected void loadConfigHotKeyActions(ConfigHotKey hotkey, SimpleConfig.EditType type, Map<String, ConfigCategory> categoryMap) {
        Map<String, HotKeyAction<?>> actionMap = hotkey.getActions().get(Pair.of((Object)this.modId, (Object)((Object)type)));
        if (actionMap == null) {
            return;
        }
        actionMap.forEach((k, a) -> {
            AbstractConfigField<?> entry;
            String[] path = DOT.split((CharSequence)k, 2);
            ConfigCategory cat = (ConfigCategory)categoryMap.get(path[0]);
            if (cat != null && (entry = cat.getEntry(path[1])) != null) {
                this.loadHotKeyAction(entry, a);
            }
        });
    }

    protected <T, V, A extends HotKeyAction<V>> void loadHotKeyAction(AbstractConfigField<T> entry, A action) {
        HotKeyActionType<V, ?> type = action.getType();
        List<HotKeyActionType<T, ?>> types = entry.getHotKeyActionTypes();
        int idx = types.indexOf(type);
        if (idx >= 0) {
            entry.setHotKeyActionType(types.get(idx), action);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scheduledLayout = false;
        this.searchBar.w = this.f_96543_;
        this.m_7787_((GuiEventListener)this.searchBar);
        int bx = 24;
        this.editFileButton.m_264152_(bx, 2);
        this.undoButton.m_264152_(bx += 24, 2);
        this.redoButton.m_264152_(bx += 20, 2);
        bx += 24;
        this.m_142416_((GuiEventListener)this.editFileButton);
        if (this.hasUndoButtons()) {
            this.m_142416_((GuiEventListener)this.undoButton);
            this.m_142416_((GuiEventListener)this.redoButton);
        } else {
            bx -= 44;
        }
        SimpleConfig.EditType type = this.getEditedType();
        this.clientButton.setTintColor(type == SimpleConfig.EditType.CLIENT ? -2144831692 : 0);
        this.commonButton.setDefaultIcon(this.mayHaveType(SimpleConfig.EditType.SERVER_COMMON) ? SimpleConfigIcons.Types.COMMON_CLIENT : SimpleConfigIcons.Types.COMMON);
        this.commonButton.setTintColor(type == SimpleConfig.EditType.COMMON ? -2138020812 : 0);
        this.remoteCommonButton.setTintColor(type == SimpleConfig.EditType.SERVER_COMMON ? -2138020812 : 0);
        this.serverButton.setTintColor(type == SimpleConfig.EditType.SERVER ? -2146811286 : 0);
        this.clientButton.setWidthRange(20, 80);
        this.commonButton.setWidthRange(20, 80);
        this.remoteCommonButton.setExactWidth(20);
        this.serverButton.setWidthRange(20, 80);
        this.modeButtons = new ArrayList<MultiFunctionIconButton>();
        if (this.hasType(SimpleConfig.EditType.CLIENT)) {
            this.modeButtons.add(this.clientButton);
        }
        if (this.hasType(SimpleConfig.EditType.COMMON)) {
            this.modeButtons.add(this.commonButton);
            if (this.mayHaveType(SimpleConfig.EditType.SERVER_COMMON)) {
                this.modeButtons.add(this.remoteCommonButton);
            }
        }
        if (this.hasType(SimpleConfig.EditType.SERVER)) {
            this.modeButtons.add(this.serverButton);
        }
        if ((double)(bx + this.modeButtons.stream().mapToInt(MultiFunctionIconButton::m_5711_).sum()) > 0.35 * (double)this.f_96543_) {
            this.modeButtons.forEach(b -> b.setExactWidth(20));
        }
        for (MultiFunctionIconButton multiFunctionIconButton : this.modeButtons) {
            multiFunctionIconButton.m_264152_(bx, 2);
            bx += multiFunctionIconButton.m_5711_();
            this.m_142416_((GuiEventListener)multiFunctionIconButton);
        }
        this.titleStartX = bx + 4;
        this.selectionToolbar = new SelectionToolbar(this, 76, 2);
        this.selectionToolbar.visible = false;
        this.m_7787_((GuiEventListener)this.selectionToolbar);
        if (this.isEditingConfigHotKey()) {
            int textFieldWidth = Mth.m_14045_((int)(this.f_96543_ / 5), (int)100, (int)300);
            this.editedHotKeyNameTextField.m_264152_(this.f_96543_ / 2 - textFieldWidth / 2, 8);
            this.editedHotKeyNameTextField.m_93674_(textFieldWidth);
            this.editedHotKeyNameTextField.setHeight(12);
            this.m_142416_((GuiEventListener)this.editedHotKeyNameTextField);
        }
        if (!this.isEditingConfigHotKey()) {
            int presetPickerWidth = Mth.m_14045_((int)(this.f_96543_ / 3), (int)80, (int)250);
            this.presetPickerWidget.setPosition(this.f_96543_ - presetPickerWidth - 24, 2, presetPickerWidth);
            this.hotKeyButton.m_264152_(this.f_96543_ - 22, 2);
            this.m_7787_(this.presetPickerWidget);
            this.m_142416_((GuiEventListener)this.hotKeyButton);
            this.titleEndX = this.presetPickerWidget.getX() - 4;
        } else {
            int hotKeyButtonWidth = Mth.m_14045_((int)(this.f_96543_ / 3), (int)80, (int)250);
            this.editedHotKeyButton.setPosition(this.f_96543_ - hotKeyButtonWidth - 2, 2, hotKeyButtonWidth);
            this.m_7787_(this.editedHotKeyButton);
            this.titleEndX = this.editedHotKeyButton.getX() - 4;
        }
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 24, this.f_96543_, 24);
            this.tabsLeftBounds = new Rectangle(0, 24, 18, 24);
            this.tabsRightBounds = new Rectangle(this.f_96543_ - 18, 24, 18, 24);
            this.buttonLeftTab.m_264152_(4, 27);
            this.m_7787_((GuiEventListener)this.buttonLeftTab);
            this.m_7787_((GuiEventListener)this.buttonRightTab);
            this.tabButtons.clear();
            int ww = 0;
            for (ConfigCategory cat : this.getSortedTypeCategories()) {
                int w = this.f_96547_.m_92852_((FormattedText)cat.getTitle());
                ConfigCategoryButton b3 = new ConfigCategoryButton(this, cat, -100, 26, cat.getTitle(), cat.getDescription());
                this.tabButtons.add(b3);
                ww += b3.m_5711_() + 2;
            }
            this.tabsMaximumScrolled = ww + 2;
            this.tabButtons.forEach(x$0 -> {
                ConfigCategoryButton cfr_ignored_0 = (ConfigCategoryButton)this.m_7787_((GuiEventListener)x$0);
            });
            this.buttonRightTab.m_264152_(this.f_96543_ - 16, 27);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        this.listWidget = this.getListWidget(this.selectedCategory);
        this.listWidget.resize(this.f_96543_, this.f_96544_, this.isShowingTabs() ? 50 : 24, this.f_96544_ - 28);
        if (this.f_96543_ >= 800) {
            this.listWidget.setLeftPos((this.f_96543_ - 800) / 2);
            this.listWidget.setRightPos(this.f_96543_ - (this.f_96543_ - 800) / 2);
        }
        this.m_7787_((GuiEventListener)this.listWidget);
        this.m_142416_((GuiEventListener)this.statusDisplayBar);
        int by = this.f_96544_ - 21;
        bx = 3;
        this.selectAllButton = new MultiFunctionImageButton(3, by, 18, 18, SimpleConfigIcons.Buttons.SELECT_ALL, MultiFunctionImageButton.ButtonAction.of(this::selectAllEntries).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.select_all")));
        this.m_142416_((GuiEventListener)this.selectAllButton);
        this.invertSelectionButton = new MultiFunctionImageButton(bx += 22, by, 18, 18, SimpleConfigIcons.Buttons.INVERT_SELECTION, MultiFunctionImageButton.ButtonAction.of(this::invertEntrySelection).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.invert_selection")));
        this.m_142416_((GuiEventListener)this.invertSelectionButton);
        this.invertSelectionButton.f_93624_ = false;
        this.selectAllButton.f_93624_ = false;
        if (!this.isSelecting()) {
            bx = 3;
        }
        this.navigateUpButton.m_264152_(bx, by);
        this.m_142416_((GuiEventListener)this.navigateUpButton);
        this.navigateDownButton.m_264152_(bx += 22, by);
        this.m_142416_((GuiEventListener)this.navigateDownButton);
        this.navigateDownButton.f_93624_ = true;
        this.navigateUpButton.f_93624_ = true;
        int n = Math.min(200, (this.f_96543_ - 88) / 3);
        int cX = this.f_96543_ / 2;
        by = this.f_96544_ - 24;
        this.quitButton.m_264152_(cX - n - 2, by);
        this.quitButton.m_93674_(n);
        this.m_142416_((GuiEventListener)this.quitButton);
        this.saveButton.m_264152_(cX + 2, by);
        this.saveButton.m_93674_(n);
        this.m_142416_((GuiEventListener)this.saveButton);
        this.saveButton.f_93623_ = this.isEdited();
        by = this.f_96544_ - 21;
        if (!this.modId.equals("simpleconfig")) {
            this.settingsButton.m_264152_(this.f_96543_ - 41, by);
            this.m_142416_((GuiEventListener)this.settingsButton);
        }
        this.keyboardButton.m_264152_(this.f_96543_ - 21, by);
        this.m_142416_((GuiEventListener)this.keyboardButton);
        this.isSelecting = false;
        this.updateSelection();
        if (this.afterInitConsumer != null) {
            this.afterInitConsumer.accept(this);
        }
        if (this.scheduledGUIState != null) {
            ConfigScreenBuilder.IConfigScreenGUIState state = this.scheduledGUIState;
            this.scheduledGUIState = null;
            this.loadConfigScreenGUIState(state);
        }
        this.searchModeChildren = super.m_6702_().stream().filter(l -> l != this.presetPickerWidget && l != this.editFileButton && l != this.hotKeyButton && l != this.selectionToolbar && !this.modeButtons.contains(l)).toList();
    }

    public ListWidget<AbstractConfigField<?>> getListWidget(ConfigCategory category) {
        return this.listWidgets.computeIfAbsent(category, c -> {
            ListWidget w = new ListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, category, this.isShowingTabs() ? 50 : 24, this.f_96544_ - 28, c.getBackground() != null ? c.getBackground() : this.backgroundLocation);
            if (category.isLoaded()) {
                this.initListWidget(category, w);
            }
            return w;
        });
    }

    protected void initListWidget(ConfigCategory category, ListWidget<AbstractConfigField<?>> widget) {
        widget.getEntries().addAll(category.getHeldEntries());
    }

    @Override
    public List<EntryError> getErrors() {
        return this.errors;
    }

    public void updateErrors() {
        ArrayList errors = Lists.newArrayList();
        SimpleConfig.EditType type = this.getEditedType();
        this.updateErrors(errors, this.getSortedTypeCategories());
        for (SimpleConfig.EditType t : SimpleConfig.EditType.values()) {
            if (t == type) continue;
            this.updateErrors(errors, (List)this.sortedCategoriesMap.get((Object)t));
        }
        this.errors = errors;
    }

    protected void updateErrors(List<EntryError> errors, List<ConfigCategory> categories) {
        for (ConfigCategory cat : categories) {
            errors.addAll(cat.getErrors());
        }
    }

    public void showType(SimpleConfig.EditType type) {
        SimpleConfig.EditType prevType = this.getEditedType();
        if (this.hasType(type) && prevType != type) {
            ConfigCategory lastCategory = this.lastCategories.get((Object)type);
            this.setSelectedCategory(lastCategory != null ? lastCategory : (ConfigCategory)((List)this.sortedCategoriesMap.get((Object)type)).get(0));
            if (!this.hasLoadedType(type)) {
                this.loadType(type);
            }
        }
    }

    protected void loadType(SimpleConfig.EditType type) {
        if (this.hasLoadedType(type)) {
            return;
        }
        if (this.remoteConfigProvider == null) {
            throw new IllegalStateException("Missing remote config provider");
        }
        CommentedConfig config = (CommentedConfig)this.remoteConfigs.get((Object)type);
        if (config == null) {
            throw new IllegalStateException("Can't load type yet: " + type.getAlias());
        }
        this.history.runUnrecordedAction(() -> this.remoteConfigProvider.loadRemoteConfig(type, config, false));
        ((List)this.sortedCategoriesMap.get((Object)type)).stream().flatMap(c -> c.getAllMainEntries().stream()).forEach(SimpleConfigScreen::resetOriginal);
        this.loadedRemoteConfigs.add(type);
    }

    private static <T> void resetOriginal(AbstractConfigField<T> entry) {
        entry.setOriginal(entry.getValue());
    }

    @Override
    public void setRemoteCommonConfigProvider(@Nullable ConfigScreenBuilder.IRemoteConfigProvider remoteConfigProvider) {
        super.setRemoteCommonConfigProvider(remoteConfigProvider);
        if (this.getEditedType().isOnlyRemote()) {
            this.showType(Arrays.stream(SimpleConfig.EditType.values()).filter(t -> !t.isOnlyRemote() && this.hasType((SimpleConfig.EditType)((Object)t))).findFirst().orElseThrow(() -> new IllegalStateException("Config screen cannot have only remote configs")));
        }
        this.remoteConfigs.clear();
        this.loadedRemoteConfigs.clear();
        if (remoteConfigProvider != null) {
            Arrays.stream(SimpleConfig.EditType.values()).filter(SimpleConfig.EditType::isOnlyRemote).forEach(t -> remoteConfigProvider.getRemoteConfig((SimpleConfig.EditType)((Object)t)).thenAccept(c -> {
                if (c != null) {
                    this.remoteConfigs.put(t, c);
                    this.loadedRemoteConfigs.remove(t);
                }
            }));
        }
    }

    public List<Component> getErrorsMessages() {
        return this.getErrors().stream().map(EntryError::getError).collect(Collectors.toList());
    }

    @Override
    protected boolean canSave() {
        return this.isEdited() && !this.hasErrors();
    }

    @Override
    public boolean isShowingHelp() {
        return this.showingHelp;
    }

    public void finishLoadingCategory(ConfigCategory category) {
        if (!category.isLoaded()) {
            ((List)this.sortedCategoriesMap.get((Object)category.getType())).remove(category);
            this.sortedCategories.remove(category);
            ((Map)this.categoryMap.get(category.getType().getAlias())).remove(category.getName());
        } else {
            ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState state;
            ListWidget<AbstractConfigField<?>> w = this.listWidgets.get(category);
            if (w != null) {
                this.initListWidget(category, w);
            }
            this.scheduledLayout = true;
            if (this.selectedCategory == category && this.lastRestoredGUIState != null && (state = this.lastRestoredGUIState.getCategoryStates().get((Object)category.getType()).get(category.getName())) != null) {
                this.loadConfigCategoryGUIState(category, state);
            }
        }
    }

    @Override
    public void setSelectedCategory(ConfigCategory category) {
        if (this.selectedCategory != category) {
            boolean typeChange;
            int prevIndex = this.sortedCategories.indexOf(this.selectedCategory);
            int index = this.sortedCategories.indexOf(category);
            boolean bl = typeChange = this.getEditedType() != category.getType();
            if (this.isSelecting() && typeChange) {
                return;
            }
            this.lastCategories.put(this.selectedCategory.getType(), this.selectedCategory);
            super.setSelectedCategory(category);
            ListWidget<AbstractConfigField<?>> prevListWidget = this.listWidget;
            if (this.f_96543_ > 0) {
                this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
                if (prevListWidget != null) {
                    prevListWidget.onReplaced(this.listWidget);
                }
                if (typeChange) {
                    this.presetPickerWidget.refresh();
                }
                this.listWidget.playTabSlideAnimation(prevIndex > index);
                if (this.isShowingTabs()) {
                    int innerIndex = this.getSortedTypeCategories().indexOf(category);
                    int x = 0;
                    for (int i = 0; i < innerIndex; ++i) {
                        x += this.tabButtons.get(i).m_5711_() + 2;
                    }
                    x += this.tabButtons.get(innerIndex).m_5711_() / 2;
                    this.tabsScroller.scrollTo(x -= this.tabsScroller.getBounds().height / 2, true, 250L);
                }
                this.searchBar.refresh();
                if (this.searchBar.isExpanded()) {
                    this.m_7522_((GuiEventListener)this.searchBar);
                }
            }
        }
    }

    @Override
    public boolean isEdited() {
        return this.isEdited;
    }

    protected void updateIsEdited() {
        this.isEdited = super.isEdited();
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amount != 0.0) {
            this.tabsScroller.offset(-amount * 16.0, true);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getFocusedEntry() {
        return (AbstractConfigField)this.listWidget.getSelectedEntry();
    }

    public void selectAllEntries() {
        this.selectedCategory.getHeldEntries().forEach(e -> e.setSelected(true));
    }

    public void invertEntrySelection() {
        this.selectedCategory.getAllMainEntries().stream().filter(e -> !(e instanceof CaptionedSubCategoryListEntry) && e.isSelectable()).forEach(e -> e.setSelected(!e.isSelected()));
    }

    @Override
    public Set<AbstractConfigField<?>> getSelectedEntries() {
        return this.selectedEntries;
    }

    @Override
    public boolean canSelectEntries() {
        return true;
    }

    @Override
    public void loadConfigScreenGUIState(@Nullable ConfigScreenBuilder.IConfigScreenGUIState state) {
        if (state != null) {
            if (this.f_96543_ == 0) {
                this.scheduledGUIState = state;
                return;
            }
            this.lastRestoredGUIState = state;
            this.showType(state.getEditedType());
            state.getSelectedCategories().forEach((t, n) -> {
                ConfigCategory c = this.getTypeCategories((SimpleConfig.EditType)((Object)t)).get(n);
                if (c != null) {
                    this.lastCategories.put((SimpleConfig.EditType)((Object)t), c);
                    if (t == this.getEditedType()) {
                        this.setSelectedCategory(c);
                    }
                }
            });
            state.getCategoryStates().forEach((t, m) -> {
                Map<String, ConfigCategory> typeCategories = this.getTypeCategories((SimpleConfig.EditType)((Object)t));
                m.forEach((n, s) -> {
                    ConfigCategory c = (ConfigCategory)typeCategories.get(n);
                    if (c != null) {
                        this.loadConfigCategoryGUIState(c, (ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState)s);
                    }
                });
            });
        }
    }

    protected void loadConfigCategoryGUIState(ConfigCategory category, ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState state) {
        AbstractConfigField<?> entry;
        state.getExpandStates().forEach((p, e) -> {
            AbstractConfigField<?> entry = category.getEntry((String)p);
            if (entry instanceof IExpandable) {
                ((IExpandable)((Object)entry)).setExpanded((boolean)e, false, false);
            }
        });
        ListWidget<AbstractConfigField<?>> widget = this.getListWidget(category);
        widget.setScroll(state.getScrollOffset());
        String selected = state.getSelectedEntry();
        if (selected != null && (entry = category.getEntry(selected)) != null) {
            widget.setSelectedTarget(entry);
            if (this.getSelectedCategory() == category) {
                entry.navigate();
            }
            if (this.getSelectedCategory() == category) {
                this.scheduledTarget = entry;
                this.scheduledTargetDelay = 2;
            }
        }
    }

    @Override
    public ConfigScreenBuilder.IConfigScreenGUIState saveConfigScreenGUIState() {
        ConfigScreenBuilderImpl.ConfigScreenGUIState state = new ConfigScreenBuilderImpl.ConfigScreenGUIState();
        state.setEditedType(this.getEditedType());
        Map<SimpleConfig.EditType, String> selectedCategories = state.getSelectedCategories();
        Map<SimpleConfig.EditType, Map<String, ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState>> categoryStates = state.getCategoryStates();
        this.lastCategories.forEach((t, c) -> selectedCategories.put((SimpleConfig.EditType)((Object)t), c.getName()));
        selectedCategories.put(this.getEditedType(), this.getSelectedCategory().getName());
        this.sortedCategoriesMap.forEach((t, l) -> {
            HashMap states = new HashMap();
            categoryStates.put((SimpleConfig.EditType)((Object)t), states);
            l.forEach(c -> states.put(c.getName(), this.saveConfigCategoryGUIState((ConfigCategory)c)));
        });
        return state;
    }

    protected ConfigScreenBuilder.IConfigScreenGUIState.IConfigCategoryGUIState saveConfigCategoryGUIState(ConfigCategory category) {
        ConfigScreenBuilderImpl.ConfigScreenGUIState.ConfigCategoryGUIState state = new ConfigScreenBuilderImpl.ConfigScreenGUIState.ConfigCategoryGUIState();
        ListWidget<AbstractConfigField<?>> widget = this.listWidgets.get(category);
        Map<String, Boolean> states = state.getExpandStates();
        category.getAllEntries(e -> e instanceof IExpandable).forEach(e -> states.put(e.getCatPath(), ((IExpandable)((Object)e)).isExpanded()));
        if (widget != null) {
            AbstractConfigField selected = (AbstractConfigField)widget.getSelectedEntry();
            if (selected != null) {
                state.setSelectedEntry(selected.getCatPath());
            }
            state.setScrollOffset((int)widget.getScroll());
        }
        return state;
    }

    @Override
    protected void saveHotkey() {
        ConfigHotKey hotkey = this.editedConfigHotKey;
        if (!this.isEditingConfigHotKey() || hotkey == null) {
            return;
        }
        this.sortedCategoriesMap.forEach((type, categories) -> this.addHotKeyActions(hotkey, (SimpleConfig.EditType)((Object)type), (Collection<ConfigCategory>)categories));
        hotkey.setName(this.editedHotKeyNameTextField.getValue());
        hotkey.setKeyMapping(this.editedHotKeyButton.getMapping());
        super.saveHotkey();
    }

    private void addHotKeyActions(ConfigHotKey hotKey, SimpleConfig.EditType type, Collection<ConfigCategory> categories) {
        Map<Pair<String, SimpleConfig.EditType>, Map<String, HotKeyAction<?>>> actions = hotKey.getActions();
        Pair pair = Pair.of((Object)this.modId, (Object)((Object)type));
        Map actionMap = actions.computeIfAbsent((Pair<String, SimpleConfig.EditType>)pair, k -> new LinkedHashMap());
        actionMap.clear();
        categories.stream().flatMap(c -> c.getAllMainEntries().stream()).filter(e -> e.getHotKeyActionType() != null).forEach(e -> {
            String path = e.getRelPath();
            HotKeyAction action = e.createHotKeyAction();
            if (action != null) {
                actionMap.put(path, action);
            }
        });
        if (actionMap.isEmpty()) {
            actions.remove(pair);
        }
    }

    @Override
    protected void recomputeFocus() {
        if (this.searchBar.isExpanded() && !this.hasDialogs()) {
            this.m_7522_((GuiEventListener)this.searchBar);
        }
        if (this.m_7222_() instanceof ListWidget && this.m_7222_() != this.getListWidget(this.getSelectedCategory())) {
            this.m_7522_((GuiEventListener)this.getListWidget(this.getSelectedCategory()));
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            this.m_7522_((GuiEventListener)this.listWidget);
            return this.listWidget.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    protected boolean screenKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.screenKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (SimpleConfigMod.KeyBindings.NEXT_TYPE.isActiveAndMatches(key)) {
            MultiFunctionIconButton modeButton = this.modeButtonMap.get((Object)this.getEditedType());
            int i = this.modeButtons.indexOf((Object)modeButton);
            if (i < 0) {
                return true;
            }
            int s = this.modeButtons.size();
            i = (i + 1) % s;
            while (modeButton != this.modeButtons.get(i) && !this.modeButtons.get((int)i).f_93623_) {
                i = (i + 1) % s;
            }
            if (modeButton != this.modeButtons.get(i)) {
                this.modeButtons.get(i).press(0);
            }
            return true;
        }
        if (SimpleConfigMod.KeyBindings.PREV_TYPE.isActiveAndMatches(key)) {
            MultiFunctionIconButton modeButton = this.modeButtonMap.get((Object)this.getEditedType());
            int i = this.modeButtons.indexOf((Object)modeButton);
            if (i < 0) {
                return true;
            }
            int s = this.modeButtons.size();
            i = (i + s - 1) % s;
            while (modeButton != this.modeButtons.get(i) && !this.modeButtons.get((int)i).f_93623_) {
                i = (i + s - 1) % s;
            }
            if (modeButton != this.modeButtons.get(i)) {
                this.modeButtons.get(i).press(0);
            }
            return true;
        }
        if (SimpleConfigMod.KeyBindings.NEXT_ERROR.isActiveAndMatches(key)) {
            if (this.hasErrors()) {
                this.focusNextError(true);
            } else if (this.hasConflictingExternalChanges()) {
                this.focusNextExternalConflict(true);
            }
            this.playFeedbackTap(0.4f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.PREV_ERROR.isActiveAndMatches(key)) {
            if (this.hasErrors()) {
                this.focusNextError(false);
            } else if (this.hasConflictingExternalChanges()) {
                this.focusNextExternalConflict(false);
            }
            this.playFeedbackTap(0.4f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.NEXT_EDITED.isActiveAndMatches(key)) {
            boolean edited = this.isEdited();
            if (edited) {
                this.focusNextEdited(true);
            }
            this.playFeedbackTap(edited ? 0.8f : 0.2f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.PREV_EDITED.isActiveAndMatches(key)) {
            boolean edited = this.isEdited();
            if (edited) {
                this.focusNextEdited(false);
            }
            this.playFeedbackTap(edited ? 0.8f : 0.2f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.SEARCH.isActiveAndMatches(key)) {
            this.searchBar.open();
            this.m_7522_((GuiEventListener)this.searchBar);
            this.searchBar.m_93692_(true);
            this.playFeedbackTap(1.0f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.UNDO.isActiveAndMatches(key)) {
            if (this.getHistory().canUndo()) {
                this.playFeedbackTap(1.0f);
            }
            this.undo();
            return true;
        }
        if (SimpleConfigMod.KeyBindings.REDO.isActiveAndMatches(key)) {
            if (this.getHistory().canRedo()) {
                this.playFeedbackTap(1.0f);
            }
            this.redo();
            return true;
        }
        if (SimpleConfigMod.KeyBindings.RESET_RESTORE.isActiveAndMatches(key)) {
            if (this.isSelecting()) {
                Set<AbstractConfigField<?>> selected = this.getSelectedEntries();
                if (Screen.m_96639_()) {
                    if (selected.stream().anyMatch(AbstractConfigField::isRestorable)) {
                        selected.forEach(AbstractConfigField::restoreValue);
                        this.playFeedbackTap(1.0f);
                        return true;
                    }
                } else if (selected.stream().anyMatch(AbstractConfigField::isResettable)) {
                    selected.forEach(AbstractConfigField::resetValue);
                    this.playFeedbackTap(1.0f);
                    return true;
                }
            } else {
                AbstractConfigField<?> entry;
                for (entry = this.getFocusedEntry(); entry != null && entry.isSubEntry(); entry = entry.getParentEntry()) {
                }
                if (entry != null) {
                    if (Screen.m_96639_()) {
                        entry.restoreValue();
                    } else {
                        entry.resetValue();
                    }
                    entry.navigate();
                    this.playFeedbackTap(1.0f);
                    return true;
                }
            }
            this.playFeedbackTap(0.4f);
            return true;
        }
        if (SimpleConfigMod.KeyBindings.HOTKEY.isActiveAndMatches(key)) {
            if (!this.isSelecting()) {
                HotKeyActionButton button;
                AbstractConfigField<?> entry;
                for (entry = (AbstractConfigField<?>)this.listWidget.getSelectedEntry(); entry != null && entry.isSubEntry(); entry = entry.getParentEntry()) {
                }
                if (entry != null && (button = entry.getHotKeyActionTypeButton()) != null && button.f_93623_) {
                    GuiEventListener focused = entry.m_7222_();
                    if (focused != button) {
                        if (focused instanceof AbstractWidget && ((AbstractWidget)focused).m_93696_()) {
                            focused.m_93692_(false);
                        }
                        if (entry.m_6702_().contains((Object)button)) {
                            entry.m_7522_((GuiEventListener)button);
                        }
                        button.m_93692_(true);
                    }
                    if (button.click(0)) {
                        return true;
                    }
                }
                this.playFeedbackTap(0.4f);
                return true;
            }
        } else if (SimpleConfigMod.KeyBindings.HELP.isActiveAndMatches(key)) {
            this.showingHelp = !this.showingHelp;
            this.playFeedbackTap(0.4f);
            return true;
        }
        return false;
    }

    @Override
    public void updateSelection() {
        boolean selecting;
        this.selectedEntries.clear();
        this.getSortedTypeCategories().stream().flatMap(c -> c.getAllMainEntries().stream()).filter(AbstractConfigField::isSelected).forEach(this.selectedEntries::add);
        boolean bl = selecting = !this.selectedEntries.isEmpty();
        if (selecting != this.isSelecting) {
            if (selecting) {
                if (this.hasUndoButtons()) {
                    this.redoButton.f_93624_ = false;
                    this.undoButton.f_93624_ = false;
                }
                this.invertSelectionButton.f_93624_ = true;
                this.selectAllButton.f_93624_ = true;
                MultiFunctionIconButton visible = this.modeButtonMap.get((Object)this.getEditedType());
                this.modeButtons.stream().filter(b -> b != visible).forEach(b -> {
                    b.f_93624_ = false;
                });
                visible.setExactWidth(20);
                visible.m_252865_(this.editFileButton.m_252754_() + 24);
                this.selectionToolbar.visible = true;
                int y = this.selectAllButton.m_252907_();
                this.navigateUpButton.m_264152_(47, y);
                this.navigateDownButton.m_264152_(69, y);
                if (this.navigateDownButton.m_252754_() + this.navigateDownButton.m_5711_() > this.quitButton.m_252754_() - 4) {
                    this.navigateDownButton.f_93624_ = false;
                    this.navigateUpButton.f_93624_ = false;
                }
            } else {
                int bx = 48;
                if (this.hasUndoButtons()) {
                    this.redoButton.f_93624_ = true;
                    this.undoButton.f_93624_ = true;
                    bx += 44;
                }
                this.invertSelectionButton.f_93624_ = false;
                this.selectAllButton.f_93624_ = false;
                this.navigateDownButton.f_93624_ = true;
                this.navigateUpButton.f_93624_ = true;
                this.modeButtons.forEach(b -> b.setWidthRange(20, 70));
                this.remoteCommonButton.setExactWidth(20);
                if ((double)(bx + this.modeButtons.stream().mapToInt(AbstractWidget::m_5711_).sum()) > 0.35 * (double)this.f_96543_) {
                    this.modeButtons.forEach(b -> b.setExactWidth(20));
                }
                for (MultiFunctionIconButton b2 : this.modeButtons) {
                    b2.m_252865_(bx);
                    bx += b2.m_5711_();
                    b2.f_93624_ = true;
                }
                this.selectionToolbar.visible = false;
                int y = this.selectAllButton.m_252907_();
                this.navigateUpButton.m_264152_(3, y);
                this.navigateDownButton.m_264152_(25, y);
            }
            this.isSelecting = selecting;
        }
    }

    @Override
    public void m_86600_() {
        if (this.scheduledTarget != null && this.scheduledTargetDelay-- <= 0) {
            this.scheduledTarget.navigate();
            this.scheduledTarget = null;
        }
        if (this.scheduledLayout) {
            this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        super.m_86600_();
        this.listWidget.tick();
        this.updateErrors();
        this.updateIsEdited();
        this.statusDisplayBar.tick();
        this.saveButton.tick();
        if (this.isEditingConfigHotKey()) {
            this.editedHotKeyButton.tick();
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int smY;
        if (this.f_96541_ == null) {
            return;
        }
        boolean hasDialog = this.hasDialogs();
        boolean suppressHover = hasDialog || this.shouldOverlaysSuppressHover(mouseX, mouseY);
        int smX = suppressHover ? -1 : mouseX;
        int n = smY = suppressHover ? -1 : mouseY;
        if (this.m_7222_() == null) {
            this.m_7522_((GuiEventListener)this.listWidget);
        }
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - (int)this.tabsScroller.scrollAmount;
            for (ConfigCategoryButton tabButton : this.tabButtons) {
                tabButton.m_252865_(xx);
                xx += tabButton.m_5711_() + 2;
            }
        }
        if (this.isTransparentBackground()) {
            gg.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1609560048, -1341124592);
        } else {
            this.m_280039_(gg);
        }
        this.listWidget.m_88315_(gg, smX, smY, delta);
        if (!this.isEditingConfigHotKey()) {
            Component title = this.getDisplayedTitle();
            if (this.isSelecting()) {
                this.selectionToolbar.render(gg, smX, smY, delta);
                gg.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"simpleconfig.ui.n_selected", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.selectedEntries.size())).m_130940_(ChatFormatting.AQUA)}), this.selectionToolbar.x + this.selectionToolbar.width + 6, 8, -1);
            } else {
                gg.m_280653_(this.f_96547_, title, (this.titleStartX + this.titleEndX) / 2, 8, -1);
            }
        }
        if (this.isShowingTabs()) {
            Rectangle r = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            boolean suppressHoverTabs = suppressHover || !r.contains(smX, smY);
            int smtX = suppressHoverTabs ? -1 : smX;
            int smtY = suppressHoverTabs ? -1 : smY;
            ScissorsHandler.INSTANCE.pushScissor(r);
            gg.m_280024_(r.x, r.y, r.getMaxX(), r.getMaxY(), 0x68000000, 0x68000000);
            this.drawTabsShades(gg, 0, this.isTransparentBackground() ? 120 : 255);
            this.tabButtons.forEach(widget -> widget.m_88315_(gg, smtX, smtY, delta));
            ScissorsHandler.INSTANCE.popScissor();
            this.buttonLeftTab.m_88315_(gg, smX, smY, delta);
            this.buttonRightTab.m_88315_(gg, smX, smY, delta);
        }
        this.searchBar.render(gg, smX, smY, delta);
        if (this.listWidget.isScrollingNow()) {
            this.removeTooltips(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.height));
        }
        if (!this.isEditingConfigHotKey()) {
            this.presetPickerWidget.m_88315_(gg, smX, smY, delta);
        } else {
            this.editedHotKeyButton.m_88315_(gg, smX, smY, delta);
        }
        super.m_88315_(gg, mouseX, mouseY, delta);
    }

    public Component getDisplayedTitle() {
        return this.displayTitle;
    }

    @Override
    @Nullable
    public ComponentPath handleTabNavigation(FocusNavigationEvent.TabNavigation e) {
        if (this.searchBar.isExpanded()) {
            this.reportedChildren = this.searchModeChildren;
            ComponentPath path = super.handleTabNavigation(e);
            this.reportedChildren = super.m_6702_();
            return path;
        }
        return super.handleTabNavigation(e);
    }

    @Nullable
    public INavigableTarget getNext(Predicate<INavigableTarget> predicate, boolean forwards, boolean preferSameCategory) {
        Predicate<Integer> check;
        Function<Integer, Integer> step;
        List<INavigableTarget> targets = this.listWidget.getNavigableTargets(false, true);
        if (targets.isEmpty()) {
            return null;
        }
        INavigableTarget target = this.listWidget.getSelectedTarget();
        int i = -1;
        int idx = target != null ? targets.indexOf(target) : -1;
        int s = targets.size();
        Function<Integer, Integer> function = step = forwards ? j -> (j + 1) % s : j -> (j - 1 + s) % s;
        Predicate<Integer> predicate2 = preferSameCategory ? j -> j != idx : (check = forwards ? j -> j > idx : j -> j < idx);
        if (target == null) {
            Optional<INavigableTarget> opt;
            Optional<INavigableTarget> optional = opt = forwards ? targets.stream().filter(predicate).findFirst() : Lists.reverse(targets).stream().filter(predicate).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
        } else {
            i = step.apply(idx);
            while (check.test(i)) {
                if (predicate.test(targets.get(i))) {
                    return targets.get(i);
                }
                i = step.apply(i);
            }
            if (preferSameCategory && predicate.test(target)) {
                return target;
            }
        }
        int cs = this.sortedCategories.size();
        int selectedIndex = this.sortedCategories.indexOf(this.selectedCategory);
        Function<Integer, Integer> catStep = forwards ? j -> (j + 1) % cs : j -> (j - 1 + cs) % cs;
        int j2 = catStep.apply(selectedIndex);
        while (j2 != selectedIndex) {
            Optional<INavigableTarget> opt;
            ConfigCategory cat = (ConfigCategory)this.sortedCategories.get(j2);
            List catTargets = this.getListWidget(cat).getNavigableTargets(false, true);
            if (!forwards) {
                catTargets = Lists.reverse(catTargets);
            }
            if ((opt = catTargets.stream().filter(predicate).findFirst()).isPresent()) {
                return opt.get();
            }
            j2 = catStep.apply(j2);
        }
        if (!preferSameCategory && i > -1) {
            while (i != idx) {
                if (predicate.test(targets.get(i))) {
                    return targets.get(i);
                }
                i = step.apply(i);
            }
            if (predicate.test(target)) {
                return target;
            }
        }
        return null;
    }

    public void focusNextExternalConflict(boolean forwards) {
        this.focusNextEntry(e -> e.hasExternalDiff() && !e.hasAcceptedExternalDiff(), forwards, false, INavigableTarget.HighlightColors.MERGE);
    }

    public void focusNextTarget(Predicate<INavigableTarget> predicate, boolean forwards, boolean preferSameCategory, int tint) {
        ConfigCategory cat = this.getSelectedCategory();
        INavigableTarget next = this.getNext(predicate, forwards, preferSameCategory);
        if (next != null) {
            AbstractConfigField<?> entry = next.findParentEntry();
            if (entry != null && entry.getCategory() != cat) {
                this.getSearchBar().close();
            }
            next.navigate();
            next.applyFocusHighlight(tint);
        }
    }

    public void focusNextEntry(Predicate<AbstractConfigField<?>> predicate, boolean forwards, boolean preferSameCategory, int tint) {
        this.focusNextTarget(t -> {
            if (!(t instanceof AbstractConfigField)) {
                return false;
            }
            AbstractConfigField entry = (AbstractConfigField)t;
            return !entry.isSubEntry() && predicate.test(entry) && entry.isEdited();
        }, forwards, preferSameCategory, tint);
    }

    public void focusNextError(boolean forwards) {
        this.focusNextError(forwards, true);
    }

    public void focusNextError(boolean forwards, boolean prefersSameCategory) {
        Map<INavigableTarget, EntryError> errorMap = this.sortedCategories.stream().flatMap(c -> c.getErrors().stream()).collect(Collectors.toMap(EntryError::getSource, e -> e, (a, b) -> a));
        this.focusNextTarget(errorMap::containsKey, forwards, prefersSameCategory, INavigableTarget.HighlightColors.ERROR);
    }

    public void focusNextEdited(boolean forwards) {
        this.focusNextEntry(t -> {
            AbstractConfigListEntry e;
            if (!(t instanceof AbstractConfigListEntry) || !(e = (AbstractConfigListEntry)t).isEdited()) {
                return false;
            }
            if (!(t instanceof CaptionedSubCategoryListEntry)) {
                return true;
            }
            CaptionedSubCategoryListEntry sc = (CaptionedSubCategoryListEntry)t;
            AbstractConfigField<?> ce = sc.getCaptionEntry();
            return ce != null && ce.isEdited();
        }, forwards, false, INavigableTarget.HighlightColors.EDITED);
    }

    private void drawTabsShades(GuiGraphics gg, int lightColor, int darkColor) {
        this.drawTabsShades(gg.m_280168_().m_85850_().m_252922_(), lightColor, darkColor);
    }

    private void drawTabsShades(Matrix4f matrix, int lightColor, int darkColor) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderTexture((int)0, (int)0);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bb = tessellator.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMinY(), 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMinY(), 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        tessellator.m_85914_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMaxY(), 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMaxY(), 0.0f).m_6122_(0, 0, 0, darkColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        bb.m_252986_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).m_6122_(0, 0, 0, lightColor).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public AbstractDialog getControlsDialog() {
        SimpleConfigGroup advanced2 = SimpleConfigMod.CLIENT_CONFIG.getGroup("advanced");
        String SHOW_UI_TIPS = "show_ui_tips";
        return ControlsHelpDialog.of("simpleconfig.ui.controls").category("general", c -> c.key("discard", "escape").key("save", SimpleConfigMod.KeyBindings.SAVE).key("undo", SimpleConfigMod.KeyBindings.UNDO).key("redo", SimpleConfigMod.KeyBindings.REDO).key("reset_restore", SimpleConfigMod.KeyBindings.RESET_RESTORE).key("hotkey", SimpleConfigMod.KeyBindings.HOTKEY).key("help", SimpleConfigMod.KeyBindings.HELP)).category("search", c -> c.key("open", SimpleConfigMod.KeyBindings.SEARCH).key("next_prev", "up/down, enter/left.shift+enter").key("toggle_filter", "left.alt+\"f\"").key("toggle_case", "left.alt+\"c\"").key("toggle_tooltips", "left.alt+\"t\"").key("toggle_regex", "left.alt+\"r\"")).category("navigation", c -> c.key("up_down", "left.alt+up/down").key("left", "left.alt+left").key("right", "left.alt+right").key("type.prev", SimpleConfigMod.KeyBindings.PREV_TYPE).key("type.next", SimpleConfigMod.KeyBindings.NEXT_TYPE).key("page.prev", SimpleConfigMod.KeyBindings.PREV_PAGE).key("page.next", SimpleConfigMod.KeyBindings.NEXT_PAGE).key("error.prev", SimpleConfigMod.KeyBindings.PREV_ERROR).key("error.next", SimpleConfigMod.KeyBindings.NEXT_ERROR).key("edited.prev", SimpleConfigMod.KeyBindings.PREV_EDITED).key("edited.next", SimpleConfigMod.KeyBindings.NEXT_EDITED)).category("lists", c -> c.key("move", "left.control+left.alt+up/down").key("move.drag", "mouse.middle/left.alt+mouse.left").key("insert", "left.alt+insert").key("remove", "left.alt+delete")).category("color", c -> c.key("use", "mouse.left").key("save", "mouse.right").key("delete", "mouse.middle")).text("category.options").withCheckboxes((r, b) -> {
            if (advanced2.hasGUI("show_ui_tips")) {
                advanced2.setGUI("show_ui_tips", b[0]);
                ClientConfig.advanced.show_ui_tips = b[0];
            } else {
                advanced2.set("show_ui_tips", b[0]);
            }
        }, CheckboxButton.of(advanced2.getGUIBoolean("show_ui_tips"), (Component)Component.m_237115_((String)"simpleconfig.ui.controls.show_ui_tips"))).build();
    }

    @Override
    public Pair<Integer, Integer> query(Pattern query) {
        Pair<Integer, Integer> result = this.listWidget.search(query);
        Map<ConfigCategory, Long> searches = this.sortedCategories.stream().filter(p -> p != this.selectedCategory).collect(Collectors.toMap(c -> c, c -> c.getHeldEntries().stream().mapToLong(e -> e.search(query).size()).sum()));
        for (ConfigCategoryButton button : this.tabButtons) {
            button.setTintColor(searches.getOrDefault(button.category, 0L) > 0L ? -2135048894 : 0);
        }
        return result;
    }

    @Override
    public void dismissQuery() {
        this.listWidget.search(NO_MATCH);
        this.tabButtons.forEach(b -> b.setTintColor(0));
    }

    @Override
    public void selectMatch(int idx) {
        this.listWidget.changeFocusedMatch(idx);
    }

    @Override
    public void focusResults() {
        ComponentPath path = this.m_264435_();
        if (path != null) {
            path.m_264432_(false);
        }
        this.m_7522_((GuiEventListener)this.listWidget);
    }

    @Override
    public TooltipSearchBarWidget getSearchBar() {
        return this.searchBar;
    }

    @Override
    public boolean isSelecting() {
        return this.isSelecting;
    }

    public static class TooltipSearchBarWidget
    extends SearchBarWidget {
        protected static Component[] TOOLTIP_SEARCH_TOOLTIP = new Component[]{Component.m_237115_((String)"simpleconfig.ui.search.tooltip"), Component.m_237115_((String)"key.modifier.alt").m_130946_(" + T").m_130940_(ChatFormatting.GRAY)};
        protected ToggleImageButton tooltipButton;
        protected boolean searchTooltips = ClientConfig.advanced.search.search_tooltips;

        public TooltipSearchBarWidget(SearchBarWidget.ISearchHandler handler, int x, int y, int w, IDialogCapableScreen screen) {
            this(handler, x, y, w, 24, screen);
        }

        public TooltipSearchBarWidget(SearchBarWidget.ISearchHandler handler, int x, int y, int w, int h, IDialogCapableScreen screen) {
            super(handler, x, y, w, h, screen);
            this.tooltipButton = new ToggleImageButton(this.searchTooltips, 0, 0, 18, 18, SimpleConfigIcons.SearchBar.SEARCH_TOOLTIPS, b -> this.updateModifiers());
            this.addOptionButton(0, this.tooltipButton);
        }

        @Override
        protected void updateModifiers() {
            this.searchTooltips = this.tooltipButton.getValue();
            ConfigEntryHolder g = SimpleConfigMod.CLIENT_CONFIG.getChild("advanced.search");
            String SEARCH_TOOLTIPS = "search_tooltips";
            if (g.hasGUI()) {
                g.setGUI(SEARCH_TOOLTIPS, this.searchTooltips);
            } else {
                g.set(SEARCH_TOOLTIPS, this.searchTooltips);
            }
            super.updateModifiers();
        }

        @Override
        public Optional<Component[]> getTooltip(double mouseX, double mouseY) {
            if (this.isExpanded() && this.tooltipButton.m_5953_(mouseX, mouseY)) {
                return Optional.of(TOOLTIP_SEARCH_TOOLTIP);
            }
            return super.getTooltip(mouseX, mouseY);
        }

        @Override
        public boolean m_5534_(char codePoint, int modifiers) {
            if (Screen.m_96639_() && Character.toLowerCase(codePoint) == 't') {
                this.tooltipButton.setValue(!this.tooltipButton.getValue());
                return true;
            }
            return super.m_5534_(codePoint, modifiers);
        }

        public boolean isSearchTooltips() {
            return this.searchTooltips;
        }
    }

    protected static class SaveButton
    extends TintedButton {
        private final SimpleConfigScreen screen;

        public SaveButton(SimpleConfigScreen screen) {
            super(0, 0, 80, 20, GameNarrator.f_93310_, button -> {
                if (screen.isEditingConfigHotKey()) {
                    screen.saveHotkey();
                } else {
                    boolean hasErrors = screen.hasErrors();
                    if (hasErrors) {
                        if (!ClientConfig.advanced.allow_save_with_errors) {
                            return;
                        }
                        screen.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.save_with_errors.dialog.title"), d -> {
                            d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.save_with_errors.dialog.body", new Object[0]));
                            d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.save_with_errors"));
                            d.setConfirmButtonTint(-2130739200);
                            d.withAction(s -> {
                                if (s) {
                                    screen.saveAll(true, true, false, true);
                                }
                            });
                        }));
                    } else {
                        screen.saveAll(true);
                    }
                }
            });
            this.screen = screen;
        }

        public void tick() {
            boolean hasErrors = this.screen.hasErrors();
            this.f_93623_ = (!hasErrors || ClientConfig.advanced.allow_save_with_errors) && this.screen.isEdited();
            boolean editingHotKey = this.screen.isEditingConfigHotKey();
            this.setTintColor(hasErrors && ClientConfig.advanced.allow_save_with_errors ? -2130771968 : -2143109822);
            this.m_93666_((Component)Component.m_237115_((String)(hasErrors ? (ClientConfig.advanced.allow_save_with_errors ? "simpleconfig.ui.save_with_errors" : "simpleconfig.ui.error_cannot_save") : (editingHotKey ? "simpleconfig.ui.save_hotkey" : "simpleconfig.ui.save"))));
        }
    }

    public static class ListWidget<R extends AbstractConfigField<?>>
    extends DynamicElementListWidget<R> {
        private final AbstractConfigScreen screen;
        private final ConfigCategory category;
        private boolean hasCurrent;
        private double currentX;
        private double currentY;
        private double currentWidth;
        private double currentHeight;
        private final ToggleAnimator tabSlideAnimator = new ToggleAnimator(100L);
        private EntryDragAction<?> entryDragAction;
        public Rectangle target;
        public Rectangle thisTimeTarget;
        public long lastTouch;
        public long start;
        public long duration;

        public ListWidget(AbstractConfigScreen screen, Minecraft client, int width, int height, ConfigCategory category, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.category = category;
            this.screen = screen;
        }

        public void playTabSlideAnimation(boolean fromRight) {
            this.tabSlideAnimator.resetTarget();
            this.tabSlideAnimator.setOutputRange(fromRight ? (float)this.width * 0.2f : (float)(-this.width) * 0.2f, 0.0f);
        }

        @Override
        public int getItemWidth() {
            return this.right - this.left - 80;
        }

        @Override
        public int getFieldWidth() {
            return (int)Mth.m_14036_((float)((float)(this.right - this.left) * 0.3f), (float)80.0f, (float)250.0f);
        }

        @Override
        public int getKeyFieldWidth() {
            return (int)Mth.m_14036_((float)((float)(this.right - this.left) * 0.25f), (float)80.0f, (float)250.0f);
        }

        @Override
        protected int getScrollBarPosition() {
            return this.right - 36;
        }

        public void startDragAction(EntryDragAction<?> action) {
            this.entryDragAction = action;
        }

        @Override
        protected void renderItem(GuiGraphics matrices, R item, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            ((AbstractConfigField)item).updateFocused(this.getFocusedItem() == item);
            super.renderItem(matrices, item, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        }

        @Override
        protected void renderList(GuiGraphics gg, int startX, int startY, int mouseX, int mouseY, float delta) {
            long timePast;
            boolean animated = this.tabSlideAnimator.isInProgress();
            PoseStack mStack = gg.m_280168_();
            if (animated) {
                mStack.m_85836_();
                mStack.m_252880_(-this.tabSlideAnimator.getEaseOut(), 0.0f, 0.0f);
            }
            if (this.entryDragAction != null) {
                this.entryDragAction.applyToList(this, mouseX, mouseY);
            }
            this.thisTimeTarget = null;
            if (this.hasCurrent) {
                timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : Mth.m_14165_((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                this.fillGradient(gg, this.currentX, this.currentY, this.currentX + this.currentWidth, this.currentY + this.currentHeight, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(gg, startX, startY, mouseX, mouseY, delta);
            if (this.m_7282_() || this.thisTimeTarget != null && !this.thisTimeTarget.contains(mouseX, mouseY)) {
                this.thisTimeTarget = null;
            }
            if (this.thisTimeTarget != null && this.m_5953_(mouseX, mouseY)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null) {
                this.thisTimeTarget = new Rectangle(0, this.thisTimeTarget.y, this.width, this.thisTimeTarget.height);
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals(this.target)) {
                if (!this.hasCurrent) {
                    this.currentX = this.thisTimeTarget.x;
                    this.currentY = this.thisTimeTarget.y;
                    this.currentWidth = this.thisTimeTarget.width;
                    this.currentHeight = this.thisTimeTarget.height;
                    this.hasCurrent = true;
                }
                this.target = this.thisTimeTarget.copy();
                this.start = this.lastTouch;
                this.duration = 40L;
            } else if (this.hasCurrent && this.target != null) {
                timePast = System.currentTimeMillis() - this.start;
                this.currentX = (int)ScrollingHandler.ease(this.currentX, this.target.x, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentY = (int)ScrollingHandler.ease(this.currentY, this.target.y, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentWidth = (int)ScrollingHandler.ease(this.currentWidth, this.target.width, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentHeight = (int)ScrollingHandler.ease(this.currentHeight, this.target.height, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
            }
            if (animated) {
                mStack.m_85849_();
            }
        }

        @Override
        protected MutableComponent getEmptyPlaceHolder() {
            if (!this.category.isLoaded()) {
                CompletableFuture<Boolean> future = this.category.getLoadingFuture();
                return Component.m_237115_((String)(future == null || future.isDone() ? "simpleconfig.ui.not_available" : "simpleconfig.ui.loading"));
            }
            SearchBarWidget bar = this.screen.getSearchBar();
            return bar.isFilter() && bar.isExpanded() ? Component.m_237115_((String)"simpleconfig.ui.no_matches").m_130940_(ChatFormatting.GOLD) : super.getEmptyPlaceHolder();
        }

        protected void fillGradient(GuiGraphics gg, double xStart, double yStart, double xEnd, double yEnd, int colorStart, int colorEnd) {
            RenderSystem.setShaderTexture((int)0, (int)0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::m_172811_);
            AbstractConfigScreen.fillGradient(gg, xStart, yStart, xEnd, yEnd, 0, colorStart, colorEnd);
            RenderSystem.disableBlend();
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.updateScrollingState(mouseX, mouseY, button);
            if (!this.m_5953_(mouseX, mouseY)) {
                return false;
            }
            for (AbstractConfigField entry : this.m_6702_()) {
                if (!entry.m_6375_(mouseX, mouseY, button)) continue;
                this.m_7522_((GuiEventListener)entry);
                if (!this.m_7282_()) {
                    this.setDragged((Pair<Integer, GuiEventListener>)Pair.of((Object)button, (Object)entry));
                }
                this.m_7897_(true);
                this.updateSelectedTarget();
                return true;
            }
            if (button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.entryDragAction != null || super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        @Override
        public void endDrag(double mouseX, double mouseY, int button) {
            super.endDrag(mouseX, mouseY, button);
            this.entryDragAction = null;
        }

        @Override
        protected void renderBackBackground(GuiGraphics gg, BufferBuilder buffer, Tesselator tessellator) {
            if (!this.screen.isTransparentBackground()) {
                super.renderBackBackground(gg, buffer, tessellator);
            } else {
                this.fillGradient(gg, 0.0, this.top, this.width, this.bottom, 0x68000000, 0x68000000);
            }
        }

        @Override
        protected void renderBarBackground(GuiGraphics gg, int y1, int y2, int alpha1, int alpha2) {
            if (!this.screen.isTransparentBackground()) {
                super.renderBarBackground(gg, y1, y2, alpha1, alpha2);
            }
            if (this.screen.isEditingConfigHotKey()) {
                gg.m_280509_(0, y1, this.width, y2, 1216389375);
            }
        }

        public void onReplaced(ListWidget<R> other) {
            this.tick();
            if (this == other) {
                return;
            }
            other.setExtraScroll(this.getExtraScroll());
            AbstractConfigField entry = (AbstractConfigField)this.getSelectedEntry();
            if (entry != null) {
                entry.updateFocused(false);
            }
            if ((entry = (AbstractConfigField)other.getSelectedEntry()) != null) {
                entry.navigate();
            }
        }

        public static abstract class EntryDragAction<T> {
            public final T value;

            public EntryDragAction(T value) {
                this.value = value;
            }

            public void applyToList(DynamicEntryListWidget<?> list, int mouseX, int mouseY) {
                Lists.reverse(list.getNavigableTargets(true, false)).stream().filter(e -> e.getRowArea().contains(mouseX, mouseY)).findFirst().ifPresent(entry -> {
                    if (this.apply((INavigableTarget)entry, mouseX, mouseY)) {
                        this.onSuccess((INavigableTarget)entry, mouseX, mouseY);
                    }
                });
            }

            public void onSuccess(INavigableTarget entry, int mouseX, int mouseY) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)0.6f));
            }

            public abstract boolean apply(INavigableTarget var1, int var2, int var3);

            public static class ExpandedDragAction
            extends EntryDragAction<Boolean> {
                public ExpandedDragAction(Boolean value) {
                    super(value);
                }

                @Override
                public boolean apply(INavigableTarget target, int mouseX, int mouseY) {
                    if (target instanceof IExpandable) {
                        AbstractConfigListEntry entry;
                        IExpandable expandable = (IExpandable)((Object)target);
                        if (target instanceof AbstractConfigListEntry && !(entry = (AbstractConfigListEntry)target).isMouseOverRow(mouseX, mouseY)) {
                            return false;
                        }
                        if (expandable.isExpanded() != ((Boolean)this.value).booleanValue()) {
                            expandable.setExpanded((Boolean)this.value);
                            return expandable.isExpanded() == ((Boolean)this.value).booleanValue();
                        }
                    }
                    return false;
                }
            }

            public static class SelectionDragAction
            extends EntryDragAction<Boolean> {
                public SelectionDragAction(Boolean value) {
                    super(value);
                }

                @Override
                public boolean apply(INavigableTarget target, int mouseX, int mouseY) {
                    AbstractConfigListEntry entry;
                    if (target instanceof AbstractConfigListEntry && (entry = (AbstractConfigListEntry)target).getSelectionCheckbox().m_5953_(mouseX, mouseY) && entry.isSelectable() && entry.isSelected() != ((Boolean)this.value).booleanValue()) {
                        entry.setSelected((Boolean)this.value);
                        return entry.isSelected() == ((Boolean)this.value).booleanValue();
                    }
                    return false;
                }
            }
        }
    }

    public static class EditConfigFileDialog
    extends ConfirmDialog {
        protected TintedButton openAndExit;
        protected final Path file;

        public static EditConfigFileDialog create(AbstractConfigScreen screen, Path file) {
            return EditConfigFileDialog.create(screen, file, null);
        }

        public static EditConfigFileDialog create(AbstractConfigScreen screen, Path file, @Nullable Consumer<EditConfigFileDialog> builder) {
            EditConfigFileDialog dialog = new EditConfigFileDialog(screen, file);
            if (builder != null) {
                builder.accept(dialog);
            }
            return dialog;
        }

        protected EditConfigFileDialog(AbstractConfigScreen screen, Path file) {
            super((Component)Component.m_237115_((String)"simpleconfig.file.dialog.title"));
            this.withAction(b -> {
                if (b) {
                    EditConfigFileDialog.open(file);
                }
            });
            this.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.file.dialog.body", Component.m_237113_((String)file.toString()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_AQUA).m_131162_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, file.toString())))));
            this.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.file.dialog.option.open_n_continue"));
            this.setConfirmButtonTint(-1434451798);
            this.file = file;
            this.openAndExit = new TintedButton(0, 0, 0, 20, (Component)Component.m_237115_((String)"simpleconfig.file.dialog.option.open_n_discard"), p -> {
                EditConfigFileDialog.open(file);
                this.cancel(true);
                screen.quit(true);
            });
            this.openAndExit.setTintColor(-1433386480);
            this.addButton(1, (AbstractWidget)this.openAndExit);
        }

        protected static void open(Path path) {
            Util.m_137581_().m_137644_(path.toFile());
        }
    }
}

