/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ProgressDialog
extends ConfirmDialog {
    private static final Logger LOGGER = LogManager.getLogger();
    protected List<Component> actualBody = Lists.newArrayList();
    protected boolean cancellableByUser = true;
    protected boolean closeOnExceptions = false;
    protected CompletableFuture<?> future;
    @Nullable
    protected List<Component> error = null;
    @Nullable
    protected Icon iconSave = null;
    protected Supplier<@Nullable AbstractDialog> successDialog = () -> null;

    public static ProgressDialog create(Component title, CompletableFuture<?> future) {
        return ProgressDialog.create(title, future, null);
    }

    public static ProgressDialog create(Component title, CompletableFuture<?> future, @Nullable Consumer<ProgressDialog> builder) {
        ProgressDialog dialog = new ProgressDialog(title, future);
        if (builder != null) {
            builder.accept(dialog);
        }
        return dialog;
    }

    protected ProgressDialog(Component title, CompletableFuture<?> future) {
        super(title);
        this.future = future;
        this.setCancelButtonTint(-2135088092);
        this.removeButton((AbstractWidget)this.confirmButton);
        this.setPersistent(true);
        this.updateActualBody();
        this.setIcon(SimpleConfigIcons.SPINNING_CUBE);
    }

    @Override
    public boolean escapeKeyPressed() {
        if (this.m_7222_() != this.cancelButton) {
            this.m_7522_((GuiEventListener)this.cancelButton);
        } else {
            this.cancel(false);
        }
        return true;
    }

    @Override
    public void cancel(boolean success) {
        AbstractDialog next;
        super.cancel(success);
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (success && (next = this.successDialog.get()) != null) {
            ((IDialogCapableScreen)this.getScreen()).addDialog(next);
        }
    }

    protected void update() {
        if (this.future != null) {
            if (this.future.isDone() && !this.future.isCancelled() && !this.future.isCompletedExceptionally()) {
                this.future = null;
                this.cancel(true);
            } else if (this.future.isCancelled()) {
                this.future = null;
                this.cancel(false);
            } else if (this.future.isCompletedExceptionally()) {
                try {
                    this.future.join();
                }
                catch (CompletionException e) {
                    Throwable cause = e.getCause();
                    LOGGER.error("Operation completed exceptionally, cause:", cause);
                    this.setError(this.renderException(cause));
                }
                this.future = null;
                if (this.closeOnExceptions) {
                    this.cancel(false);
                }
            }
        }
    }

    protected List<Component> renderException(Throwable e) {
        StackTraceElement[] trace = e.getStackTrace();
        ArrayList l = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)(e.getClass().getSimpleName() + ": " + e.getLocalizedMessage())).m_130940_(ChatFormatting.RED)});
        if (trace.length > 0) {
            l.add(Component.m_237113_((String)("  at " + trace[0].getFileName() + ":" + trace[0].getLineNumber())).m_130940_(ChatFormatting.RED));
        }
        if (e.getCause() != null) {
            List<Component> c = this.renderException(e.getCause());
            c.set(0, (Component)Component.m_237113_((String)"caused by: ").m_130940_(ChatFormatting.RED).m_7220_(c.get(0)));
            l.addAll(c);
        }
        return l;
    }

    @Override
    protected void layout() {
        super.layout();
    }

    @Override
    public void renderInner(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        this.update();
        int tx = x + 4;
        int ty = y + 4;
        for (List line : this.lines) {
            for (FormattedCharSequence l : line) {
                gg.m_280648_(this.font, l, tx, ty, this.bodyColor);
                ty += this.lineHeight;
            }
            ty += this.paragraphMarginDown;
        }
        this.cancelButton.f_93623_ = this.cancellableByUser || this.future == null || this.future.isDone();
    }

    protected void updateActualBody() {
        this.actualBody.clear();
        this.actualBody.addAll(this.body);
        if (this.error != null) {
            this.actualBody.addAll(this.error);
        }
    }

    @Override
    public List<Component> getBody() {
        return this.actualBody;
    }

    @Override
    public void setBody(List<? extends Component> body) {
        this.body = new ArrayList<Component>(body);
        this.updateActualBody();
    }

    public boolean isCancellableByUser() {
        return this.cancellableByUser;
    }

    public void setCancellableByUser(boolean cancellableByUser) {
        this.cancellableByUser = cancellableByUser;
    }

    public boolean isCloseOnExceptions() {
        return this.closeOnExceptions;
    }

    public void setCloseOnExceptions(boolean closeOnExceptions) {
        this.closeOnExceptions = closeOnExceptions;
    }

    public void setSuccessDialog(@Nullable AbstractDialog dialog) {
        this.setSuccessDialog(() -> dialog);
    }

    public void setSuccessDialog(Supplier<@Nullable AbstractDialog> dialogSupplier) {
        this.successDialog = dialogSupplier;
    }

    @Nullable
    public List<Component> getError() {
        return this.error;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.iconSave = icon;
    }

    protected List<Component> decorateError(List<Component> error) {
        return error.stream().map(t -> t.m_6881_().m_130940_(ChatFormatting.RED)).collect(Collectors.toList());
    }

    public void setError(@Nullable List<Component> error) {
        if (error != null) {
            error = this.decorateError(error);
        }
        this.error = error;
        int height = this.getInnerHeight();
        this.updateActualBody();
        if (error != null) {
            this.scroller.scrollTo(height, true);
        }
        Icon iconSave = this.iconSave;
        this.setIcon(error != null ? null : iconSave);
        this.iconSave = iconSave;
    }

    public void setError(Throwable error) {
        this.setError(this.renderException(error));
    }
}

