/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig")
public class OverlayInjector {
    private static final Map<Screen, IOverlayCapableContainer.SortedOverlayCollection> CACHE = new WeakHashMap<Screen, IOverlayCapableContainer.SortedOverlayCollection>();

    private static IOverlayCapableContainer.SortedOverlayCollection getOverlays(Screen screen) {
        return CACHE.computeIfAbsent(screen, s -> new IOverlayCapableContainer.SortedOverlayCollection());
    }

    public static void injectVisualOverlay(Rectangle area, IOverlayCapableContainer.IOverlayRenderer overlay2, int priority) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen != null) {
            OverlayInjector.injectVisualOverlay(screen, area, overlay2, priority);
        }
    }

    public static void injectVisualOverlay(Screen screen, Rectangle area, IOverlayCapableContainer.IOverlayRenderer overlay2, int priority) {
        OverlayInjector.getOverlays(screen).add(area, overlay2, priority);
    }

    @SubscribeEvent
    public static void onRenderScreen(ScreenEvent.Render.Post event) {
        IOverlayCapableContainer.SortedOverlayCollection sortedOverlays = OverlayInjector.getOverlays(event.getScreen());
        if (sortedOverlays == null) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        int mouseX = event.getMouseX();
        int mouseY = event.getMouseY();
        float delta = event.getPartialTick();
        LinkedList<IOverlayCapableContainer.OverlayTicket> removed = new LinkedList<IOverlayCapableContainer.OverlayTicket>();
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        mStack.m_85837_(0.0, 0.0, 100.0);
        Screen screen = Minecraft.m_91087_().f_91080_;
        IMultiTooltipScreen tScreen = screen instanceof IMultiTooltipScreen ? (IMultiTooltipScreen)screen : null;
        for (IOverlayCapableContainer.OverlayTicket ticket : sortedOverlays) {
            if (tScreen != null) {
                tScreen.removeTooltips(ticket.area);
            }
            ScissorsHandler.INSTANCE.pushScissor(ticket.area);
            if (!ticket.renderer.renderOverlay(gg, ticket.area, mouseX, mouseY, delta)) {
                removed.add(ticket);
            }
            ScissorsHandler.INSTANCE.popScissor();
        }
        mStack.m_85849_();
        sortedOverlays.removeAll(removed);
    }
}

