/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalChangesDialog
extends ConfirmDialog {
    TintedButton acceptAllButton;
    protected SimpleConfig.EditType type;
    @Nullable
    protected Consumer<ExternalChangeResponse> responseAction;

    public static ExternalChangesDialog create(SimpleConfig.EditType type, Consumer<ExternalChangeResponse> handler) {
        return ExternalChangesDialog.create(type, handler, null);
    }

    public static ExternalChangesDialog create(SimpleConfig.EditType type, Consumer<ExternalChangeResponse> handler, @Nullable Consumer<ExternalChangesDialog> builder) {
        ExternalChangesDialog dialog = new ExternalChangesDialog(type, handler);
        if (builder != null) {
            builder.accept(dialog);
        }
        return dialog;
    }

    protected ExternalChangesDialog(SimpleConfig.EditType type, @NotNull Consumer<ExternalChangeResponse> action) {
        super((Component)Component.m_237115_((String)(type == SimpleConfig.EditType.SERVER ? "simpleconfig.ui.remote_changes_detected.title" : "simpleconfig.ui.external_changes_detected.title")));
        this.type = type;
        this.responseAction = action;
        this.setPersistent(true);
        this.setBody(Stream.concat(SimpleConfigTextUtil.splitTtc(type == SimpleConfig.EditType.SERVER ? "simpleconfig.ui.remote_changes_detected.body" : "simpleconfig.ui.external_changes_detected.body", new Object[0]).stream(), Stream.of(Component.m_237119_(), Component.m_237115_((String)"simpleconfig.ui.prompt_accept_changes"))).collect(Collectors.toList()));
        this.acceptAllButton = new TintedButton(0, 0, 120, 20, (Component)Component.m_237115_((String)"simpleconfig.ui.action.accept_all_changes"), p -> {
            if (this.responseAction != null) {
                this.responseAction.accept(ExternalChangeResponse.ACCEPT_ALL);
                this.responseAction = null;
                this.cancel(true);
            }
        });
        this.addButton(1, (AbstractWidget)this.acceptAllButton);
        this.cancelButton.setTintColor(-2139151324);
        this.acceptAllButton.setTintColor(-2139007953);
        this.confirmButton.setTintColor(-2140654440);
        this.withAction(this::action);
        this.setCancelText((Component)Component.m_237115_((String)"simpleconfig.ui.action.reject_changes"));
        this.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.action.accept_non_conflicting_changes"));
    }

    public void action(boolean acceptUnedited) {
        if (this.responseAction != null) {
            this.responseAction.accept(acceptUnedited ? ExternalChangeResponse.ACCEPT_NON_CONFLICTING : ExternalChangeResponse.REJECT);
        }
    }

    public static enum ExternalChangeResponse {
        REJECT,
        ACCEPT_ALL,
        ACCEPT_NON_CONFLICTING;

    }
}

