/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.ControlsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class ControlsHelpDialog
extends ConfirmDialog {
    protected ControlsHelpDialog(Component title) {
        super(title);
    }

    public static Builder of(String prefix) {
        return ControlsHelpDialog.of(prefix, (Component)Component.m_237115_((String)"simpleconfig.ui.controls"));
    }

    public static Builder of(String prefix, Component title) {
        return new Builder(prefix, title);
    }

    public static class Builder {
        private static final Pattern COMMA = Pattern.compile("\\s*,\\s*");
        private static final Pattern SLASH = Pattern.compile("\\s*/\\s*");
        private final Component title;
        private final String prefix;
        private final List<Component> lines = Lists.newArrayList();
        private Style categoryStyle = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true));
        private Style keyStyle = Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA);
        private Style keyBindStyle = Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN);
        private Style unboundKeyBindStyle = Style.f_131099_.m_131140_(ChatFormatting.DARK_RED);
        private Style modifierStyle = Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE);
        private Style helpStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
        private CheckboxButton[] checkBoxes = new CheckboxButton[0];
        private ConfirmDialog.ComplexDialogAction action = (v, s) -> {};
        private Component confirmText = CommonComponents.f_130655_;
        @Nullable
        private Function<Screen, Screen> controlsScreenSupplier = s -> new ControlsScreen(s, Minecraft.m_91087_().f_91066_);
        private static final Pattern TITLE_CASE_PATTERN = Pattern.compile("(?<!\\w)\\w");

        private Builder(String prefix, Component title) {
            this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
            this.title = title;
        }

        private MutableComponent parseSingle(String key) {
            return KeyBindMapping.parse(key).getDisplayName(this.keyStyle).m_6881_();
        }

        private MutableComponent parse(String keys) {
            MutableComponent comma = Component.m_237113_((String)", ").m_130948_(this.keyStyle);
            MutableComponent slash = Component.m_237113_((String)"/").m_130948_(this.keyStyle);
            return Arrays.stream(COMMA.split(keys)).map(s -> Arrays.stream(SLASH.split((CharSequence)s)).map(this::parseSingle).reduce((a, b) -> a.m_7220_((Component)slash).m_7220_((Component)b)).orElse(Component.m_237119_())).reduce((a, b) -> a.m_7220_((Component)comma).m_7220_((Component)b)).orElse(Component.m_237119_());
        }

        private static String toTitleCase(String s) {
            Matcher m = TITLE_CASE_PATTERN.matcher(s.toLowerCase());
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                m.appendReplacement(sb, m.group().toUpperCase());
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public Builder withCategoryStyle(Function<Style, Style> styleModifier) {
            this.categoryStyle = styleModifier.apply(this.categoryStyle);
            return this;
        }

        public Builder withKeyStyle(Function<Style, Style> styleModifier) {
            this.keyStyle = styleModifier.apply(this.keyStyle);
            return this;
        }

        public Builder withKeyBindStyle(Function<Style, Style> styleModifier) {
            this.keyBindStyle = styleModifier.apply(this.keyBindStyle);
            return this;
        }

        public Builder withUnboundKeyBindStyle(Function<Style, Style> styleModifier) {
            this.unboundKeyBindStyle = styleModifier.apply(this.unboundKeyBindStyle);
            return this;
        }

        public Builder withModifierStyle(Function<Style, Style> styleModifier) {
            this.modifierStyle = styleModifier.apply(this.modifierStyle);
            return this;
        }

        public Builder withHelpStyle(Function<Style, Style> styleModifier) {
            this.helpStyle = styleModifier.apply(this.helpStyle);
            return this;
        }

        public Builder withAction(ConfirmDialog.DialogAction action) {
            this.action = action::handle;
            return this;
        }

        public Builder withCheckboxes(ConfirmDialog.ComplexDialogAction action, CheckboxButton ... checkBoxes) {
            this.action = action;
            this.checkBoxes = checkBoxes;
            return this;
        }

        public Builder withConfirmText(Component confirmText) {
            this.confirmText = confirmText;
            return this;
        }

        public Builder withControlsScreen(@Nullable Function<Screen, Screen> controlsScreenSupplier) {
            this.controlsScreenSupplier = controlsScreenSupplier;
            return this;
        }

        public Builder category(String name, Consumer<CategoryBuilder> builder) {
            this.lines.add((Component)Component.m_237115_((String)(this.prefix + "category." + name)).m_130948_(this.categoryStyle));
            builder.accept(new CategoryBuilder(name));
            this.lines.add((Component)Component.m_237119_());
            return this;
        }

        public Builder text(String key) {
            return this.text((Component)Component.m_237115_((String)(this.prefix + key)));
        }

        public Builder text(Component text) {
            this.lines.add(text);
            return this;
        }

        public ControlsHelpDialog build() {
            ControlsHelpDialog d = new ControlsHelpDialog(this.title);
            d.setBody(this.lines);
            d.setConfirmText(this.confirmText);
            d.withCheckBoxes(this.action, this.checkBoxes);
            d.removeButton((AbstractWidget)d.cancelButton);
            d.setIcon(SimpleConfigIcons.Buttons.KEYBOARD);
            if (this.controlsScreenSupplier != null) {
                d.addButton(0, (AbstractWidget)MultiFunctionIconButton.of(SimpleConfigIcons.Buttons.KEYBOARD, -1, -1, MultiFunctionImageButton.ButtonAction.of(() -> {
                    Minecraft.m_91087_().m_91152_(this.controlsScreenSupplier.apply((Screen)d.getScreen()));
                    d.cancel();
                }).title(() -> Component.m_237115_((String)"simpleconfig.ui.controls.edit_controls")).tint(-2139005906)));
            }
            return d;
        }

        public class CategoryBuilder {
            private final String name;

            public CategoryBuilder(String name) {
                this.name = name;
            }

            public CategoryBuilder key(String help, String keys) {
                MutableComponent keyHelp = Component.m_237115_((String)(Builder.this.prefix + this.name + "." + help)).m_130948_(Builder.this.helpStyle);
                Builder.this.lines.add((Component)Builder.this.parse(keys).m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)keyHelp));
                return this;
            }

            public CategoryBuilder key(String help, KeyMapping key) {
                MutableComponent keyHelp = Component.m_237115_((String)(Builder.this.prefix + this.name + "." + help)).m_130948_(Builder.this.helpStyle);
                String keyName = key.m_90862_() ? "---" : Builder.toTitleCase(key.m_90863_().getString());
                Builder.this.lines.add((Component)Component.m_237113_((String)keyName).m_130948_(key.m_90862_() ? Builder.this.unboundKeyBindStyle : Builder.this.keyBindStyle).m_7220_((Component)Component.m_237113_((String)": ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)keyHelp));
                return this;
            }

            public CategoryBuilder text(String key) {
                return this.text((Component)Component.m_237115_((String)(Builder.this.prefix + this.name + "." + key)));
            }

            public CategoryBuilder text(Component text) {
                Builder.this.lines.add(text);
                return this;
            }
        }
    }
}

