/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ConfirmLinkDialog
extends ConfirmDialog {
    protected TintedButton copyButton;
    protected String link;

    public static ConfirmLinkDialog create(String link, boolean securityWarning) {
        return ConfirmLinkDialog.create(link, securityWarning, null);
    }

    public static ConfirmLinkDialog create(String link, boolean securityWarning, @Nullable Consumer<ConfirmLinkDialog> builder) {
        ConfirmLinkDialog dialog = new ConfirmLinkDialog(link, securityWarning);
        if (builder != null) {
            builder.accept(dialog);
        }
        return dialog;
    }

    public ConfirmLinkDialog(String link, boolean securityWarning) {
        this(link, (Component)Component.m_237115_((String)"chat.link.confirmTrusted"), Lists.newArrayList(), CommonComponents.f_130656_, (Component)Component.m_237115_((String)"chat.copy"), (Component)Component.m_237115_((String)"chat.link.open"), securityWarning);
    }

    protected MutableComponent formatLink(String link) {
        if (((String)link).length() > 256) {
            link = ((String)link).substring(0, 253) + "...";
        }
        return Component.m_237113_((String)link).m_130940_(ChatFormatting.GRAY);
    }

    public ConfirmLinkDialog(String link, Component title, List<Component> body, Component cancelText, Component copyText, Component confirmText, boolean securityWarning) {
        super(title);
        this.setCancelText(cancelText);
        this.setConfirmText(confirmText);
        this.withAction(this::action);
        if (securityWarning) {
            body.add(0, (Component)Component.m_237115_((String)"chat.link.warning"));
        }
        body.add((Component)Component.m_237110_((String)"simpleconfig.ui.link.display", (Object[])new Object[]{this.formatLink(link)}));
        this.setBody(body);
        this.link = link;
        this.copyButton = new TintedButton(0, 0, 120, 20, copyText, p -> this.copy());
        this.copyButton.setTintColor(-2145114947);
        this.addButton(1, (AbstractWidget)this.copyButton);
        this.confirmButton.setTintColor(-2136969200);
    }

    public void copy() {
        this.cancel(false);
        Minecraft.m_91087_().f_91068_.m_90911_(this.link);
    }

    public void action(boolean go) {
        if (go) {
            Util.m_137581_().m_137646_(this.link);
        }
    }

    public void setCopyButtonTint(int color) {
        this.copyButton.setTintColor(color);
    }
}

