/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import endorh.simpleconfig.ui.gui.AbstractButtonDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.TintedButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class ConfirmDialog
extends AbstractButtonDialog {
    protected List<Component> body = Collections.emptyList();
    protected int bodyColor = -4342339;
    protected int lineHeight = 10;
    protected int paragraphMarginDown = 4;
    protected List<List<FormattedCharSequence>> lines;
    protected TintedButton cancelButton;
    protected TintedButton confirmButton;
    protected DialogAction action = (v, s) -> {};
    protected CheckboxButton[] checkBoxes = new CheckboxButton[0];

    public static ConfirmDialog create(Component title) {
        return ConfirmDialog.create(title, d -> {});
    }

    public static ConfirmDialog create(Component title, Consumer<ConfirmDialog> builder) {
        ConfirmDialog dialog = new ConfirmDialog(title);
        builder.accept(dialog);
        return dialog;
    }

    protected ConfirmDialog(Component title) {
        super(title);
        this.cancelButton = TintedButton.of(CommonComponents.f_130656_, p -> this.cancel());
        this.confirmButton = TintedButton.of(CommonComponents.f_130659_, p -> this.confirm());
        this.addButton((AbstractWidget)this.cancelButton);
        this.addButton((AbstractWidget)this.confirmButton);
        this.m_7522_((GuiEventListener)this.cancelButton);
        this.cancelButton.m_93692_(true);
    }

    public void withAction(DialogAction handler) {
        this.action = handler;
    }

    public void withCheckBoxes(ComplexDialogAction action, CheckboxButton ... checkBoxes) {
        this.action = action;
        this.bodyListeners.removeAll(Arrays.asList(this.checkBoxes));
        this.checkBoxes = checkBoxes;
        this.bodyListeners.addAll(Arrays.asList(this.checkBoxes));
    }

    public CheckboxButton[] getCheckBoxes() {
        return this.checkBoxes;
    }

    public boolean[] getCheckBoxesState() {
        boolean[] state = new boolean[this.checkBoxes.length];
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            state[i] = this.checkBoxes[i].getValue();
        }
        return state;
    }

    public void confirm() {
        this.cancel(true);
    }

    @Override
    public void cancel(boolean success) {
        super.cancel(success);
        this.action.handle(success, this.getCheckBoxesState());
    }

    @Override
    protected void layout() {
        int cW = (int)Mth.m_14008_((double)((double)((Screen)this.getScreen()).f_96543_ * 0.7), (double)120.0, (double)800.0);
        int w = (int)Mth.m_14008_((double)((double)((Screen)this.getScreen()).f_96543_ * 0.4), (double)120.0, (double)800.0);
        int titleWidth = this.font.m_92852_((FormattedText)this.title);
        w = Math.max(w, titleWidth + 16);
        this.lines = this.getBody().stream().map(l -> this.font.m_92923_((FormattedText)l, cW - 16)).collect(Collectors.toList());
        int bodyWidth = IntStream.concat(this.lines.stream().flatMap(Collection::stream).mapToInt(l -> this.font.m_92724_(l)), Arrays.stream(this.checkBoxes).mapToInt(AbstractWidget::m_5711_)).max().orElse(w) + 16;
        bodyWidth = Math.max(bodyWidth, this.buttons.size() * 80);
        w = Math.max(w, bodyWidth);
        w = Math.min(w, ((Screen)this.getScreen()).f_96543_ - 32);
        int h = (int)Mth.m_14008_((double)(60 + this.getInnerHeight()), (double)68.0, (double)((double)((Screen)this.getScreen()).f_96544_ * 0.9));
        this.setWidth(w);
        this.setHeight(h);
        super.layout();
    }

    @Override
    public void renderInner(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
        int tx = x + 4;
        int ty = y + 4;
        for (List<FormattedCharSequence> line : this.lines) {
            for (FormattedCharSequence l : line) {
                gg.m_280648_(this.font, l, tx, ty, this.bodyColor);
                ty += this.lineHeight;
            }
            ty += this.paragraphMarginDown;
        }
        for (CheckboxButton checkBox : this.checkBoxes) {
            checkBox.m_252865_(x + 8);
            checkBox.m_253211_(ty + 2);
            checkBox.m_93674_(w - 16);
            checkBox.m_88315_(gg, mouseX, mouseY, delta);
            ty += 22;
        }
    }

    @Override
    @Nullable
    public Style getInnerTextAt(int x, int y, int w, int h, double mX, double mY) {
        int tx = x + 4;
        int ty = y + 4;
        for (List<FormattedCharSequence> line : this.lines) {
            for (FormattedCharSequence l : line) {
                if (mY >= (double)ty && mY < (double)(ty + this.lineHeight) && mX >= (double)tx && tx < x + w - 8) {
                    return this.font.m_92865_().m_92338_(l, (int)Math.round(mX - (double)tx));
                }
                ty += this.lineHeight;
            }
            ty += this.paragraphMarginDown;
        }
        return null;
    }

    @Override
    public int getInnerHeight() {
        return 4 + this.lines.stream().reduce(0, (s, l) -> s + this.paragraphMarginDown + l.stream().reduce(0, (ss, ll) -> ss + this.lineHeight, Integer::sum), Integer::sum) + this.checkBoxes.length * 22;
    }

    @Override
    public String getText() {
        return this.title.getString() + "\n" + this.getBody().stream().map(Component::getString).collect(Collectors.joining("\n"));
    }

    public List<Component> getBody() {
        return this.body;
    }

    public void setBody(List<? extends Component> body) {
        this.body = new ArrayList<Component>(body);
    }

    public void setCancelText(Component text) {
        this.cancelButton.m_93666_(text);
    }

    public void setConfirmText(Component text) {
        this.confirmButton.m_93666_(text);
    }

    public void setCancelButtonTint(int color) {
        this.cancelButton.setTintColor(color);
    }

    public void setConfirmButtonTint(int color) {
        this.confirmButton.setTintColor(color);
    }

    @FunctionalInterface
    public static interface ComplexDialogAction
    extends DialogAction {
        public void handleComplex(boolean var1, boolean[] var2);

        @Override
        default public void handle(boolean success) {
            throw new UnsupportedOperationException("Illegal implementation");
        }

        @Override
        default public void handle(boolean success, boolean[] checkBoxes) {
            this.handleComplex(success, checkBoxes);
        }
    }

    @FunctionalInterface
    public static interface DialogAction {
        public void handle(boolean var1);

        default public void handle(boolean success, boolean[] checkBoxes) {
            this.handle(success);
        }
    }
}

