/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionIconButton;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryButton
extends MultiFunctionIconButton {
    protected final SimpleConfigScreen screen;
    protected final ConfigCategory category;
    protected final Supplier<Optional<Component[]>> descriptionSupplier;
    private int lastColor;
    private int lastDark;
    private int lastLight;

    public ConfigCategoryButton(SimpleConfigScreen screen, ConfigCategory category, int x, int y, Component title) {
        this(screen, category, x, y, title, null);
    }

    public ConfigCategoryButton(SimpleConfigScreen screen, ConfigCategory category, int x, int y, Component title, @Nullable Supplier<Optional<Component[]>> descriptionSupplier) {
        super(x, y, 20, 200, Icon.EMPTY, MultiFunctionImageButton.ButtonAction.of(() -> {
            if (category != null) {
                screen.setSelectedCategory(category);
            }
        }).icon(category.getIcon()).title(() -> screen.isSelecting() ? title.m_6881_().m_7220_((Component)Component.m_237113_((String)(" [" + category.getAllMainEntries().stream().filter(AbstractConfigField::isSelected).count() + "]")).m_130940_(ChatFormatting.AQUA)) : title).active(category::isLoaded));
        this.descriptionSupplier = descriptionSupplier;
        this.category = category;
        this.screen = screen;
        this.lastColor = category.getColor();
        this.updateColors();
    }

    @Override
    public List<Component> getTooltipContents() {
        if (this.descriptionSupplier != null && (!this.isSelected() || this.f_93622_)) {
            return Lists.newArrayList((Object[])this.descriptionSupplier.get().orElse(new Component[0]));
        }
        return Collections.emptyList();
    }

    private void updateColors() {
        int c = this.lastColor;
        this.lastDark = c == 0 ? 0x64242424 : new Color(c, true).darker().darker().getRGB() & 0xFFFFFF | (int)((float)(c >> 24 & 0xFF) * 0.6f) << 24;
        this.lastLight = c == 0 ? 853598432 : c;
    }

    @Override
    public Component getTitle() {
        Component title = super.getTitle();
        if (!this.isSelected()) {
            title = title.m_6881_().m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)-1428431909)));
        }
        return title;
    }

    @Override
    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        int c = this.category.getColor();
        if (c != this.lastColor) {
            this.lastColor = c;
            this.updateColors();
        }
        this.defaultTint = this.isSelected() ? this.lastLight : this.lastDark;
        super.m_87963_(gg, mouseX, mouseY, partialTicks);
    }

    public boolean isSelected() {
        return this.screen.getSelectedCategory() == this.category;
    }

    public boolean m_198029_() {
        return super.m_198029_() || this.isSelected();
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) && mouseX >= 20.0 && mouseX <= (double)(this.screen.f_96543_ - 20);
    }
}

