/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IModalInputProcessor;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.Tooltip;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDialogScreen
extends Screen
implements IDialogCapableScreen {
    private final IDialogCapableScreen.SortedDialogCollection dialogs = new IDialogCapableScreen.SortedDialogCollection();
    private final IOverlayCapableContainer.SortedOverlayCollection overlays = new IOverlayCapableContainer.SortedOverlayCollection();
    private final List<Tooltip> tooltips = Lists.newArrayList();
    private IModalInputProcessor modalInputProcessor = null;

    protected AbstractDialogScreen(Component title) {
        super(title);
    }

    public final void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        boolean hasDialog = this.hasDialogs();
        boolean suppressHover = hasDialog || this.shouldOverlaysSuppressHover(mouseX, mouseY);
        int mX = suppressHover ? -1 : mouseX;
        int mY = suppressHover ? -1 : mouseY;
        super.m_88315_(gg, mX, mY, delta);
        this.renderScreen(gg, mX, mY, delta);
        this.renderOverlays(gg, hasDialog ? mX : mouseX, hasDialog ? mY : mouseY, delta);
        if (hasDialog) {
            this.tooltips.clear();
        }
        this.renderDialogs(gg, mouseX, mouseY, delta);
        this.renderTooltips(gg, mouseX, mouseY, delta);
    }

    public void renderScreen(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
    }

    protected void renderTooltips(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        for (Tooltip tooltip : this.tooltips) {
            int ty = tooltip.getY();
            if (ty <= 24) {
                ty += 16;
            }
            gg.m_280245_(this.f_96547_, tooltip.getText(), tooltip.getX(), ty);
        }
        this.tooltips.clear();
    }

    @MustBeInvokedByOverriders
    public void m_86600_() {
        this.tickDialogs();
        this.screenTick();
    }

    public void screenTick() {
    }

    @MustBeInvokedByOverriders
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.handleModalKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.handleDialogsKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screenKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean screenKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.handleModalKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.handleDialogsKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screenKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    protected boolean screenKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.handleModalCharTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.handleDialogsCharTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.screenCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    protected boolean screenCharTyped(char codePoint, int modifiers) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.handleModalMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleDialogsMouseClicked(mouseX, mouseY, button) || this.handleOverlaysMouseClicked(mouseX, mouseY, button) || this.screenMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean screenMouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.handleModalMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleOverlaysMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleDialogsMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.screenMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected boolean screenMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleDialogsMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.handleOverlaysMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.screenMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean screenMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    @MustBeInvokedByOverriders
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleModalMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.handleDialogsMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.handleOverlaysMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.screenMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected boolean screenMouseScrolled(double mouseX, double mouseY, double delta) {
        return false;
    }

    @Override
    public List<Tooltip> getTooltips() {
        return this.tooltips;
    }

    @Override
    public IDialogCapableScreen.SortedDialogCollection getDialogs() {
        return this.dialogs;
    }

    @Override
    public IOverlayCapableContainer.SortedOverlayCollection getSortedOverlays() {
        return this.overlays;
    }

    @Override
    @Nullable
    public IModalInputProcessor getModalInputProcessor() {
        return this.modalInputProcessor;
    }

    @Override
    public void setModalInputProcessor(IModalInputProcessor processor) {
        this.modalInputProcessor = processor;
    }
}

