/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.ContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.RectangleAnimator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDialog
extends AbstractContainerEventHandler
implements ContainerEventHandlerEx,
IOverlayCapableContainer {
    protected Component title;
    protected MultiFunctionImageButton copyTextButton;
    protected RedirectGuiEventListener copyTextReference;
    protected int titleColor = -2039584;
    protected int borderColor = -7303024;
    protected int subBorderColor = -10197916;
    protected int backgroundColor = -14408668;
    protected int backgroundOverlayColor = -13355980;
    protected int screenColor = -2146430960;
    private Screen screen;
    protected List<GuiEventListener> listeners = Lists.newArrayList();
    private boolean persistent = false;
    protected boolean cancelled;
    protected Icon icon = Icon.EMPTY;
    protected Rectangle area = new Rectangle();
    protected Rectangle animatedArea = new Rectangle();
    protected RectangleAnimator areaAnimator = new RectangleAnimator(150L);
    protected Font font;
    protected Pair<Integer, GuiEventListener> dragged;
    private final IOverlayCapableContainer.SortedOverlayCollection sortedOverlays;

    public AbstractDialog(Component title) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.dragged = null;
        this.sortedOverlays = new IOverlayCapableContainer.SortedOverlayCollection();
        this.title = title;
        this.copyTextButton = new MultiFunctionImageButton(0, 0, 18, 18, SimpleConfigIcons.Buttons.COPY, MultiFunctionImageButton.ButtonAction.of(this::copyText).tooltip((Component)Component.m_237115_((String)"simpleconfig.ui.copy_dialog")));
        this.copyTextReference = new RedirectGuiEventListener((GuiEventListener)this.copyTextButton);
        this.listeners.add(this.copyTextReference);
    }

    @ApiStatus.Internal
    public void setScreen(IDialogCapableScreen screen) {
        if (!(screen instanceof Screen)) {
            throw new IllegalArgumentException("Invalid screen type: " + screen.getClass().getName() + " does not implement IDialogCapableScreen");
        }
        this.screen = (Screen)screen;
        int width = this.screen.f_96543_;
        int height = this.screen.f_96544_;
        this.areaAnimator.setOrigin(new Rectangle(width / 2 - 30, height / 2 - 20, 60, 40));
    }

    public <T extends Screen> T getScreen() {
        if (this.screen == null) {
            throw new IllegalStateException("Cannot retrieve screen of dialog before showing the dialog");
        }
        return (T)this.screen;
    }

    public void tick(boolean top) {
    }

    public void copyText() {
        Minecraft.m_91087_().f_91068_.m_90911_(this.getText());
    }

    public String getText() {
        return this.title.getString();
    }

    public void cancel() {
        this.cancel(false);
    }

    public void cancel(boolean success) {
        this.setCancelled(true);
    }

    protected void layout() {
        int screenWidth = ((Screen)this.getScreen()).f_96543_;
        int screenHeight = ((Screen)this.getScreen()).f_96544_;
        int w = this.getArea().getWidth();
        int h = this.getArea().getHeight();
        this.setX(screenWidth / 2 - w / 2);
        this.setY(screenHeight / 2 - h / 2);
        if (this.canCopyText()) {
            this.copyTextReference.setTarget((GuiEventListener)this.copyTextButton);
            this.copyTextButton.m_252865_(this.getX() + this.getWidth() - 21);
            this.copyTextButton.m_253211_(this.getY() + 3);
        } else {
            this.copyTextReference.setTarget(null);
        }
    }

    protected void animateLayout() {
        this.animatedArea = this.areaAnimator.getCurrentEaseOut();
    }

    public boolean render(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.isCancelled()) {
            return false;
        }
        this.layout();
        this.animateLayout();
        boolean hideHover = this.shouldOverlaysSuppressHover(mouseX, mouseY);
        int mX = hideHover ? -1 : mouseX;
        int mY = hideHover ? -1 : mouseY;
        this.renderBackground(gg, mX, mY, delta);
        this.renderTitle(gg, mX, mY, delta);
        this.renderBody(gg, mX, mY, delta);
        this.renderOverlays(gg, mouseX, mouseY, delta);
        return true;
    }

    public void renderTitle(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        gg.m_280509_(x + 1, y + 1, x + w - 1, y + 23, this.backgroundOverlayColor);
        gg.m_280509_(x + 1, y + 23, x + w - 1, y + 24, this.subBorderColor);
        int tx = x + 8;
        if (this.icon != null && this.icon != Icon.EMPTY) {
            tx += 18;
            this.icon.renderCentered(gg, x + 2, y + 2, 20, 20);
        }
        gg.m_280430_(this.font, this.title, tx, y + 8, this.titleColor);
        if (this.canCopyText()) {
            this.copyTextButton.m_88315_(gg, mouseX, mouseY, delta);
        }
    }

    public void renderBackground(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        gg.m_280509_(0, 0, ((Screen)this.getScreen()).f_96543_, ((Screen)this.getScreen()).f_96544_, this.screenColor);
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        gg.m_280509_(x - 8, y - 8, x + w + 8, y + h + 8, 0x24242424);
        gg.m_280509_(x - 6, y - 6, x + w + 6, y + h + 6, 0x48242424);
        gg.m_280509_(x - 4, y - 4, x + w + 4, y + h + 4, -2145115100);
        gg.m_280509_(x - 2, y - 2, x + w + 2, y + h + 2, -1608244188);
        gg.m_280509_(x, y, x + w, y + h, this.borderColor);
        gg.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, this.backgroundColor);
    }

    public abstract void renderBody(GuiGraphics var1, int var2, int var3, float var4);

    public boolean isMouseInside(double mouseX, double mouseY) {
        int x = this.getX();
        int y = this.getY();
        return mouseX >= (double)x && mouseX < (double)(x + this.getWidth()) && mouseY >= (double)y && mouseY < (double)(y + this.getHeight());
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.handleOverlaysMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (!this.isMouseInside(mouseX, mouseY) && !this.isPersistent()) {
            this.cancel();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)0.8f));
            return true;
        }
        return ContainerEventHandlerEx.super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.handleOverlaysMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleOverlaysMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleOverlaysMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    @Override
    public void endDrag(double mouseX, double mouseY, int button) {
        if (this.handleOverlaysDragEnd(mouseX, mouseY, button)) {
            return;
        }
        ContainerEventHandlerEx.super.endDrag(mouseX, mouseY, button);
    }

    public boolean escapeKeyPressed() {
        if (this.handleOverlaysEscapeKey()) {
            return true;
        }
        if (!this.isPersistent()) {
            this.cancel();
        }
        return true;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    @Override
    public int getScreenWidth() {
        return ((Screen)this.getScreen()).f_96543_;
    }

    @Override
    public int getScreenHeight() {
        return ((Screen)this.getScreen()).f_96544_;
    }

    @Override
    public IOverlayCapableContainer.SortedOverlayCollection getSortedOverlays() {
        return this.sortedOverlays;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public boolean canCopyText() {
        return true;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public int getX() {
        return this.animatedArea.getX();
    }

    public int getY() {
        return this.animatedArea.getY();
    }

    public int getWidth() {
        return this.animatedArea.getWidth();
    }

    public int getHeight() {
        return this.animatedArea.getHeight();
    }

    public void setX(int x) {
        boolean changed = this.area.x != x;
        this.area.x = x;
        if (changed) {
            this.areaAnimator.setTarget(this.area);
        }
    }

    public void setY(int y) {
        boolean changed = this.area.y != y;
        this.area.y = y;
        if (changed) {
            this.areaAnimator.setTarget(this.area);
        }
    }

    protected void setWidth(int width) {
        boolean changed = this.area.width != width;
        this.area.width = width;
        if (changed) {
            this.areaAnimator.setTarget(this.area);
        }
    }

    protected void setHeight(int height) {
        boolean changed = this.area.height != height;
        this.area.height = height;
        if (changed) {
            this.areaAnimator.setTarget(this.area);
        }
    }
}

