/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.ConfigScreen;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.api.ConfigScreenBuilder;
import endorh.simpleconfig.ui.api.ContainerEventHandlerEx;
import endorh.simpleconfig.ui.api.IDialogCapableScreen;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IModalInputProcessor;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.ConfirmDialog;
import endorh.simpleconfig.ui.gui.ConfirmLinkDialog;
import endorh.simpleconfig.ui.gui.ExternalChangesDialog;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.SearchBarWidget;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.hotkey.ConfigHotKeyManager;
import endorh.simpleconfig.ui.impl.EditHistory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigScreen,
ContainerEventHandlerEx,
ConfigScreenBuilder.IConfigSnapshotHandler.IExternalChangeHandler,
IEntryHolder,
IDialogCapableScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ResourceLocation backgroundLocation;
    protected final Screen parent;
    protected final String modId;
    protected final List<Tooltip> tooltips = Lists.newArrayList();
    protected boolean confirmUnsaved = ClientConfig.confirm.discard;
    protected boolean confirmSave = ClientConfig.confirm.save;
    protected boolean alwaysShowTabs = false;
    protected boolean transparentBackground = false;
    protected boolean editable = true;
    @Nullable
    protected IModalInputProcessor modalInputProcessor = null;
    @Nullable
    protected Runnable savingRunnable = null;
    @Nullable
    protected Runnable closingRunnable;
    @Nullable
    protected Consumer<Screen> afterInitConsumer = null;
    protected Pair<Integer, GuiEventListener> dragged = null;
    protected Map<String, Map<String, ConfigCategory>> categoryMap;
    protected ExternalChangesDialog externalChangesDialog;
    protected ConfigCategory selectedCategory;
    protected List<ConfigCategory> sortedCategories;
    protected EnumMap<SimpleConfig.EditType, List<ConfigCategory>> sortedCategoriesMap;
    protected IOverlayCapableContainer.SortedOverlayCollection sortedOverlays = new IOverlayCapableContainer.SortedOverlayCollection();
    protected EditHistory history;
    @Nullable
    protected ConfigHotKey editedConfigHotKey;
    protected Consumer<Boolean> hotKeySaver = null;
    private final IDialogCapableScreen.SortedDialogCollection dialogs = new IDialogCapableScreen.SortedDialogCollection();
    @Nullable
    protected ConfigScreenBuilder.IConfigSnapshotHandler snapshotHandler;
    @Nullable
    protected ConfigScreenBuilder.IRemoteConfigProvider remoteConfigProvider;
    protected Map<SimpleConfig.EditType, CommentedConfig> remoteConfigs = new EnumMap<SimpleConfig.EditType, CommentedConfig>(SimpleConfig.EditType.class);
    protected Set<SimpleConfig.EditType> loadedRemoteConfigs = Collections.newSetFromMap(new EnumMap(SimpleConfig.EditType.class));

    protected AbstractConfigScreen(Screen parent, String modId, Component title, ResourceLocation backgroundLocation, Collection<ConfigCategory> clientCategories, Collection<ConfigCategory> commonCategories, Collection<ConfigCategory> serverCommonCategories, Collection<ConfigCategory> serverCategories) {
        super(title);
        this.parent = parent;
        this.modId = modId;
        this.backgroundLocation = backgroundLocation;
        Map<String, ConfigCategory> clientCategoryMap = clientCategories.stream().collect(Collectors.toMap(ConfigCategory::getName, c -> c, (a, b) -> a));
        List sortedClientCategories = clientCategories.stream().sorted(Comparator.comparingInt(ConfigCategory::getSortingOrder)).collect(Collectors.toList());
        Map<String, ConfigCategory> commonCategoryMap = commonCategories.stream().collect(Collectors.toMap(ConfigCategory::getName, c -> c, (a, b) -> a));
        List sortedCommonCategories = commonCategories.stream().sorted(Comparator.comparingInt(ConfigCategory::getSortingOrder)).collect(Collectors.toList());
        Map<String, ConfigCategory> serverCommonCategoryMap = serverCommonCategories.stream().collect(Collectors.toMap(ConfigCategory::getName, c -> c, (a, b) -> a));
        List sortedServerCommonCategories = serverCommonCategories.stream().sorted(Comparator.comparingInt(ConfigCategory::getSortingOrder)).collect(Collectors.toList());
        Map<String, ConfigCategory> serverCategoryMap = serverCategories.stream().collect(Collectors.toMap(ConfigCategory::getName, c -> c, (a, b) -> a));
        List sortedServerCategories = serverCategories.stream().sorted(Comparator.comparingInt(ConfigCategory::getSortingOrder)).collect(Collectors.toList());
        this.categoryMap = (Map)Util.m_137469_(new HashMap(4), m -> {
            m.put(SimpleConfig.EditType.CLIENT.getAlias(), clientCategoryMap);
            m.put(SimpleConfig.EditType.COMMON.getAlias(), commonCategoryMap);
            m.put(SimpleConfig.EditType.SERVER_COMMON.getAlias(), serverCommonCategoryMap);
            m.put(SimpleConfig.EditType.SERVER.getAlias(), serverCategoryMap);
        });
        this.sortedCategoriesMap = (EnumMap)Util.m_137469_(new EnumMap(SimpleConfig.EditType.class), m -> {
            m.put(SimpleConfig.EditType.CLIENT, sortedClientCategories);
            m.put(SimpleConfig.EditType.COMMON, sortedCommonCategories);
            m.put(SimpleConfig.EditType.SERVER_COMMON, sortedServerCommonCategories);
            m.put(SimpleConfig.EditType.SERVER, sortedServerCategories);
        });
        this.sortedCategories = Stream.of(sortedClientCategories, sortedCommonCategories, sortedServerCommonCategories, sortedServerCategories).flatMap(Collection::stream).collect(Collectors.toList());
        this.history = new EditHistory();
        this.history.setOwner(this);
    }

    public String getModId() {
        return this.modId;
    }

    public static void fillGradient(GuiGraphics gg, double xStart, double yStart, double xEnd, double yEnd, int blitOffset, int from, int to) {
        float fa = (float)(from >> 24 & 0xFF) / 255.0f;
        float fr = (float)(from >> 16 & 0xFF) / 255.0f;
        float fg = (float)(from >> 8 & 0xFF) / 255.0f;
        float fb = (float)(from & 0xFF) / 255.0f;
        float ta = (float)(to >> 24 & 0xFF) / 255.0f;
        float tr = (float)(to >> 16 & 0xFF) / 255.0f;
        float tg = (float)(to >> 8 & 0xFF) / 255.0f;
        float tb = (float)(to & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bb = tessellator.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
        bb.m_252986_(m, (float)xEnd, (float)yStart, (float)blitOffset).m_85950_(fr, fg, fb, fa).m_5752_();
        bb.m_252986_(m, (float)xStart, (float)yStart, (float)blitOffset).m_85950_(fr, fg, fb, fa).m_5752_();
        bb.m_252986_(m, (float)xStart, (float)yEnd, (float)blitOffset).m_85950_(tr, tg, tb, ta).m_5752_();
        bb.m_252986_(m, (float)xEnd, (float)yEnd, (float)blitOffset).m_85950_(tr, tg, tb, ta).m_5752_();
        tessellator.m_85914_();
    }

    public static void fillGradient(@NotNull Matrix4f m, BufferBuilder bb, int minX, int minY, int maxX, int maxY, int blitOffset, int from, int to) {
        float fA = (float)(from >> 24 & 0xFF) / 255.0f;
        float fR = (float)(from >> 16 & 0xFF) / 255.0f;
        float fG = (float)(from >> 8 & 0xFF) / 255.0f;
        float fB = (float)(from & 0xFF) / 255.0f;
        float tA = (float)(to >> 24 & 0xFF) / 255.0f;
        float tR = (float)(to >> 16 & 0xFF) / 255.0f;
        float tG = (float)(to >> 8 & 0xFF) / 255.0f;
        float tB = (float)(to & 0xFF) / 255.0f;
        bb.m_252986_(m, (float)maxX, (float)minY, (float)blitOffset).m_85950_(fR, fG, fB, fA).m_5752_();
        bb.m_252986_(m, (float)minX, (float)minY, (float)blitOffset).m_85950_(fR, fG, fB, fA).m_5752_();
        bb.m_252986_(m, (float)minX, (float)maxY, (float)blitOffset).m_85950_(tR, tG, tB, tA).m_5752_();
        bb.m_252986_(m, (float)maxX, (float)maxY, (float)blitOffset).m_85950_(tR, tG, tB, tA).m_5752_();
    }

    public static void drawBorderRect(GuiGraphics gg, Rectangle area, int w, int color, int innerColor) {
        AbstractConfigScreen.drawBorderRect(gg, area.x, area.y, area.getMaxX(), area.getMaxY(), w, color, innerColor);
    }

    public static void drawBorderRect(GuiGraphics gg, int l, int t, int r, int b, int w, int color, int innerColor) {
        gg.m_280509_(l, t, r, t + w, color);
        gg.m_280509_(l, b - w, r, b, color);
        gg.m_280509_(l, t + w, l + w, b - w, color);
        gg.m_280509_(r - w, t + w, r, b - w, color);
        if (innerColor != 0) {
            gg.m_280509_(l + w, t + w, r - w, b - w, innerColor);
        }
    }

    @Override
    public void setSavingRunnable(@Nullable Runnable savingRunnable) {
        this.savingRunnable = savingRunnable;
    }

    @Override
    public void setClosingRunnable(@Nullable Runnable closingRunnable) {
        this.closingRunnable = closingRunnable;
    }

    @Override
    public void setAfterInitConsumer(@Nullable Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
    }

    @Override
    public ResourceLocation getBackgroundLocation() {
        ResourceLocation background = this.selectedCategory.getBackground();
        return background != null ? background : this.backgroundLocation;
    }

    @Override
    public boolean isRequiresRestart() {
        return this.getAllMainEntries().stream().anyMatch(e -> e.isRequiresRestart() && e.isEdited());
    }

    public boolean isShowingHelp() {
        return false;
    }

    public void selectNextCategory(boolean forward) {
        int i = this.sortedCategories.indexOf(this.selectedCategory);
        if (i == -1) {
            throw new IllegalStateException("Unknown selected category: " + this.selectedCategory);
        }
        i = (i + (forward ? 1 : -1) + this.sortedCategories.size()) % this.sortedCategories.size();
        this.setSelectedCategory(this.sortedCategories.get(i));
    }

    public ConfigCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(ConfigCategory category) {
        if (this.categoryMap.values().stream().noneMatch(m -> m.containsKey(category.getName()))) {
            throw new IllegalStateException("Unknown category: " + category.getName());
        }
        this.selectedCategory = category;
    }

    @Override
    public boolean isEdited() {
        for (ConfigCategory cat : this.sortedCategories) {
            for (AbstractConfigField<?> entry : cat.getHeldEntries()) {
                if (!entry.isEdited()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public AbstractConfigField<?> getEntry(String path) {
        return null;
    }

    public SimpleConfig.EditType getEditedType() {
        return this.getSelectedCategory().getType();
    }

    public List<ConfigCategory> getSortedTypeCategories() {
        return this.sortedCategoriesMap.get((Object)this.getEditedType());
    }

    public Map<String, ConfigCategory> getTypeCategories(SimpleConfig.EditType type) {
        return this.categoryMap.get(type.getAlias());
    }

    public Map<String, ConfigCategory> getTypeCategories() {
        return this.getTypeCategories(this.getEditedType());
    }

    public boolean isEditingServer() {
        return this.getEditedType() == SimpleConfig.EditType.SERVER;
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.getTypeCategories().size() > 1;
    }

    public void runUnrecordedAction(Runnable action) {
        this.getHistory().runUnrecordedAction(action);
    }

    public void runAtomicTransparentAction(Runnable action) {
        this.runAtomicTransparentAction(null, action);
    }

    public void runAtomicTransparentAction(@Nullable AbstractConfigField<?> focus, Runnable action) {
        this.getHistory().runAtomicTransparentAction(focus, action);
    }

    public Set<AbstractConfigField<?>> getSelectedEntries() {
        return Collections.emptySet();
    }

    public boolean canSelectEntries() {
        return false;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @ApiStatus.Internal
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground && Minecraft.m_91087_().f_91073_ != null;
    }

    @ApiStatus.Internal
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public void loadConfigScreenGUIState(@Nullable ConfigScreenBuilder.IConfigScreenGUIState state) {
    }

    public ConfigScreenBuilder.IConfigScreenGUIState saveConfigScreenGUIState() {
        return null;
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        this.saveAll(openOtherScreens, false, false, false);
    }

    public void saveAll(boolean openOtherScreens, boolean skipConfirm, boolean forceOverwrite, boolean forceSaveWithErrors) {
        boolean remote;
        if (this.hasErrors() && !forceSaveWithErrors || !this.isEdited()) {
            return;
        }
        boolean external = !forceOverwrite && ClientConfig.confirm.overwrite_external && this.hasConflictingExternalChanges();
        boolean bl = remote = !forceOverwrite && ClientConfig.confirm.overwrite_remote && this.hasConflictingRemoteChanges();
        if (external || remote) {
            this.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.confirm_overwrite"), d -> {
                List<Component> body = SimpleConfigTextUtil.splitTtc("simpleconfig.ui.confirm_overwrite.msg." + (external ? (remote ? "both" : "external") : "remote"), new Object[0]);
                body.addAll(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.confirm_overwrite.msg.overwrite", new Object[0]));
                d.setBody(body);
                CheckboxButton[] checkBoxes = (CheckboxButton[])Stream.concat(Stream.of(CheckboxButton.of(!ClientConfig.confirm.overwrite_external, (Component)Component.m_237115_((String)"simpleconfig.ui.confirm_overwrite.do_not_ask_external"))).filter(p -> external), Stream.of(CheckboxButton.of(!ClientConfig.confirm.overwrite_remote, (Component)Component.m_237115_((String)"simpleconfig.ui.confirm_overwrite.do_not_ask_remote"))).filter(p -> remote)).toArray(CheckboxButton[]::new);
                d.withCheckBoxes((b, s) -> {
                    if (b) {
                        if (external) {
                            String CONFIRM_OVERWRITE_EXTERNAL = "confirm.overwrite_external";
                            if (SimpleConfigMod.CLIENT_CONFIG.hasGUI()) {
                                SimpleConfigMod.CLIENT_CONFIG.setGUI(CONFIRM_OVERWRITE_EXTERNAL, !s[0]);
                                ClientConfig.confirm.overwrite_external = !s[0];
                            } else {
                                SimpleConfigMod.CLIENT_CONFIG.set(CONFIRM_OVERWRITE_EXTERNAL, !s[0]);
                            }
                        }
                        String CONFIRM_OVERWRITE_REMOTE = "confirm.overwrite_remote";
                        if (remote) {
                            boolean c;
                            boolean bl = c = !s[external ? 1 : 0];
                            if (SimpleConfigMod.CLIENT_CONFIG.hasGUI()) {
                                SimpleConfigMod.CLIENT_CONFIG.setGUI(CONFIRM_OVERWRITE_REMOTE, c);
                                ClientConfig.confirm.overwrite_external = c;
                            } else {
                                SimpleConfigMod.CLIENT_CONFIG.set(CONFIRM_OVERWRITE_REMOTE, c);
                            }
                        }
                        this.saveAll(openOtherScreens, true, true, forceSaveWithErrors);
                    }
                }, checkBoxes);
                d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.confirm_overwrite.overwrite"));
                d.setConfirmButtonTint(-2141179792);
            }));
        } else if (this.confirmSave && !skipConfirm) {
            this.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.confirm_save"), d -> {
                d.withCheckBoxes((b, s) -> {
                    if (b) {
                        if (s[0]) {
                            String CONFIRM_SAVE = "confirm.save";
                            if (SimpleConfigMod.CLIENT_CONFIG.hasGUI()) {
                                SimpleConfigMod.CLIENT_CONFIG.setGUI("confirm.save", false);
                                ClientConfig.confirm.save = false;
                            } else {
                                SimpleConfigMod.CLIENT_CONFIG.set("confirm.save", false);
                            }
                        }
                        this.saveAll(openOtherScreens, true, true, forceSaveWithErrors);
                    }
                }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again")));
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.confirm_save.msg", new Object[0]));
                d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.save"));
                d.setConfirmButtonTint(-2143109822);
            }));
        } else {
            this.doSaveAll(openOtherScreens, forceSaveWithErrors);
        }
    }

    protected void doSaveAll(boolean openOtherScreens, boolean allowErrors) {
        if (this.hasErrors() && !allowErrors) {
            return;
        }
        for (ConfigCategory cat : this.sortedCategories) {
            for (AbstractConfigField<?> entry : cat.getHeldEntries()) {
                entry.save();
            }
        }
        if (this.remoteConfigProvider != null) {
            for (SimpleConfig.EditType type : this.loadedRemoteConfigs) {
                boolean requiresRestart = this.sortedCategoriesMap.get((Object)type).stream().flatMap(c -> c.getAllMainEntries().stream()).anyMatch(e -> e.isEdited() && e.isRequiresRestart());
                this.remoteConfigProvider.saveRemoteConfig(type, requiresRestart);
            }
        }
        this.save();
        if (openOtherScreens && this.f_96541_ != null) {
            if (this.closingRunnable != null) {
                this.closingRunnable.run();
            }
            this.f_96541_.m_91152_(this.parent);
        }
    }

    protected void save() {
        Optional.ofNullable(this.savingRunnable).ifPresent(Runnable::run);
    }

    protected void saveHotkey() {
        if (this.isOnlyEditingConfigHotKey()) {
            if (this.hotKeySaver != null) {
                this.hotKeySaver.accept(true);
            }
        } else {
            ConfigHotKeyManager.ConfigHotKeyGroup hotkeys2 = ConfigHotKeyManager.INSTANCE.getHotKeys();
            hotkeys2.addEntry(this.editedConfigHotKey);
            ConfigHotKeyManager.INSTANCE.updateHotKeys(hotkeys2);
            this.setEditedConfigHotKey(null, null);
        }
    }

    protected void discardHotkey() {
        if (this.isOnlyEditingConfigHotKey()) {
            if (this.hotKeySaver != null) {
                this.hotKeySaver.accept(false);
            }
        } else {
            this.setEditedConfigHotKey(null, null);
        }
    }

    public boolean hasConflictingExternalChanges() {
        return Arrays.stream(SimpleConfig.EditType.values()).filter(t -> !t.isRemote()).map(this.sortedCategoriesMap::get).flatMap(Collection::stream).flatMap(c -> c.getAllMainEntries().stream()).anyMatch(AbstractConfigField::hasConflictingExternalDiff);
    }

    public boolean hasConflictingRemoteChanges() {
        return Arrays.stream(SimpleConfig.EditType.values()).filter(SimpleConfig.EditType::isRemote).map(this.sortedCategoriesMap::get).flatMap(Collection::stream).flatMap(c -> c.getAllMainEntries().stream()).anyMatch(AbstractConfigField::hasConflictingExternalDiff);
    }

    public boolean isEditable() {
        return this.editable && this.getSelectedCategory().isEditable();
    }

    @ApiStatus.Internal
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Nullable
    public ConfigHotKey getEditedConfigHotKey() {
        return this.editedConfigHotKey;
    }

    public void setEditedConfigHotKey(@Nullable ConfigHotKey hotkey, Consumer<Boolean> hotKeySaver) {
        if (this.editedConfigHotKey == null && hotkey == null && this.hotKeySaver == null && hotKeySaver == null) {
            return;
        }
        if (hotkey == null) {
            this.getAllMainEntries().forEach(e -> e.setHotKeyActionType(null, null));
        }
        this.editedConfigHotKey = hotkey;
        this.hotKeySaver = hotKeySaver;
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    public boolean isEditingConfigHotKey() {
        return this.editedConfigHotKey != null;
    }

    public boolean isOnlyEditingConfigHotKey() {
        return this.hotKeySaver != null;
    }

    @Override
    @Nullable
    public IModalInputProcessor getModalInputProcessor() {
        return this.modalInputProcessor;
    }

    @Override
    public void setModalInputProcessor(@Nullable IModalInputProcessor processor) {
        this.modalInputProcessor = processor;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.handleEndDrag(mouseX, mouseY, button);
        if (this.handleModalMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleOverlaysMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.handleDialogsMouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.handleDialogsMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.handleOverlaysMouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleModalMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.handleDialogsMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.handleOverlaysMouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.handleModalKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.handleDialogsKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.getDragged() != null) {
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.handleModalMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        SearchBarWidget searchBar = this.getSearchBar();
        if (searchBar.m_5953_(mouseX, mouseY)) {
            this.m_7522_((GuiEventListener)searchBar);
        }
        if (this.handleDialogsMouseClicked(mouseX, mouseY, button) || this.handleOverlaysMouseClicked(mouseX, mouseY, button) || this.getDragged() != null) {
            return true;
        }
        return ContainerEventHandlerEx.super.m_6375_(mouseX, mouseY, button);
    }

    protected void recomputeFocus() {
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.handleModalCharTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.handleDialogsCharTyped(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        FocusNavigationEvent.TabNavigation event;
        if (this.handleModalKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.handleDialogsKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.getDragged() != null) {
            return true;
        }
        if (keyCode == 256) {
            if (this.handleOverlaysEscapeKey()) {
                return true;
            }
            if (this.isEditingConfigHotKey()) {
                this.discardHotkey();
                this.playFeedbackTap(1.0f);
                return true;
            }
            if (this.m_6913_()) {
                this.playFeedbackTap(1.0f);
                return this.quit();
            }
        }
        if (this.screenKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 258: {
                FocusNavigationEvent.TabNavigation tabNavigation = new FocusNavigationEvent.TabNavigation(!AbstractConfigScreen.m_96638_());
                break;
            }
            case 259: {
                FocusNavigationEvent.TabNavigation tabNavigation = null;
                break;
            }
            case 260: {
                FocusNavigationEvent.TabNavigation tabNavigation = null;
                break;
            }
            case 261: {
                FocusNavigationEvent.TabNavigation tabNavigation = null;
                break;
            }
            default: {
                FocusNavigationEvent.TabNavigation tabNavigation = null;
                break;
            }
            case 262: {
                FocusNavigationEvent.TabNavigation tabNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.RIGHT);
                break;
            }
            case 263: {
                FocusNavigationEvent.TabNavigation tabNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.LEFT);
                break;
            }
            case 264: {
                FocusNavigationEvent.TabNavigation tabNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN);
                break;
            }
            case 265: {
                FocusNavigationEvent.TabNavigation tabNavigation = event = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.UP);
            }
        }
        if (event != null) {
            ComponentPath path = this.m_264064_((FocusNavigationEvent)event);
            if (path == null && event instanceof FocusNavigationEvent.TabNavigation) {
                ComponentPath current = this.m_264435_();
                if (current != null) {
                    current.m_264432_(false);
                }
                path = this.m_264064_((FocusNavigationEvent)event);
            }
            if (path != null) {
                this.m_264158_(path);
            }
        }
        return false;
    }

    protected boolean canSave() {
        return this.isEdited();
    }

    protected void playFeedbackTap(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)volume));
    }

    protected void playFeedbackClick(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)volume));
    }

    protected boolean screenKeyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (SimpleConfigMod.KeyBindings.NEXT_PAGE.isActiveAndMatches(key)) {
            SimpleConfig.EditType prevType = this.getEditedType();
            this.selectNextCategory(true);
            this.recomputeFocus();
            if (prevType == this.getEditedType()) {
                this.playFeedbackTap(1.0f);
            } else {
                this.playFeedbackClick(1.0f);
            }
            return true;
        }
        if (SimpleConfigMod.KeyBindings.PREV_PAGE.isActiveAndMatches(key)) {
            SimpleConfig.EditType prevType = this.getEditedType();
            this.selectNextCategory(false);
            this.recomputeFocus();
            if (prevType == this.getEditedType()) {
                this.playFeedbackTap(1.0f);
            } else {
                this.playFeedbackClick(1.0f);
            }
            return true;
        }
        if (SimpleConfigMod.KeyBindings.SAVE.isActiveAndMatches(key)) {
            if (this.isEditingConfigHotKey()) {
                this.saveHotkey();
            } else if (this.canSave()) {
                this.saveAll(true);
            }
            this.playFeedbackTap(1.0f);
            return true;
        }
        return false;
    }

    protected final boolean quit() {
        return this.quit(false);
    }

    protected final boolean quit(boolean skipConfirm) {
        if (this.f_96541_ == null) {
            return false;
        }
        if (!skipConfirm && this.confirmUnsaved && this.isEdited()) {
            this.addDialog(ConfirmDialog.create((Component)Component.m_237115_((String)"simpleconfig.ui.discard.dialog"), d -> {
                d.withCheckBoxes((b, s) -> {
                    if (b) {
                        if (s[0]) {
                            String CONFIRM_UNSAVED = "confirm.unsaved";
                            if (SimpleConfigMod.CLIENT_CONFIG.hasGUI()) {
                                SimpleConfigMod.CLIENT_CONFIG.setGUI("confirm.unsaved", false);
                                ClientConfig.confirm.discard = false;
                            } else {
                                SimpleConfigMod.CLIENT_CONFIG.set("confirm.unsaved", false);
                            }
                        }
                        this.quit(true);
                    }
                }, CheckboxButton.of(false, (Component)Component.m_237115_((String)"simpleconfig.ui.do_not_ask_again")));
                d.setBody(SimpleConfigTextUtil.splitTtc("simpleconfig.ui.discard.confirm", new Object[0]));
                d.setConfirmText((Component)Component.m_237115_((String)"simpleconfig.ui.discard"));
                d.setConfirmButtonTint(-2135088092);
            }));
        } else {
            if (this.closingRunnable != null) {
                this.closingRunnable.run();
            }
            this.f_96541_.m_91152_(this.parent);
        }
        return true;
    }

    public void m_86600_() {
        super.m_86600_();
        this.tickDialogs();
        boolean edited = this.isEdited();
        Optional.ofNullable(this.getQuitButton()).ifPresent(button -> button.m_93666_((Component)(edited ? Component.m_237115_((String)"simpleconfig.ui.discard") : CommonComponents.f_130656_)));
    }

    @Nullable
    protected AbstractWidget getQuitButton() {
        return null;
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        boolean hasDialog = this.hasDialogs();
        boolean suppressHover = hasDialog || this.shouldOverlaysSuppressHover(mouseX, mouseY);
        super.m_88315_(gg, suppressHover ? -1 : mouseX, suppressHover ? -1 : mouseY, delta);
        this.renderOverlays(gg, mouseX, mouseY, delta);
        if (hasDialog) {
            this.tooltips.clear();
        }
        this.renderDialogs(gg, mouseX, mouseY, delta);
        this.renderTooltips(gg, mouseX, mouseY, delta);
    }

    protected void renderTooltips(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
        for (Tooltip tooltip : this.tooltips) {
            if (tooltip.isFromKeyboard() && this.tooltips.size() != 1) continue;
            tooltip.render(this, gg);
        }
        this.tooltips.clear();
    }

    @Override
    public List<Tooltip> getTooltips() {
        return this.tooltips;
    }

    @Override
    public boolean removeTooltips(Rectangle area) {
        List<Tooltip> removed = this.tooltips.stream().filter(t -> area.contains(t.getPoint())).toList();
        return this.tooltips.removeAll(removed);
    }

    public boolean m_5561_(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent != null && clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL) {
            try {
                URI uri = new URI(clickEvent.m_130623_());
                String string = uri.getScheme();
                if (string == null) {
                    throw new URISyntaxException(clickEvent.m_130623_(), "Missing protocol");
                }
                if (!string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
                    throw new URISyntaxException(clickEvent.m_130623_(), "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                this.addDialog(ConfirmLinkDialog.create(clickEvent.m_130623_(), true));
            }
            catch (URISyntaxException e) {
                LOGGER.error("Can't open url for {}", (Object)clickEvent, (Object)e);
            }
            return true;
        }
        return super.m_5561_(style);
    }

    public boolean hasType(SimpleConfig.EditType type) {
        return !this.sortedCategoriesMap.get((Object)type).isEmpty() && (!type.isOnlyRemote() || this.remoteConfigProvider != null && this.remoteConfigs.containsKey((Object)type));
    }

    public boolean mayHaveType(SimpleConfig.EditType type) {
        return this.sortedCategoriesMap.containsKey((Object)type) && (!type.isOnlyRemote() || this.remoteConfigProvider != null && this.remoteConfigProvider.mayHaveRemoteConfig(type));
    }

    public boolean hasLoadedType(SimpleConfig.EditType type) {
        return !type.isOnlyRemote() || this.loadedRemoteConfigs.contains((Object)type);
    }

    @Override
    public Pair<Integer, GuiEventListener> getDragged() {
        return this.dragged;
    }

    @Override
    public void setDragged(Pair<Integer, GuiEventListener> dragged) {
        this.dragged = dragged;
    }

    @Override
    public IOverlayCapableContainer.SortedOverlayCollection getSortedOverlays() {
        return this.sortedOverlays;
    }

    public abstract SearchBarWidget getSearchBar();

    public EditHistory getHistory() {
        return this.history;
    }

    public void setHistory(EditHistory previous) {
        this.history = new EditHistory(previous);
        this.history.setOwner(this);
    }

    public void commitHistory() {
        this.history.saveState();
        AbstractConfigField<?> entry = this.getFocusedEntry();
        if (entry != null) {
            entry.preserveState();
        }
    }

    public void undo() {
        this.history.apply(false);
    }

    public void redo() {
        this.history.apply(true);
    }

    @Override
    public IDialogCapableScreen.SortedDialogCollection getDialogs() {
        return this.dialogs;
    }

    @Nullable
    public ConfigScreenBuilder.IConfigSnapshotHandler getSnapshotHandler() {
        return this.snapshotHandler;
    }

    public void setSnapshotHandler(@Nullable ConfigScreenBuilder.IConfigSnapshotHandler snapshotHandler) {
        this.snapshotHandler = snapshotHandler;
        if (snapshotHandler != null) {
            snapshotHandler.setExternalChangeHandler(this);
        }
    }

    @Nullable
    public ConfigScreenBuilder.IRemoteConfigProvider getRemoteConfigProvider() {
        return this.remoteConfigProvider;
    }

    public void setRemoteCommonConfigProvider(@Nullable ConfigScreenBuilder.IRemoteConfigProvider remoteConfigProvider) {
        this.remoteConfigProvider = remoteConfigProvider;
    }

    @Nullable
    public AbstractConfigField<?> getFocusedEntry() {
        return null;
    }

    public boolean isSelecting() {
        return false;
    }

    public void updateSelection() {
    }

    @Override
    public void handleExternalChange(SimpleConfig.EditType type) {
        if (this.externalChangesDialog != null) {
            this.externalChangesDialog.cancel(false);
        }
        this.externalChangesDialog = ExternalChangesDialog.create(type, response -> {
            this.handleExternalChangeResponse((ExternalChangesDialog.ExternalChangeResponse)((Object)response));
            this.externalChangesDialog = null;
        });
        this.addDialog(this.externalChangesDialog);
    }

    @Override
    public void handleRemoteConfigExternalChange(SimpleConfig.EditType type, CommentedConfig remoteConfig) {
        if (this.remoteConfigProvider == null) {
            return;
        }
        if (!this.loadedRemoteConfigs.contains((Object)type)) {
            this.remoteConfigs.put(type, remoteConfig);
        } else {
            this.remoteConfigProvider.loadRemoteConfig(type, remoteConfig, true);
        }
    }

    public void handleExternalChangeResponse(ExternalChangesDialog.ExternalChangeResponse response) {
        if (response == ExternalChangesDialog.ExternalChangeResponse.ACCEPT_ALL) {
            this.runAtomicTransparentAction(() -> this.getAllMainEntries().forEach(AbstractConfigField::acceptExternalValue));
        } else if (response == ExternalChangesDialog.ExternalChangeResponse.ACCEPT_NON_CONFLICTING) {
            this.runAtomicTransparentAction(() -> this.getAllMainEntries().stream().filter(e -> !e.isEdited()).forEach(AbstractConfigField::acceptExternalValue));
        }
    }

    public static void fill(GuiGraphics gg, ResourceLocation texture, float tw, float th, float x, float y, float w, float h, int tint) {
        float r = tint >> 16 & 0xFF;
        float g = tint >> 8 & 0xFF;
        float b = tint & 0xFF;
        float a = tint >> 24;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        Matrix4f m = gg.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(m, x, y, 0.0f).m_7421_(x / tw, y / th).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, x + w, y, 0.0f).m_7421_((x + w) / tw, y / th).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, x + w, y + h, 0.0f).m_7421_((x + w) / tw, (y + h) / th).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(m, x, y + h, 0.0f).m_7421_(x / tw, (y + h) / th).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
    }
}

