/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.gui;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import endorh.simpleconfig.ui.gui.widget.ScrollingContainerWidget;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractButtonDialog
extends AbstractDialog {
    protected List<AbstractWidget> buttons = Lists.newArrayList();
    protected ScrollingContainerWidget scroller;
    protected Consumer<String> linkActionHandler = s -> {};
    protected List<GuiEventListener> bodyListeners = Lists.newArrayList();

    public AbstractButtonDialog(Component title) {
        super(title);
        this.scroller = new DialogScrollingContainerWidget(this.getX(), this.getY(), (int)((double)this.getWidth() * 0.9), (int)((double)this.getHeight() * 0.5), this);
        this.listeners.add(this.scroller);
    }

    public void addButton(AbstractWidget button) {
        this.buttons.add(button);
        this.listeners.add(button);
    }

    public void addButton(int i, AbstractWidget button) {
        if (i == this.buttons.size()) {
            this.addButton(button);
        } else {
            if (!this.buttons.isEmpty()) {
                this.listeners.add(this.listeners.indexOf(this.buttons.get(i)), button);
            } else {
                this.listeners.add(button);
            }
            this.buttons.add(i, button);
        }
    }

    public void removeButton(AbstractWidget button) {
        this.buttons.remove(button);
        this.listeners.remove(button);
    }

    public void removeButton(int i) {
        this.listeners.remove(this.buttons.remove(i));
    }

    @Override
    protected void layout() {
        super.layout();
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        this.scroller.area.setBounds(x + 4, y + 28, w - 8, h - 60);
        this.scroller.setHideScrollBar(this.areaAnimator.isInProgress());
        int count = this.buttons.size();
        if (count > 0) {
            int bw = Math.min(150, (w - 4 - count * 4) / count);
            int by = y + h - 24;
            int bx = Math.max(x + 4, x + w / 2 - ((bw + 4) * count - 4) / 2);
            for (AbstractWidget button : this.buttons) {
                button.m_252865_(bx);
                button.m_253211_(by);
                button.m_93674_(bw);
                bx += bw + 4;
            }
        }
    }

    @Override
    public void renderBody(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        gg.m_280509_(x + 1, y + h - 27, x + w - 1, y + h - 1, this.backgroundOverlayColor);
        gg.m_280509_(x + 1, y + h - 28, x + w - 1, y + h - 27, this.subBorderColor);
        this.scroller.m_88315_(gg, mouseX, mouseY, delta);
        for (AbstractWidget button : this.buttons) {
            button.m_88315_(gg, mouseX, mouseY, delta);
        }
    }

    public abstract void renderInner(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    @Nullable
    public Style getInnerTextAt(int x, int y, int w, int h, double mX, double mY) {
        return null;
    }

    protected boolean handleComponentClicked(@NotNull Style style, double mouseX, double mouseY, int button) {
        String value;
        ClickEvent event = style.m_131182_();
        if (event != null && event.m_130622_() == ClickEvent.Action.OPEN_URL && (value = event.m_130623_()).startsWith("action:")) {
            this.handleTextAction(value.substring("action:".length()), mouseX, mouseY, button, style);
            return true;
        }
        return this.getScreen().m_5561_(style);
    }

    protected void handleTextAction(String action, double mouseX, double mouseY, int button, @NotNull Style style) {
        if (this.linkActionHandler != null) {
            this.linkActionHandler.accept(action);
        }
    }

    public Consumer<String> getLinkActionHandler() {
        return this.linkActionHandler;
    }

    public void setLinkActionHandler(Consumer<String> linkActionHandler) {
        this.linkActionHandler = linkActionHandler;
    }

    public abstract int getInnerHeight();

    public static class DialogScrollingContainerWidget
    extends ScrollingContainerWidget {
        protected final AbstractButtonDialog dialog;

        public DialogScrollingContainerWidget(int x, int y, int w, int h, AbstractButtonDialog dialog) {
            super(x, y, w, h);
            this.dialog = dialog;
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float delta) {
            super.m_88315_(gg, mouseX, mouseY, delta);
            Rectangle area = this.getArea();
            Style style = this.dialog.getInnerTextAt(area.x, (int)Math.round((double)area.y - this.scrollAmount), area.width - 8, area.height, mouseX, mouseY);
            if (style != null) {
                gg.m_280304_(Minecraft.m_91087_().f_91062_, style, mouseX, mouseY);
            }
        }

        @Override
        public void renderInner(GuiGraphics gg, int x, int y, int w, int h, int mouseX, int mouseY, float delta) {
            this.dialog.renderInner(gg, x, y, w, h, mouseX, mouseY, delta);
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Rectangle area = this.getArea();
            if (!area.contains(mouseX, mouseY)) {
                return false;
            }
            Style style = this.dialog.getInnerTextAt(area.x, (int)Math.round((double)area.y - this.scrollAmount), area.width - 8, area.height, mouseX, mouseY);
            if (style != null && this.dialog.handleComponentClicked(style, mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public int getInnerHeight() {
            return this.dialog.getInnerHeight();
        }

        @Override
        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.dialog.bodyListeners;
        }
    }
}

