/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AreaTooltip;
import endorh.simpleconfig.ui.api.PointTooltip;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public interface Tooltip {
    public static Tooltip of(Point location, List<Component> text) {
        return PointTooltip.create(location, text);
    }

    public static Tooltip of(Point location, Component ... text) {
        return PointTooltip.create(location, text);
    }

    public static Tooltip of(Point location, FormattedCharSequence ... text) {
        return PointTooltip.create(location, text);
    }

    public static Tooltip of(Rectangle area, Point point, List<Component> text) {
        return AreaTooltip.create(area, point, text);
    }

    public static Tooltip of(Rectangle area, List<Component> text) {
        return AreaTooltip.create(area, text);
    }

    public static Tooltip of(Rectangle area, Point point, Component ... text) {
        return AreaTooltip.create(area, point, text);
    }

    public static Tooltip of(Rectangle area, Component ... text) {
        return AreaTooltip.create(area, text);
    }

    public static Tooltip of(Rectangle area, Point point, FormattedCharSequence ... text) {
        return AreaTooltip.create(area, point, text);
    }

    public static Tooltip of(Rectangle area, FormattedCharSequence ... text) {
        return AreaTooltip.create(area, text);
    }

    public Point getPoint();

    default public int getX() {
        return this.getPoint().getX();
    }

    default public int getY() {
        return this.getPoint().getY();
    }

    public Font getFont();

    public boolean isFromKeyboard();

    default public Tooltip asKeyboardTooltip() {
        return this.asKeyboardTooltip(true);
    }

    public Tooltip asKeyboardTooltip(boolean var1);

    public Tooltip withFont(Font var1);

    public List<FormattedCharSequence> getText();

    @ApiStatus.Internal
    default public void adjustForScreen(int tooltipWidth, int tooltipHeight, int width, int height) {
        Point point = this.getPoint();
        int defaultOffset = 12;
        int enforcedMargin = 6;
        point.x = point.x + tooltipWidth + defaultOffset < width - enforcedMargin || point.x < width / 2 ? (point.x += defaultOffset) : (point.x -= tooltipWidth + defaultOffset);
        point.y = point.y - tooltipHeight - defaultOffset > enforcedMargin || point.y > height / 2 ? (point.y -= tooltipHeight + defaultOffset) : (point.y += defaultOffset);
        if (point.x + tooltipWidth > width - enforcedMargin) {
            point.x = Math.max(enforcedMargin, width - tooltipWidth - enforcedMargin);
        } else if (point.x < enforcedMargin) {
            point.x = enforcedMargin;
        }
        if (point.y + tooltipHeight > height - enforcedMargin) {
            point.y = Math.max(enforcedMargin, height - tooltipHeight - enforcedMargin);
        } else if (point.y < enforcedMargin) {
            point.y = enforcedMargin;
        }
    }

    default public void render(Screen screen, GuiGraphics gg) {
        ClientTooltipComponent line;
        int l;
        int bgSt;
        List<ClientTooltipComponent> text = this.getText().stream().map(ClientTooltipComponent::m_169948_).toList();
        if (text.isEmpty()) {
            return;
        }
        Font font = this.getFont();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int w = text.stream().mapToInt(t -> t.m_142069_(font)).max().orElse(0);
        int h = text.stream().mapToInt(ClientTooltipComponent::m_142103_).sum();
        this.adjustForScreen(w, h, screen.f_96543_, screen.f_96544_);
        int x = this.getX();
        int y = this.getY();
        x = Math.max(0, Math.min(screen.f_96543_ - w, x));
        y = Math.max(0, Math.min(screen.f_96544_ - h, y));
        int bgEd = bgSt = -267386864;
        int bdSt = 0x505000FF;
        int bdEd = 1344798847;
        int bo = 400;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bb = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        Matrix4f m = mStack.m_85850_().m_252922_();
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y - 4, x + w + 3, y - 3, bo, bgSt, bgSt);
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y + h + 3, x + w + 3, y + h + 4, bo, bgEd, bgEd);
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y - 3, x + w + 3, y + h + 3, bo, bgSt, bgEd);
        AbstractConfigScreen.fillGradient(m, bb, x - 4, y - 3, x - 3, y + h + 3, bo, bgSt, bgEd);
        AbstractConfigScreen.fillGradient(m, bb, x + w + 3, y - 3, x + w + 4, y + h + 3, bo, bgSt, bgEd);
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y - 3 + 1, x - 3 + 1, y + h + 3 - 1, bo, bdSt, bdEd);
        AbstractConfigScreen.fillGradient(m, bb, x + w + 2, y - 3 + 1, x + w + 3, y + h + 3 - 1, bo, bdSt, bdEd);
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y - 3, x + w + 3, y - 3 + 1, bo, bdSt, bdEd);
        AbstractConfigScreen.fillGradient(m, bb, x - 3, y + h + 2, x + w + 3, y + h + 3, bo, bdEd, bdEd);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        RenderSystem.disableBlend();
        MultiBufferSource.BufferSource bSrc = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        mStack.m_85837_(0.0, 0.0, (double)bo);
        int lineY = y;
        for (l = 0; l < text.size(); ++l) {
            line = text.get(l);
            line.m_142440_(font, x, lineY, m, bSrc);
            lineY += line.m_142103_() + (l == 0 ? 2 : 0);
        }
        bSrc.m_109911_();
        mStack.m_85849_();
        lineY = y;
        for (l = 0; l < text.size(); ++l) {
            line = text.get(l);
            line.m_183452_(font, x, lineY, gg);
            lineY += line.m_142103_() + (l == 0 ? 2 : 0);
        }
    }
}

