/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.impl.EasingMethod;
import endorh.simpleconfig.ui.math.impl.PointHelper;
import net.minecraft.util.Mth;

public abstract class ScrollingHandler {
    public double scrollAmount;
    public double scrollTarget;
    public long start;
    public long duration;
    public boolean draggingScrollBar = false;
    public boolean hideScrollBar = false;

    public abstract Rectangle getBounds();

    public Rectangle getScissorBounds() {
        Rectangle bounds = this.getBounds();
        if (this.hasScrollBar()) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        }
        return bounds;
    }

    public int getScrollBarX() {
        return this.hasScrollBar() ? this.getBounds().getMaxX() - 6 : this.getBounds().getMaxX();
    }

    public boolean hasScrollBar() {
        return !this.isHideScrollBar() && this.getMaxScrollHeight() > this.getBounds().height;
    }

    public boolean isHideScrollBar() {
        return this.hideScrollBar;
    }

    public void setHideScrollBar(boolean hide) {
        this.hideScrollBar = hide;
    }

    public abstract int getMaxScrollHeight();

    public int getMaxScroll() {
        return Math.max(0, this.getMaxScrollHeight() - this.getBounds().height);
    }

    public double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    public double clamp(double v, double clampExtension) {
        return Mth.m_14008_((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.scrollTarget + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, 200L);
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.scrollTarget = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scrollAmount = this.scrollTarget;
        }
    }

    public void scrollToShow(double start, double end) {
        this.scrollToShow(start, end, true);
    }

    public void scrollToShow(double start, double end, boolean animated) {
        double current = this.scrollAmount;
        int height = this.getBounds().getHeight();
        double margin = Math.min((double)height * 0.15, 48.0);
        if (current > start - margin) {
            this.scrollTo(start - margin, animated);
        } else if (current < end + margin - (double)height) {
            this.scrollTo(Math.min(start - margin, end + margin - (double)height), animated);
        }
    }

    public void updatePosition(float delta) {
        double[] target = new double[]{this.scrollTarget};
        this.scrollAmount = ScrollingHandler.handleScrollingPosition(target, this.scrollAmount, this.getMaxScroll(), delta, this.start, this.duration);
        this.scrollTarget = target[0];
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration) {
        return ScrollingHandler.handleScrollingPosition(target, scroll, maxScroll, delta, start, duration, -10.0, EasingMethod.EasingMethodImpl.CIRC);
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration, double bounceBackMultiplier, EasingMethod easingMethod) {
        if (bounceBackMultiplier >= 0.0) {
            target[0] = ScrollingHandler.clampExtension(target[0], maxScroll);
            if (target[0] < 0.0) {
                target[0] = target[0] - target[0] * (1.0 - bounceBackMultiplier);
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0 - (1.0 - bounceBackMultiplier) * (double)delta / 3.0) + maxScroll;
            }
        } else {
            target[0] = ScrollingHandler.clampExtension(target[0], maxScroll, 32.0);
        }
        return ScrollingHandler.ease(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration, 1.0), easingMethod);
    }

    public static double ease(double start, double end, double amount, EasingMethod easingMethod) {
        return start + (end - start) * easingMethod.apply(amount);
    }

    public static double clampExtension(double value, double maxScroll) {
        return ScrollingHandler.clampExtension(value, maxScroll, 32.0);
    }

    public static double clampExtension(double v, double maxScroll, double clampExtension) {
        return Mth.m_14008_((double)v, (double)(-clampExtension), (double)(maxScroll + clampExtension));
    }

    public void renderScrollBar() {
        this.renderScrollBar(0, 1.0f, 1.0f);
    }

    public void renderScrollBar(int background, float alpha, float scrollBarAlphaOffset) {
        if (this.hasScrollBar()) {
            Rectangle bounds = this.getBounds();
            int maxScroll = this.getMaxScroll();
            int maxScrollHeight = this.getMaxScrollHeight();
            if (maxScrollHeight <= 0) {
                maxScrollHeight = 1;
            }
            int height = bounds.height * bounds.height / maxScrollHeight;
            height = Mth.m_14045_((int)height, (int)32, (int)bounds.height);
            height = (int)((double)height - Math.min(this.scrollAmount < 0.0 ? (double)((int)(-this.scrollAmount)) : (this.scrollAmount > (double)maxScroll ? (double)((int)this.scrollAmount - maxScroll) : 0.0), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Mth.m_14045_((int)((int)this.scrollAmount * (bounds.height - height) / maxScroll + bounds.y), (int)bounds.y, (int)(bounds.getMaxY() - height));
            int minX = this.getScrollBarX();
            int maxX = minX + 6;
            boolean hovered = new Rectangle(minX, minY, maxX - minX, height).contains(PointHelper.ofMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * scrollBarAlphaOffset;
            float topC = (hovered ? 0.87f : 0.67f) * scrollBarAlphaOffset;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            float a = (float)(background >> 24 & 0xFF) / 255.0f;
            float r = (float)(background >> 16 & 0xFF) / 255.0f;
            float g = (float)(background >> 8 & 0xFF) / 255.0f;
            float b = (float)(background & 0xFF) / 255.0f;
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)minX, (double)bounds.getMaxY(), 0.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)maxX, (double)bounds.getMaxY(), 0.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)maxX, (double)bounds.y, 0.0).m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)minX, (double)bounds.y, 0.0).m_85950_(r, g, b, a).m_5752_();
            tessellator.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)minX, (double)(minY + height), 0.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)maxX, (double)(minY + height), 0.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)maxX, (double)minY, 0.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            buffer.m_5483_((double)minX, (double)minY, 0.0).m_85950_(bottomC, bottomC, bottomC, alpha).m_5752_();
            tessellator.m_85914_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_5483_((double)minX, (double)(minY + height - 1), 0.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)(maxX - 1), (double)(minY + height - 1), 0.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)(maxX - 1), (double)minY, 0.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            buffer.m_5483_((double)minX, (double)minY, 0.0).m_85950_(topC, topC, topC, alpha).m_5752_();
            tessellator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.mouseDragged(mouseX, mouseY, button, dx, dy, false, 0.0);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy, boolean snapToRows, double rowSize) {
        if (button == 0 && this.draggingScrollBar) {
            float height = this.getMaxScrollHeight();
            Rectangle bounds = this.getBounds();
            int actualHeight = bounds.height;
            if (mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
                double maxScroll = Math.max(1, this.getMaxScroll());
                double int_3 = Mth.m_14008_((double)((double)(actualHeight * actualHeight) / (double)height), (double)32.0, (double)(actualHeight - 8));
                double double_6 = Math.max(1.0, maxScroll / ((double)actualHeight - int_3));
                float to = Mth.m_14036_((float)((float)(this.scrollAmount + dy * double_6)), (float)0.0f, (float)this.getMaxScroll());
                if (snapToRows) {
                    double nearestRow = (double)Math.round((double)to / rowSize) * rowSize;
                    this.scrollTo(nearestRow, false);
                } else {
                    this.scrollTo(to, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateDraggingState(double mouseX, double mouseY, int button) {
        if (!this.hasScrollBar()) {
            return false;
        }
        double height = this.getMaxScrollHeight();
        Rectangle bounds = this.getBounds();
        int actualHeight = bounds.height;
        if (height > (double)actualHeight && mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
            double d;
            double scrollbarPositionMinX = this.getScrollBarX();
            if (mouseX >= d - 1.0 && mouseX <= scrollbarPositionMinX + 8.0) {
                this.draggingScrollBar = true;
                return true;
            }
        }
        this.draggingScrollBar = false;
        return false;
    }
}

