/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.ui.api.Tooltip;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class PointTooltip
implements Tooltip {
    private Font font;
    private final Point location;
    private final List<FormattedCharSequence> text;
    private boolean fromKeyboard;

    protected PointTooltip(Point location, List<FormattedCharSequence> text) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.fromKeyboard = false;
        this.location = location;
        this.text = Collections.unmodifiableList(text);
    }

    public static PointTooltip create(Point location, List<Component> text) {
        return new PointTooltip(location, Language.m_128107_().m_128112_(text));
    }

    public static PointTooltip create(Point location, Component ... text) {
        return PointTooltip.create(location, Arrays.asList(text));
    }

    public static PointTooltip create(Point location, FormattedCharSequence ... text) {
        return new PointTooltip(location, Arrays.asList(text));
    }

    public static PointTooltip create(Point location, FormattedText ... text) {
        return new PointTooltip(location, Language.m_128107_().m_128112_(Arrays.asList(text)));
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public PointTooltip withFont(Font font) {
        this.font = font;
        return this;
    }

    @Override
    public Point getPoint() {
        return this.location;
    }

    @Override
    public List<FormattedCharSequence> getText() {
        return this.text;
    }

    @Override
    public boolean isFromKeyboard() {
        return this.fromKeyboard;
    }

    @Override
    public PointTooltip asKeyboardTooltip(boolean fromKeyboard) {
        this.fromKeyboard = fromKeyboard;
        return this;
    }
}

