/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class Modifier {
    private final short value;

    private Modifier(short value) {
        this.value = value;
    }

    public static Modifier none() {
        return Modifier.of((short)0);
    }

    @Nullable
    public static Modifier ofKeyCode(int code) {
        if (Minecraft.f_91002_ ? code == 343 || code == 347 : code == 341 || code == 345) {
            return Modifier.of(false, true, false);
        }
        if (code == 344 || code == 340) {
            return Modifier.of(false, false, true);
        }
        if (code == 342 || code == 346) {
            return Modifier.of(true, false, false);
        }
        return null;
    }

    public static Modifier of(boolean alt, boolean control, boolean shift) {
        short value = Modifier.setFlag((short)0, (short)1, alt);
        value = Modifier.setFlag(value, (short)2, control);
        value = Modifier.setFlag(value, (short)4, shift);
        return Modifier.of(value);
    }

    public static Modifier of(short value) {
        return new Modifier(value);
    }

    public static Modifier current() {
        return Modifier.of(Screen.m_96639_(), Screen.m_96637_(), Screen.m_96638_());
    }

    private static short setFlag(short base, short flag, boolean val) {
        return val ? Modifier.setFlag(base, flag) : Modifier.removeFlag(base, flag);
    }

    private static short setFlag(short base, short flag) {
        return (short)(base | flag);
    }

    private static short removeFlag(short base, short flag) {
        return (short)(base & ~flag);
    }

    private static boolean getFlag(short base, short flag) {
        return (base & flag) != 0;
    }

    public boolean matchesCurrent() {
        return this.equals(Modifier.current());
    }

    public short getValue() {
        return this.value;
    }

    public boolean hasAlt() {
        return Modifier.getFlag(this.value, (short)1);
    }

    public boolean hasControl() {
        return Modifier.getFlag(this.value, (short)2);
    }

    public boolean hasShift() {
        return Modifier.getFlag(this.value, (short)4);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public Modifier merge(Modifier mod) {
        return new Modifier((short)(this.value | mod.value));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Modifier)) {
            return false;
        }
        return this.value == ((Modifier)other).value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

