/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IOverlayCapableContainer {
    public int getScreenWidth();

    public int getScreenHeight();

    public SortedOverlayCollection getSortedOverlays();

    default public void addOverlay(Rectangle area, IOverlayRenderer overlayRenderer, int priority) {
        this.getSortedOverlays().addDeferred(area, overlayRenderer, priority);
    }

    default public void addOverlay(Rectangle area, IOverlayRenderer overlayRenderer) {
        this.addOverlay(area, overlayRenderer, 0);
    }

    default public boolean handleOverlaysEscapeKey() {
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        for (OverlayTicket ticket : sortedOverlays.descending()) {
            if (!ticket.renderer.overlayEscape()) continue;
            return true;
        }
        return false;
    }

    default public boolean handleOverlaysMouseClicked(double mouseX, double mouseY, int button) {
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        for (OverlayTicket ticket : sortedOverlays.descending()) {
            if (ticket.area.contains(mouseX, mouseY)) {
                if (!ticket.renderer.overlayMouseClicked(ticket.area, mouseX, mouseY, button)) continue;
                if (ticket.renderer.isOverlayDragging()) {
                    sortedOverlays.setDragTarget(ticket.renderer);
                }
                return true;
            }
            ticket.renderer.overlayMouseClickedOutside(ticket.area, mouseX, mouseY, button);
        }
        return false;
    }

    default public boolean handleOverlaysMouseScrolled(double mouseX, double mouseY, double amount) {
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        for (OverlayTicket ticket : sortedOverlays.descending()) {
            if (!ticket.area.contains(mouseX, mouseY) || !ticket.renderer.overlayMouseScrolled(ticket.area, mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    default public boolean handleOverlaysMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Optional<OverlayTicket> target;
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        IOverlayRenderer dragTarget = sortedOverlays.getDragTarget();
        if (dragTarget != null && (target = sortedOverlays.stream().filter(ticket -> ticket.renderer == dragTarget).findFirst()).isPresent()) {
            OverlayTicket ticket2 = target.get();
            if (ticket2.renderer.overlayMouseDragged(ticket2.area, mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            sortedOverlays.setDragTarget(null);
        }
        return false;
    }

    default public boolean handleOverlaysDragEnd(double mouseX, double mouseY, int button) {
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        IOverlayRenderer dragTarget = sortedOverlays.getDragTarget();
        if (dragTarget != null) {
            sortedOverlays.setDragTarget(null);
            Optional<OverlayTicket> target = sortedOverlays.stream().filter(ticket -> ticket.renderer == dragTarget).findFirst();
            if (target.isPresent()) {
                OverlayTicket ticket2 = target.get();
                ticket2.renderer.overlayMouseDragEnd(ticket2.area, mouseX, mouseY, button);
                return true;
            }
        }
        return false;
    }

    default public boolean handleOverlaysMouseReleased(double mouseX, double mouseY, int button) {
        if (this.handleOverlaysDragEnd(mouseX, mouseY, button)) {
            return true;
        }
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        for (OverlayTicket ticket : sortedOverlays.descending()) {
            if (!ticket.area.contains(mouseX, mouseY) || !ticket.renderer.overlayMouseReleased(ticket.area, mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    default public void renderOverlays(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        SortedOverlayCollection sortedOverlays = this.getSortedOverlays();
        sortedOverlays.commitPending();
        LinkedList<OverlayTicket> removed = new LinkedList<OverlayTicket>();
        PoseStack mStack = gg.m_280168_();
        mStack.m_85836_();
        mStack.m_85837_(0.0, 0.0, 100.0);
        Screen screen = Minecraft.m_91087_().f_91080_;
        IMultiTooltipScreen tScreen = screen instanceof IMultiTooltipScreen ? (IMultiTooltipScreen)screen : null;
        for (OverlayTicket ticket : sortedOverlays) {
            if (tScreen != null) {
                tScreen.removeTooltips(ticket.area);
            }
            ScissorsHandler.INSTANCE.pushScissor(ticket.area);
            if (!ticket.renderer.renderOverlay(gg, ticket.area, mouseX, mouseY, delta)) {
                removed.add(ticket);
            }
            ScissorsHandler.INSTANCE.popScissor();
        }
        mStack.m_85849_();
        sortedOverlays.removeAll(removed);
    }

    default public boolean shouldOverlaysSuppressHover(int mouseX, int mouseY) {
        return this.getSortedOverlays().stream().anyMatch(t -> t.area.contains(mouseX, mouseY));
    }

    public static class SortedOverlayCollection
    implements Iterable<OverlayTicket> {
        int count = 0;
        protected TreeSet<OverlayTicket> tree = new TreeSet();
        protected Collection<OverlayTicket> pendingAdded = new LinkedList<OverlayTicket>();
        @Nullable
        protected IOverlayRenderer dragTarget = null;

        public void addDeferred(Rectangle area, IOverlayRenderer renderer, int priority) {
            this.pendingAdded.add(new OverlayTicket(priority, this.count++, area, renderer));
        }

        public void addDeferred(OverlayTicket ticket) {
            this.pendingAdded.add(new OverlayTicket(ticket.priority, this.count++, ticket.area, ticket.renderer));
        }

        public boolean add(Rectangle area, IOverlayRenderer renderer, int priority) {
            return this.tree.add(new OverlayTicket(priority, this.count++, area, renderer));
        }

        public boolean add(OverlayTicket ticket) {
            return this.tree.add(new OverlayTicket(ticket.priority, this.count++, ticket.area, ticket.renderer));
        }

        public boolean addAll(Collection<? extends OverlayTicket> collection) {
            return this.tree.addAll(collection);
        }

        public boolean remove(OverlayTicket ticket) {
            this.pendingAdded.remove(ticket);
            return this.tree.remove(ticket);
        }

        public boolean removeAll(Collection<? extends OverlayTicket> collection) {
            this.pendingAdded.removeAll(collection);
            return this.tree.removeAll(collection);
        }

        public void clear() {
            this.pendingAdded.clear();
            this.tree.clear();
            this.count = 0;
        }

        public int size() {
            return this.tree.size();
        }

        public boolean isEmpty() {
            return this.tree.isEmpty();
        }

        public void commitPending() {
            this.addAll(this.pendingAdded);
            this.pendingAdded.clear();
        }

        @Override
        @NotNull
        public Iterator<OverlayTicket> iterator() {
            return this.tree.iterator();
        }

        public Iterable<OverlayTicket> descending() {
            return () -> this.tree.descendingIterator();
        }

        public Stream<OverlayTicket> stream() {
            return this.tree.stream();
        }

        @Nullable
        public IOverlayRenderer getDragTarget() {
            return this.dragTarget;
        }

        public void setDragTarget(@Nullable IOverlayRenderer dragTarget) {
            this.dragTarget = dragTarget;
        }
    }

    public static interface IOverlayRenderer {
        public boolean renderOverlay(GuiGraphics var1, Rectangle var2, int var3, int var4, float var5);

        default public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
            return false;
        }

        default public void overlayMouseClickedOutside(Rectangle area, double mouseX, double mouseY, int button) {
        }

        default public boolean overlayMouseDragged(Rectangle area, double mouseX, double mouseY, int button, double dragX, double dragY) {
            return false;
        }

        default public void overlayMouseDragEnd(Rectangle area, double mouseX, double mouseY, int button) {
        }

        default public boolean overlayMouseReleased(Rectangle area, double mouseX, double mouseY, int button) {
            return false;
        }

        default public boolean overlayMouseScrolled(Rectangle area, double mouseX, double mouseY, double amount) {
            return false;
        }

        default public boolean isOverlayDragging() {
            return false;
        }

        default public boolean overlayEscape() {
            return false;
        }
    }

    public static class OverlayTicket
    implements Comparable<OverlayTicket> {
        public final int priority;
        protected final int tieBreaker;
        public final Rectangle area;
        public final IOverlayRenderer renderer;

        protected OverlayTicket(int priority, int tieBreaker, Rectangle area, IOverlayRenderer renderer) {
            this.priority = priority;
            this.tieBreaker = tieBreaker;
            this.area = area;
            this.renderer = renderer;
        }

        @Override
        public int compareTo(@NotNull OverlayTicket o) {
            int c = Integer.compare(this.priority, o.priority);
            if (c == 0) {
                c = Integer.compare(this.tieBreaker, o.tieBreaker);
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OverlayTicket that = (OverlayTicket)o;
            return this.priority == that.priority && this.tieBreaker == that.tieBreaker;
        }

        public int hashCode() {
            return Objects.hash(this.priority, this.tieBreaker);
        }
    }
}

