/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import org.jetbrains.annotations.Nullable;

public interface INavigableTarget
extends ContainerEventHandler {
    public void navigate();

    default public boolean isNavigable() {
        return true;
    }

    public Rectangle getNavigableArea();

    public Rectangle getRowArea();

    @Nullable
    default public INavigableTarget getLastSelectedNavigableSubTarget() {
        return null;
    }

    default public void setLastSelectedNavigableSubTarget(@Nullable INavigableTarget target) {
    }

    @Nullable
    default public INavigableTarget getNavigableParent() {
        return null;
    }

    default public List<INavigableTarget> getNavigableChildren(boolean onlyVisible) {
        return Collections.emptyList();
    }

    default public List<INavigableTarget> getNavigableDescendants(boolean onlyVisible) {
        return this.getNavigableChildren(onlyVisible).stream().flatMap(e -> Stream.concat(Stream.of(e), e.getNavigableDescendants(onlyVisible).stream())).collect(Collectors.toList());
    }

    default public List<INavigableTarget> getNavigableDescendantsAndSubDescendants(boolean onlyVisible) {
        return this.getNavigableChildren(onlyVisible).stream().flatMap(e -> Stream.of(Stream.of(e), e.getNavigableSubTargets().stream(), e.getNavigableDescendantsAndSubDescendants(onlyVisible).stream())).flatMap(Function.identity()).collect(Collectors.toList());
    }

    default public boolean isNavigableSubTarget() {
        return false;
    }

    default public List<INavigableTarget> getNavigableSubTargets() {
        return Lists.newArrayList();
    }

    default public INavigableTarget selectClosestTarget(List<INavigableTarget> targets, @Nullable INavigableTarget hint) {
        Rectangle area = this.getNavigableArea();
        if (hint != null) {
            Rectangle hintArea = hint.getNavigableArea();
            INavigableTarget closest = targets.stream().max(Comparator.comparingInt(r -> r.getNavigableArea().horizontalIntersection(hintArea))).orElse(null);
            if (closest != null && closest.getNavigableArea().horizontalIntersection(area) > 0) {
                return closest;
            }
        }
        return targets.stream().max(Comparator.comparingInt(r -> r.getNavigableArea().horizontalIntersection(area))).orElse(null);
    }

    default public boolean handleNavigationKey(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public void applyFocusHighlight(int var1, int var2);

    default public void applyFocusHighlight(int color) {
        this.applyFocusHighlight(color, 0);
    }

    @Nullable
    default public AbstractConfigField<?> findParentEntry() {
        INavigableTarget target;
        for (target = this; !(target instanceof AbstractConfigField) && target != null; target = target.getNavigableParent()) {
        }
        return (AbstractConfigField)target;
    }

    public static final class HighlightColors {
        public static int HISTORY = -2143141121;
        public static int MERGE = -2141179792;
        public static int WARNING = -1604033464;
        public static int ERROR = -2130755006;
        public static int EDITED = -2136956768;

        private HighlightColors() {
        }
    }
}

