/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import endorh.simpleconfig.ui.api.IModalInputProcessor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IModalInputCapableScreen {
    @Nullable
    public IModalInputProcessor getModalInputProcessor();

    @ApiStatus.Internal
    public void setModalInputProcessor(IModalInputProcessor var1);

    default public void claimModalInput(IModalInputProcessor processor) {
        IModalInputProcessor prev = this.getModalInputProcessor();
        this.setModalInputProcessor(processor);
        if (prev != null) {
            prev.cancelModalInputProcessing();
        }
    }

    default public void cancelModalInput() {
        IModalInputProcessor prev = this.getModalInputProcessor();
        this.setModalInputProcessor(null);
        if (prev != null) {
            prev.cancelModalInputProcessing();
        }
    }

    default public boolean handleModalKeyPressed(int keyCode, int scanCode, int modifiers) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.modalKeyPressed(keyCode, scanCode, modifiers)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }

    default public boolean handleModalKeyReleased(int keyCode, int scanCode, int modifiers) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.modalKeyReleased(keyCode, scanCode, modifiers)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }

    default public boolean handleModalCharTyped(char codePoint, int modifiers) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.modalCharTyped(codePoint, modifiers)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }

    default public boolean handleModalMouseClicked(double mouseX, double mouseY, int button) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.shouldConsumeModalClicks(mouseX, mouseY, button)) {
                this.cancelModalInput();
                return false;
            }
            if (!proc.modalMouseClicked(mouseX, mouseY, button)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }

    default public boolean handleModalMouseReleased(double mouseX, double mouseY, int button) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.modalMouseReleased(mouseX, mouseY, button)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }

    default public boolean handleModalMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        IModalInputProcessor proc = this.getModalInputProcessor();
        if (proc != null) {
            if (!proc.modalMouseScrolled(mouseX, mouseY, scrollDelta)) {
                this.cancelModalInput();
            }
            return true;
        }
        return false;
    }
}

