/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.google.common.collect.Lists;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.EntryError;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface IEntryHolder {
    public static final Pattern DOT = Pattern.compile("\\.");

    public List<AbstractConfigField<?>> getHeldEntries();

    @Nullable
    default public AbstractConfigField<?> getEntry(String path) {
        String[] sp = DOT.split(path, 2);
        List<AbstractConfigField<?>> entries2 = this.getHeldEntries();
        AbstractConfigField entry = entries2.stream().filter(e -> e.getName().equals(sp[0])).findFirst().orElse(null);
        if (sp.length < 2) {
            return entry;
        }
        if (entry instanceof IEntryHolder) {
            return ((IEntryHolder)((Object)entry)).getEntry(sp[1]);
        }
        return entry;
    }

    default public List<AbstractConfigField<?>> getAllMainEntries() {
        return this.getAllEntries(e -> !e.isSubEntry());
    }

    default public List<AbstractConfigField<?>> getAllEntries(Predicate<AbstractConfigField<?>> filter) {
        ArrayList list = Lists.newArrayList();
        this.getHeldEntries().stream().filter(filter).flatMap(e -> e instanceof IEntryHolder ? Stream.concat(Stream.of(e), ((IEntryHolder)((Object)e)).getAllEntries(filter).stream()) : Stream.of(e)).forEach(list::add);
        return list;
    }

    default public List<EntryError> getErrors() {
        return this.getHeldEntries().stream().flatMap(e -> e.getErrors().stream()).collect(Collectors.toList());
    }

    default public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    default public List<AbstractConfigField<?>> getAllExternalConflicts() {
        return this.getAllMainEntries().stream().filter(AbstractConfigField::hasConflictingExternalDiff).collect(Collectors.toList());
    }

    default public boolean hasExternalConflicts() {
        return this.getAllMainEntries().stream().anyMatch(AbstractConfigField::hasConflictingExternalDiff);
    }

    @Nullable
    default public AbstractConfigField<?> getSingleResettableEntry() {
        return null;
    }

    @Nullable
    default public AbstractConfigField<?> getSingleRestorableEntry() {
        return null;
    }

    default public void resetSingleEntry(AbstractConfigField<?> entry) {
    }

    default public void restoreSingleEntry(AbstractConfigField<?> entry) {
    }
}

