/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import endorh.simpleconfig.ui.api.IModalInputCapableScreen;
import endorh.simpleconfig.ui.api.IMultiTooltipScreen;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.gui.AbstractDialog;
import java.util.List;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface IDialogCapableScreen
extends IOverlayCapableContainer,
IModalInputCapableScreen,
IMultiTooltipScreen {
    public SortedDialogCollection getDialogs();

    default public boolean hasDialogs() {
        return !this.getDialogs().isEmpty();
    }

    default public void addDialog(AbstractDialog dialog) {
        dialog.setScreen(this);
        this.getDialogs().add(dialog);
    }

    default public void removeDialog(AbstractDialog dialog) {
        this.getDialogs().remove(dialog);
    }

    default public void renderDialogs(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        SortedDialogCollection dialogs = this.getDialogs();
        dialogs.update();
        List<AbstractDialog> current = dialogs.getDialogs();
        int size = current.size();
        int count = 1;
        PoseStack mStack = gg.m_280168_();
        for (AbstractDialog dialog : current) {
            int mY;
            mStack.m_85836_();
            mStack.m_85837_(0.0, 0.0, (double)count * 100.0);
            int mX = count == size ? mouseX : -1;
            int n = mY = count == size ? mouseY : -1;
            if (!dialog.render(gg, mX, mY, delta)) {
                dialogs.remove(dialog);
            }
            ++count;
            mStack.m_85849_();
        }
        dialogs.update();
        current = dialogs.getDialogs();
        if (!current.isEmpty() && this instanceof ContainerEventHandler) {
            ((ContainerEventHandler)this).m_7522_((GuiEventListener)current.get(current.size() - 1));
        }
    }

    default public void tickDialogs() {
        List<AbstractDialog> current = this.getDialogs().getDialogs();
        int i = 0;
        for (AbstractDialog dialog : current) {
            dialog.tick(++i == current.size());
        }
    }

    default public boolean handleDialogsMouseClicked(double mouseX, double mouseY, int button) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_6375_(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsMouseScrolled(double mouseX, double mouseY, double delta) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_6050_(mouseX, mouseY, delta);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_7979_(mouseX, mouseY, button, dragX, dragY);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsMouseReleased(double mouseX, double mouseY, int button) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_6348_(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return this.handleDialogsEscapeKey();
        }
        if (keyCode == 258) {
            return this.handleDialogsChangeFocus(!Screen.m_96638_());
        }
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_7933_(keyCode, scanCode, modifiers);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsCharTyped(char codePoint, int modifiers) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_5534_(codePoint, modifiers);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsKeyReleased(int keyCode, int scanCode, int modifiers) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.m_7920_(keyCode, scanCode, modifiers);
            return true;
        }
        return false;
    }

    default public boolean handleDialogsEscapeKey() {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            last.escapeKeyPressed();
            return true;
        }
        return false;
    }

    default public boolean handleDialogsChangeFocus(boolean forward) {
        AbstractDialog last = this.getDialogs().getLast();
        if (last != null) {
            ComponentPath pre;
            FocusNavigationEvent.TabNavigation e = new FocusNavigationEvent.TabNavigation(forward);
            ComponentPath path = last.m_264064_((FocusNavigationEvent)e);
            if (path == null) {
                pre = last.m_264435_();
                if (pre != null) {
                    pre.m_264432_(false);
                }
                path = last.m_264064_((FocusNavigationEvent)e);
            }
            if (path != null) {
                pre = last.m_264435_();
                if (pre != null) {
                    pre.m_264432_(false);
                }
                path.m_264432_(true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public int getScreenWidth() {
        return ((Screen)this).f_96543_;
    }

    @Override
    default public int getScreenHeight() {
        return ((Screen)this).f_96544_;
    }

    public static class SortedDialogCollection {
        private final List<AbstractDialog> dialogs = Lists.newArrayList();
        private final List<AbstractDialog> reversed = Lists.reverse(this.dialogs);
        private final List<AbstractDialog> added = Lists.newArrayList();
        private final List<AbstractDialog> removed = Lists.newArrayList();

        public List<AbstractDialog> getDialogs() {
            return this.dialogs;
        }

        public List<AbstractDialog> getDescendingDialogs() {
            return this.reversed;
        }

        @Nullable
        public AbstractDialog getLast() {
            return this.reversed.isEmpty() ? null : this.reversed.get(0);
        }

        protected List<AbstractDialog> getAdded() {
            return this.added;
        }

        protected List<AbstractDialog> getRemoved() {
            return this.removed;
        }

        public void update() {
            List<AbstractDialog> dialogs = this.getDialogs();
            List<AbstractDialog> added = this.getAdded();
            List<AbstractDialog> removed = this.getRemoved();
            dialogs.removeAll(added);
            dialogs.addAll(added);
            dialogs.removeAll(removed);
            added.clear();
            removed.clear();
        }

        public boolean isEmpty() {
            return this.dialogs.isEmpty();
        }

        public void add(AbstractDialog dialog) {
            this.added.remove(dialog);
            this.removed.remove(dialog);
            this.added.add(dialog);
        }

        public void remove(AbstractDialog dialog) {
            this.added.remove(dialog);
            this.removed.remove(dialog);
            this.removed.add(dialog);
        }
    }
}

