/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import endorh.simpleconfig.ui.api.GuiEventListenerEx;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public interface ContainerEventHandlerEx
extends ContainerEventHandler {
    @Nullable
    default public ComponentPath m_264435_() {
        GuiEventListener focused = this.m_7222_();
        return focused != null ? ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)focused.m_264435_()) : null;
    }

    @Nullable
    default public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
        ComponentPath componentpath;
        GuiEventListener focused = this.m_7222_();
        if (focused != null && (componentpath = focused.m_264064_(e)) != null) {
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentpath);
        }
        if (e instanceof FocusNavigationEvent.TabNavigation) {
            FocusNavigationEvent.TabNavigation te = (FocusNavigationEvent.TabNavigation)e;
            return this.handleTabNavigation(te);
        }
        if (e instanceof FocusNavigationEvent.ArrowNavigation) {
            FocusNavigationEvent.ArrowNavigation ae = (FocusNavigationEvent.ArrowNavigation)e;
            return this.handleArrowNavigation(ae);
        }
        return null;
    }

    default public boolean shouldTabNavigationCycleWithin() {
        return false;
    }

    @Nullable
    default public ComponentPath handleTabNavigation(FocusNavigationEvent.TabNavigation e) {
        Supplier<GuiEventListener> next;
        BooleanSupplier cond;
        boolean forward = e.f_263782_();
        GuiEventListener focused = this.m_7222_();
        ArrayList<GuiEventListener> list = new ArrayList<GuiEventListener>(this.m_6702_());
        list.sort(Comparator.comparingInt(TabOrderedElement::m_267579_));
        int j = list.indexOf(focused);
        int i = focused != null && j >= 0 ? j + (forward ? 1 : 0) : (forward ? 0 : list.size());
        ListIterator iter = list.listIterator(i);
        BooleanSupplier booleanSupplier = forward ? iter::hasNext : (cond = iter::hasPrevious);
        Supplier<GuiEventListener> supplier = forward ? iter::next : (next = iter::previous);
        while (cond.getAsBoolean()) {
            GuiEventListener l = next.get();
            ComponentPath path = l.m_264064_((FocusNavigationEvent)e);
            if (path == null) continue;
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)path);
        }
        return null;
    }

    @Nullable
    default public ComponentPath handleArrowNavigation(FocusNavigationEvent.ArrowNavigation e) {
        GuiEventListener focused = this.m_7222_();
        if (focused == null) {
            ScreenDirection d = e.f_263812_();
            ScreenRectangle rect = this.m_264198_().m_264525_(d.m_264089_());
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)this.nextFocusPathInDirection(rect, d, null, (FocusNavigationEvent)e));
        }
        ScreenRectangle rect = focused.m_264198_();
        return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)this.nextFocusPathInDirection(rect, e.f_263812_(), focused, (FocusNavigationEvent)e));
    }

    @Nullable
    default public ComponentPath nextFocusPathInDirection(ScreenRectangle rect, ScreenDirection dir, @Nullable GuiEventListener current, FocusNavigationEvent e) {
        ScreenAxis axis = dir.m_264093_();
        ScreenAxis otherAxis = axis.m_264385_();
        ScreenDirection otherDir = otherAxis.m_264292_();
        int b = rect.m_264095_(dir.m_264089_());
        ArrayList<GuiEventListener> list = new ArrayList<GuiEventListener>();
        for (GuiEventListener child : this.m_6702_()) {
            ScreenRectangle childRect;
            if (child == current || !(childRect = child.m_264198_()).m_264632_(rect, otherAxis)) continue;
            int cb = childRect.m_264095_(dir.m_264089_());
            if (dir.m_264526_(cb, b)) {
                list.add(child);
                continue;
            }
            if (cb != b || !dir.m_264526_(childRect.m_264095_(dir), rect.m_264095_(dir))) continue;
            list.add(child);
        }
        list.sort(Comparator.comparing(l -> l.m_264198_().m_264095_(dir.m_264089_()), dir.m_264394_()).thenComparing(l -> l.m_264198_().m_264095_(otherDir.m_264089_()), otherDir.m_264394_()));
        for (GuiEventListener option : list) {
            ComponentPath path = option.m_264064_(e);
            if (path == null) continue;
            return path;
        }
        return this.nextFocusPathVaguelyInDirection(rect, dir, current, e);
    }

    @Nullable
    default public ComponentPath nextFocusPathVaguelyInDirection(ScreenRectangle rect, ScreenDirection dir, @Nullable GuiEventListener current, FocusNavigationEvent e) {
        ScreenAxis axis = dir.m_264093_();
        ScreenAxis otherAxis = axis.m_264385_();
        ArrayList<Pair> list = new ArrayList<Pair>();
        ScreenPosition pos = ScreenPosition.m_264208_((ScreenAxis)axis, (int)rect.m_264095_(dir), (int)rect.m_264037_(otherAxis));
        for (GuiEventListener child : this.m_6702_()) {
            ScreenRectangle childRect;
            ScreenPosition childPos;
            if (child == current || !dir.m_264526_((childPos = ScreenPosition.m_264208_((ScreenAxis)axis, (int)(childRect = child.m_264198_()).m_264095_(dir.m_264089_()), (int)childRect.m_264037_(otherAxis))).m_264196_(axis), pos.m_264196_(axis))) continue;
            long dist = Vector2i.distanceSquared((int)pos.f_263719_(), (int)pos.f_263694_(), (int)childPos.f_263719_(), (int)childPos.f_263694_());
            list.add(Pair.of((Object)child, (Object)dist));
        }
        list.sort(Comparator.comparingDouble(Pair::getRight));
        for (Pair pair : list) {
            ComponentPath path = ((GuiEventListener)pair.getLeft()).m_264064_(e);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    public Pair<Integer, GuiEventListener> getDragged();

    public void setDragged(Pair<Integer, GuiEventListener> var1);

    default public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener listener : this.m_6702_()) {
            if (!listener.m_6375_(mouseX, mouseY, button)) continue;
            this.onMouseClickedForListener(listener, mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    default public void onMouseClickedForListener(GuiEventListener listener, double mouseX, double mouseY, int button) {
        this.m_7522_(listener);
        if ((!this.m_7282_() || this.getDragged() != null && (Integer)this.getDragged().getLeft() == button) && (button == 0 || listener instanceof ContainerEventHandlerEx || listener instanceof GuiEventListenerEx)) {
            this.m_7897_(true);
            this.setDragged((Pair<Integer, GuiEventListener>)Pair.of((Object)button, (Object)listener));
        }
    }

    default public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.m_7222_() != null && this.m_7282_() && (button == 0 || this.m_7222_() instanceof ContainerEventHandlerEx || this.m_7222_() instanceof GuiEventListenerEx) && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    default public void endDrag(double mouseX, double mouseY, int button) {
        Pair<Integer, GuiEventListener> dragged = this.getDragged();
        if (dragged != null) {
            if ((Integer)dragged.getLeft() != button) {
                button = -1;
            }
            if (dragged.getRight() instanceof ContainerEventHandlerEx) {
                ((ContainerEventHandlerEx)dragged.getRight()).endDrag(mouseX, mouseY, button);
                this.m_7897_(false);
                this.setDragged(null);
            } else if (dragged.getRight() instanceof GuiEventListenerEx) {
                if ((Integer)dragged.getLeft() == button) {
                    ((GuiEventListenerEx)dragged.getRight()).endDrag(mouseX, mouseY, button);
                }
                this.m_7897_(false);
                this.setDragged(null);
            } else {
                this.m_7897_(false);
                this.setDragged(null);
            }
        }
    }

    default public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.handleEndDrag(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    default public void handleEndDrag(double mouseX, double mouseY, int button) {
        if (this.getDragged() != null && button == (Integer)this.getDragged().getLeft()) {
            this.endDrag(mouseX, mouseY, button);
        }
    }
}

