/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.electronwill.nightconfig.core.CommentedConfig;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.ui.api.ConfigCategoryBuilder;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.widget.PresetPickerWidget;
import endorh.simpleconfig.ui.hotkey.ConfigHotKey;
import endorh.simpleconfig.ui.impl.ConfigEntryBuilderImpl;
import endorh.simpleconfig.ui.impl.ConfigScreenBuilderImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface ConfigScreenBuilder {
    public static ConfigScreenBuilder create() {
        return ConfigScreenBuilder.create("");
    }

    public static ConfigScreenBuilder create(String modId) {
        return new ConfigScreenBuilderImpl(modId);
    }

    public ConfigScreenBuilder setFallbackCategory(ConfigCategoryBuilder var1);

    public Screen getParentScreen();

    public ConfigScreenBuilder setParentScreen(Screen var1);

    public Component getTitle();

    public ConfigScreenBuilder setTitle(Component var1);

    public ConfigHotKey getEditedConfigHotKey();

    public Consumer<Boolean> getHotKeySaver();

    public ConfigScreenBuilder setEditedConfigHotKey(ConfigHotKey var1, Consumer<Boolean> var2);

    public ConfigCategoryBuilder getSelectedCategory();

    public ConfigScreenBuilder setSelectedCategory(ConfigCategoryBuilder var1);

    default public ConfigScreenBuilder setSelectedCategory(String name, SimpleConfig.EditType type) {
        return this.setSelectedCategory(this.getOrCreateCategory(name, type));
    }

    @Nullable
    public IConfigScreenGUIState getPreviousGUIState();

    public ConfigScreenBuilder setPreviousGUIState(@Nullable IConfigScreenGUIState var1);

    public boolean isEditable();

    public ConfigScreenBuilder setEditable(boolean var1);

    @ApiStatus.Internal
    public List<ConfigCategoryBuilder> getCategories(SimpleConfig.EditType var1);

    public ConfigCategoryBuilder getOrCreateCategory(String var1, SimpleConfig.EditType var2);

    public ConfigScreenBuilder removeCategory(String var1, SimpleConfig.EditType var2);

    public ConfigScreenBuilder removeCategoryIfExists(String var1, SimpleConfig.EditType var2);

    public boolean hasCategory(String var1, SimpleConfig.EditType var2);

    public ResourceLocation getDefaultBackgroundTexture();

    public ConfigScreenBuilder setDefaultBackgroundTexture(ResourceLocation var1);

    public Runnable getSavingRunnable();

    public ConfigScreenBuilder setSavingRunnable(Runnable var1);

    public Runnable getClosingRunnable();

    public ConfigScreenBuilder setClosingRunnable(Runnable var1);

    public Consumer<Screen> getAfterInitConsumer();

    public ConfigScreenBuilder setAfterInitConsumer(Consumer<Screen> var1);

    default public ConfigScreenBuilder alwaysShowTabs() {
        return this.setAlwaysShowTabs(true);
    }

    public boolean isAlwaysShowTabs();

    public ConfigScreenBuilder setAlwaysShowTabs(boolean var1);

    public ConfigScreenBuilder setTransparentBackground(boolean var1);

    default public ConfigScreenBuilder transparentBackground() {
        return this.setTransparentBackground(true);
    }

    default public ConfigScreenBuilder solidBackground() {
        return this.setTransparentBackground(false);
    }

    public boolean hasTransparentBackground();

    default public ConfigFieldBuilder entryBuilder() {
        return ConfigEntryBuilderImpl.create();
    }

    public AbstractConfigScreen build();

    public ConfigScreenBuilder setSnapshotHandler(IConfigSnapshotHandler var1);

    public ConfigScreenBuilder setRemoteCommonConfigProvider(IRemoteConfigProvider var1);

    public static interface IConfigScreenGUIState {
        public SimpleConfig.EditType getEditedType();

        public Map<SimpleConfig.EditType, String> getSelectedCategories();

        public Map<SimpleConfig.EditType, Map<String, IConfigCategoryGUIState>> getCategoryStates();

        public static interface IConfigCategoryGUIState {
            public Map<String, Boolean> getExpandStates();

            public String getSelectedEntry();

            public int getScrollOffset();
        }
    }

    public static interface IConfigSnapshotHandler {
        default public CommentedConfig preserve(SimpleConfig.Type type) {
            return this.preserve(type, null);
        }

        public CommentedConfig preserve(SimpleConfig.Type var1, @Nullable Set<String> var2);

        public void restore(CommentedConfig var1, SimpleConfig.Type var2, @Nullable Set<String> var3);

        public boolean canSaveRemote();

        public CompletableFuture<CommentedConfig> getPresetSnapshot(PresetPickerWidget.Preset var1);

        public CommentedConfig getLocal(String var1, SimpleConfig.Type var2);

        public CompletableFuture<CommentedConfig> getRemote(String var1, SimpleConfig.Type var2);

        public CommentedConfig getResource(String var1, SimpleConfig.Type var2);

        public Optional<Throwable> saveLocal(String var1, SimpleConfig.Type var2, CommentedConfig var3);

        public CompletableFuture<Void> saveRemote(String var1, SimpleConfig.Type var2, CommentedConfig var3);

        public Optional<Throwable> deleteLocal(String var1, SimpleConfig.Type var2);

        public CompletableFuture<Void> deleteRemote(String var1, SimpleConfig.Type var2);

        public List<PresetPickerWidget.Preset> getLocalPresets();

        public CompletableFuture<List<PresetPickerWidget.Preset>> getRemotePresets();

        public List<PresetPickerWidget.Preset> getResourcePresets();

        public IExternalChangeHandler getExternalChangeHandler();

        public void setExternalChangeHandler(IExternalChangeHandler var1);

        public void notifyExternalChanges(SimpleConfig var1);

        public static interface IExternalChangeHandler {
            public void handleExternalChange(SimpleConfig.EditType var1);

            public void handleRemoteConfigExternalChange(SimpleConfig.EditType var1, CommentedConfig var2);
        }
    }

    public static interface IRemoteConfigProvider {
        public CompletableFuture<CommentedConfig> getRemoteConfig(SimpleConfig.EditType var1);

        public boolean mayHaveRemoteConfig(SimpleConfig.EditType var1);

        public void loadRemoteConfig(SimpleConfig.EditType var1, CommentedConfig var2, boolean var3);

        public void saveRemoteConfig(SimpleConfig.EditType var1, boolean var2);
    }
}

