/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import endorh.simpleconfig.api.ui.math.Point;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.ui.api.PointTooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class AreaTooltip
extends PointTooltip {
    private final Rectangle area;

    protected AreaTooltip(Rectangle area, Point point, List<FormattedCharSequence> text) {
        super(point, text);
        this.area = area;
    }

    protected static Point inferPoint(Rectangle area) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return Point.of(area.getMaxX(), area.getY());
        }
        return Point.of(area.getCenterX() > screen.f_96543_ / 2 ? area.getX() : area.getMaxX(), area.getCenterY() > screen.f_96544_ / 2 ? area.getY() : area.getMaxY());
    }

    public static AreaTooltip create(Rectangle area, Point point, List<Component> text) {
        return new AreaTooltip(area, point, Language.m_128107_().m_128112_(text));
    }

    public static AreaTooltip create(Rectangle area, List<Component> text) {
        return AreaTooltip.create(area, AreaTooltip.inferPoint(area), text);
    }

    public static AreaTooltip create(Rectangle area, Point point, Component ... text) {
        return new AreaTooltip(area, point, Language.m_128107_().m_128112_(Arrays.asList(text)));
    }

    public static AreaTooltip create(Rectangle area, Component ... text) {
        return AreaTooltip.create(area, AreaTooltip.inferPoint(area), text);
    }

    public static AreaTooltip create(Rectangle area, Point point, FormattedCharSequence ... text) {
        return new AreaTooltip(area, point, Arrays.asList(text));
    }

    public static AreaTooltip create(Rectangle area, FormattedCharSequence ... text) {
        return AreaTooltip.create(area, AreaTooltip.inferPoint(area), text);
    }

    public Rectangle getArea() {
        return this.area;
    }

    @Override
    public void adjustForScreen(int tooltipWidth, int tooltipHeight, int width, int height) {
        Point point = this.getPoint();
        Rectangle area = this.getArea();
        int enforcedMargin = 6;
        Point initial = point.clone();
        int defaultOffset = 12;
        point.x = point.x + tooltipWidth + defaultOffset < width - enforcedMargin || point.x < width / 2 ? (point.x += defaultOffset) : (point.x -= tooltipWidth + defaultOffset);
        point.y = point.y - tooltipHeight - defaultOffset > enforcedMargin || point.y > height / 2 ? (point.y -= tooltipHeight + defaultOffset) : (point.y += defaultOffset);
        if (point.x + tooltipWidth > width - enforcedMargin) {
            point.x = width - tooltipWidth - enforcedMargin;
        }
        if (point.x < area.getMaxX() + enforcedMargin) {
            point.x = Math.max(enforcedMargin, area.getX() - tooltipWidth - defaultOffset);
            if (point.x + tooltipWidth > area.getX()) {
                point.x = initial.getX();
                point.x = point.x + tooltipWidth + defaultOffset < width - enforcedMargin || point.x < width / 2 ? (point.x += defaultOffset) : (point.x -= tooltipWidth + defaultOffset);
                if (point.x + tooltipWidth > width - enforcedMargin) {
                    point.x = Math.max(enforcedMargin, width - tooltipWidth - enforcedMargin);
                } else if (point.x < enforcedMargin) {
                    point.x = enforcedMargin;
                }
                point.y = area.getY() - tooltipHeight - defaultOffset;
                if (point.y < enforcedMargin && area.getCenterY() < height / 2) {
                    point.y = area.getMaxY() + defaultOffset;
                }
                point.y = Math.max(enforcedMargin, Math.min(height - tooltipHeight - enforcedMargin, point.y));
                return;
            }
        }
        if (point.y + tooltipHeight > height - enforcedMargin) {
            point.y = Math.max(enforcedMargin, height - tooltipHeight - enforcedMargin);
        } else if (point.y < enforcedMargin) {
            point.y = enforcedMargin;
        }
    }
}

