/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.api.ui.math.Rectangle;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.ui.api.AbstractConfigField;
import endorh.simpleconfig.ui.api.IChildListEntry;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.IOverlayCapableContainer;
import endorh.simpleconfig.ui.api.ScissorsHandler;
import endorh.simpleconfig.ui.gui.SimpleConfigScreen;
import endorh.simpleconfig.ui.gui.entries.BeanListEntry;
import endorh.simpleconfig.ui.gui.widget.CheckboxButton;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.MultiFunctionImageButton;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import endorh.simpleconfig.ui.gui.widget.SearchBarWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigListEntry<T>
extends AbstractConfigField<T>
implements IOverlayCapableContainer.IOverlayRenderer {
    protected final Rectangle entryArea = new Rectangle();
    protected final Rectangle fieldArea = new Rectangle();
    protected final Rectangle rowArea = new Rectangle();
    protected final List<GuiEventListener> previewListeners = new ArrayList<GuiEventListener>();
    protected final Rectangle previewOverlayRectangle = new Rectangle();
    protected final Rectangle previewOverlayCaptionRectangle = new Rectangle();
    protected final Rectangle flagsRectangle = new Rectangle();
    protected final MultiFunctionImageButton mergeButton;
    protected final MultiFunctionImageButton acceptButton;
    protected final CheckboxButton selectionCheckbox;
    private boolean headless;
    private INavigableTarget lastSelectedSubTarget;
    protected int externalPreviewShadowColor = -1608244188;
    protected int externalPreviewBgColor = -532528574;
    protected int externalPreviewBorderColor = -527077677;
    protected int externalPreviewTextColor = -526086957;

    public AbstractConfigListEntry(Component name) {
        super(name);
        this.setName(name.getString().replace(".", ""));
        this.selectionCheckbox = new CheckboxButton(false, 0, 0, 18, 18, SimpleConfigIcons.Widgets.CHECKBOX_FLAT, null, this::setSelected);
        this.acceptButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Buttons.MERGE_ACCEPT, MultiFunctionImageButton.ButtonAction.of(this::acceptExternalValue).active(() -> this.hasExternalDiff() && !this.hasAcceptedExternalDiff()).tooltip(() -> Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("simpleconfig.ui.merge.accept." + (this.getScreen().isEditingServer() ? "remote" : "external"))).m_130940_(ChatFormatting.LIGHT_PURPLE)})));
        this.mergeButton = new MultiFunctionImageButton(0, 0, 20, 20, SimpleConfigIcons.Entries.MERGE_CONFLICT, MultiFunctionImageButton.ButtonAction.of(() -> this.setPreviewingExternal(true)).active(() -> !this.isPreviewingExternal() && this.hasConflictingExternalDiff()).tooltip(() -> Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("simpleconfig.ui.view_" + (this.getScreen().isEditingServer() ? "remote" : "external") + "_changes")).m_130940_(ChatFormatting.GOLD)}))){

            @Override
            public void m_257544_(@Nullable Tooltip tooltip) {
                if (ClientConfig.advanced.show_ui_tips) {
                    super.m_257544_(tooltip);
                }
            }
        }.on(MultiFunctionImageButton.Modifier.NONE, MultiFunctionImageButton.ButtonAction.of(() -> {}).active(() -> !this.isPreviewingExternal() && this.hasAcceptedExternalDiff()).icon(SimpleConfigIcons.Entries.MERGE_ACCEPTED).tooltip(() -> Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)("simpleconfig.ui.accepted_" + (this.getScreen().isEditingServer() ? "remote" : "external") + "_changes")).m_130940_(ChatFormatting.DARK_GREEN)}))).on(MultiFunctionImageButton.Modifier.NONE, MultiFunctionImageButton.ButtonAction.of(() -> this.setPreviewingExternal(false)).active(this::isPreviewingExternal).icon(SimpleConfigIcons.Entries.CLOSE_X).tooltip(Collections::emptyList));
        this.previewListeners.add((GuiEventListener)this.acceptButton);
    }

    @Override
    @Nullable
    public ComponentPath m_264435_() {
        return AbstractConfigListEntry.wrapPath(super.m_264435_());
    }

    @Override
    @Nullable
    public ComponentPath m_264064_(@NotNull FocusNavigationEvent e) {
        return AbstractConfigListEntry.wrapPath(super.m_264064_(e));
    }

    public static ComponentPath wrapPath(ComponentPath path) {
        if (path instanceof ComponentPath.Path) {
            ComponentPath.Path p = (ComponentPath.Path)path;
            GuiEventListener entry = path.m_264222_();
            if (entry instanceof AbstractConfigListEntry) {
                return EntryPath.entryPath((AbstractConfigListEntry)entry, p.f_263808_());
            }
        } else if (path instanceof ComponentPath.Leaf) {
            ComponentPath.Leaf l = (ComponentPath.Leaf)path;
            GuiEventListener entry = path.m_264222_();
            if (entry instanceof AbstractConfigListEntry) {
                return EntryLeafPath.entryLeaf((AbstractConfigListEntry)entry);
            }
        }
        return path;
    }

    @Override
    public void updateFocused(boolean isFocused) {
        ResetButton resetButton;
        super.updateFocused(isFocused);
        if (!isFocused && (resetButton = this.getResetButton()) != null) {
            resetButton.m_93692_(false);
        }
    }

    @Override
    public void setPreviewingExternal(boolean previewing) {
        super.setPreviewingExternal(previewing);
        if (this.isPreviewingExternal()) {
            this.updateFocused(false);
            this.getScreen().addOverlay(this.previewOverlayRectangle, this, 10);
        }
    }

    public final int getPreferredTextColor() {
        if (this.isEditingHotKeyAction()) {
            return this.getHotKeyActionType() == null ? -8355712 : (this.hasError() ? -43691 : -1);
        }
        return this.shouldRenderEditable() ? (this.hasError() ? -43691 : -1) : -6250336;
    }

    @Override
    public boolean isShown() {
        SearchBarWidget bar = this.getScreen().getSearchBar();
        AbstractConfigField<?> parent = this.getParentEntry();
        return this.isSubEntry() ? parent != null && parent.isShown() : !bar.isExpanded() || !bar.isFilter() || this.matchesSearch() || parent != null && parent.shouldShowChildren() || bar.isEmpty();
    }

    public CheckboxButton getSelectionCheckbox() {
        return this.selectionCheckbox;
    }

    public Rectangle getSelectionArea() {
        return this.rowArea;
    }

    @Override
    public Rectangle getRowArea() {
        return this.rowArea;
    }

    @Override
    public boolean handleModalClicks(double mouseX, double mouseY, int button) {
        if (this.isPreviewingExternal()) {
            for (GuiEventListener listener : this.previewListeners) {
                if (!listener.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
            return true;
        }
        return super.handleModalClicks(mouseX, mouseY, button);
    }

    @Override
    public boolean handleModalKeyPress(int keyCode, int scanCode, int modifiers) {
        if (this.isPreviewingExternal()) {
            for (GuiEventListener listener : this.previewListeners) {
                if (!listener.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return true;
        }
        return super.handleModalKeyPress(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        if (this.isSelectable() && this.selectionCheckbox.m_6375_(mouseX, mouseY, button)) {
            DynamicEntryListWidget<?> parent = this.getEntryList();
            if (parent instanceof SimpleConfigScreen.ListWidget) {
                ((SimpleConfigScreen.ListWidget)parent).startDragAction(new SimpleConfigScreen.ListWidget.EntryDragAction.SelectionDragAction(this.isSelected()));
            }
            this.m_7897_(true);
            return true;
        }
        Optional<ImageButton> opt = this.getMarginButton();
        if (opt.isPresent() && opt.get().m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    public int getFieldWidth() {
        return this.getEntryList().getFieldWidth();
    }

    public int getKeyFieldWidth() {
        return this.getEntryList().getKeyFieldWidth();
    }

    public int getFieldHeight() {
        return 20;
    }

    protected boolean shouldRenderTitle() {
        return !this.isSubEntry() || this.getParentEntry() instanceof BeanListEntry;
    }

    @Override
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        int fieldX;
        super.renderEntry(gg, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        this.entryArea.setBounds(x, y, entryWidth, entryHeight);
        DynamicEntryListWidget<?> parent = this.getEntryList();
        this.rowArea.setBounds(parent.left, this.entryArea.y, parent.right - parent.left, this.getFieldHeight());
        this.selectionCheckbox.m_252865_(parent.left + 2);
        this.selectionCheckbox.m_253211_(y + 12 - 10);
        this.selectionCheckbox.setToggle(this.isSelected());
        if (this.isSelectable() && (this.getScreen().isSelecting() || this.selectionCheckbox.m_5953_(mouseX, this.selectionCheckbox.m_252907_() + 1) && this.getEntryList().getArea().contains(mouseX, mouseY))) {
            this.selectionCheckbox.m_88315_(gg, mouseX, mouseY, delta);
        }
        ResetButton resetButton = this.getResetButton();
        Font font = Minecraft.m_91087_().f_91062_;
        int fieldWidth = this.getFieldWidth();
        int fieldHeight = this.getFieldHeight();
        int n = fieldX = font.m_92718_() ? x : x + entryWidth - fieldWidth;
        if (this.shouldRenderTitle()) {
            Component title = this.getDisplayedTitle();
            float textX = font.m_92718_() ? x + entryWidth - font.m_92852_((FormattedText)title) : x;
            this.renderTitle(gg, title, textX, index, x, y, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        }
        boolean ctrlDown = Screen.m_96637_();
        if ((this.isEditingHotKeyAction() || ctrlDown) && !this.getHotKeyActionTypes().isEmpty()) {
            this.sideButtonReference.setTarget((GuiEventListener)this.hotKeyActionButton);
            int resetButtonOffset = this.hotKeyActionButton.m_5711_() + 2;
            fieldWidth -= resetButtonOffset;
            this.hotKeyActionButton.m_253211_(y);
            this.hotKeyActionButton.m_252865_(font.m_92718_() ? x : x + entryWidth - this.hotKeyActionButton.m_5711_());
            fieldX += font.m_92718_() ? this.hotKeyActionButton.m_5711_() : 0;
            this.hotKeyActionButton.m_88315_(gg, mouseX, mouseY, delta);
        } else if (resetButton != null && !ctrlDown) {
            this.sideButtonReference.setTarget(this.resetButton);
            int resetButtonOffset = resetButton.m_5711_() + 2;
            fieldWidth -= resetButtonOffset;
            resetButton.m_253211_(y);
            resetButton.m_252865_(font.m_92718_() ? x : x + entryWidth - resetButton.m_5711_());
            fieldX += font.m_92718_() ? resetButton.m_5711_() : 0;
            if (this.isDisplayingValue()) {
                resetButton.m_88315_(gg, mouseX, mouseY, delta);
            }
        }
        Optional<ImageButton> opt = this.getMarginButton();
        MultiFunctionImageButton marginButton = this.isPreviewingExternal() ? this.mergeButton : opt.orElse(this.mergeButton);
        marginButton.m_252865_(x + entryWidth + 8);
        marginButton.m_253211_(y);
        if (opt.isPresent()) {
            marginButton.m_88315_(gg, mouseX, mouseY, delta);
        }
        if (this.hasExternalDiff()) {
            if (this.isPreviewingExternal()) {
                int cH = Math.max(0, this.getCaptionHeight());
                int pWidth = this.getPreviewFieldWidth();
                int pX = font.m_92718_() ? x - 36 : x + entryWidth - pWidth - 8;
                this.previewOverlayRectangle.setBounds(pX, y - 32 - 2, pWidth + 44, entryHeight + 32 + 4);
            }
        } else if (this.isPreviewingExternal()) {
            this.setPreviewingExternal(false);
        }
        this.fieldArea.setBounds(fieldX, y, fieldWidth, fieldHeight);
        this.renderField(gg, fieldX, y, fieldWidth, fieldHeight, x, y, entryWidth, entryHeight, index, mouseX, mouseY, delta);
        Rectangle selectionArea = this.getSelectionArea();
        if (selectionArea.contains(mouseX, mouseY) && parent instanceof SimpleConfigScreen.ListWidget) {
            ((SimpleConfigScreen.ListWidget)parent).thisTimeTarget = selectionArea;
        }
    }

    protected Optional<ImageButton> getMarginButton() {
        return this.hasExternalDiff() ? Optional.of(this.mergeButton) : Optional.empty();
    }

    @Override
    public Rectangle getNavigableArea() {
        return this.fieldArea;
    }

    @Override
    @Nullable
    public INavigableTarget getLastSelectedNavigableSubTarget() {
        return this.lastSelectedSubTarget;
    }

    @Override
    public void setLastSelectedNavigableSubTarget(@Nullable INavigableTarget target) {
        this.lastSelectedSubTarget = target;
    }

    protected int getPreviewCaptionOffset() {
        return 20;
    }

    protected boolean isFieldFullWidth() {
        return false;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    protected int getPreviewFieldWidth() {
        return this.isFieldFullWidth() ? this.entryArea.width + 24 : this.getFieldWidth();
    }

    @Override
    public boolean renderOverlay(GuiGraphics gg, Rectangle area, int mouseX, int mouseY, float delta) {
        if (area == this.previewOverlayRectangle) {
            if (!this.isPreviewingExternal()) {
                return false;
            }
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent caption = Component.m_237115_((String)("simpleconfig.ui." + (this.getScreen().isEditingServer() ? "remote_changes" : "external_changes")));
            int captionWidth = font.m_92852_((FormattedText)caption);
            int l = area.x + 4;
            int t = area.y + 32 + 2 - 4;
            int r = area.getMaxX() - 4;
            int b = area.getMaxY() - 4 + 2;
            int cH = this.getPreviewCaptionOffset();
            int cY = t - cH;
            int fW = this.getFieldWidth();
            int cW = Math.min(fW - this.resetButton.m_5711_() - 2, captionWidth + 8) + 8;
            int cX = this.entryArea.getMaxX() - fW - 8 + 4;
            this.previewOverlayCaptionRectangle.setBounds(cX, cY, cW, cH);
            DynamicEntryListWidget<?> entryList = this.getEntryList();
            ScissorsHandler.INSTANCE.pushScissor(entryList.getArea());
            if (cH > 0) {
                gg.m_280509_(l - 2, t - 2, cX, t, this.externalPreviewShadowColor);
                gg.m_280509_(cX + cW, t - 2, r + 2, t, this.externalPreviewShadowColor);
                gg.m_280509_(cX - 2, cY, cX, t - 2, this.externalPreviewShadowColor);
                gg.m_280509_(cX + cW, cY, cX + cW + 2, t - 2, this.externalPreviewShadowColor);
                gg.m_280509_(cX - 2, cY - 2, cX + cW + 2, cY, this.externalPreviewShadowColor);
            } else {
                gg.m_280509_(l - 2, t - 2, r + 2, t, this.externalPreviewShadowColor);
            }
            gg.m_280509_(l - 2, b, r + 2, b + 2, this.externalPreviewShadowColor);
            gg.m_280509_(l - 2, t, l, b, this.externalPreviewShadowColor);
            gg.m_280509_(r, t, r + 2, b, this.externalPreviewShadowColor);
            if (cH > 0) {
                gg.m_280509_(l, t, cX + 2, t + 2, this.externalPreviewBorderColor);
                gg.m_280509_(cX + cW - 2, t, r, t + 2, this.externalPreviewBorderColor);
                gg.m_280509_(cX, cY + 2, cX + 2, t, this.externalPreviewBorderColor);
                gg.m_280509_(cX + cW - 2, cY + 2, cX + cW, t, this.externalPreviewBorderColor);
                gg.m_280509_(cX, cY, cX + cW, cY + 2, this.externalPreviewBorderColor);
            } else {
                gg.m_280509_(l, t, r, t + 2, this.externalPreviewBorderColor);
            }
            gg.m_280509_(l, b - 2, r, b, this.externalPreviewBorderColor);
            gg.m_280509_(l, t + 2, l + 2, b - 2, this.externalPreviewBorderColor);
            gg.m_280509_(r - 2, t + 2, r, b - 2, this.externalPreviewBorderColor);
            gg.m_280509_(l + 2, t + 2, r - 2, t + 4, this.externalPreviewBgColor);
            gg.m_280509_(l + 2, b - 4, r - 2, b - 2, this.externalPreviewBgColor);
            gg.m_280509_(l + 2, t + 4, l + 4, b - 4, this.externalPreviewBgColor);
            gg.m_280509_(r - 32, t + 4, r - 2, b - 4, this.externalPreviewBgColor);
            gg.m_280509_(cX + 2, cY + 2, cX + cW - 2, t + 2, this.externalPreviewBgColor);
            gg.m_280648_(font, (FormattedCharSequence)font.m_92923_((FormattedText)caption, fW - 16).get(0), cX + 6, cY + 8, this.externalPreviewTextColor);
            this.acceptButton.m_252865_(this.resetButton.m_252754_());
            this.acceptButton.m_253211_(this.resetButton.m_252907_());
            this.acceptButton.m_88315_(gg, mouseX, mouseY, delta);
            this.mergeButton.m_88315_(gg, mouseX, mouseY, delta);
            ScissorsHandler.INSTANCE.popScissor();
            return true;
        }
        return false;
    }

    @Override
    public boolean overlayMouseClicked(Rectangle area, double mouseX, double mouseY, int button) {
        if (area != this.previewOverlayRectangle) {
            return IOverlayCapableContainer.IOverlayRenderer.super.overlayMouseClicked(area, mouseX, mouseY, button);
        }
        if (!this.getEntryList().getArea().contains(mouseX, mouseY)) {
            return false;
        }
        if (!this.isPreviewingExternal()) {
            return false;
        }
        if (mouseY < (double)(this.entryArea.y - 4) && !this.previewOverlayCaptionRectangle.contains(mouseX, mouseY)) {
            this.setPreviewingExternal(false);
            return false;
        }
        for (GuiEventListener listener : this.previewListeners) {
            if (!listener.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        this.mergeButton.m_6375_(mouseX, mouseY, button);
        return true;
    }

    @Override
    public void overlayMouseClickedOutside(Rectangle area, double mouseX, double mouseY, int button) {
        IOverlayCapableContainer.IOverlayRenderer.super.overlayMouseClickedOutside(area, mouseX, mouseY, button);
        if (area == this.previewOverlayRectangle && this.isPreviewingExternal()) {
            this.setPreviewingExternal(false);
        }
    }

    @Override
    public void renderBg(GuiGraphics gg, int index, int x, int y, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (this.isPreviewingExternal()) {
            gg.m_280509_(this.previewOverlayRectangle.x + 8, this.previewOverlayRectangle.y + 32 + 2, this.previewOverlayRectangle.getMaxX() - 36, this.previewOverlayRectangle.getMaxY() - 4 + 2, this.externalPreviewBgColor);
        }
        super.renderBg(gg, index, x, y, w, h, mouseX, mouseY, isHovered, delta);
    }

    protected void renderField(GuiGraphics gg, int fieldX, int fieldY, int fieldWidth, int fieldHeight, int x, int y, int entryWidth, int entryHeight, int index, int mouseX, int mouseY, float delta) {
        if (this instanceof IChildListEntry) {
            ((IChildListEntry)((Object)this)).renderChild(gg, fieldX, fieldY, fieldWidth, fieldHeight, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void renderSelectionOverlay(GuiGraphics gg, int index, int y, int x, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        Rectangle area = this.getSelectionArea();
        gg.m_280509_(area.x, area.y - 2, area.getMaxX(), area.getMaxY() + 2, this.selectionColor);
    }

    protected void renderTitle(GuiGraphics gg, Component title, float textX, int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        boolean hoveredTitle;
        Font font = Minecraft.m_91087_().f_91062_;
        NavigableSet<EntryTag> entryFlags = this.getEntryTags();
        int flagsW = 14 * entryFlags.size();
        int textW = entryWidth - this.getFieldWidth() - flagsW - 4;
        boolean bl = hoveredTitle = mouseY >= y + 4 && mouseY < y + 16 && (float)mouseX > textX && (float)mouseX < textX + (float)textW;
        if (hoveredTitle) {
            textW = font.m_92852_((FormattedText)title);
        }
        MutableComponent text = SimpleConfigTextUtil.subText(title, 0, font.m_92854_((FormattedText)title, textW).getString().length());
        gg.m_280430_(font, (Component)text, (int)textX, y + 6, this.getPreferredTextColor());
        if (!entryFlags.isEmpty()) {
            int flagsX;
            int tW = font.m_92852_((FormattedText)text);
            if (font.m_92718_()) {
                flagsX = (int)textX - tW - 4 - flagsW;
                if (!hoveredTitle) {
                    flagsX = Math.max(flagsX, x + this.getFieldWidth() + flagsW + 2);
                }
            } else {
                flagsX = (int)textX + tW + 4;
                if (!hoveredTitle) {
                    flagsX = Math.min(flagsX, x + entryWidth - this.getFieldWidth() - flagsW - 2);
                }
            }
            Objects.requireNonNull(font);
            int flagsY = y + 6 + 9 / 2 - 7;
            this.flagsRectangle.setBounds(flagsX, flagsY, flagsW, 14);
            int xx = flagsX;
            for (EntryTag entryFlag : font.m_92718_() ? entryFlags.descendingSet() : entryFlags) {
                entryFlag.getIcon().renderCentered(gg, xx, flagsY, 14, 14);
                xx += 14;
            }
        }
    }

    protected boolean isMouseOverFlags(int mouseX, int mouseY) {
        return this.flagsRectangle.contains(mouseX, mouseY);
    }

    public boolean isMouseOverRow(double mouseX, double mouseY) {
        return this.rowArea.contains(mouseX, mouseY);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.entryArea.contains(mouseX, mouseY);
    }

    @Override
    public int getScrollY() {
        DynamicEntryListWidget<?> entryList = this.getEntryList();
        return (int)Math.round((double)(this.entryArea.y - entryList.top) + entryList.getScroll());
    }

    @NotNull
    public final List<? extends GuiEventListener> m_6702_() {
        if (this.isPreviewingExternal()) {
            return this.previewListeners;
        }
        return this.getEntryListeners();
    }

    @NotNull
    protected abstract List<? extends GuiEventListener> getEntryListeners();

    public record EntryPath(@NotNull AbstractConfigListEntry<?> entry, @NotNull ComponentPath childPath) implements ComponentPath
    {
        public static EntryPath entryPath(@NotNull AbstractConfigListEntry<?> entry, @NotNull ComponentPath childPath) {
            return new EntryPath(entry, childPath);
        }

        @NotNull
        public GuiEventListener m_264222_() {
            return this.entry;
        }

        public void m_264432_(boolean focused) {
            if (focused) {
                if (!(this.childPath.m_264222_() instanceof AbstractConfigListEntry)) {
                    this.entry.navigate();
                    ComponentPath curr = this.entry.m_264435_();
                    if (curr != null) {
                        curr.m_264432_(false);
                    }
                } else {
                    this.entry.m_93692_(true);
                }
                this.entry.m_7522_(this.childPath.m_264222_());
            } else {
                this.entry.m_93692_(false);
            }
            this.childPath.m_264432_(focused);
        }
    }

    public record EntryLeafPath(@NotNull AbstractConfigListEntry<?> entry) implements ComponentPath
    {
        public static EntryLeafPath entryLeaf(@NotNull AbstractConfigListEntry<?> entry) {
            return new EntryLeafPath(entry);
        }

        @NotNull
        public GuiEventListener m_264222_() {
            return this.entry;
        }

        public void m_264432_(boolean focused) {
            if (focused) {
                this.entry.navigate();
            } else {
                this.entry.m_93692_(false);
            }
        }
    }
}

