/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.ui.api;

import com.google.common.collect.Lists;
import com.ibm.icu.impl.Pair;
import endorh.simpleconfig.SimpleConfigMod;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.ui.api.ConfigCategory;
import endorh.simpleconfig.ui.api.EntryError;
import endorh.simpleconfig.ui.api.IEntryHolder;
import endorh.simpleconfig.ui.api.IExpandable;
import endorh.simpleconfig.ui.api.INavigableTarget;
import endorh.simpleconfig.ui.api.RedirectGuiEventListener;
import endorh.simpleconfig.ui.api.Tooltip;
import endorh.simpleconfig.ui.gui.AbstractConfigScreen;
import endorh.simpleconfig.ui.gui.entries.BaseListEntry;
import endorh.simpleconfig.ui.gui.widget.DynamicElementListWidget;
import endorh.simpleconfig.ui.gui.widget.DynamicEntryListWidget;
import endorh.simpleconfig.ui.gui.widget.HotKeyActionButton;
import endorh.simpleconfig.ui.gui.widget.ResetButton;
import endorh.simpleconfig.ui.hotkey.HotKeyAction;
import endorh.simpleconfig.ui.hotkey.HotKeyActionType;
import endorh.simpleconfig.ui.hotkey.HotKeyActionTypes;
import endorh.simpleconfig.ui.hotkey.SimpleHotKeyActionType;
import endorh.simpleconfig.ui.impl.ISeekableComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigField<T>
extends DynamicElementListWidget.ElementEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private AbstractConfigScreen screen = null;
    @Nullable
    private DynamicEntryListWidget<?> entryList = null;
    @Nullable
    private AbstractConfigField<?> parentEntry = null;
    private T value;
    @Nullable
    private T original = null;
    @Nullable
    private T defValue = null;
    @Nullable
    private T external = null;
    private boolean isEdited = false;
    private List<EntryError> errors = Collections.emptyList();
    private boolean hasError;
    private boolean updatedValue = false;
    @NotNull
    private Supplier<T> defaultSupplier = () -> null;
    @Nullable
    private Supplier<Optional<Component>> errorSupplier = null;
    @Nullable
    private Consumer<T> saveConsumer = null;
    private boolean isSubEntry = false;
    private boolean isChildSubEntry = false;
    private boolean ignoreEdits = false;
    private boolean editable = true;
    private boolean previewingExternal = false;
    private boolean editingHotKeyAction = false;
    private boolean requiresRestart;
    private Supplier<Boolean> editableSupplier;
    private ConfigCategory category = null;
    private String name = "";
    private Component title;
    private final NavigableSet<EntryTag> entryTags = new TreeSet<EntryTag>();
    protected String matchedText = null;
    protected String matchedValueText = null;
    private boolean focusedMatch = false;
    private boolean isFocused = false;
    private boolean isSelected = false;
    protected long lastFocusHighlightTime;
    protected int focusHighlightLength;
    protected int focusHighlightColor;
    protected int matchColor = 0x42FFFF42;
    protected int focusedMatchColor = -2130723518;
    protected int selectionColor = 1082167536;
    protected RedirectGuiEventListener sideButtonReference;
    protected ResetButton resetButton;
    protected HotKeyActionButton<T> hotKeyActionButton;
    @Nullable
    private INavigableTarget navigableParent = null;
    protected List<HotKeyActionType<T, ?>> hotKeyActionTypes;
    private HotKeyActionType<T, ?> hotKeyActionType;
    private HotKeyAction<T> prevHotKeyAction = null;
    @Nullable
    protected AbstractConfigEntry<?, ?, T> configEntry = null;
    private static final Pattern STYLE_ESCAPE = Pattern.compile("\u00a7[\\da-f]");

    public AbstractConfigField(Component title) {
        this.title = title;
        this.resetButton = new ResetButton(this);
        this.hotKeyActionButton = new HotKeyActionButton(this);
        this.sideButtonReference = new RedirectGuiEventListener(this.resetButton);
        this.hotKeyActionTypes = Lists.newArrayList((Object[])new HotKeyActionType[]{HotKeyActionTypes.ASSIGN.cast()});
    }

    public String getPath() {
        return this.getCategory().getType().getAlias() + "." + this.getRelPath();
    }

    public String getRelPath() {
        if (this.parentEntry != null) {
            return this.getCategory().getName() + "." + this.parentEntry.providePath(this);
        }
        return this.getCategory().getName() + "." + this.getName();
    }

    public String getCatPath() {
        if (this.parentEntry != null) {
            return this.parentEntry.providePath(this);
        }
        return this.getName();
    }

    public String providePath(AbstractConfigField<?> child) {
        return this.getCatPath() + "." + child.getName();
    }

    public ConfigCategory getCategory() {
        if (this.category != null) {
            return this.category;
        }
        if (this.parentEntry != null) {
            return this.parentEntry.getCategory();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategory(ConfigCategory category) {
        this.category = category;
    }

    public boolean isSubEntry() {
        return this.isSubEntry || this.parentEntry != null && this.parentEntry.isSubEntry();
    }

    public void setSubEntry(boolean isSubEntry) {
        this.isSubEntry = isSubEntry;
        if (!isSubEntry) {
            this.setChildSubEntry(false);
        }
    }

    public boolean isChildSubEntry() {
        return this.isChildSubEntry;
    }

    public void setChildSubEntry(boolean childSubEntry) {
        this.isChildSubEntry = childSubEntry;
        if (childSubEntry) {
            this.setSubEntry(true);
        }
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
    }

    public NavigableSet<EntryTag> getEntryTags() {
        return this.entryTags;
    }

    public void addTag(EntryTag flag) {
        this.getEntryTags().add(flag);
    }

    public void removeTag(EntryTag flag) {
        this.getEntryTags().remove(flag);
    }

    public boolean m_93696_() {
        return this.isFocused;
    }

    public void m_93692_(boolean focused) {
        this.isFocused = focused;
    }

    public boolean isSelectable() {
        return this.getScreen().canSelectEntries() && !this.isSubEntry();
    }

    public boolean isSelected() {
        return this.isSelectable() && this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        if (!this.isSelectable()) {
            return;
        }
        this.isSelected = isSelected;
        this.getScreen().updateSelection();
    }

    public boolean shouldShowChildren() {
        AbstractConfigField<?> parent = this.getParentEntry();
        return !this.isSubEntry() && this.matchesSearch() || parent != null && parent.shouldShowChildren();
    }

    @Nullable
    public AbstractConfigField<?> getParentEntry() {
        return this.parentEntry;
    }

    public void setParentEntry(@Nullable AbstractConfigField<?> parentEntry) {
        this.parentEntry = parentEntry;
    }

    @Nullable
    public BaseListEntry<?, ?, ?> getListParent() {
        return this.parentEntry instanceof BaseListEntry ? (BaseListEntry<?, ?, ?>)this.parentEntry : (this.parentEntry != null ? this.parentEntry.getListParent() : null);
    }

    @Nullable
    public IExpandable getExpandableParent() {
        return this.parentEntry instanceof IExpandable ? (IExpandable)((Object)this.parentEntry) : (this.parentEntry != null ? this.parentEntry.getExpandableParent() : null);
    }

    @ApiStatus.Internal
    protected void doExpandParents(AbstractConfigField<?> entry) {
        IExpandable parent = this.getExpandableParent();
        if (this instanceof IExpandable) {
            ((IExpandable)((Object)this)).setExpanded(true);
        }
        if (parent instanceof AbstractConfigField) {
            ((AbstractConfigField)((Object)parent)).doExpandParents(entry);
        } else if (parent != null) {
            parent.setExpanded(true);
        }
    }

    @Override
    public void expandParents() {
        IExpandable parent = this.getExpandableParent();
        if (parent != null) {
            if (parent instanceof AbstractConfigField) {
                ((AbstractConfigField)((Object)parent)).doExpandParents(this);
            } else {
                parent.setExpanded(true);
            }
        }
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public Component getDisplayedTitle() {
        String title;
        int i;
        boolean hasError = this.hasError();
        boolean isEdited = this.isEdited();
        MutableComponent text = this.getTitle().m_6881_();
        if (this.matchedText != null && !this.matchedText.isEmpty() && (i = (title = AbstractConfigField.getUnformattedString(this.getTitle())).indexOf(this.matchedText)) != -1) {
            text = Component.m_237113_((String)title.substring(0, i)).m_7220_((Component)Component.m_237113_((String)title.substring(i, i + this.matchedText.length())).m_130940_(this.isFocusedMatch() ? ChatFormatting.GOLD : ChatFormatting.YELLOW).m_130940_(ChatFormatting.UNDERLINE)).m_130946_(title.substring(i + this.matchedText.length()));
        }
        if (hasError) {
            text.m_130940_(ChatFormatting.RED);
        }
        if (this.isEditingHotKeyAction()) {
            if (this.getHotKeyActionType() == null) {
                text.m_130940_(ChatFormatting.GRAY);
            }
        } else {
            if (isEdited) {
                text.m_130940_(ChatFormatting.ITALIC);
            }
            if (!hasError && !isEdited) {
                text.m_130940_(ChatFormatting.GRAY);
            }
        }
        return text;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setValueTransparently(T value) {
        this.runTransparentAction(() -> {
            this.setValue(value);
            if (this.isDisplayingValue()) {
                this.setDisplayedValue(value);
            }
        });
    }

    public void setDisplayedValueTransparently(T value) {
        this.runTransparentAction(() -> {
            if (this.isDisplayingValue()) {
                this.setDisplayedValue(value);
            }
        });
    }

    public T getDisplayedValue() {
        return this.getValue();
    }

    public void setDisplayedValue(T value) {
    }

    @Nullable
    public T getOriginal() {
        return this.original;
    }

    public void setOriginal(@Nullable T original) {
        this.original = original;
    }

    @Nullable
    public T getExternalValue() {
        return this.external;
    }

    public void setExternalValue(@Nullable T value) {
        this.external = value;
    }

    public void resetValue() {
        this.setValueTransparently(this.getDefaultValue());
    }

    public void restoreValue() {
        this.setValueTransparently(this.getOriginal());
    }

    public void acceptExternalValue() {
        if (this.hasExternalDiff() && !this.hasAcceptedExternalDiff()) {
            if (this.isPreviewingExternal()) {
                this.setPreviewingExternal(false);
            }
            this.setValueTransparently(this.getExternalValue());
        }
    }

    public void restoreHistoryValue(Object storedValue) {
        try {
            this.setValue(storedValue);
            if (this.isDisplayingValue()) {
                this.setDisplayedValue(storedValue);
            }
            this.applyFocusHighlight(INavigableTarget.HighlightColors.HISTORY);
        }
        catch (RuntimeException e) {
            this.applyFocusHighlight(INavigableTarget.HighlightColors.ERROR);
            LOGGER.warn("Could not revert value of config entry with path " + this.getPath() + ": " + e.getMessage());
        }
    }

    public boolean isPreviewingExternal() {
        return this.previewingExternal;
    }

    public void setPreviewingExternal(boolean previewing) {
        if (!this.hasExternalDiff()) {
            previewing = false;
        }
        if (previewing == this.previewingExternal) {
            return;
        }
        T value = this.getValue();
        T external = this.getExternalValue();
        if (previewing) {
            this.previewingExternal = true;
            this.setDisplayedValue(external);
            if (this instanceof IExpandable) {
                ((IExpandable)((Object)this)).setExpanded(true, true);
            }
            this.m_7522_(null);
        } else {
            this.setDisplayedValue(value);
            this.previewingExternal = false;
        }
    }

    public boolean isEditingHotKeyAction() {
        return this.getScreen().isEditingConfigHotKey();
    }

    public void setEditingHotKeyAction(boolean editing) {
        if (editing == this.editingHotKeyAction) {
            return;
        }
        if (!editing) {
            this.setDisplayedValue(this.getValue());
        }
        this.editingHotKeyAction = editing;
    }

    public boolean isDisplayingValue() {
        return !this.isPreviewingExternal() && !this.isEditingHotKeyAction();
    }

    @Override
    public final boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isShown()) {
            return false;
        }
        if (this.handleModalClicks(mouseX, mouseY, button)) {
            return true;
        }
        return this.onMouseClicked(mouseX, mouseY, button);
    }

    public boolean handleModalClicks(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public final boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.isShown()) {
            return false;
        }
        if (this.handleModalKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.onKeyPressed(keyCode, scanCode, modifiers);
    }

    public boolean handleModalKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void updateValue(boolean force) {
        if (this.updatedValue && !force) {
            return;
        }
        if (this.isPreviewingExternal()) {
            this.setDisplayedValue(this.getExternalValue());
        } else if (!this.isEditingHotKeyAction() && this.isEditable()) {
            this.setValue(this.getDisplayedValue());
        }
        this.updatedValue = true;
    }

    public void runTransparentAction(Runnable action) {
        this.preserveState();
        action.run();
    }

    @Nullable
    public ResetButton getResetButton() {
        return this.resetButton;
    }

    @Override
    public void applyFocusHighlight(int color, int length) {
        this.lastFocusHighlightTime = System.currentTimeMillis();
        this.focusHighlightColor = color;
        this.focusHighlightLength = length;
    }

    @ApiStatus.Internal
    public Optional<Component> getErrorMessage() {
        return Optional.empty();
    }

    public List<EntryError> getErrors() {
        return this.errors;
    }

    protected List<EntryError> computeErrors() {
        if (this.isEditingHotKeyAction()) {
            HotKeyActionType<T, ?> type = this.getHotKeyActionType();
            return type == null ? new ArrayList() : this.getHotKeyActionErrors(type);
        }
        return this.getEntryErrors();
    }

    public List<EntryError> getEntryErrors() {
        ArrayList<EntryError> errors = new ArrayList<EntryError>();
        if (this.errorSupplier != null) {
            this.errorSupplier.get().ifPresent(e -> errors.add(EntryError.of(e, this)));
        }
        if (errors.isEmpty()) {
            this.getErrorMessage().ifPresent(e -> errors.add(EntryError.of(e, this)));
        }
        return errors;
    }

    public boolean hasError() {
        return this.hasError;
    }

    protected boolean computeHasError() {
        return !this.getErrors().isEmpty() || this instanceof IEntryHolder && ((IEntryHolder)((Object)this)).getHeldEntries().stream().anyMatch(AbstractConfigField::hasError);
    }

    public void setErrorSupplier(@Nullable Supplier<Optional<Component>> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Nullable
    public Supplier<Optional<Component>> getErrorSupplier() {
        return this.errorSupplier;
    }

    @Nullable
    public T getDefaultValue() {
        if (this.defValue != null) {
            return this.defValue;
        }
        this.defValue = this.defaultSupplier.get();
        return this.defValue;
    }

    public void setDefaultValue(Supplier<T> defaultSupplier) {
        this.defaultSupplier = defaultSupplier;
        this.defValue = null;
    }

    public void setSaveConsumer(@Nullable Consumer<T> saveConsumer) {
        this.saveConsumer = saveConsumer;
    }

    @Nullable
    public Consumer<T> getSaveConsumer() {
        return this.saveConsumer;
    }

    public boolean isIgnoreEdits() {
        return this.ignoreEdits;
    }

    public void setIgnoreEdits(boolean ignoreEdits) {
        this.ignoreEdits = ignoreEdits;
    }

    @NotNull
    public final AbstractConfigScreen getScreen() {
        AbstractConfigScreen screen = this.screen;
        if (screen != null) {
            return screen;
        }
        AbstractConfigField<?> parent = this.getParentEntry();
        if (parent != null) {
            screen = parent.getScreen();
        }
        if (screen == null) {
            throw new IllegalStateException("Cannot get config screen so early!");
        }
        return screen;
    }

    protected final void addTooltip(@NotNull Tooltip tooltip) {
        this.getScreen().addTooltip(tooltip);
    }

    @ApiStatus.Internal
    public boolean preserveState() {
        this.updateValue(true);
        this.getScreen().getHistory().preserveState(this);
        return true;
    }

    public void updateFocused(boolean isFocused) {
        if (!(!isFocused || this.m_93696_() || this instanceof IEntryHolder && ((IEntryHolder)((Object)this)).getHeldEntries().contains(this.m_7222_()))) {
            this.preserveState();
        }
        this.m_93692_(isFocused);
        if (!isFocused) {
            GuiEventListener listener = this.m_7222_();
            if (listener != null && listener.m_93696_()) {
                listener.m_93692_(false);
            }
            this.m_7522_(null);
        }
    }

    @ApiStatus.Internal
    public void setScreen(@Nullable AbstractConfigScreen screen) {
        this.screen = screen;
    }

    public boolean isEditable() {
        if (this.isEditingHotKeyAction()) {
            return this.getScreen().isEditable() && (this.isSubEntry() ? this.parentEntry != null && this.parentEntry.isEditable() : this.getHotKeyActionType() != null);
        }
        return this.getScreen().isEditable() && this.editable && (this.parentEntry == null || this.parentEntry.isEditable()) && !this.isPreviewingExternal();
    }

    public boolean shouldRenderEditable() {
        return this.isEditable() || this.isPreviewingExternal();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setEditableSupplier(Supplier<Boolean> editableSupplier) {
        this.editableSupplier = editableSupplier;
    }

    @Nullable
    public Supplier<Boolean> getEditableSupplier() {
        return this.editableSupplier;
    }

    public void save() {
        this.setPreviewingExternal(false);
        this.updateValue(true);
        Consumer<T> saveConsumer = this.getSaveConsumer();
        if (!this.isIgnoreEdits() && !this.isSubEntry() && saveConsumer != null && this.isEditable() && !this.hasError()) {
            saveConsumer.accept(this.getValue());
        }
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    protected boolean computeIsEdited() {
        if (this.isIgnoreEdits() || this.isSubEntry() && !this.isEditable()) {
            return false;
        }
        if (this.isEditingHotKeyAction()) {
            HotKeyActionType<T, ?> type = this.getHotKeyActionType();
            HotKeyAction<T> prev = this.prevHotKeyAction;
            if (prev == null) {
                return type != null;
            }
            if (prev.getType() != type) {
                return true;
            }
            return !prev.equals(this.createHotKeyAction());
        }
        return this.hasError() || !this.areEqual(this.getValue(), this.getOriginal());
    }

    public boolean isResettable() {
        if (!this.isEditable()) {
            return false;
        }
        return this.hasError() || !this.areEqual(this.getValue(), this.getDefaultValue());
    }

    public boolean isRestorable() {
        if (!this.isEditable()) {
            return false;
        }
        return this.hasError() || !this.areEqual(this.getValue(), this.getOriginal());
    }

    public boolean isGroup() {
        return this instanceof IEntryHolder;
    }

    public boolean canResetGroup() {
        return this.isGroup() && this.isResettable();
    }

    public boolean canRestoreGroup() {
        return this.isGroup() && this.isRestorable();
    }

    public boolean hasExternalDiff() {
        if (this.isSubEntry()) {
            return false;
        }
        T external = this.getExternalValue();
        return external != null && !this.areEqual(this.getOriginal(), external);
    }

    public boolean hasAcceptedExternalDiff() {
        if (this.isSubEntry()) {
            return false;
        }
        T external = this.getExternalValue();
        return external != null && this.areEqual(this.getValue(), external);
    }

    public boolean hasConflictingExternalDiff() {
        return this.hasExternalDiff() && !this.hasAcceptedExternalDiff();
    }

    public boolean areEqual(T value, T other) {
        return Objects.equals(value, other);
    }

    @Override
    public int getItemHeight() {
        return 24;
    }

    @Override
    public void tick() {
        Boolean editable;
        super.tick();
        if (!this.isShown() && this.m_93696_()) {
            this.updateFocused(false);
        }
        this.updateValue(false);
        Supplier<Boolean> editableSupplier = this.getEditableSupplier();
        if (editableSupplier != null && (editable = editableSupplier.get()) != null) {
            this.setEditable(editable);
        }
        if (this instanceof IEntryHolder) {
            ((IEntryHolder)((Object)this)).getHeldEntries().forEach(AbstractConfigField::tick);
        }
        if (this.isEditingHotKeyAction()) {
            this.hotKeyActionButton.tick();
        }
        this.errors = this.computeErrors();
        this.hasError = this.computeHasError();
        this.isEdited = this.computeIsEdited();
        this.resetButton.tick();
        this.updatedValue = false;
    }

    @Override
    public void render(GuiGraphics gg, int index, int x, int y, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.renderBg(gg, index, x, y, w, h, mouseX, mouseY, isHovered, delta);
        this.renderEntry(gg, index, x, y, w, h, mouseX, mouseY, isHovered, delta);
        this.renderEntryOverlay(gg, index, x, y, w, h, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public DynamicEntryListWidget<?> getEntryList() {
        DynamicEntryListWidget<?> entryList = this.entryList;
        if (entryList != null) {
            return entryList;
        }
        AbstractConfigField<?> parent = this.getParentEntry();
        try {
            if (parent != null) {
                entryList = parent.getEntryList();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (entryList == null) {
            throw new IllegalStateException("Tried to get parent of orphan config entry of type " + this.getClass().getSimpleName() + "\nThis entry hasn't been properly initialized");
        }
        return entryList;
    }

    @Override
    public void setEntryList(@Nullable DynamicEntryListWidget<?> parent) {
        this.entryList = parent;
    }

    public void renderBg(GuiGraphics gg, int index, int x, int y, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        long t;
        AbstractConfigScreen screen = this.getScreen();
        if (this.matchesSearch() && !screen.getSearchBar().isFilter()) {
            gg.m_280509_(0, y, screen.f_96543_, y + this.getCaptionHeight(), this.isFocusedMatch() ? this.focusedMatchColor : this.matchColor);
        }
        if ((t = System.currentTimeMillis() - this.lastFocusHighlightTime - (long)this.focusHighlightLength) < 1000L) {
            int color = this.focusHighlightColor;
            gg.m_280509_(0, y, screen.f_96543_, y + this.getCaptionHeight(), color & 0xFFFFFF | (int)((double)(color >> 24 & 0xFF) * ((double)Math.min(1000L, 1000L - t) / 1000.0)) << 24);
        }
    }

    @ApiStatus.Internal
    public void renderEntry(GuiGraphics gg, int index, int x, int y, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
    }

    public void renderEntryOverlay(GuiGraphics gg, int index, int x, int y, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (this.isSelected()) {
            this.renderSelectionOverlay(gg, index, y, x, w, h, mouseX, mouseY, isHovered, delta);
        }
    }

    protected void renderSelectionOverlay(GuiGraphics gg, int index, int y, int x, int w, int h, int mouseX, int mouseY, boolean isHovered, float delta) {
        gg.m_280509_(2, y - 2, x + w, y + h - 2, this.selectionColor);
    }

    @Override
    public void claimFocus() {
        this.getScreen().setSelectedCategory(this.getCategory());
        this.updateFocused(true);
        ArrayList parents = Lists.newArrayList();
        parents.add(this);
        for (AbstractConfigField<?> parent = this.getParentEntry(); parent != null; parent = parent.getParentEntry()) {
            parents.add(parent);
        }
        AbstractConfigField p = (AbstractConfigField)parents.get(parents.size() - 1);
        this.getEntryList().m_7522_((GuiEventListener)p);
        for (int i = parents.size() - 2; i >= 0; --i) {
            AbstractConfigField n = (AbstractConfigField)parents.get(i);
            p.m_7522_((GuiEventListener)n);
            p = n;
        }
        this.getEntryList().scrollTo(this);
        this.acquireFocus();
        this.getEntryList().setSelectedTarget(this);
    }

    protected static void playFeedbackTap(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SimpleConfigMod.UI_TAP, (float)volume));
    }

    protected static void playFeedbackClick(float volume) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)volume));
    }

    protected boolean matchesSearch() {
        return this.matchedText != null && !this.matchedText.isEmpty();
    }

    @Override
    public List<ISeekableComponent> search(Pattern query) {
        boolean matchesSelf = this.searchSelf(query);
        List<Pair> children = this.seekableChildren().stream().map(c -> Pair.of((Object)c, c.search(query))).filter(p -> !((List)p.second).isEmpty()).toList();
        List<ISeekableComponent> result = children.stream().flatMap(p -> ((List)p.second).stream()).collect(Collectors.toList());
        if (matchesSelf) {
            result.add(0, this);
        }
        return result;
    }

    protected boolean searchSelf(Pattern query) {
        String valueText;
        boolean matches = false;
        String text = this.seekableText();
        this.matchedValueText = null;
        this.matchedText = null;
        if (!text.isEmpty()) {
            Matcher m = query.matcher(text);
            while (m.find()) {
                if (m.group().isEmpty()) continue;
                matches = true;
                this.matchedText = m.group();
                break;
            }
        }
        if (!(valueText = this.seekableValueText()).isEmpty()) {
            Matcher m = query.matcher(valueText);
            while (m.find()) {
                if (m.group().isEmpty()) continue;
                matches = true;
                this.matchedValueText = m.group();
                break;
            }
        }
        return matches;
    }

    @ApiStatus.Internal
    public String seekableText() {
        if (this.isSubEntry()) {
            return "";
        }
        return AbstractConfigField.getUnformattedString(this.getDisplayedTitle());
    }

    @ApiStatus.Internal
    public String seekableValueText() {
        T value = this.getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected List<ISeekableComponent> seekableChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isFocusedMatch() {
        return this.focusedMatch;
    }

    @Override
    public void setFocusedMatch(boolean isFocusedMatch) {
        this.focusedMatch = isFocusedMatch;
        this.expandParents();
        this.claimFocus();
    }

    @Override
    @Nullable
    public INavigableTarget getNavigableParent() {
        return this.navigableParent != null ? this.navigableParent : this.getParentEntry();
    }

    @Override
    public boolean isNavigable() {
        return this.isShown();
    }

    @Override
    public boolean isNavigableSubTarget() {
        return this.isSubEntry;
    }

    public void setNavigableParent(@Nullable INavigableTarget parent) {
        this.navigableParent = parent;
    }

    @Override
    public void navigate() {
        if (this.getCategory().isLoaded()) {
            this.expandParents();
            this.claimFocus();
        }
    }

    protected void acquireFocus() {
        List listeners = this.m_6702_();
        if (!listeners.isEmpty()) {
            GuiEventListener listener = (GuiEventListener)listeners.get(0);
            this.m_7522_(listener);
            listener.m_93692_(true);
        }
    }

    protected static String getUnformattedString(Component component) {
        return STYLE_ESCAPE.matcher(component.getString()).replaceAll("");
    }

    protected static void drawBorder(GuiGraphics gg, int x, int y, int w, int h, int borderWidth, int color) {
        int maxX = x + w;
        int maxY = y + h;
        int bw = Math.min(Math.min(borderWidth, w), h);
        gg.m_280509_(x, y, maxX, y + bw, color);
        gg.m_280509_(x, y + bw, x + bw, maxY - bw, color);
        gg.m_280509_(maxX - bw, y + bw, maxX, maxY - bw, color);
        gg.m_280509_(x, maxY - bw, maxX, maxY, color);
    }

    public HotKeyActionButton<T> getHotKeyActionTypeButton() {
        return this.hotKeyActionButton;
    }

    public List<HotKeyActionType<T, ?>> getHotKeyActionTypes() {
        return this.isSubEntry() ? (this.parentEntry == null ? Collections.emptyList() : this.parentEntry.getSubHotKeyActionTypes(this.hotKeyActionTypes)) : this.hotKeyActionTypes;
    }

    public HotKeyActionType<T, ?> getHotKeyActionType() {
        return this.hotKeyActionType;
    }

    public void setHotKeyActionType(HotKeyActionType<T, ?> type) {
        this.hotKeyActionType = type;
    }

    public void setHotKeyActionType(HotKeyActionType<T, ?> type, @Nullable HotKeyAction<T> prev) {
        this.setHotKeyActionType(type);
        this.setPrevHotKeyAction(prev);
        if (prev instanceof SimpleHotKeyActionType.SimpleHotKeyAction) {
            this.setHotKeyActionValue(((SimpleHotKeyActionType.SimpleHotKeyAction)prev).getStorage());
        }
    }

    @Nullable
    protected HotKeyAction<T> getPrevHotKeyAction() {
        return this.prevHotKeyAction;
    }

    private void setPrevHotKeyAction(@Nullable HotKeyAction<T> prev) {
        this.prevHotKeyAction = prev;
    }

    @Nullable
    protected AbstractConfigEntry<?, ?, T> getConfigEntry() {
        String path;
        SimpleConfigImpl config;
        if (this.configEntry != null) {
            return this.configEntry;
        }
        AbstractConfigScreen screen = this.getScreen();
        String modId = screen.getModId();
        ConfigCategory category = this.getCategory();
        if (category == null) {
            return null;
        }
        SimpleConfig.Type type = category.getType().getType();
        if (SimpleConfigImpl.hasConfig(modId, type) && (config = SimpleConfigImpl.getConfig(modId, type)).hasEntry(path = this.getRelPath())) {
            this.configEntry = config.getEntry(path);
            return this.configEntry;
        }
        return null;
    }

    @Nullable
    public HotKeyAction<T> createHotKeyAction() {
        return this.createHotKeyAction(this.getConfigEntry());
    }

    @Nullable
    public HotKeyAction<T> createHotKeyAction(AbstractConfigEntry<?, ?, T> entry) {
        HotKeyActionType<T, ?> type = this.getHotKeyActionType();
        return type != null && entry != null ? (HotKeyAction<T>)type.create(entry, this.getHotKeyActionValue()) : null;
    }

    public <V> List<HotKeyActionType<V, ?>> getSubHotKeyActionTypes(List<HotKeyActionType<V, ?>> types) {
        return Collections.emptyList();
    }

    public Object getHotKeyActionValue() {
        return this.getDisplayedValue();
    }

    public void setHotKeyActionValue(Object value) {
        T prev = this.getDisplayedValue();
        if (value != null) {
            try {
                this.setDisplayedValue(value);
            }
            catch (ClassCastException e) {
                this.setDisplayedValue(prev);
            }
        }
    }

    public List<EntryError> getHotKeyActionErrors(HotKeyActionType<T, ?> type) {
        AbstractConfigEntry<?, ?, T> entry;
        ArrayList<EntryError> errors = new ArrayList<EntryError>();
        if (type instanceof HotKeyActionTypes.AssignHotKeyActionType) {
            errors.addAll(this.getEntryErrors());
        }
        if ((entry = this.getConfigEntry()) != null) {
            type.getActionError(entry, this.getHotKeyActionValue()).map(m -> EntryError.of(m, this)).ifPresent(errors::add);
        }
        return errors;
    }
}

