/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.shadowed.org.antlr.v4.codegen;

import endorh.simpleconfig.shadowed.org.antlr.v4.Tool;
import endorh.simpleconfig.shadowed.org.antlr.v4.codegen.OutputModelController;
import endorh.simpleconfig.shadowed.org.antlr.v4.codegen.OutputModelWalker;
import endorh.simpleconfig.shadowed.org.antlr.v4.codegen.ParserFactory;
import endorh.simpleconfig.shadowed.org.antlr.v4.codegen.Target;
import endorh.simpleconfig.shadowed.org.antlr.v4.codegen.model.OutputModelObject;
import endorh.simpleconfig.shadowed.org.antlr.v4.tool.ErrorType;
import endorh.simpleconfig.shadowed.org.antlr.v4.tool.Grammar;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;

public class CodeGenerator {
    public static final String TEMPLATE_ROOT = "endorh/simpleconfig/shadowed/org/antlr/v4/tool/templates/codegen";
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    public static final String DEFAULT_LANGUAGE = "Java";
    public static final String vocabFilePattern = "<tokens.keys:{t | <t>=<tokens.(t)>\n}><literals.keys:{t | <t>=<literals.(t)>\n}>";
    public final Grammar g;
    public final Tool tool;
    public final String language;
    private Target target;
    public int lineWidth = 72;

    private CodeGenerator(String language) {
        this.g = null;
        this.tool = null;
        this.language = language;
    }

    public CodeGenerator(Grammar g) {
        this(g.tool, g, g.getOptionString("language"));
    }

    public CodeGenerator(Tool tool, Grammar g, String language) {
        this.g = g;
        this.tool = tool;
        this.language = language != null ? language : DEFAULT_LANGUAGE;
    }

    public static boolean targetExists(String language) {
        String targetName = "endorh.simpleconfig.shadowed.org.antlr.v4.codegen.target." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            Constructor<Target> ctor = c.getConstructor(CodeGenerator.class);
            CodeGenerator gen = new CodeGenerator(language);
            Target target = ctor.newInstance(gen);
            return target.templatesExist();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Target getTarget() {
        if (this.target == null && CodeGenerator.targetExists(this.language)) {
            this.loadLanguageTarget(this.language);
        }
        return this.target;
    }

    public STGroup getTemplates() {
        Target t = this.getTarget();
        return t == null ? null : t.getTemplates();
    }

    protected void loadLanguageTarget(String language) {
        String targetName = "endorh.simpleconfig.shadowed.org.antlr.v4.codegen.target." + language + "Target";
        try {
            Class<Target> c = Class.forName(targetName).asSubclass(Target.class);
            Constructor<Target> ctor = c.getConstructor(CodeGenerator.class);
            this.target = ctor.newInstance(this);
        }
        catch (Exception e) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_CREATE_TARGET_GENERATOR, e, targetName);
        }
    }

    private OutputModelController createController() {
        ParserFactory factory = new ParserFactory(this);
        OutputModelController controller = new OutputModelController(factory);
        factory.setController(controller);
        return controller;
    }

    private ST walk(OutputModelObject outputModel, boolean header) {
        OutputModelWalker walker = new OutputModelWalker(this.tool, this.getTemplates());
        return walker.walk(outputModel, header);
    }

    public ST generateLexer() {
        return this.generateLexer(false);
    }

    public ST generateLexer(boolean header) {
        return this.walk(this.createController().buildLexerOutputModel(header), header);
    }

    public ST generateParser() {
        return this.generateParser(false);
    }

    public ST generateParser(boolean header) {
        return this.walk(this.createController().buildParserOutputModel(header), header);
    }

    public ST generateListener() {
        return this.generateListener(false);
    }

    public ST generateListener(boolean header) {
        return this.walk(this.createController().buildListenerOutputModel(header), header);
    }

    public ST generateBaseListener() {
        return this.generateBaseListener(false);
    }

    public ST generateBaseListener(boolean header) {
        return this.walk(this.createController().buildBaseListenerOutputModel(header), header);
    }

    public ST generateVisitor() {
        return this.generateVisitor(false);
    }

    public ST generateVisitor(boolean header) {
        return this.walk(this.createController().buildVisitorOutputModel(header), header);
    }

    public ST generateBaseVisitor() {
        return this.generateBaseVisitor(false);
    }

    public ST generateBaseVisitor(boolean header) {
        return this.walk(this.createController().buildBaseVisitorOutputModel(header), header);
    }

    ST getTokenVocabOutput() {
        ST vocabFileST = new ST(vocabFilePattern);
        LinkedHashMap<String, Integer> tokens = new LinkedHashMap<String, Integer>();
        for (String t : this.g.tokenNameToTypeMap.keySet()) {
            int tokenType = this.g.tokenNameToTypeMap.get(t);
            if (tokenType < 1) continue;
            tokens.put(t, tokenType);
        }
        vocabFileST.add("tokens", tokens);
        LinkedHashMap<String, Integer> literals = new LinkedHashMap<String, Integer>();
        for (String literal : this.g.stringLiteralToTypeMap.keySet()) {
            int tokenType = this.g.stringLiteralToTypeMap.get(literal);
            if (tokenType < 1) continue;
            literals.put(literal, tokenType);
        }
        vocabFileST.add("literals", literals);
        return vocabFileST;
    }

    public void writeRecognizer(ST outputFileST, boolean header) {
        this.getTarget().genFile(this.g, outputFileST, this.getRecognizerFileName(header));
    }

    public void writeListener(ST outputFileST, boolean header) {
        this.getTarget().genFile(this.g, outputFileST, this.getListenerFileName(header));
    }

    public void writeBaseListener(ST outputFileST, boolean header) {
        this.getTarget().genFile(this.g, outputFileST, this.getBaseListenerFileName(header));
    }

    public void writeVisitor(ST outputFileST, boolean header) {
        this.getTarget().genFile(this.g, outputFileST, this.getVisitorFileName(header));
    }

    public void writeBaseVisitor(ST outputFileST, boolean header) {
        this.getTarget().genFile(this.g, outputFileST, this.getBaseVisitorFileName(header));
    }

    public void writeVocabFile() {
        ST tokenVocabSerialization = this.getTokenVocabOutput();
        String fileName = this.getVocabFileName();
        if (fileName != null) {
            this.getTarget().genFile(this.g, tokenVocabSerialization, fileName);
        }
    }

    public void write(ST code, String fileName) {
        try {
            Writer w = this.tool.getOutputFileWriter(this.g, fileName);
            AutoIndentWriter wr = new AutoIndentWriter(w);
            wr.setLineWidth(this.lineWidth);
            code.write((STWriter)wr);
            w.close();
        }
        catch (IOException ioe) {
            this.tool.errMgr.toolError(ErrorType.CANNOT_WRITE_FILE, ioe, fileName);
        }
    }

    public String getRecognizerFileName() {
        return this.getRecognizerFileName(false);
    }

    public String getListenerFileName() {
        return this.getListenerFileName(false);
    }

    public String getVisitorFileName() {
        return this.getVisitorFileName(false);
    }

    public String getBaseListenerFileName() {
        return this.getBaseListenerFileName(false);
    }

    public String getBaseVisitorFileName() {
        return this.getBaseVisitorFileName(false);
    }

    public String getRecognizerFileName(boolean header) {
        return this.getTarget().getRecognizerFileName(header);
    }

    public String getListenerFileName(boolean header) {
        return this.getTarget().getListenerFileName(header);
    }

    public String getVisitorFileName(boolean header) {
        return this.getTarget().getVisitorFileName(header);
    }

    public String getBaseListenerFileName(boolean header) {
        return this.getTarget().getBaseListenerFileName(header);
    }

    public String getBaseVisitorFileName(boolean header) {
        return this.getTarget().getBaseVisitorFileName(header);
    }

    public String getVocabFileName() {
        return this.g.name + VOCAB_FILE_EXTENSION;
    }

    public String getHeaderFileName() {
        ST extST = this.getTemplates().getInstanceOf("headerFileExtension");
        if (extST == null) {
            return null;
        }
        String recognizerName = this.g.getRecognizerName();
        return recognizerName + extST.render();
    }
}

