/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.konfig.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.entry.AbstractSerializableEntry;
import endorh.simpleconfig.konfig.entry.RegexEntryBuilder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001c\u001dB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0014\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0011H\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00182\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lendorh/simpleconfig/konfig/entry/RegexEntry;", "Lendorh/simpleconfig/core/entry/AbstractSerializableEntry;", "Lkotlin/text/Regex;", "parent", "Lendorh/simpleconfig/api/ConfigEntryHolder;", "name", "", "value", "(Lendorh/simpleconfig/api/ConfigEntryHolder;Ljava/lang/String;Lkotlin/text/Regex;)V", "options", "", "Lkotlin/text/RegexOption;", "getOptions", "()Ljava/util/Set;", "setOptions", "(Ljava/util/Set;)V", "addExtraTooltip", "", "Lnet/minecraft/network/chat/Component;", "deserialize", "displayFlags", "flags", "getConfigCommentTooltips", "getErrorMessage", "Ljava/util/Optional;", "getTextFormatter", "Lendorh/simpleconfig/api/ui/TextFormatter;", "serialize", "Builder", "Companion", "simple-config_kotlinApi"})
@SourceDebugExtension(value={"SMAP\nRegexEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexEntry.kt\nendorh/simpleconfig/konfig/entry/RegexEntry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,106:1\n1855#2:107\n1856#2:109\n1#3:108\n107#4:110\n79#4,22:111\n*S KotlinDebug\n*F\n+ 1 RegexEntry.kt\nendorh/simpleconfig/konfig/entry/RegexEntry\n*L\n80#1:107\n80#1:109\n95#1:110\n95#1:111,22\n*E\n"})
public final class RegexEntry
extends AbstractSerializableEntry<Regex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Set<? extends RegexOption> options;
    @NotNull
    private static final Map<RegexOption, Character> FLAG_NAMES;

    public RegexEntry(@NotNull ConfigEntryHolder parent, @NotNull String name, @NotNull Regex value) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(parent, name, value, Regex.class);
        EnumSet<RegexOption> enumSet = EnumSet.noneOf(RegexOption.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(RegexOption::class.java)");
        this.options = enumSet;
    }

    @NotNull
    public final Set<RegexOption> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Set<? extends RegexOption> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.options = set;
    }

    @Override
    @NotNull
    protected String serialize(@NotNull Regex value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value.getPattern();
    }

    @Override
    @Nullable
    protected Regex deserialize(@NotNull String value) {
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            regex = new Regex(value, this.options);
        }
        catch (PatternSyntaxException e) {
            regex = null;
        }
        return regex;
    }

    @Override
    @Nullable
    protected List<Component> addExtraTooltip(@Nullable String value) {
        List<Component> extra = super.addExtraTooltip(value);
        if (!((Collection)this.options).isEmpty()) {
            Object[] objectArray = new Object[]{this.displayFlags(this.options)};
            extra.add(0, (Component)Component.m_237110_((String)"simpleconfig.config.help.pattern_flags", (Object[])objectArray).m_130940_(ChatFormatting.GRAY));
        }
        return extra;
    }

    @NotNull
    public final String displayFlags(@NotNull Set<? extends RegexOption> flags) {
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        if (flags.isEmpty()) {
            return "";
        }
        StringBuilder f = new StringBuilder("(?");
        Iterable $this$forEach$iv = flags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegexOption opt = (RegexOption)element$iv;
            boolean bl = false;
            Character c = FLAG_NAMES.get(opt);
            if (c == null) continue;
            char it = c.charValue();
            boolean bl2 = false;
            f.append(it);
        }
        if (flags.contains(RegexOption.LITERAL)) {
            f.append("+LITERAL");
        }
        if (flags.contains(RegexOption.CANON_EQ)) {
            f.append("+CANON_EQ");
        }
        f.append(')');
        String string = f.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Optional<Component> getErrorMessage(@NotNull String value) {
        Optional<Component> optional;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            new Regex(value, this.options);
            optional = super.getErrorMessage(value);
        }
        catch (PatternSyntaxException e) {
            void $this$trim$iv;
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            int n = 0;
            Object[] objectArray2 = objectArray;
            String string3 = "simpleconfig.config.error.invalid_pattern";
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string4 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            objectArray2[n] = StringsKt.replace$default((String)string4, (String)"\r\n", (String)": ", (boolean)false, (int)4, null);
            optional = Optional.of(Component.m_237110_((String)string3, (Object[])objectArray));
        }
        return optional;
    }

    @Override
    @Nullable
    public List<String> getConfigCommentTooltips() {
        List<String> tooltips = super.getConfigCommentTooltips();
        if (!((Collection)this.options).isEmpty()) {
            tooltips.add("Flags: " + this.displayFlags(this.options));
        }
        return tooltips;
    }

    @Override
    @Nullable
    protected TextFormatter getTextFormatter() {
        return TextFormatter.forLanguageOrDefault("regex", TextFormatter.DEFAULT);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RegexOption.UNIX_LINES, (Object)Character.valueOf('d')), TuplesKt.to((Object)RegexOption.IGNORE_CASE, (Object)Character.valueOf('i')), TuplesKt.to((Object)RegexOption.COMMENTS, (Object)Character.valueOf('x')), TuplesKt.to((Object)RegexOption.MULTILINE, (Object)Character.valueOf('m')), TuplesKt.to((Object)RegexOption.DOT_MATCHES_ALL, (Object)Character.valueOf('s')), TuplesKt.to((Object)RegexOption.LITERAL, null), TuplesKt.to((Object)RegexOption.CANON_EQ, null)};
        FLAG_NAMES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lendorh/simpleconfig/konfig/entry/RegexEntry$Companion;", "", "()V", "FLAG_NAMES", "", "Lkotlin/text/RegexOption;", "", "simple-config_kotlinApi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014JM\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H\u0015H\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u0001H\u0015H\u0015\u0018\u00010\u00140\u0014\"\u0010\b\u0000\u0010\u0015\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0082\bJ\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J!\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001c\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001c\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001dR \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lendorh/simpleconfig/konfig/entry/RegexEntry$Builder;", "Lendorh/simpleconfig/core/entry/AbstractSerializableEntry$Builder;", "Lkotlin/text/Regex;", "Lendorh/simpleconfig/konfig/entry/RegexEntry;", "Lendorh/simpleconfig/konfig/entry/RegexEntryBuilder;", "value", "(Lkotlin/text/Regex;)V", "options", "", "Lkotlin/text/RegexOption;", "getOptions", "()Ljava/util/Set;", "setOptions", "(Ljava/util/Set;)V", "buildEntry", "parent", "Lendorh/simpleconfig/api/ConfigEntryHolder;", "name", "", "copySet", "Ljava/util/EnumSet;", "E", "kotlin.jvm.PlatformType", "", "src", "", "createCopy", "withOptions", "", "([Lkotlin/text/RegexOption;)Lendorh/simpleconfig/konfig/entry/RegexEntry$Builder;", "withoutOptions", "simple-config_kotlinApi"})
    @SourceDebugExtension(value={"SMAP\nRegexEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexEntry.kt\nendorh/simpleconfig/konfig/entry/RegexEntry$Builder\n*L\n1#1,106:1\n29#1:107\n29#1:108\n29#1:109\n*S KotlinDebug\n*F\n+ 1 RegexEntry.kt\nendorh/simpleconfig/konfig/entry/RegexEntry$Builder\n*L\n31#1:107\n42#1:108\n46#1:109\n*E\n"})
    public static final class Builder
    extends AbstractSerializableEntry.Builder<Regex, RegexEntry, RegexEntryBuilder, Builder>
    implements RegexEntryBuilder {
        @NotNull
        private Set<RegexOption> options;

        public Builder(@NotNull Regex value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value, Regex.class);
            Builder builder = this;
            Collection src$iv = value.getOptions();
            boolean $i$f$copySet = false;
            EnumSet<Object> enumSet = src$iv.isEmpty() ? EnumSet.noneOf(RegexOption.class) : EnumSet.copyOf(src$iv);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copySet(value.options)");
            this.options = enumSet;
        }

        private final /* synthetic */ <E extends Enum<E>> EnumSet<E> copySet(Collection<? extends E> src) {
            EnumSet<Object> enumSet;
            boolean $i$f$copySet = false;
            if (src.isEmpty()) {
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                enumSet = EnumSet.noneOf(Enum.class);
            } else {
                enumSet = EnumSet.copyOf(src);
            }
            return enumSet;
        }

        @NotNull
        public final Set<RegexOption> getOptions() {
            return this.options;
        }

        public final void setOptions(@NotNull Set<RegexOption> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.options = set;
        }

        @Override
        @NotNull
        public Builder withOptions(RegexOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object SelfImpl = this.copy();
            Intrinsics.checkNotNull(SelfImpl);
            Object SelfImpl2 = SelfImpl;
            Builder it = (Builder)SelfImpl2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)it.options, (Object[])options);
            return (Builder)SelfImpl2;
        }

        @Override
        @NotNull
        public Builder withoutOptions(RegexOption ... options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Object SelfImpl = this.copy();
            Intrinsics.checkNotNull(SelfImpl);
            Object SelfImpl2 = SelfImpl;
            Builder it = (Builder)SelfImpl2;
            boolean bl = false;
            it.options.removeAll(ArraysKt.toSet((Object[])options));
            return (Builder)SelfImpl2;
        }

        @Override
        @NotNull
        protected RegexEntry buildEntry(@NotNull ConfigEntryHolder parent, @NotNull String name) {
            RegexEntry regexEntry;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Object object = this.value;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value");
            RegexEntry it = regexEntry = new RegexEntry(parent, name, (Regex)object);
            boolean bl = false;
            Builder builder = this;
            Collection src$iv = this.options;
            boolean $i$f$copySet = false;
            EnumSet<Object> enumSet = src$iv.isEmpty() ? EnumSet.noneOf(RegexOption.class) : EnumSet.copyOf(src$iv);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copySet(options)");
            it.setOptions((Set<? extends RegexOption>)enumSet);
            return regexEntry;
        }

        @Override
        @NotNull
        protected Builder createCopy(@NotNull Regex value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder it = builder = new Builder(value);
            boolean bl = false;
            Builder builder2 = this;
            Collection src$iv = this.options;
            boolean $i$f$copySet = false;
            EnumSet<Object> enumSet = src$iv.isEmpty() ? EnumSet.noneOf(RegexOption.class) : EnumSet.copyOf(src$iv);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copySet(options)");
            it.options = enumSet;
            return builder;
        }
    }
}

