/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.highlight;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import endorh.simpleconfig.api.ui.HighlighterManager;
import endorh.simpleconfig.api.ui.LanguageHighlighter;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.CharStream;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.CharStreams;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.CommonTokenStream;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.Lexer;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.Parser;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.ParserRuleContext;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.Token;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.tree.ErrorNode;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.tree.ParseTreeListener;
import endorh.simpleconfig.shadowed.org.antlr.v4.runtime.tree.TerminalNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.Deserializers;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlighterManagerImpl
extends SimpleJsonResourceReloadListener
implements HighlighterManager {
    private static final Gson GSON = Deserializers.m_78798_().registerTypeAdapter(HighlightRule.class, (Object)new HighlightRule.RuleDeserializer()).registerTypeAdapter(LanguageHighlightingRules.class, (Object)new LanguageHighlightingRules.HighlighterDeserializer()).registerTypeAdapter(Style.class, (Object)new LanguageHighlightingRules.StyleDeserializer()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    public static final HighlighterManagerImpl INSTANCE = new HighlighterManagerImpl();
    private final Map<String, LanguageHighlighterImpl<?>> highlighters = new HashMap();
    private final Map<String, LanguageHighlightingRules> rules = new HashMap<String, LanguageHighlightingRules>();

    public HighlighterManagerImpl() {
        super(GSON, "simpleconfig-highlight");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        map.entrySet().stream().map(e -> Pair.of((Object)((ResourceLocation)e.getKey()), (Object)((LanguageHighlightingRules)GSON.fromJson((JsonElement)e.getValue(), LanguageHighlightingRules.class)))).forEach(e -> {
            String path = ((ResourceLocation)e.getKey()).m_135815_();
            LanguageHighlightingRules rules = (LanguageHighlightingRules)e.getValue();
            this.highlighters.get(path).setRules(rules);
            this.rules.put(path, rules);
        });
    }

    public void registerHighlighter(LanguageHighlighterImpl<?> parser) {
        this.highlighters.put(parser.getLanguage(), parser);
    }

    @Override
    @Nullable
    public LanguageHighlighter getHighlighter(String language) {
        LanguageHighlighterImpl<?> parser = this.highlighters.get(language);
        if (parser != null) {
            parser.setRules(this.rules.getOrDefault(language, LanguageHighlightingRules.EMPTY));
        }
        return parser;
    }

    public static class LanguageHighlighterImpl<P extends Parser>
    implements LanguageHighlighter {
        private final String language;
        private final Function<CharStream, Lexer> lexerFactory;
        private final Function<CommonTokenStream, P> parserFactory;
        private final Function<P, ParserRuleContext> rootParser;
        private LanguageHighlightingRules highlighter = LanguageHighlightingRules.EMPTY;

        public LanguageHighlighterImpl(String language, Function<CharStream, Lexer> lexerFactory, Function<CommonTokenStream, P> parserFactory, Function<P, ParserRuleContext> rootParser) {
            this.language = language;
            this.lexerFactory = lexerFactory;
            this.parserFactory = parserFactory;
            this.rootParser = rootParser;
        }

        @Override
        @NotNull
        public MutableComponent highlight(@NotNull String text) {
            if (text.isEmpty()) {
                return Component.m_237119_();
            }
            Lexer lexer = this.lexerFactory.apply(CharStreams.fromString(text));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            Parser parser = (Parser)this.parserFactory.apply(tokens);
            parser.removeErrorListeners();
            HighlightListener highlighter = new HighlightListener(parser, tokens, this.highlighter);
            parser.addParseListener(highlighter);
            this.rootParser.apply(parser);
            return highlighter.getResult();
        }

        @Override
        public MutableComponent formatText(String text) {
            return this.highlight(text);
        }

        @Override
        @Nullable
        public String closingPair(char typedChar, String context, int caretPos) {
            Map<String, String> charPairs;
            Map<String, String> tokenPairs = this.highlighter.getTokenPairs();
            String upTo = context.substring(0, caretPos) + typedChar;
            if (!tokenPairs.isEmpty()) {
                Lexer lexer = this.lexerFactory.apply(CharStreams.fromString(upTo));
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                tokens.fill();
                if (tokens.size() > 0) {
                    String tokenType;
                    String closingPair;
                    int i = tokens.size() - 1;
                    Token last = null;
                    while (i >= 0 && (last = tokens.get(i--)).getType() == -1) {
                    }
                    if (last != null && (closingPair = tokenPairs.get(tokenType = lexer.getVocabulary().getSymbolicName(last.getType()))) != null) {
                        return closingPair;
                    }
                }
            }
            if (!(charPairs = this.highlighter.getCharPairs()).isEmpty()) {
                return charPairs.entrySet().stream().filter(e -> upTo.endsWith((String)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
            }
            return null;
        }

        @Override
        public boolean shouldSkipClosingPair(char typedChar, String context, int caretPos) {
            return this.highlighter.getClosingPairs().contains(String.valueOf(typedChar));
        }

        @Override
        @NotNull
        public String getLanguage() {
            return this.language;
        }

        public Function<CharStream, Lexer> getLexerFactory() {
            return this.lexerFactory;
        }

        public Function<CommonTokenStream, P> getParserFactory() {
            return this.parserFactory;
        }

        public Function<P, ParserRuleContext> getRootParser() {
            return this.rootParser;
        }

        public LanguageHighlightingRules getHighlighter() {
            return this.highlighter;
        }

        public void setRules(LanguageHighlightingRules highlighter) {
            this.highlighter = highlighter;
        }

        private static class HighlightListener
        implements ParseTreeListener {
            private final Parser parser;
            private final CommonTokenStream tokens;
            private final LanguageHighlightingRules highlighter;
            private Style defaultStyle = Style.f_131099_;
            private Style errorStyle = Style.f_131099_.m_131140_(ChatFormatting.RED).m_131162_(Boolean.valueOf(true));
            private MutableComponent result = null;
            private int lastIndex = 0;
            private final Stack<Style> styleStack = new Stack();

            public HighlightListener(Parser parser, CommonTokenStream tokens, LanguageHighlightingRules highlighter) {
                this.parser = parser;
                this.tokens = tokens;
                this.highlighter = highlighter;
                Map<String, Style> styles = highlighter.getStyles();
                this.defaultStyle = styles.getOrDefault("default", this.defaultStyle);
                this.errorStyle = styles.getOrDefault("error", this.errorStyle);
            }

            public HighlightListener withDefaultStyle(Style style) {
                this.defaultStyle = style;
                return this;
            }

            public HighlightListener withErrorStyle(Style style) {
                this.errorStyle = style;
                return this;
            }

            public MutableComponent getResult() {
                return this.result != null ? this.result : Component.m_237119_();
            }

            protected void appendFragment(String fragment, Style style) {
                if (style == null) {
                    style = this.defaultStyle;
                }
                if (this.result != null) {
                    this.result.m_7220_((Component)Component.m_237113_((String)fragment).m_6270_(style));
                } else {
                    this.result = Component.m_237113_((String)fragment).m_6270_(style);
                }
            }

            public void visitHiddenTokensUpTo(int index) {
                if (index - this.lastIndex > 0) {
                    for (int i = this.lastIndex; i < index; ++i) {
                        Token token = this.tokens.get(i);
                        if (token.getChannel() == 0) continue;
                        this.visitHiddenToken(token);
                    }
                }
                this.lastIndex = index;
            }

            public void visitHiddenToken(Token token) {
                if (token.getType() == -1) {
                    return;
                }
                this.appendFragment(token.getText(), this.styleStack.isEmpty() ? this.defaultStyle : this.styleStack.peek());
            }

            @Override
            public void visitTerminal(TerminalNode node) {
                this.visitHiddenTokensUpTo(node.getSymbol().getTokenIndex());
                if (node.getSymbol().getType() == -1) {
                    return;
                }
                Style style = this.styleStack.isEmpty() ? this.defaultStyle : this.styleStack.peek();
                String tokenName = this.parser.getVocabulary().getSymbolicName(node.getSymbol().getType());
                String ruleName = this.highlighter.getRuleForToken(tokenName);
                if (ruleName != null) {
                    style = this.highlighter.getStyles().getOrDefault(ruleName, style).m_131146_(style);
                }
                this.appendFragment(node.getText(), style);
            }

            @Override
            public void visitErrorNode(ErrorNode node) {
                this.visitHiddenTokensUpTo(node.getSymbol().getTokenIndex());
                this.appendFragment(node.getText(), this.errorStyle);
            }

            @Override
            public void enterEveryRule(ParserRuleContext ctx) {
                String grammarRule = this.parser.getRuleNames()[ctx.getRuleIndex()];
                String highlightingRule = this.highlighter.getRuleForRule(grammarRule);
                if (highlightingRule != null) {
                    Style style = this.highlighter.getStyles().getOrDefault(highlightingRule, this.defaultStyle);
                    Style last = this.styleStack.isEmpty() ? Style.f_131099_ : this.styleStack.peek();
                    this.styleStack.push(style.m_131146_(last));
                }
            }

            @Override
            public void exitEveryRule(ParserRuleContext ctx) {
                String ruleName = this.parser.getRuleNames()[ctx.getRuleIndex()];
                if (this.highlighter.getRuleForRule(ruleName) != null) {
                    this.styleStack.pop();
                }
            }
        }
    }

    public static class LanguageHighlightingRules {
        public static final LanguageHighlightingRules EMPTY = new LanguageHighlightingRules(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        private final Map<String, HighlightRule> rules;
        private final Map<String, Style> styles;
        private final Map<String, String> tokenPairs;
        private final Map<String, String> charPairs;
        private final Set<String> closingPairs;
        private final Map<String, String> rulesByRule = new HashMap<String, String>();
        private final Map<String, String> rulesByToken = new HashMap<String, String>();

        public LanguageHighlightingRules(Map<String, HighlightRule> rules, Map<String, Style> styles, Map<String, String> tokenPairs, Map<String, String> charPairs) {
            this.rules = rules;
            this.styles = styles;
            this.tokenPairs = tokenPairs;
            this.charPairs = charPairs;
            this.closingPairs = Stream.concat(tokenPairs.values().stream(), charPairs.values().stream()).collect(Collectors.toSet());
        }

        public String getRuleForRule(String rule) {
            return this.rulesByRule.computeIfAbsent(rule, r -> this.rules.entrySet().stream().filter(e -> ((HighlightRule)e.getValue()).rules().contains(r)).map(Map.Entry::getKey).findFirst().orElse(null));
        }

        public String getRuleForToken(String token) {
            return this.rulesByToken.computeIfAbsent(token, t -> this.rules.entrySet().stream().filter(e -> ((HighlightRule)e.getValue()).tokens().contains(t)).map(Map.Entry::getKey).findFirst().orElse(null));
        }

        public Map<String, HighlightRule> getRules() {
            return this.rules;
        }

        public Style getStyle(String ruleName) {
            return this.styles.get(ruleName);
        }

        public Map<String, Style> getStyles() {
            return this.styles;
        }

        public Map<String, String> getTokenPairs() {
            return this.tokenPairs;
        }

        public Map<String, String> getCharPairs() {
            return this.charPairs;
        }

        public Set<String> getClosingPairs() {
            return this.closingPairs;
        }

        public static class StyleDeserializer
        implements JsonDeserializer<Style> {
            private static final Pattern COLOR_PATTERN = Pattern.compile("#(?:[\\da-fA-F]{3}){1,2}");

            public Style deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Style must be a JSON object");
                }
                JsonObject obj = json.getAsJsonObject();
                Object color = GsonHelper.m_13851_((JsonObject)obj, (String)"color", (String)"#F0F0F0");
                if (!COLOR_PATTERN.matcher((CharSequence)color).matches()) {
                    throw new JsonParseException("Invalid hex color: " + (String)color);
                }
                if (((String)color).length() == 4) {
                    color = ((String)color).substring(1, 1) + ((String)color).substring(1, 1) + ((String)color).substring(2, 2) + ((String)color).substring(2, 2) + ((String)color).substring(3, 3) + ((String)color).substring(3, 3);
                }
                boolean bold = GsonHelper.m_13855_((JsonObject)obj, (String)"bold", (boolean)false);
                boolean italic = GsonHelper.m_13855_((JsonObject)obj, (String)"italic", (boolean)false);
                boolean underlined = GsonHelper.m_13855_((JsonObject)obj, (String)"underlined", (boolean)false);
                boolean strikethrough = GsonHelper.m_13855_((JsonObject)obj, (String)"strikethrough", (boolean)false);
                return Style.f_131099_.m_131148_(TextColor.m_131268_((String)color)).m_131136_(Boolean.valueOf(bold)).m_131155_(Boolean.valueOf(italic)).m_131162_(Boolean.valueOf(underlined)).m_178522_(Boolean.valueOf(strikethrough));
            }
        }

        public static class HighlighterDeserializer
        implements JsonDeserializer<LanguageHighlightingRules> {
            public LanguageHighlightingRules deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Highlighter must be a JSON object");
                }
                JsonObject obj = json.getAsJsonObject();
                JsonObject rulesObj = GsonHelper.m_13930_((JsonObject)obj, (String)"rules");
                LinkedHashMap<String, HighlightRule> rules = new LinkedHashMap<String, HighlightRule>();
                rulesObj.entrySet().forEach(e -> rules.put((String)e.getKey(), (HighlightRule)context.deserialize((JsonElement)e.getValue(), HighlightRule.class)));
                JsonObject stylesObj = GsonHelper.m_13930_((JsonObject)obj, (String)"styles");
                LinkedHashMap<String, Object> styleDefs = new LinkedHashMap<String, Object>();
                stylesObj.entrySet().forEach(e -> styleDefs.put((String)e.getKey(), ((JsonElement)e.getValue()).isJsonPrimitive() ? ((JsonElement)e.getValue()).getAsString() : context.deserialize((JsonElement)e.getValue(), Style.class)));
                LinkedHashMap<String, Style> styles = new LinkedHashMap<String, Style>();
                styleDefs.forEach((key, value) -> {
                    if (value instanceof Style) {
                        styles.put((String)key, (Style)value);
                    } else {
                        int guard = 1024;
                        while (value instanceof String && guard-- > 0) {
                            value = styleDefs.get((String)value);
                        }
                        if (guard <= 0) {
                            throw new JsonParseException("Circular style reference");
                        }
                        if (value instanceof Style) {
                            styles.put((String)key, (Style)value);
                        } else {
                            throw new JsonParseException("Invalid style definition");
                        }
                    }
                });
                LinkedHashMap<String, String> tokenPairs = new LinkedHashMap<String, String>();
                if (obj.has("token_pairs")) {
                    JsonObject tokenPairsObj = GsonHelper.m_13930_((JsonObject)obj, (String)"token_pairs");
                    tokenPairsObj.entrySet().forEach(e -> tokenPairs.put((String)e.getKey(), GsonHelper.m_13906_((JsonObject)tokenPairsObj, (String)((String)e.getKey()))));
                }
                LinkedHashMap<String, String> charPairs = new LinkedHashMap<String, String>();
                if (obj.has("char_pairs")) {
                    JsonObject charPairsObj = GsonHelper.m_13930_((JsonObject)obj, (String)"char_pairs");
                    charPairsObj.entrySet().forEach(e -> charPairs.put((String)e.getKey(), GsonHelper.m_13906_((JsonObject)charPairsObj, (String)((String)e.getKey()))));
                }
                return new LanguageHighlightingRules(rules, styles, tokenPairs, charPairs);
            }
        }
    }

    public record HighlightRule(List<String> tokens, List<String> rules) {

        public static class RuleDeserializer
        implements JsonDeserializer<HighlightRule> {
            public HighlightRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Highlight rule must be a JSON object");
                }
                JsonObject obj = json.getAsJsonObject();
                JsonArray arr = GsonHelper.m_13832_((JsonObject)obj, (String)"tokens", null);
                ArrayList<String> tokens = new ArrayList<String>();
                if (arr != null) {
                    for (JsonElement element : arr) {
                        String str = element.getAsJsonPrimitive().getAsString();
                        tokens.add(str);
                    }
                }
                arr = GsonHelper.m_13832_((JsonObject)obj, (String)"rules", null);
                ArrayList<String> rules = new ArrayList<String>();
                if (arr != null) {
                    for (JsonElement element : arr) {
                        String str = element.getAsJsonPrimitive().getAsString();
                        rules.add(str);
                    }
                }
                return new HighlightRule(tokens, rules);
            }
        }
    }
}

