/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.demo;

import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfigCategory;
import endorh.simpleconfig.api.annotation.Bake;
import endorh.simpleconfig.api.annotation.Bean;
import endorh.simpleconfig.api.annotation.Bind;
import endorh.simpleconfig.api.annotation.Category;
import endorh.simpleconfig.api.annotation.Configure;
import endorh.simpleconfig.api.annotation.Default;
import endorh.simpleconfig.api.annotation.Entry;
import endorh.simpleconfig.api.annotation.Group;
import endorh.simpleconfig.api.annotation.HasAlpha;
import endorh.simpleconfig.api.annotation.Length;
import endorh.simpleconfig.api.annotation.Max;
import endorh.simpleconfig.api.annotation.Min;
import endorh.simpleconfig.api.annotation.NonPersistent;
import endorh.simpleconfig.api.annotation.RequireRestart;
import endorh.simpleconfig.api.annotation.Size;
import endorh.simpleconfig.api.annotation.Slider;
import endorh.simpleconfig.api.annotation.Suggest;
import endorh.simpleconfig.api.annotation.Text;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.api.entry.StringEntryBuilder;
import endorh.simpleconfig.api.ui.icon.Icon;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@Category(background="textures/block/cobblestone.png", color=-2141163392)
public class DemoDeclarativeConfigCategory {
    @Text
    private static final Component _greeting = DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("text.greeting_declarative"), DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("text.github"), new Object[0]).m_130938_(s -> s.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/endorh/simple-config/blob/1.19/src/main/java/endorh/simpleconfig/demo/DemoDeclarativeConfigCategory.java"))));
    @Entry
    public static String entry = "value";
    @Group
    private static Void group$marker;
    @Group
    private static Void demo_group$marker;

    private static String prefix(String key) {
        return "simpleconfig.config." + key;
    }

    private static MutableComponent stc(String msg, Object ... args) {
        return Component.m_237113_((String)String.format(msg, args));
    }

    private static MutableComponent ttc(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    @ApiStatus.Internal
    public static ConfigCategoryBuilder build() {
        return ConfigBuilderFactoryProxy.category("declarative_demo", DemoDeclarativeConfigCategory.class);
    }

    @Bind
    private static Icon getIcon() {
        return SimpleConfigIcons.Status.INFO;
    }

    @Bind
    protected static void bake(SimpleConfigCategory config) {
        entry = entry.toLowerCase();
    }

    public static class MyConfigAnnotations {
        @Bind
        static StringEntryBuilder decLowercase(StringEntryBuilder value) {
            return (StringEntryBuilder)value.error(s -> !s.equals(s.toLowerCase()) ? Optional.of(DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("error.not_lowercase"), s)) : Optional.empty());
        }

        @Bind
        static IntegerEntryBuilder decSlider(IntegerEntryBuilder value, ExtraSlider a) {
            return ((IntegerEntryBuilder)value.range(0, a.extraMax()).slider()).sliderRange(0, a.max());
        }

        @Bind
        static FloatEntryBuilder decSlider(FloatEntryBuilder value, ExtraSlider a) {
            return ((FloatEntryBuilder)value.range(0.0f, a.extraMax()).slider()).sliderRange(0.0f, a.max());
        }

        @Bind
        static float map(float value, Mapped m) {
            return m.outputMin() + (value - m.inputMin()) * (m.outputMax() - m.outputMin()) / (m.inputMax() - m.inputMin());
        }

        @Bind
        static double map(double value, Mapped m) {
            return (double)m.outputMin() + (value - (double)m.inputMin()) * (double)(m.outputMax() - m.outputMin()) / (double)(m.inputMax() - m.inputMin());
        }

        @Target(value={ElementType.FIELD, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        @Configure(value="decSlider")
        public static @interface ExtraSlider {
            public int max() default 100;

            public int extraMax() default 200;
        }

        @Target(value={ElementType.FIELD, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        @Bake(method="map")
        public static @interface Mapped {
            public float inputMin() default 0.0f;

            public float inputMax() default 1.0f;

            public float outputMin() default 0.0f;

            public float outputMax() default 10.0f;
        }

        @Target(value={ElementType.FIELD, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
        @Retention(value=RetentionPolicy.RUNTIME)
        @Configure(value="decLowercase")
        public static @interface Lowercase {
        }
    }

    @Bean
    public static class DemoBean {
        @Group.Caption
        public String name = "Name";
        @Entry
        @Min(value=0.0)
        @Max(value=10.0)
        public @Min(value=0.0) @Max(value=10.0) int number = 0;
        @Entry
        public Pair<String, @Min(value=0.0) @Max(value=10.0) @Slider Integer> pair = Pair.of((Object)"a", (Object)0);
        @Entry
        public SubBean subBean = new SubBean();

        @Bean
        public static class SubBean {
            @Group.Caption
            public String name = "";
            @Entry
            public int value = 0;
        }
    }

    @Group(expand=false)
    public static abstract class demo_group {
        @Entry
        @Min(value=0.0)
        @Max(value=10.0)
        @Slider
        public static @Min(value=0.0) @Max(value=10.0) @Slider long even_score = 10L;
        @Entry
        @HasAlpha
        public static Color alpha_color = Color.GRAY;
        @Entry
        @Bake.Scale(value=0.05)
        public static float speed = 0.5f;
        @Text
        private static Void text;
        @Entry
        @Min(value=0.0)
        @Max(value=1.0)
        @RequireRestart
        public static @Min(value=0.0) @Max(value=1.0) double ore_gen_chance;
        public static String summon_command;
        @Entry
        @Min(value=0.0)
        public static @Min(value=0.0) float speed_m_s;
        public static float speed_m_tick;
        @Group
        private static Void nested_group$marker;
        @Entry
        @NonPersistent
        public static boolean temp_bool;
        @Text
        private static final Supplier<Component> _2;

        @Bind
        private static Optional<Component> even_score$error(long v) {
            return v % 2L != 0L ? Optional.of(DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("error.not_even"), v)) : Optional.empty();
        }

        @Bind
        private static List<Component> even_score$tooltip() {
            return Arrays.asList(DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("tooltip.score.1"), new Object[0]), DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("tooltip.score.2"), new Object[0]));
        }

        @Bind
        private static long even_score$bake(long v) {
            return v * 2L;
        }

        static {
            ore_gen_chance = 1.0;
            summon_command = "/summon minecraft:sheep ~ ~ ~ {Color:6}";
            speed_m_s = 2.0f;
            temp_bool = false;
            _2 = () -> DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("text.some_complex_text"), DemoDeclarativeConfigCategory.stc(summon_command, new Object[0]).m_130938_(s -> s.m_131140_(ChatFormatting.LIGHT_PURPLE).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)DemoDeclarativeConfigCategory.ttc("chat.copy.click", new Object[0]))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, summon_command))));
        }

        @Group
        public static abstract class nested_group {
            @Group.Caption
            public static String caption = "Caption entry";
            @Entry
            public static Color no_alpha_color = Color.BLUE;
            @Entry
            @HasAlpha
            public static Color alpha_color = Color.YELLOW;
            @Entry
            public static List<@Min(value=0.0) Long> long_list = Arrays.asList(0L, 2L);
            @Entry
            public static List<@Min(value=0.0) @Max(value=1.0) Double> double_list = Arrays.asList(0.1, 0.2, 0.3, 0.4);
            @Entry
            public static List<@Default(value="['a', 'b', 'c', 'd']") List<@Default(value="'e'") String>> list_list = Arrays.asList(Arrays.asList("a", "b", "c", "d"), Arrays.asList("e", "f", "g", "h"));
            @Entry
            public static Map<String, @Min(value=0.0) @Max(value=20.0) @Default(value="10") Integer> int_map = (Map)Util.m_137469_(new HashMap(), m -> m.put("key", 0));
            @Entry
            public static List<Pair<@Default(value="move") @Suggest(value={"move", "rotate", "tower", "dig"}) String, @Min(value=0.0) @Default(value="10") Integer>> string_int_pair_list = Arrays.asList(Pair.of((Object)"move", (Object)4), Pair.of((Object)"rotate", (Object)90), Pair.of((Object)"move", (Object)2));
            @Entry
            public static Pair<@Default(value="overwritten") @Length(max=10) String, @Size(max=4) List<@Min(value=0.0) @Max(value=10.0) Integer>> captioned_list = Pair.of((Object)"caption", Arrays.asList(4, 2));
            @Entry.Caption
            public static String set_caption = "caption";
            @Entry
            public static Set<@Min(value=0.0) @Max(value=10.0) @Slider Integer> set_with_caption;
            @Entry
            @Slider1020
            public static int int10;
            @Entry
            @MyConfigAnnotations.Lowercase
            public static String lower_str;
            @Entry
            @MyConfigAnnotations.ExtraSlider
            public static int extra_slider;
            @Entry
            @MyConfigAnnotations.ExtraSlider(extraMax=300)
            public static @MyConfigAnnotations.ExtraSlider(extraMax=300) int extra_slider_300;
            @Entry
            @Min(value=0.0)
            @Max(value=1.0)
            @MyConfigAnnotations.Mapped
            public static @Min(value=0.0) @Max(value=1.0) @MyConfigAnnotations.Mapped float mapped_float;
            @Entry
            @Min(value=0.0)
            @Max(value=1.0)
            @MyConfigAnnotations.Mapped(outputMin=10.0f, outputMax=5.0f)
            public static @Min(value=0.0) @Max(value=1.0) @MyConfigAnnotations.Mapped(outputMin=10.0f, outputMax=5.0f) double mapped_double;
            @Entry
            public static DemoBean demo_bean;
            @Entry
            public static Set<@Default(value="{name: name, number: 5, pair: [k, 5], subBean: {name: db, number: 42}}") DemoBean> bean_set;

            @Bind
            private static Optional<Component> long_list$v$error(long element) {
                return element % 2L == 0L ? Optional.empty() : Optional.of(DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("error.not_even"), new Object[0]));
            }

            @Bind
            private static Optional<Component> double_list$v$error(double element) {
                return Double.compare(element, (double)Math.round(element * 10.0) / 10.0) != 0 ? Optional.of(DemoDeclarativeConfigCategory.ttc(DemoDeclarativeConfigCategory.prefix("error.too_many_decimals"), new Object[0])) : Optional.empty();
            }

            @Bind
            public static boolean list_list$v$v$error(String elem) {
                return !elem.equals(elem.toLowerCase());
            }

            static {
                int10 = 5;
                lower_str = "lowercase";
                extra_slider = 50;
                extra_slider_300 = 250;
                bean_set = (Set)Util.m_137469_(new HashSet(), s -> s.add(new DemoBean()));
            }

            @Target(value={ElementType.FIELD, ElementType.TYPE_USE, ElementType.ANNOTATION_TYPE})
            @Retention(value=RetentionPolicy.RUNTIME)
            @Min(value=0.0)
            @Max(value=20.0)
            @Slider(max=10.0)
            static @interface Slider1020 {
            }
        }
    }

    @Group(expand=false)
    public static abstract class group {
        @Entry
        @Configure(value="$configure")
        public static @Configure(value="$configure") boolean bool = false;
        @Entry
        public static CompoundTag nbt = new CompoundTag();
        @Entry
        public static Direction direction;

        @Bind
        private static BooleanEntryBuilder bool$configure(BooleanEntryBuilder b) {
            return b.text("simpleconfig.format.bool.on_off");
        }

        @Bind
        private static ConfigGroupBuilder build(ConfigGroupBuilder builder) {
            return (ConfigGroupBuilder)builder.add("built_with_builder", ConfigBuilderFactoryProxy.string(""));
        }

        static {
            nbt.m_128365_("name", (Tag)StringTag.m_129297_((String)"Steve"));
            nbt.m_128365_("health", (Tag)IntTag.m_128679_((int)20));
        }
    }
}

