/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.wrap;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Lists;
import com.google.gson.internal.Primitives;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolderBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AbstractSimpleConfigEntryHolderBuilder;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.SimpleConfigNetworkHandler;
import endorh.simpleconfig.core.wrap.ConfigEntryDelegate;
import endorh.simpleconfig.ui.api.ConfigCategory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="simpleconfig")
public class MinecraftServerConfigWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MINECRAFT_MOD_ID = "minecraft";
    public static final String EDIT_PROTECTED_PROPERTIES = "edit-protected-properties";
    private static SimpleConfigImpl config;
    @Nullable
    private static Consumer<MinecraftServer> binder;

    private static void wrapMinecraftServerConfig() {
        try {
            MinecraftGameRulesWrapperBuilder builder = new MinecraftGameRulesWrapperBuilder();
            Pair<SimpleConfigImpl, Consumer<MinecraftServer>> pair = builder.build();
            config = (SimpleConfigImpl)pair.getLeft();
            binder = (Consumer)pair.getRight();
        }
        catch (RuntimeException e) {
            LOGGER.error("Error wrapping Minecraft Server config", (Throwable)e);
            throw e;
        }
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        MinecraftServerConfigWrapper.wrapMinecraftServerConfig();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static boolean areProtectedPropertiesEditable() {
        if (config != null) {
            return config.hasChild("properties.protected");
        }
        DedicatedServer server = (DedicatedServer)ServerLifecycleHooks.getCurrentServer();
        DedicatedServerProperties properties = server.m_7913_();
        Method Settings$get = ObfuscationReflectionHelper.findMethod(Settings.class, (String)"m_139836_", (Class[])new Class[]{String.class, Boolean.TYPE});
        Settings$get.setAccessible(true);
        try {
            return (Boolean)Settings$get.invoke((Object)properties, EDIT_PROTECTED_PROPERTIES, false);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    private static void removeProtectedProperties() {
        config.removeChild("properties.protected");
    }

    static {
        binder = null;
    }

    public static class MinecraftGameRulesWrapperBuilder {
        private final SimpleConfigBuilderImpl builder;
        private ConfigEntryHolderBuilder<?> target;
        private boolean caption;
        private final MinecraftGameRuleConfigValueBuilder vb;
        private final List<MinecraftServerPropertyEntryDelegate<?>> delegates;
        private static final Map<GameRules.Key<?>, GameRules.Type<?>> GAME_RULE_TYPES = (Map)ObfuscationReflectionHelper.getPrivateValue(GameRules.class, null, (String)"f_46129_");
        private static final Map<GameRules.Key<GameRules.IntegerValue>, ConfigEntryBuilder<Integer, ?, ?, ?>> OVERRIDES = (Map)Util.m_137469_(new HashMap(), m -> {
            m.put(GameRules.f_46149_, ConfigBuilderFactoryProxy.number(24).sliderRange(1, 256).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.pow(2.0)));
            m.put(GameRules.f_151486_, ConfigBuilderFactoryProxy.percent(100));
            m.put(GameRules.f_46143_, ConfigBuilderFactoryProxy.number(3).sliderRange(0, 3000).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(8.0)));
            m.put(GameRules.f_46147_, ConfigBuilderFactoryProxy.number(10).sliderRange(0, 64).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.pow(2.0)));
        });

        public MinecraftGameRulesWrapperBuilder() {
            this.target = this.builder = (SimpleConfigBuilderImpl)ConfigBuilderFactoryProxy.config(MinecraftServerConfigWrapper.MINECRAFT_MOD_ID, SimpleConfig.Type.SERVER);
            this.caption = false;
            this.vb = new MinecraftGameRuleConfigValueBuilder();
            this.delegates = Lists.newArrayList();
        }

        public Pair<SimpleConfigImpl, @Nullable Consumer<MinecraftServer>> build() {
            try {
                this.with(ConfigBuilderFactoryProxy.category("gamerule").withIcon(SimpleConfigIcons.MinecraftOptions.GAMERULES).withColor(-2143141121), this::addGameRuleEntries);
                this.with(ConfigBuilderFactoryProxy.category("properties").withIcon(SimpleConfigIcons.MinecraftOptions.PROPERTIES).withColor(-2143092926), this::addServerPropertiesEntries);
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.builder.withGUIDecorator((s, b) -> {
                    if (!SimpleConfigNetworkHandler.isConnectedToDedicatedServer()) {
                        b.removeCategory("properties", SimpleConfig.EditType.SERVER);
                    } else {
                        SimpleConfigImpl config = (SimpleConfigImpl)s;
                        b.getOrCreateCategory("properties", SimpleConfig.EditType.SERVER).setLoadingFuture((CompletableFuture<Function<ConfigCategory, Boolean>>)SimpleConfigNetworkHandler.requestServerProperties().handle((p, t) -> {
                            CommentedConfig c;
                            if (p != null && (c = (CommentedConfig)p.getRight()) != null) {
                                boolean protectedProperties = (Boolean)p.getLeft();
                                config.loadSnapshot(c, false, false, pp -> pp.startsWith("properties."));
                                config.loadSnapshot(c, true, false, true, pp -> pp.startsWith("properties."));
                                return cc -> {
                                    cc.finishLoadingEntries();
                                    cc.removeEntry(protectedProperties ? "protected-disclaimer" : "protected");
                                    return true;
                                };
                            }
                            return cc -> false;
                        }));
                    }
                }));
                SimpleConfigImpl config = this.builder.buildAndRegister(null, this.vb);
                return Pair.of((Object)config, FMLEnvironment.dist == Dist.DEDICATED_SERVER ? s -> this.delegates.forEach(d -> d.bind((DedicatedServer)s)) : null);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)e);
                throw e;
            }
        }

        private void addGameRuleEntries() {
            if (GAME_RULE_TYPES == null) {
                throw new IllegalStateException("Cannot access GameRules#GAME_RULE_TYPES");
            }
            GAME_RULE_TYPES.forEach((k, t) -> {
                try {
                    GameRules.Value rule = t.m_46352_();
                    if (rule instanceof GameRules.BooleanValue) {
                        GameRules.BooleanValue v = (GameRules.BooleanValue)rule;
                        boolean defValue = v.m_46223_();
                        this.add((GameRules.Key<?>)k, ConfigBuilderFactoryProxy.yesNo(defValue));
                    } else if (rule instanceof GameRules.IntegerValue) {
                        GameRules.IntegerValue v = (GameRules.IntegerValue)rule;
                        int defValue = v.m_46288_();
                        ConfigEntryBuilder<Integer, ?, ?, ?> override = OVERRIDES.get(k);
                        this.add((GameRules.Key<?>)k, (ConfigEntryBuilder<Integer, ?, ?, ?>)(override != null ? override.withValue(defValue) : ConfigBuilderFactoryProxy.number(defValue)));
                    }
                }
                catch (RuntimeException e) {
                    LOGGER.error("Error wrapping game rule: " + k.m_46328_(), (Throwable)e);
                }
            });
        }

        private void addServerPropertiesEntries() {
            this.addFlag("enable-status", ConfigBuilderFactoryProxy.yesNo(true));
            this.add("motd", ConfigBuilderFactoryProxy.string("A Minecraft Server"), (s, m) -> s.m_129989_(m));
            this.addFlag("hide-online-players", ConfigBuilderFactoryProxy.yesNo(false));
            this.add("view-distance", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number(10).sliderRange(1, 64).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(2.0)), (BiConsumer)(s, d) -> s.m_6846_().m_11217_(d.intValue()));
            this.add("simulation-distance", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number(10).sliderRange(1, 64).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(2.0)), (BiConsumer)(s, d) -> s.m_6846_().m_184211_(d.intValue()));
            this.addFlag("entity-broadcast-range-percentage", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.percent(100).range(10, 1000).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(6.0)));
            this.add("pvp", ConfigBuilderFactoryProxy.yesNo(true), MinecraftServer::m_129997_);
            this.addFlag("spawn-animals", ConfigBuilderFactoryProxy.yesNo(true));
            this.addFlag("spawn-npcs", ConfigBuilderFactoryProxy.yesNo(true));
            this.addFlag("spawn-monsters", ConfigBuilderFactoryProxy.yesNo(true));
            this.addFlag("allow-nether", ConfigBuilderFactoryProxy.yesNo(true));
            this.add("allow-flight", ConfigBuilderFactoryProxy.yesNo(false), MinecraftServer::m_129999_);
            this.addFlag("enable-command-block", ConfigBuilderFactoryProxy.yesNo(false));
            this.addFlag("difficulty", ConfigBuilderFactoryProxy.option(Difficulty.EASY));
            this.addFlag("gamemode", ConfigBuilderFactoryProxy.option(GameType.SURVIVAL));
            this.addFlag("force-gamemode", ConfigBuilderFactoryProxy.yesNo(false));
            this.add("hardcore", ConfigBuilderFactoryProxy.yesNo(false));
            this.add("level-name", ConfigBuilderFactoryProxy.string("world"));
            this.addFlag("spawn-protection", (ConfigEntryBuilder)((IntegerEntryBuilder)ConfigBuilderFactoryProxy.number(16).slider("options.chunks")).sliderRange(0, 64).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(2.0)));
            this.addFlag("op-permission-level", ConfigBuilderFactoryProxy.number(4).sliderRange(1, 4));
            this.add("function-permission-level", ConfigBuilderFactoryProxy.number(2).sliderRange(1, 4));
            this.wrap("white-list", ConfigBuilderFactoryProxy.yesNo(false), (d, b) -> d.m_6846_().m_6628_(b.booleanValue()));
            this.add("enforce-whitelist", ConfigBuilderFactoryProxy.yesNo(false));
            this.add("enforce-secure-profile", ConfigBuilderFactoryProxy.yesNo(true));
            this.add("max-players", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number(20).sliderRange(1, 1000).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.expMap(4.0)));
            this.add("max-world-size", ConfigBuilderFactoryProxy.number(29999984).range(1, 29999984));
            this.add("max-tick-time", ConfigBuilderFactoryProxy.number(TimeUnit.MINUTES.toMillis(1L)));
            this.wrap("player-idle-timeout", (ConfigEntryBuilder)ConfigBuilderFactoryProxy.number(0).sliderRange(0, 120).sliderMap(RangedEntryBuilder.InvertibleDouble2DoubleFunction.sqrt()), (BiConsumer)DedicatedServer::m_7196_);
            this.add("max-chained-neighbor-updates", ConfigBuilderFactoryProxy.number(1000000));
            this.add("rate-limit", ConfigBuilderFactoryProxy.number(0));
            this.add("network-compression-threshold", ConfigBuilderFactoryProxy.number(256));
            this.add("use-native-transport", ConfigBuilderFactoryProxy.yesNo(true));
            this.add("sync-chunk-writes", ConfigBuilderFactoryProxy.yesNo(true));
            this.with(ConfigBuilderFactoryProxy.group("world-gen"), () -> {
                this.add("level-seed", ConfigBuilderFactoryProxy.string(""));
                this.add("generate-structures", ConfigBuilderFactoryProxy.yesNo(true));
                this.add("level-type", ConfigBuilderFactoryProxy.string(WorldPresets.f_226437_.m_135782_().toString()).suggest(Stream.of(WorldPresets.f_226437_, WorldPresets.f_226438_, WorldPresets.f_226439_, WorldPresets.f_226440_, WorldPresets.f_226441_, WorldPresets.f_226442_).map(ResourceKey::m_135782_).map(Object::toString).collect(Collectors.toList())));
                this.add("initial-enabled-packs", ConfigBuilderFactoryProxy.string(""));
                this.add("initial-disabled-packs", ConfigBuilderFactoryProxy.string(""));
                this.add("generator-settings", ConfigBuilderFactoryProxy.string("{}"));
            });
            this.with(ConfigBuilderFactoryProxy.group("resource-pack"), true, () -> {
                this.addFlag("resource-pack", ConfigBuilderFactoryProxy.string(""));
                this.addFlag("resource-pack-sha1", ConfigBuilderFactoryProxy.string(""));
                this.addFlag("require-resource-pack", ConfigBuilderFactoryProxy.yesNo(false));
                this.addFlag("resource-pack-prompt", ConfigBuilderFactoryProxy.string(""));
            });
            this.with(ConfigBuilderFactoryProxy.group("protected"), () -> {
                this.addProtected(MinecraftServerConfigWrapper.EDIT_PROTECTED_PROPERTIES, ConfigBuilderFactoryProxy.enable(false));
                this.addProtected("online-mode", ConfigBuilderFactoryProxy.yesNo(true));
                this.addProtected("prevent-proxy-connections", ConfigBuilderFactoryProxy.yesNo(false));
                this.addProtected("server-ip", ConfigBuilderFactoryProxy.string(""));
                this.addProtected("server-port", ConfigBuilderFactoryProxy.number(25565));
                this.addProtected("enable-query", ConfigBuilderFactoryProxy.yesNo(false));
                this.addProtected("query.port", ConfigBuilderFactoryProxy.number(25565));
                this.addProtected("enable-rcon", ConfigBuilderFactoryProxy.yesNo(false));
                this.addProtected("rcon.port", ConfigBuilderFactoryProxy.number(25575));
                this.addProtected("rcon.password", ConfigBuilderFactoryProxy.string(""));
                this.addProtected("broadcast-rcon-to-ops", ConfigBuilderFactoryProxy.yesNo(true));
                this.addProtected("broadcast-console-to-ops", ConfigBuilderFactoryProxy.yesNo(true));
                this.addProtected("enable-jmx-monitoring", ConfigBuilderFactoryProxy.yesNo(false));
                this.addProtected("text-filtering-config", ConfigBuilderFactoryProxy.string(""));
            });
            this.target.text("protected-disclaimer", new Object[0]);
        }

        private void with(ConfigCategoryBuilder builder, Runnable runnable) {
            ConfigEntryHolderBuilder<?> prev = this.target;
            if (prev != this.builder) {
                throw new IllegalStateException("Categories must be declared at root level");
            }
            this.target = builder;
            runnable.run();
            this.builder.n(builder);
            this.target = prev;
        }

        private void with(ConfigGroupBuilder builder, Runnable runnable) {
            this.with(builder, false, runnable);
        }

        private void with(ConfigGroupBuilder builder, boolean caption, Runnable runnable) {
            ConfigEntryHolderBuilder<?> prev = this.target;
            this.caption = caption;
            this.target = builder;
            runnable.run();
            prev.n(builder);
            this.target = prev;
            this.caption = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addEntry(String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            ConfigEntryHolderBuilder<?> prevTarget = null;
            if (name.contains(".")) {
                AbstractSimpleConfigEntryHolderBuilder t = (AbstractSimpleConfigEntryHolderBuilder)this.target;
                prevTarget = this.target;
                this.target = t.getOrCreateHolderBuilder(name.substring(0, name.lastIndexOf(46)), true);
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            if (this.caption) {
                ConfigEntryHolderBuilder<?> configEntryHolderBuilder = this.target;
                if (!(configEntryHolderBuilder instanceof ConfigGroupBuilder)) throw new IllegalStateException("Cannot add caption outside a group: " + name);
                ConfigGroupBuilder group2 = (ConfigGroupBuilder)configEntryHolderBuilder;
                group2.caption(name, this.castAtom(entryBuilder));
                this.caption = false;
            } else {
                this.target.add(name, entryBuilder);
            }
            if (prevTarget == null) return;
            this.target = prevTarget;
        }

        private <T extends ConfigEntryBuilder<?, ?, ?, ?> & AtomicEntryBuilder> T castAtom(ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            if (!(entryBuilder instanceof AtomicEntryBuilder)) {
                throw new IllegalArgumentException("Entry builder is not atomic: " + entryBuilder.getClass().getCanonicalName());
            }
            return (T)entryBuilder;
        }

        private <T> void add(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder) {
            this.add(name, entryBuilder, null);
        }

        private <T> void addProtected(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder) {
            this.add(name, entryBuilder, null);
        }

        private <T> void addFlag(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder) {
            this.doAdd(name, entryBuilder, null);
        }

        private <T> void add(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder, @Nullable BiConsumer<DedicatedServer, T> applier) {
            if (applier == null) {
                entryBuilder = entryBuilder.restart();
            }
            this.doAdd(name, entryBuilder, applier != null ? (s, t) -> {
                applier.accept((DedicatedServer)s, (Object)t);
                return true;
            } : null);
        }

        private <T> void wrap(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder, @Nullable BiConsumer<DedicatedServer, T> applier) {
            if (applier == null) {
                entryBuilder = entryBuilder.restart();
            }
            this.doAdd(name, entryBuilder, applier != null ? (s, t) -> {
                applier.accept((DedicatedServer)s, (Object)t);
                return false;
            } : null);
        }

        private <T> void doAdd(String name, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder, @Nullable BiFunction<DedicatedServer, T, Boolean> applier) {
            MinecraftServerPropertyEntryDelegate<Object> delegate;
            AbstractConfigEntryBuilder<T, ?, ?, ?, ?, ?> b = MinecraftGameRulesWrapperBuilder.cast(entryBuilder);
            Class<?> typeClass = b.getTypeClass();
            if (typeClass == Boolean.class || typeClass == Integer.class) {
                delegate = new MinecraftServerPropertyEntryDelegate<T>(name, typeClass, b.getValue(), applier);
            } else if (typeClass == String.class) {
                delegate = new MinecraftServerPropertyEntryDelegate<Object>(name, s -> s, t -> (String)t, b.getValue(), applier);
            } else if (typeClass == Long.class) {
                delegate = new MinecraftServerPropertyEntryDelegate<Object>(name, MinecraftGameRulesWrapperBuilder.wrapNumberDeserializer(Long::parseLong), Object::toString, b.getValue(), applier);
            } else if (Enum.class.isAssignableFrom(typeClass)) {
                delegate = new MinecraftServerPropertyEntryDelegate<Object>(name, s -> Arrays.stream(typeClass.getEnumConstants()).map(e -> (Enum)e).filter(e -> e.name().equalsIgnoreCase((String)s)).map(e -> e).findFirst().orElse(null), t -> ((Enum)t).name(), b.getValue(), applier);
            } else {
                throw new IllegalArgumentException("Unsupported server property type: " + typeClass);
            }
            this.delegates.add(delegate);
            this.addEntry(name.replace('.', '-'), (ConfigEntryBuilder<?, ?, ?, ?>)b.withDelegate(delegate));
        }

        private static <T, V extends Number> Function<String, T> wrapNumberDeserializer(Function<String, V> deserializer) {
            return s -> {
                try {
                    return deserializer.apply((String)s);
                }
                catch (NumberFormatException numberformatexception) {
                    return null;
                }
            };
        }

        private void add(GameRules.Key<?> key, BooleanEntryBuilder entryBuilder) {
            AbstractConfigEntryBuilder<Boolean, BooleanEntryBuilder, BooleanEntryBuilder, BooleanEntryBuilder, BooleanEntryBuilder, BooleanEntryBuilder> b = this.patch(key, entryBuilder);
            this.addEntry(key.m_46328_(), b.withDelegate(MinecraftGameRuleEntryDelegate.bool(key)));
        }

        private void add(GameRules.Key<?> key, ConfigEntryBuilder<Integer, ?, ?, ?> entryBuilder) {
            AbstractConfigEntryBuilder<Integer, ?, ?, ?, ?, ?> b = this.patch(key, entryBuilder);
            this.addEntry(key.m_46328_(), (ConfigEntryBuilder<?, ?, ?, ?>)b.withDelegate(MinecraftGameRuleEntryDelegate.integer(key)));
        }

        private <T> AbstractConfigEntryBuilder<T, ?, ?, ?, ?, ?> patch(GameRules.Key<?> key, ConfigEntryBuilder<T, ?, ?, ?> entryBuilder) {
            entryBuilder = (ConfigEntryBuilder)entryBuilder.tooltip(() -> Stream.concat(SimpleConfigTextUtil.optSplitTtc(key.m_46331_() + ".description", new Object[0]).stream(), Stream.of(Component.m_237113_((String)("/gamerule " + key.m_46328_())).m_130940_(ChatFormatting.GRAY))).collect(Collectors.toList()));
            AbstractConfigEntryBuilder<T, ?, ?, ?, ?, ?> b = MinecraftGameRulesWrapperBuilder.cast(entryBuilder);
            return b.translation(key.m_46331_());
        }

        private static <T> AbstractConfigEntryBuilder<T, ?, ?, ?, ?, ?> cast(ConfigEntryBuilder<T, ?, ?, ?> entryBuilder) {
            return (AbstractConfigEntryBuilder)entryBuilder;
        }

        public static class MinecraftGameRuleConfigValueBuilder
        extends SimpleConfigBuilderImpl.ConfigValueBuilder {
            private final ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("minecraft").orElseThrow(() -> new IllegalStateException("Minecraft mod not found"));

            @Override
            public void buildModConfig(SimpleConfigImpl config) {
                config.build(this.modContainer, null);
            }

            @Override
            public void build(AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entryBuilder, AbstractConfigEntry<?, ?, ?> entry) {
            }

            @Override
            public Pair<ForgeConfigSpec, List<ForgeConfigSpec>> build() {
                return null;
            }
        }

        public static class MinecraftServerPropertyEntryDelegate<T>
        implements ConfigEntryDelegate<T> {
            private DedicatedServer server = null;
            private DedicatedServerSettings settings = null;
            private Method Settings$getMutable = null;
            private final String name;
            @Nullable
            private final Class<?> type;
            @Nullable
            private final Function<String, T> deserializer;
            @Nullable
            private final Function<T, String> serializer;
            private final T defValue;
            private final BiFunction<DedicatedServer, T, Boolean> applier;
            private T value;

            public MinecraftServerPropertyEntryDelegate(String name, @NotNull Class<?> type, T defValue, @Nullable BiFunction<DedicatedServer, T, Boolean> applier) {
                this.name = name;
                this.type = type;
                this.deserializer = null;
                this.serializer = null;
                this.defValue = defValue;
                this.applier = applier;
                this.value = defValue;
            }

            public MinecraftServerPropertyEntryDelegate(String name, @NotNull Function<String, T> deserializer, @NotNull Function<T, String> serializer, T defValue, @Nullable BiFunction<DedicatedServer, T, Boolean> applier) {
                this.name = name;
                this.deserializer = deserializer;
                this.serializer = serializer;
                this.type = null;
                this.defValue = defValue;
                this.applier = applier;
                this.value = defValue;
            }

            @OnlyIn(value=Dist.DEDICATED_SERVER)
            public void bind(DedicatedServer server) {
                this.server = server;
                this.settings = (DedicatedServerSettings)ObfuscationReflectionHelper.getPrivateValue(DedicatedServer.class, (Object)server, (String)"f_139604_");
            }

            @Override
            public T getValue() {
                return (T)(this.server != null ? this.getAccessor().get() : this.value);
            }

            @Override
            public void setValue(T value) {
                if (this.server != null) {
                    if (Objects.equals(this.getValue(), value)) {
                        return;
                    }
                    if (this.applier == null || this.applier.apply(this.server, (DedicatedServer)value).booleanValue()) {
                        this.settings.m_139778_(p -> (DedicatedServerProperties)this.getAccessor().m_139895_((RegistryAccess)this.server.m_206579_(), value));
                    }
                } else {
                    this.value = value;
                }
            }

            private Settings.MutableValue<T> getAccessor() {
                if (this.Settings$getMutable == null) {
                    this.Settings$getMutable = this.type == null ? ObfuscationReflectionHelper.findMethod(Settings.class, (String)"m_139868_", (Class[])new Class[]{String.class, Function.class, Function.class, Object.class}) : ObfuscationReflectionHelper.findMethod(Settings.class, (String)"m_139873_", (Class[])new Class[]{String.class, Primitives.unwrap(this.type)});
                    this.Settings$getMutable.setAccessible(true);
                }
                try {
                    return (Settings.MutableValue)(this.type == null ? this.Settings$getMutable.invoke((Object)this.settings.m_139777_(), this.name, this.deserializer, this.serializer, this.defValue) : this.Settings$getMutable.invoke((Object)this.settings.m_139777_(), this.name, this.defValue));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public static class MinecraftGameRuleEntryDelegate<T, V extends GameRules.Value<V>>
        implements ConfigEntryDelegate<T> {
            private final GameRules.Key<V> key;
            private final Function<V, T> getter;
            private final BiConsumer<V, T> setter;
            private T value;

            public static MinecraftGameRuleEntryDelegate<Boolean, GameRules.BooleanValue> bool(GameRules.Key<GameRules.BooleanValue> key) {
                return new MinecraftGameRuleEntryDelegate<Boolean, GameRules.BooleanValue>(key, GameRules.BooleanValue::m_46223_, (v, t) -> v.m_46246_(t.booleanValue(), ServerLifecycleHooks.getCurrentServer()));
            }

            public static MinecraftGameRuleEntryDelegate<Integer, GameRules.IntegerValue> integer(GameRules.Key<GameRules.IntegerValue> key) {
                return new MinecraftGameRuleEntryDelegate<Integer, GameRules.IntegerValue>(key, GameRules.IntegerValue::m_46288_, (v, t) -> v.m_151489_(t.intValue(), ServerLifecycleHooks.getCurrentServer()));
            }

            public MinecraftGameRuleEntryDelegate(GameRules.Key<V> key, Function<V, T> getter, BiConsumer<V, T> setter) {
                this.key = key;
                this.getter = getter;
                this.setter = setter;
            }

            @Override
            public T getValue() {
                return (T)DistExecutor.unsafeRunForDist(() -> () -> this.value, () -> () -> {
                    GameRules rules = ServerLifecycleHooks.getCurrentServer().m_129900_();
                    return this.getter.apply(rules.m_46170_(this.key));
                });
            }

            @Override
            public void setValue(T value) {
                DistExecutor.unsafeRunForDist(() -> () -> {
                    this.value = value;
                    return null;
                }, () -> () -> {
                    if (Objects.equals(this.getValue(), value)) {
                        return null;
                    }
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    GameRules rules = server.m_129900_();
                    GameRules.Value rule = rules.m_46170_(this.key);
                    this.setter.accept((V)rule, (GameRules.Value)value);
                    return null;
                });
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, modid="simpleconfig")
    public static class ServerEventSubscriber {
        @SubscribeEvent
        public static void onServerAboutToStart(ServerAboutToStartEvent event) {
            DedicatedServer server = (DedicatedServer)event.getServer();
            if (binder != null) {
                binder.accept((MinecraftServer)server);
            }
            MinecraftGameRulesWrapperBuilder.MinecraftServerPropertyEntryDelegate<Boolean> delegate = new MinecraftGameRulesWrapperBuilder.MinecraftServerPropertyEntryDelegate<Boolean>(MinecraftServerConfigWrapper.EDIT_PROTECTED_PROPERTIES, Boolean.TYPE, false, null);
            delegate.bind(server);
            delegate.setValue(delegate.getValue());
            if (!delegate.getValue().booleanValue()) {
                MinecraftServerConfigWrapper.removeProtectedProperties();
            }
        }
    }
}

