/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.wrap;

import com.google.common.primitives.Primitives;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigCategoryBuilder;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.ConfigEntryHolderBuilder;
import endorh.simpleconfig.api.ConfigGroupBuilder;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.entry.BooleanEntryBuilder;
import endorh.simpleconfig.api.entry.DoubleEntryBuilder;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.api.entry.OptionEntryBuilder;
import endorh.simpleconfig.api.ui.icon.SimpleConfigIcons;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.SimpleConfigBuilderImpl;
import endorh.simpleconfig.core.SimpleConfigImpl;
import endorh.simpleconfig.core.wrap.ConfigEntryDelegate;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="simpleconfig", bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class MinecraftClientConfigWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MINECRAFT_MODID = "minecraft";
    public static final String OPTIONS_TXT = "options.txt";

    private static void wrapMinecraftOptions() {
        try {
            MinecraftOptionsWrapperBuilder builder = new MinecraftOptionsWrapperBuilder();
            builder.build();
        }
        catch (RuntimeException e) {
            LOGGER.error("Error wrapping Minecraft Client config", (Throwable)e);
            throw e;
        }
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(MinecraftClientConfigWrapper::wrapMinecraftOptions);
    }

    private static class MinecraftOptionsWrapperBuilder {
        private static final Map<String, String> SRG_NAMES = (Map)Util.m_137469_(new HashMap(), m -> {
            m.put("resourcePacks", "f_92117_");
            m.put("incompatibleResourcePacks", "f_92118_");
            m.put("lastServer", "f_92066_");
            m.put("lang", "f_92075_");
            m.put("hideServerAddress", "f_92124_");
            m.put("advancedItemTooltips", "f_92125_");
            m.put("pauseOnLostFocus", "f_92126_");
            m.put("overrideWidth", "f_92128_");
            m.put("overrideHeight", "f_92129_");
            m.put("useNativeTransport", "f_92028_");
            m.put("tutorialStep", "f_92030_");
            m.put("glDebugVerbosity", "f_92035_");
            m.put("skipMultiplayerWarning", "f_92083_");
            m.put("skipRealms32bitWarning", "f_210816_");
            m.put("joinedFirstServer", "f_92031_");
            m.put("hideBundleTutorial", "f_168405_");
            m.put("syncChunkWrites", "f_92076_");
            m.put("modelParts", "f_92108_");
            m.put("sourceVolumes", "f_92109_");
        });
        private final Options options;
        private final SimpleConfigBuilderImpl builder;
        private ConfigEntryHolderBuilder<?> target;
        private boolean caption;
        private final MinecraftConfigValueBuilder vb;
        private static final Method Options$readPackList = ObfuscationReflectionHelper.findMethod(Options.class, (String)"m_168442_", (Class[])new Class[]{String.class});

        private MinecraftOptionsWrapperBuilder() {
            this.options = Minecraft.m_91087_().f_91066_;
            this.target = this.builder = (SimpleConfigBuilderImpl)ConfigBuilderFactoryProxy.config(MinecraftClientConfigWrapper.MINECRAFT_MODID, SimpleConfig.Type.CLIENT);
            this.caption = false;
            this.vb = new MinecraftConfigValueBuilder();
        }

        private void addEntries() {
            Minecraft mc = Minecraft.m_91087_();
            this.with(ConfigBuilderFactoryProxy.category("controls").withIcon(SimpleConfigIcons.MinecraftOptions.CONTROLS).withColor(-2139062032), () -> {
                this.with(ConfigBuilderFactoryProxy.group("mouse", true), () -> {
                    this.wrapDouble((OptionInstance<Double>)this.options.m_231964_());
                    this.wrapBool((OptionInstance<Boolean>)this.options.m_231820_());
                    this.wrapDouble((OptionInstance<Double>)this.options.m_232122_());
                    this.wrapBool((OptionInstance<Boolean>)this.options.m_231821_());
                    this.wrapBool((OptionInstance<Boolean>)this.options.m_231828_());
                    this.wrapBool((OptionInstance<Boolean>)this.options.m_232123_());
                });
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231831_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231832_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231812_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_257871_());
                this.target.add("keyMappings", ConfigBuilderFactoryProxy.button(() -> mc.m_91152_((Screen)new KeyBindsScreen(mc.f_91080_, mc.f_91066_))).label("simpleconfig.ui.open"));
            });
            this.with(ConfigBuilderFactoryProxy.category("graphics").withIcon(SimpleConfigIcons.MinecraftOptions.GRAPHICS).withColor(-2139033440), () -> {
                this.wrapInt((OptionInstance<Integer>)this.options.m_231837_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_231928_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_231984_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_232001_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232018_());
                this.wrapOption(this.options.m_232060_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_231927_());
                this.wrapOption(this.options.m_232070_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_232121_());
                this.wrapOption(this.options.m_232050_());
                this.wrapOption(this.options.m_231929_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231818_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231830_());
                this.wrapOption(this.options.m_232120_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231834_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_232035_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231817_());
                this.wrapOption(this.options.m_232080_());
                this.wrapInt((OptionInstance<Integer>)this.options.m_232119_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_231925_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_231926_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_231924_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_267805_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_267782_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231829_());
                this.wrapInt("overrideWidth", 0);
                this.wrapInt("overrideHeight", 0);
            });
            this.with(ConfigBuilderFactoryProxy.category("sound").withIcon(SimpleConfigIcons.MinecraftOptions.SOUND).withColor(-2131737984), () -> {
                this.with(ConfigBuilderFactoryProxy.group("volume", true), true, () -> {
                    for (SoundSource source : SoundSource.values()) {
                        this.wrapVolume((OptionInstance<Double>)this.options.m_246669_(source));
                    }
                });
                this.wrapOption(this.options.m_231931_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231825_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231826_());
            });
            this.with(ConfigBuilderFactoryProxy.category("chat").withIcon(SimpleConfigIcons.MinecraftOptions.CHAT).withColor(-2137984896), () -> {
                this.wrapOption(this.options.m_232090_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232098_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232104_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231827_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232113_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232117_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232116_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232101_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232110_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231814_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_232118_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231813_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231815_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231816_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231836_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231833_());
            });
            this.with(ConfigBuilderFactoryProxy.category("skin").withIcon(SimpleConfigIcons.MinecraftOptions.SKIN).withColor(-2132746112), () -> {
                this.wrapOption(this.options.m_232107_());
                this.with(ConfigBuilderFactoryProxy.group("modelPart", true), () -> {
                    Set modelParts = (Set)ObfuscationReflectionHelper.getPrivateValue(Options.class, (Object)this.options, (String)SRG_NAMES.get("modelParts"));
                    for (PlayerModelPart part : PlayerModelPart.values()) {
                        this.wrapSetBool(part.m_36446_(), "options.modelPart." + part.m_36446_(), modelParts, part, true);
                    }
                });
            });
            this.with(ConfigBuilderFactoryProxy.category("language").withIcon(SimpleConfigIcons.MinecraftOptions.LANGUAGE).withColor(-2132786464), () -> {
                this.wrapString("lang", "en_us", () -> Minecraft.m_91087_().m_91102_().m_264450_().values().stream().map(LanguageInfo::m_264517_).map(Component::getString).collect(Collectors.toList()));
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231819_());
            });
            this.with(ConfigBuilderFactoryProxy.category("online").withIcon(SimpleConfigIcons.MinecraftOptions.ONLINE).withColor(-2131713920), () -> {
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231823_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231822_());
            });
            this.with(ConfigBuilderFactoryProxy.category("accessibility").withIcon(SimpleConfigIcons.MinecraftOptions.ACCESSIBILITY).withColor(-2132745985), () -> {
                this.wrapOption(this.options.m_231930_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_264038_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_274330_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231935_());
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231838_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_245201_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_269326_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_267805_());
                this.wrapDouble((OptionInstance<Double>)this.options.m_267782_());
            });
            this.with(ConfigBuilderFactoryProxy.category("advanced").withIcon(SimpleConfigIcons.MinecraftOptions.ADVANCED), () -> {
                this.wrapBool((OptionInstance<Boolean>)this.options.m_261324_(), b -> (BooleanEntryBuilder)b.editable(() -> ((Minecraft)mc).m_261210_()));
                this.wrapBool((OptionInstance<Boolean>)this.options.m_231824_());
                this.wrapBool("pauseOnLostFocus", true);
                this.wrapBool("advancedItemTooltips", false);
                this.wrapBool("hideServerAddress", false);
                this.wrapBool("syncChunkWrites", Util.m_137581_() == Util.OS.WINDOWS);
                this.wrapBool("useNativeTransport", true);
                this.wrapInt("glDebugVerbosity", 1);
                this.wrapEnum("tutorialStep", TutorialSteps.MOVEMENT);
                this.wrapBool("hideBundleTutorial", false);
                this.wrapBool("skipMultiplayerWarning", false);
                this.wrapBool("skipRealms32bitWarning", false);
                this.wrapString("lastServer", "");
                this.wrapBool("joinedFirstServer", false);
                this.target.add("credits_and_attribution", MinecraftOptionsWrapperBuilder.cast(ConfigBuilderFactoryProxy.button(() -> mc.m_91152_((Screen)new CreditsAndAttributionScreen(mc.f_91080_))).label("simpleconfig.ui.open")).translation("options.credits_and_attribution"));
            });
        }

        public SimpleConfig build() {
            try {
                this.addEntries();
                this.builder.withGUIDecorator((s, b) -> b.getCategories(SimpleConfig.EditType.CLIENT).forEach(c -> c.setContainingFile(new File(Minecraft.m_91087_().f_91069_, MinecraftClientConfigWrapper.OPTIONS_TXT).toPath().normalize())));
                return this.builder.buildAndRegister(null, this.vb);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)e);
                throw e;
            }
        }

        private void with(ConfigCategoryBuilder builder, Runnable runnable) {
            ConfigEntryHolderBuilder<?> prev = this.target;
            if (prev != this.builder) {
                throw new IllegalStateException("Categories must be declared at root level");
            }
            this.caption = false;
            this.target = builder;
            runnable.run();
            this.builder.n(builder);
            this.target = prev;
        }

        private void with(ConfigGroupBuilder builder, Runnable runnable) {
            this.with(builder, false, runnable);
        }

        private void with(ConfigGroupBuilder builder, boolean caption, Runnable runnable) {
            ConfigEntryHolderBuilder<?> prev = this.target;
            this.caption = caption;
            this.target = builder;
            runnable.run();
            prev.n(builder);
            this.target = prev;
            this.caption = false;
        }

        private void wrapInt(OptionInstance<Integer> opt) {
            OptionInstance.ValueSet values = opt.m_231555_();
            if (values instanceof OptionInstance.IntRange) {
                OptionInstance.IntRange range = (OptionInstance.IntRange)values;
                IntegerEntryBuilder b = (IntegerEntryBuilder)ConfigBuilderFactoryProxy.number(MinecraftOptionsWrapperBuilder.getInitialValue(opt)).range(range.m_214123_(), range.m_214118_()).slider(MinecraftOptionsWrapperBuilder.getSliderLabelProvider(opt));
                this.add(opt, b);
            } else if (values instanceof OptionInstance.ClampingLazyMaxIntRange) {
                OptionInstance.ClampingLazyMaxIntRange range = (OptionInstance.ClampingLazyMaxIntRange)values;
                OptionEntryBuilder<Integer> bb = ConfigBuilderFactoryProxy.option(Integer.valueOf(0), () -> IntStream.range(0, range.m_214118_() + 1).boxed().toList()).withDisplay(MinecraftOptionsWrapperBuilder.getSliderLabelProvider(opt));
                this.add(opt, bb);
            } else if (values instanceof OptionInstance.SliderableValueSet) {
                OptionInstance.SliderableValueSet set = (OptionInstance.SliderableValueSet)values;
                IntegerEntryBuilder b = (IntegerEntryBuilder)((IntegerEntryBuilder)ConfigBuilderFactoryProxy.number(MinecraftOptionsWrapperBuilder.getInitialValue(opt)).range((Integer)set.m_213729_(0.0), (Integer)set.m_213729_(1.0))).slider(MinecraftOptionsWrapperBuilder.getSliderLabelProvider(opt));
                this.add(opt, b);
            }
        }

        private void wrapDouble(OptionInstance<Double> opt) {
            this.wrapDouble(opt, null);
        }

        private void wrapDouble(OptionInstance<Double> opt, DoubleEntryBuilder builder) {
            DoubleEntryBuilder b = builder != null ? (DoubleEntryBuilder)builder.withValue(MinecraftOptionsWrapperBuilder.getInitialValue(opt)) : ConfigBuilderFactoryProxy.number(MinecraftOptionsWrapperBuilder.getInitialValue(opt));
            OptionInstance.ValueSet values = opt.m_231555_();
            if (values instanceof OptionInstance.UnitDouble) {
                OptionInstance.UnitDouble unit = (OptionInstance.UnitDouble)values;
                b = (DoubleEntryBuilder)b.range(0.0, 1.0).slider(MinecraftOptionsWrapperBuilder.getSliderLabelProvider(opt));
            } else if (values instanceof OptionInstance.SliderableValueSet) {
                OptionInstance.SliderableValueSet set = (OptionInstance.SliderableValueSet)values;
                b = (DoubleEntryBuilder)((DoubleEntryBuilder)b.range((Double)set.m_213729_(0.0), (Double)set.m_213729_(1.0))).slider(MinecraftOptionsWrapperBuilder.getSliderLabelProvider(opt));
            }
            this.add(opt, b);
        }

        private void wrapVolume(OptionInstance<Double> opt) {
            this.wrapDouble(opt, ConfigBuilderFactoryProxy.volume(1.0));
        }

        private <T> void wrapOption(OptionInstance<T> opt) {
            OptionInstance.ValueSet values = opt.m_231555_();
            T initial = MinecraftOptionsWrapperBuilder.getInitialValue(opt);
            if (values instanceof OptionInstance.LazyEnum) {
                OptionInstance.LazyEnum le = (OptionInstance.LazyEnum)values;
                OptionEntryBuilder<T> b = ConfigBuilderFactoryProxy.option(initial, () -> ((CycleButton.ValueListSupplier)le.m_213889_()).m_142477_()).withCodec(le.m_213664_()).withDisplay(MinecraftOptionsWrapperBuilder.getStringifier(opt));
                this.add(opt, b);
            } else if (values instanceof OptionInstance.Enum) {
                OptionInstance.Enum e = (OptionInstance.Enum)values;
                OptionEntryBuilder<T> b = ConfigBuilderFactoryProxy.option(initial, e.f_231625_()).withCodec(e.m_213664_()).withDisplay(MinecraftOptionsWrapperBuilder.getStringifier(opt));
                this.add(opt, b);
            } else if (values instanceof OptionInstance.AltEnum) {
                OptionInstance.AltEnum e = (OptionInstance.AltEnum)values;
                OptionEntryBuilder<T> b = ConfigBuilderFactoryProxy.option(initial, e.m_213889_().m_142477_()).withCodec(e.m_213664_()).withDisplay(MinecraftOptionsWrapperBuilder.getStringifier(opt));
                this.add(opt, b);
            }
        }

        private void wrapBool(OptionInstance<Boolean> opt, Function<BooleanEntryBuilder, BooleanEntryBuilder> modifier) {
            Function<Boolean, Component> stringifier = MinecraftOptionsWrapperBuilder.getStringifier(opt);
            this.add(opt, (ConfigEntryBuilder)modifier.apply(ConfigBuilderFactoryProxy.bool(MinecraftOptionsWrapperBuilder.getInitialValue(opt)).text(b -> MinecraftOptionsWrapperBuilder.patchBoolean((Component)stringifier.apply(b)))));
        }

        private void wrapBool(OptionInstance<Boolean> opt) {
            this.wrapBool(opt, b -> b);
        }

        private static Component patchBoolean(Component c) {
            if ("OFF".equals(c.getString()) && c.m_7383_().m_131179_()) {
                return c.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xFF4242));
            }
            if ("ON".equals(c.getString()) && c.m_7383_().m_131179_()) {
                return c.m_6881_().m_130940_(ChatFormatting.GREEN);
            }
            return c;
        }

        private void wrapBool(String name, boolean def) {
            this.add(name, ConfigBuilderFactoryProxy.bool(def));
        }

        private void wrapInt(String name, int def) {
            this.add(name, ConfigBuilderFactoryProxy.number(def));
        }

        private void wrapDouble(String name, double def) {
            this.add(name, ConfigBuilderFactoryProxy.number(def));
        }

        private void wrapFloat(String name, float def) {
            this.add(name, ConfigBuilderFactoryProxy.number(def));
        }

        private void wrapString(String name, String def) {
            this.add(name, ConfigBuilderFactoryProxy.string(def));
        }

        private void wrapString(String name, String def, Supplier<List<String>> suggestions) {
            this.add(name, ConfigBuilderFactoryProxy.string(def).suggest(suggestions));
        }

        private <V extends Enum<V>> void wrapEnum(String name, V val) {
            this.add(name, ConfigBuilderFactoryProxy.option(val));
        }

        private <V> void wrapSetBool(String name, Set<V> set, V value, boolean defValue) {
            this.wrapSetBool(name, null, set, value, defValue);
        }

        private <V> void wrapSetBool(String name, @Nullable String translation, Set<V> set, V value, boolean defValue) {
            ConfigEntryBuilder b = MinecraftOptionsWrapperBuilder.cast(ConfigBuilderFactoryProxy.bool(defValue));
            b = b.withDelegate(new MinecraftSetBoolDelegate<V>(set, value));
            if (translation != null) {
                b = b.translation(translation);
            }
            this.addEntry(name, b);
        }

        private <K, V> void wrapMapValue(String name, Map<K, V> map, K key, ConfigEntryBuilder<V, ?, ?, ?> entryBuilder) {
            this.wrapMapValue(name, null, map, key, entryBuilder);
        }

        private <K, V> void wrapMapValue(String name, @Nullable String translation, Map<K, V> map, K key, ConfigEntryBuilder<V, ?, ?, ?> entryBuilder) {
            Object b = MinecraftOptionsWrapperBuilder.cast(entryBuilder);
            b = ((AbstractConfigEntryBuilder)b).withDelegate(new MinecraftMapValueDelegate<K, V>(map, key, ((AbstractConfigEntryBuilder)b).getValue()));
            if (translation != null) {
                b = ((AbstractConfigEntryBuilder)b).translation(translation);
            }
            this.addEntry(name, (ConfigEntryBuilder<?, ?, ?, ?>)b);
        }

        private <V> void add(String name, ConfigEntryBuilder<V, ?, ?, ?> entryBuilder) {
            String srgName = SRG_NAMES.get(name);
            if (srgName == null) {
                throw new IllegalArgumentException("No SRG name for Minecraft option field: " + name);
            }
            Field field = ObfuscationReflectionHelper.findField(Options.class, (String)srgName);
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Minecraft option field cannot be static: " + name);
            }
            if (!Primitives.wrap(field.getType()).isInstance(entryBuilder.getValue())) {
                throw new IllegalArgumentException("Minecraft option field type does not match: " + name + ": " + field.getType() + " </- " + entryBuilder.getValue().getClass());
            }
            AbstractConfigEntryBuilder<V, Object, Object, Object, Object, Object> b = MinecraftOptionsWrapperBuilder.cast(entryBuilder);
            b = b.withDelegate(new MinecraftFieldOptionEntryDelegate<V>(this.options, field, entryBuilder.getValue()));
            this.addEntry(name, b);
        }

        private <V> void add(OptionInstance<V> opt, ConfigEntryBuilder<V, ?, ?, ?> entryBuilder) {
            OptionInstance.TooltipSupplier tooltipSupplier = this.getTooltip(opt);
            entryBuilder = (ConfigEntryBuilder)entryBuilder.tooltip(v -> Optional.ofNullable(tooltipSupplier.m_257630_(v)).map(t -> t.m_257408_(Minecraft.m_91087_())).orElseGet(Collections::emptyList).stream().map(SimpleConfigTextUtil::asComponent).collect(Collectors.toList()));
            AbstractConfigEntryBuilder<V, Object, Object, Object, Object, Object> b = MinecraftOptionsWrapperBuilder.cast(entryBuilder);
            b = ((AbstractConfigEntryBuilder)b.translation(this.getName(opt))).withDelegate(new MinecraftOptionEntryDelegate<V>(opt));
            this.addEntry(this.getID(opt), b);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addEntry(String name, ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            try {
                if (this.caption) {
                    ConfigEntryHolderBuilder<?> configEntryHolderBuilder = this.target;
                    if (!(configEntryHolderBuilder instanceof ConfigGroupBuilder)) throw new IllegalStateException("Cannot add caption outside a group: " + name);
                    ConfigGroupBuilder group2 = (ConfigGroupBuilder)configEntryHolderBuilder;
                    group2.caption(name, this.castAtom(entryBuilder));
                    this.caption = false;
                    return;
                } else {
                    this.target.add(name, entryBuilder);
                }
                return;
            }
            catch (RuntimeException e) {
                LOGGER.error("Error wrapping Minecraft option: " + name, (Throwable)e);
            }
        }

        private <T extends ConfigEntryBuilder<?, ?, ?, ?> & AtomicEntryBuilder> T castAtom(ConfigEntryBuilder<?, ?, ?, ?> entryBuilder) {
            if (!(entryBuilder instanceof AtomicEntryBuilder)) {
                throw new IllegalArgumentException("Entry builder is not atomic: " + entryBuilder.getClass().getCanonicalName());
            }
            return (T)entryBuilder;
        }

        private static <V> AbstractConfigEntryBuilder<V, ?, ?, ?, ?, ?> cast(ConfigEntryBuilder<V, ?, ?, ?> builder) {
            return (AbstractConfigEntryBuilder)builder;
        }

        private Component getCaption(OptionInstance<?> opt) {
            return (Component)ObfuscationReflectionHelper.getPrivateValue(OptionInstance.class, opt, (String)"f_231480_");
        }

        private <V> OptionInstance.TooltipSupplier<V> getTooltip(OptionInstance<V> opt) {
            return (OptionInstance.TooltipSupplier)ObfuscationReflectionHelper.getPrivateValue(OptionInstance.class, opt, (String)"f_231474_");
        }

        private String getName(OptionInstance<?> opt) {
            String string;
            Component caption = this.getCaption(opt);
            ComponentContents componentContents = caption.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents c = (TranslatableContents)componentContents;
                string = c.m_237508_();
            } else {
                string = caption.getString();
            }
            return string;
        }

        private String getID(OptionInstance<?> opt) {
            return this.getName(opt).replace("options.", "").replace('.', '_');
        }

        private static <T> T getInitialValue(OptionInstance<T> opt) {
            return (T)ObfuscationReflectionHelper.getPrivateValue(OptionInstance.class, opt, (String)"f_231478_");
        }

        private static <T> Function<T, Component> getStringifier(OptionInstance<T> opt) {
            return (Function)ObfuscationReflectionHelper.getPrivateValue(OptionInstance.class, opt, (String)"f_231475_");
        }

        private static <T> Function<T, Component> getSliderLabelProvider(OptionInstance<T> opt) {
            Function str = MinecraftOptionsWrapperBuilder.getStringifier(opt);
            return v -> {
                Component a = (Component)str.apply(v);
                ComponentContents contents = a.m_214077_();
                if (contents instanceof TranslatableContents) {
                    TranslatableContents tc = (TranslatableContents)contents;
                    Object[] args = tc.m_237523_();
                    if (args.length >= 2) {
                        Object first = args[1];
                        if (first instanceof Component) {
                            return (Component)first;
                        }
                        return Component.m_237113_((String)String.valueOf(first));
                    }
                    return a;
                }
                return a;
            };
        }

        private static List<String> readPackList(String packList) {
            try {
                return (List)Options$readPackList.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static class MinecraftConfigValueBuilder
        extends SimpleConfigBuilderImpl.ConfigValueBuilder {
            private final ModContainer modContainer = (ModContainer)ModList.get().getModContainerById("minecraft").orElseThrow(() -> new IllegalStateException("Minecraft mod not found"));

            @Override
            public void buildModConfig(SimpleConfigImpl config) {
                config.build(this.modContainer, null);
            }

            @Override
            public void build(AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> entryBuilder, AbstractConfigEntry<?, ?, ?> entry) {
            }

            @Override
            public Pair<ForgeConfigSpec, List<ForgeConfigSpec>> build() {
                return null;
            }
        }
    }

    public static class MinecraftMapValueDelegate<K, V>
    implements ConfigEntryDelegate<V> {
        private final Map<K, V> map;
        private final K key;
        private final V defValue;

        public MinecraftMapValueDelegate(Map<K, V> map, K key, V defValue) {
            this.map = map;
            this.key = key;
            this.defValue = defValue;
        }

        @Override
        public V getValue() {
            return this.map.getOrDefault(this.key, this.defValue);
        }

        @Override
        public void setValue(V value) {
            if (Objects.equals(this.map.get(this.key), value)) {
                return;
            }
            this.map.put(this.key, value);
            Minecraft.m_91087_().f_91066_.m_92169_();
        }
    }

    public static class MinecraftSetBoolDelegate<V>
    implements ConfigEntryDelegate<Boolean> {
        private final Set<V> set;
        private final V value;

        public MinecraftSetBoolDelegate(Set<V> set, V value) {
            this.set = set;
            this.value = value;
        }

        @Override
        public Boolean getValue() {
            return this.set.contains(this.value);
        }

        @Override
        public void setValue(Boolean value) {
            if (this.set.contains(this.value) == value.booleanValue()) {
                return;
            }
            if (value.booleanValue()) {
                this.set.add(this.value);
            } else {
                this.set.remove(this.value);
            }
            Minecraft.m_91087_().f_91066_.m_92169_();
        }
    }

    public static class MinecraftFieldOptionEntryDelegate<V>
    implements ConfigEntryDelegate<V> {
        private final Options options;
        private final Field field;
        private final V defValue;

        public MinecraftFieldOptionEntryDelegate(Options options, Field field, V defValue) {
            this.options = options;
            this.field = field;
            this.defValue = defValue;
        }

        @Override
        public V getValue() {
            try {
                return (V)this.field.get(this.options);
            }
            catch (IllegalAccessException e) {
                return this.defValue;
            }
        }

        @Override
        public void setValue(V value) {
            if (Objects.equals(this.getValue(), value)) {
                return;
            }
            try {
                this.field.set(this.options, value);
                Minecraft.m_91087_().f_91066_.m_92169_();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static class MinecraftOptionEntryDelegate<V>
    implements ConfigEntryDelegate<V> {
        private final OptionInstance<V> option;

        public MinecraftOptionEntryDelegate(OptionInstance<V> option) {
            this.option = option;
        }

        @Override
        public V getValue() {
            return (V)this.option.m_231551_();
        }

        @Override
        public void setValue(V value) {
            if (Objects.equals(this.getValue(), value)) {
                return;
            }
            this.option.m_231514_(value);
            Minecraft.m_91087_().f_91066_.m_92169_();
        }
    }
}

