/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.wrap;

import endorh.simpleconfig.core.entry.BeanProxy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MapProxy
implements BeanProxy<Map<String, Object>> {
    private final Map<String, BeanProxy.IBeanGuiAdapter> adapters;

    public MapProxy(Map<String, BeanProxy.IBeanGuiAdapter> adapters) {
        this.adapters = adapters;
    }

    @Override
    public Map<String, Object> create(@Nullable Map<String, Object> properties) {
        return properties == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap<String, Object>(properties);
    }

    @Override
    public Map<String, Object> createFrom(Map<String, Object> def, @Nullable Map<String, Object> properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(def);
        if (properties != null) {
            map.putAll(properties);
        }
        return map;
    }

    @Override
    public Map<String, Object> createFromGUI(Map<String, Object> def, @Nullable Map<String, Object> properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(def);
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                BeanProxy.IBeanGuiAdapter adapter = this.adapters.get(entry.getKey());
                if (adapter != null) {
                    map.put(entry.getKey(), adapter.fromGui(entry.getValue()));
                    continue;
                }
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    @Override
    public Object get(Map<String, Object> bean, String name) {
        return bean.get(name);
    }

    @Override
    public Object getGUI(Map<String, Object> bean, String name) {
        BeanProxy.IBeanGuiAdapter adapter = this.adapters.get(name);
        return adapter != null ? adapter.forGui(bean.get(name)) : bean.get(name);
    }

    @Override
    public String getTypeName() {
        return Map.class.getCanonicalName();
    }

    @Override
    public String getPropertyName(String name) {
        return "Map[" + name + "]";
    }

    @Override
    public String getTypeTranslation() {
        return Map.class.getSimpleName();
    }

    @Override
    public String getTranslation(String property) {
        return property;
    }
}

