/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.reflection;

import endorh.simpleconfig.core.EntryType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public interface FieldTypeFilter {
    public static FieldTypeFilter matching(EntryType<?> type) {
        return new EntryTypeFieldTypeFilter(type);
    }

    public static FieldTypeFilter subClasses(Class<?> superClass) {
        return new SubClassFieldTypeFilter(superClass);
    }

    public static FieldTypeFilter annotated(Class<? extends Annotation> annotation) {
        return new AnnotationFieldTypeFilter(annotation);
    }

    default public boolean isApplicable(Field field) {
        return this.isApplicable(field.getType());
    }

    public boolean isApplicable(Type var1);

    default public boolean isApplicable(AnnotatedType type) {
        return this.isApplicable(type.getType());
    }

    public static class EntryTypeFieldTypeFilter
    implements FieldTypeFilter {
        private final EntryType<?> type;

        public EntryTypeFieldTypeFilter(EntryType<?> type) {
            this.type = type;
        }

        @Override
        public boolean isApplicable(Field field) {
            return this.type.matches(EntryType.fromField(field));
        }

        @Override
        public boolean isApplicable(Type type) {
            return this.type.matches(EntryType.fromType(type));
        }
    }

    public static class SubClassFieldTypeFilter
    implements FieldTypeFilter {
        private final Class<?> superClass;

        public SubClassFieldTypeFilter(Class<?> superClass) {
            this.superClass = superClass;
        }

        @Override
        public boolean isApplicable(Type type) {
            if (!(type instanceof Class)) {
                return false;
            }
            Class c = (Class)type;
            return this.superClass.isAssignableFrom(c);
        }
    }

    public static class AnnotationFieldTypeFilter
    implements FieldTypeFilter {
        private final Class<? extends Annotation> annotation;

        public AnnotationFieldTypeFilter(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean isApplicable(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType t = (ParameterizedType)type;
                type = t.getRawType();
            }
            if (!(type instanceof Class)) {
                return false;
            }
            Class c = (Class)type;
            return c.isAnnotationPresent(this.annotation);
        }
    }
}

