/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.reflection;

import com.google.common.collect.Lists;
import endorh.simpleconfig.api.AtomicEntryBuilder;
import endorh.simpleconfig.api.ConfigBuilderFactoryProxy;
import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.api.EntryTag;
import endorh.simpleconfig.api.SimpleConfig;
import endorh.simpleconfig.api.SimpleConfigTextUtil;
import endorh.simpleconfig.api.annotation.Advanced;
import endorh.simpleconfig.api.annotation.Bake;
import endorh.simpleconfig.api.annotation.Bean;
import endorh.simpleconfig.api.annotation.Configure;
import endorh.simpleconfig.api.annotation.Default;
import endorh.simpleconfig.api.annotation.Error;
import endorh.simpleconfig.api.annotation.Experimental;
import endorh.simpleconfig.api.annotation.HasAlpha;
import endorh.simpleconfig.api.annotation.Length;
import endorh.simpleconfig.api.annotation.Linked;
import endorh.simpleconfig.api.annotation.Max;
import endorh.simpleconfig.api.annotation.Min;
import endorh.simpleconfig.api.annotation.NonPersistent;
import endorh.simpleconfig.api.annotation.Operator;
import endorh.simpleconfig.api.annotation.RequireRestart;
import endorh.simpleconfig.api.annotation.Size;
import endorh.simpleconfig.api.annotation.Slider;
import endorh.simpleconfig.api.annotation.Suggest;
import endorh.simpleconfig.api.entry.ByteEntryBuilder;
import endorh.simpleconfig.api.entry.CaptionedCollectionEntryBuilder;
import endorh.simpleconfig.api.entry.CollectionEntryBuilder;
import endorh.simpleconfig.api.entry.ColorEntryBuilder;
import endorh.simpleconfig.api.entry.DoubleEntryBuilder;
import endorh.simpleconfig.api.entry.EntryMapEntryBuilder;
import endorh.simpleconfig.api.entry.EntryPairListEntryBuilder;
import endorh.simpleconfig.api.entry.EntrySetEntryBuilder;
import endorh.simpleconfig.api.entry.FloatEntryBuilder;
import endorh.simpleconfig.api.entry.IntegerEntryBuilder;
import endorh.simpleconfig.api.entry.ListEntryBuilder;
import endorh.simpleconfig.api.entry.LongEntryBuilder;
import endorh.simpleconfig.api.entry.RangedEntryBuilder;
import endorh.simpleconfig.api.entry.ShortEntryBuilder;
import endorh.simpleconfig.api.entry.StringEntryBuilder;
import endorh.simpleconfig.api.range.DoubleRange;
import endorh.simpleconfig.api.range.FloatRange;
import endorh.simpleconfig.api.range.IntRange;
import endorh.simpleconfig.api.range.LongRange;
import endorh.simpleconfig.api.ui.hotkey.KeyBindMapping;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.DummyEntryHolder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.ReflectionUtil;
import endorh.simpleconfig.core.SimpleConfigClassParser;
import endorh.simpleconfig.core.reflection.BindingContext;
import endorh.simpleconfig.core.reflection.EntryTypeData;
import endorh.simpleconfig.core.reflection.FieldBuilderDecorator;
import endorh.simpleconfig.core.reflection.FieldEntryBuilder;
import endorh.simpleconfig.core.reflection.FieldTypeFilter;
import endorh.simpleconfig.core.reflection.FieldTypeParser;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldParser {
    private static final List<FieldTypeParser<?>> PARSERS = Collections.synchronizedList(new ArrayList());
    private static final List<FieldBuilderDecorator<?>> DECORATORS = Collections.synchronizedList(new ArrayList());
    private static final BindingContext.ReturnTypeAdapter<?, Optional<Component>>[] ERROR_TYPE_ADAPTERS;
    private static final BindingContext.ReturnTypeAdapter<?, List<Component>>[] TOOLTIP_TYPE_ADAPTERS;

    private static void registerFieldTypeParsers() {
        FieldParser.reg(FieldParser.t(Boolean.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.bool(o.orElse(false)));
        FieldParser.reg(FieldParser.t(Byte.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse((byte)0)));
        FieldParser.reg(FieldParser.t(Short.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse((short)0)));
        FieldParser.reg(FieldParser.t(Integer.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse(0)));
        FieldParser.reg(FieldParser.t(Long.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse(0L)));
        FieldParser.reg(FieldParser.t(Float.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse(Float.valueOf(0.0f)).floatValue()));
        FieldParser.reg(FieldParser.t(Double.TYPE), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.number(o.orElse(0.0)));
        FieldParser.reg(FieldParser.t(String.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.string(o.orElse("")));
        FieldParser.reg(FieldTypeFilter.subClasses(Enum.class), (EntryTypeData a, Class<?> c, Optional<V> o) -> FieldParser.makeEnum(o.or(() -> Arrays.stream(c.getEnumConstants()).findFirst()).orElseThrow(() -> new IllegalStateException("Enum class has no enum constants"))));
        FieldParser.reg(FieldParser.t(IntRange.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.range(o.orElse(IntRange.UNIT)));
        FieldParser.reg(FieldParser.t(LongRange.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.range(o.orElse(LongRange.UNIT)));
        FieldParser.reg(FieldParser.t(FloatRange.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.range(o.orElse(FloatRange.UNIT)));
        FieldParser.reg(FieldParser.t(DoubleRange.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.range(o.orElse(DoubleRange.UNIT)));
        FieldParser.reg(FieldParser.t(Color.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.color(o.orElse(Color.BLACK)));
        FieldParser.reg(FieldParser.t(Pattern.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.pattern(o.orElse(Pattern.compile(""))));
        FieldParser.reg(FieldParser.t(Tag.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.tag((Tag)o.orElse(ByteTag.m_128273_((boolean)false))));
        FieldParser.reg(FieldParser.t(CompoundTag.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.compoundTag(o.orElse(new CompoundTag())));
        FieldParser.reg(FieldParser.t(ResourceLocation.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.resource(o.orElse(new ResourceLocation(""))));
        FieldParser.reg(FieldParser.t(KeyBindMapping.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.key(o.orElse(KeyBindMapping.unset())));
        FieldParser.reg(FieldParser.t(Item.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.item(o.orElse(Items.f_41852_)));
        FieldParser.reg(FieldParser.t(Block.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.block(o.orElse(Blocks.f_50016_)));
        FieldParser.reg(FieldParser.t(Fluid.class), (EntryTypeData d, Optional<V> o) -> ConfigBuilderFactoryProxy.fluid(o.orElse(Fluids.f_76191_)));
        FieldParser.reg(EntryType.of(List.class, EntryType.unchecked(Pair.class)), (BindingContext ctx, EntryTypeData d, AnnotatedType at, Type t, Class<?> c, Optional<V> o) -> {
            AnnotatedParameterizedType apt = FieldParser.requireParameterized(d, at);
            AnnotatedType tt = apt.getAnnotatedActualTypeArguments()[0];
            AnnotatedParameterizedType pt = FieldParser.requireParameterized(d, tt);
            ConfigEntryBuilder<?, ?, ?, ?>[] args = FieldParser.parseSubTypes(ctx, d, pt, "k", "v");
            return FieldParser.makePairList(args[0], args[1], o.orElse(Collections.emptyList()));
        });
        FieldParser.rec(FieldParser.t(List.class), (ctx, d, sub, t, c, o) -> FieldParser.makeList(sub[0], o.orElse(Collections.emptyList())), "v");
        FieldParser.rec(FieldParser.t(Set.class), (ctx, d, sub, t, c, o) -> FieldParser.makeSet(sub[0], o.orElse(Collections.emptySet())), "v");
        FieldParser.rec(FieldParser.t(Map.class), (ctx, d, sub, t, c, o) -> FieldParser.makeMap(sub[0], sub[1], o.orElse(Collections.emptyMap())), "k", "v");
        FieldParser.rec(EntryType.of(Pair.class, EntryType.wildcard(), EntryType.unchecked(List.class)), (ctx, d, sub, t, c, o) -> FieldParser.makeCaptionedList(sub[0], sub[1], o.orElse(null)), "caption", "list");
        FieldParser.rec(EntryType.of(Pair.class, EntryType.wildcard(), EntryType.unchecked(Set.class)), (ctx, d, sub, t, c, o) -> FieldParser.makeCaptionedSet(sub[0], sub[1], o.orElse(null)), "caption", "set");
        FieldParser.rec(EntryType.of(Pair.class, EntryType.wildcard(), EntryType.unchecked(Map.class)), (ctx, d, sub, t, c, o) -> FieldParser.makeCaptionedMap(sub[0], sub[1], o.orElse(null)), "caption", "map");
        FieldParser.rec(EntryType.of(Pair.class, EntryType.wildcard(), EntryType.of(List.class, EntryType.unchecked(Pair.class))), (ctx, d, sub, t, c, o) -> FieldParser.makeCaptionedPairList(sub[0], sub[1], o.orElse(null)), "caption", "list");
        FieldParser.rec(FieldParser.t(Pair.class), (ctx, d, sub, t, c, o) -> FieldParser.makePair(sub[0], sub[1], o.orElse(Pair.of(sub[0].getValue(), sub[1].getValue()))), "l", "r");
        FieldParser.rec(FieldParser.t(Triple.class), (ctx, d, sub, t, c, o) -> FieldParser.makeTriple(sub[0], sub[1], sub[2], o.orElse(Triple.of(sub[0].getValue(), sub[1].getValue(), sub[2].getValue()))), "l", "m", "r");
        FieldParser.reg(FieldTypeFilter.annotated(Bean.class), (EntryTypeData a, Class<?> c, Optional<V> o) -> {
            try {
                Object v;
                if (o.isEmpty()) {
                    Constructor constructor = c.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    try {
                        v = constructor.newInstance(new Object[0]);
                    }
                    catch (RuntimeException e) {
                        throw new UnsupportedConfigEntryFieldTypeException(a, "Error instantiating bean of type: " + c.getCanonicalName(), (Exception)e);
                    }
                } else {
                    v = o.get();
                }
                return ConfigBuilderFactoryProxy.bean(v);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new UnsupportedConfigEntryFieldTypeException(a, "Failed to instantiate bean: " + c.getCanonicalName() + "\n  Ensure your bean class has an accessible default constructor", (Exception)e);
            }
        });
    }

    private static void registerFieldTypeDecorators() {
        FieldParser.dec(ConfigEntryBuilder.class, RequireRestart.class, (A a, B b) -> b.restart(a.value()));
        FieldParser.dec(ConfigEntryBuilder.class, NonPersistent.class, (A a, B b) -> b.temp(a.value()));
        FieldParser.dec(ConfigEntryBuilder.class, Experimental.class, (A a, B b) -> b.experimental(a.value()));
        FieldParser.dec(ConfigEntryBuilder.class, Advanced.class, (A a, B b) -> b.withTags(a.value(), EntryTag.ADVANCED));
        FieldParser.dec(ConfigEntryBuilder.class, Operator.class, (A a, B b) -> b.withTags(a.value(), EntryTag.OPERATOR));
        FieldParser.dec(RangedEntryBuilder.class, Min.class, (A a, B b) -> b.min((Comparable)FieldParser.adapt(b.getClass(), a.value())));
        FieldParser.dec(RangedEntryBuilder.class, Max.class, (A a, B b) -> b.max((Comparable)FieldParser.adapt(b.getClass(), a.value())));
        FieldParser.dec(RangedEntryBuilder.class, (d, b) -> d.get(Slider.class).map(a -> {
            Double max;
            Object bb = a.label().isEmpty() ? b.slider() : b.slider(a.label());
            Optional<RangedEntryBuilder.InvertibleDouble2DoubleFunction> o = Slider.SliderType.fromAnnotation(a);
            if (o.isPresent()) {
                bb = bb.sliderMap(o.get());
            }
            Double min = Double.isNaN(a.min()) ? null : Double.valueOf(a.min());
            Double d = max = Double.isNaN(a.max()) ? null : Double.valueOf(a.max());
            if (min != null || max != null) {
                Class<?> c = b.getClass();
                bb = bb.sliderRange((min != null ? (Comparable)FieldParser.adapt(c, min) : null), max != null ? (Comparable)FieldParser.adapt(c, max) : null);
            }
            return bb;
        }).orElse((RangedEntryBuilder)b));
        FieldParser.dec(FloatEntryBuilder.class, Bake.Scale.class, (A a, B b) -> ((FloatEntryBuilder)b.withValue(Float.valueOf(((Float)b.getValue()).floatValue() / (float)a.value()))).bakeScale((float)a.value()));
        FieldParser.dec(DoubleEntryBuilder.class, Bake.Scale.class, (A a, B b) -> ((DoubleEntryBuilder)b.withValue((Double)b.getValue() / a.value())).bakeScale(a.value()));
        FieldParser.dec(ColorEntryBuilder.class, HasAlpha.class, (A a, B b) -> b.alpha(a.value()));
        FieldParser.dec(ConfigEntryBuilder.class, Default.class, (BindingContext c, EntryTypeData d, A a, B b) -> {
            Optional<Component> error;
            Object v;
            try {
                Object e = DummyEntryHolder.build(b);
                v = ((AbstractConfigEntry)e).fromCommand(a.value());
                error = v == null ? ((AbstractConfigEntry)e).getErrorFromCommand(a.value()) : Optional.empty();
            }
            catch (RuntimeException e) {
                throw new UnsupportedConfigEntryFieldTypeException(d, "Error setting default value for type: " + b.getClass() + "\n  This type may not support setting a default value with the @Default annotation", (Exception)e);
            }
            if (v == null) {
                String errorText = error.map(Component::getString).orElse("Ensure it's valid YAML of the expected type!");
                throw new InvalidConfigEntryFieldAnnotationException(d, "Invalid default value for entry: " + a.value() + "\n  " + errorText.replace("\n", "\n  "));
            }
            return b.withValue(v);
        });
        FieldParser.dec(StringEntryBuilder.class, Length.class, (A s, B b) -> {
            if (s.min() > 0) {
                b = b.minLength(s.min());
            }
            if (s.max() < Integer.MAX_VALUE) {
                b = b.maxLength(s.max());
            }
            return b;
        });
        FieldParser.dec(CollectionEntryBuilder.class, Size.class, (A s, B b) -> {
            if (s.min() > 0) {
                b = (CollectionEntryBuilder)b.minSize(s.min());
            }
            if (s.max() < Integer.MAX_VALUE) {
                b = (CollectionEntryBuilder)b.maxSize(s.max());
            }
            return b;
        });
        FieldParser.dec(EntryMapEntryBuilder.class, Linked.class, (A a, B b) -> b.linked(a.value()));
        FieldParser.dec(ConfigEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> {
            BindingContext.MethodWrapper<Optional<Component>> m = c.findOwnMethod("$error", BindingContext.ParametersAdapter.oneOptionalAdapter(FieldParser.getType(b)), ERROR_TYPE_ADAPTERS);
            if (m != null) {
                return (ConfigEntryBuilder)b.error(xva$0 -> (Optional)m.invoke(xva$0));
            }
            return b;
        });
        FieldParser.dec(ConfigEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> FieldParser.addTooltip(c, b));
        FieldParser.dec(ConfigEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> {
            EntryType<?> type = FieldParser.getType(b);
            BindingContext.MethodWrapper m = c.findOwnMethod("$bake", BindingContext.ParametersAdapter.oneOptionalAdapter(type), BindingContext.ReturnTypeAdapter.identity(type));
            if (m != null) {
                return b.baked(xva$0 -> m.invoke(xva$0));
            }
            return b;
        });
        FieldParser.dec(StringEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> d.get(Suggest.class).map(s -> {
            if (s.value().length > 0) {
                return b.suggest(s.value());
            }
            if (!s.method().isEmpty()) {
                Method m = c.requireMethod(s.method(), EntryType.from(List.class, String.class), new EntryType[0]);
                return b.suggest(() -> FieldParser.invoke(m, null, List.class, new Object[0]));
            }
            return b.suggest(new String[0]);
        }).orElse((StringEntryBuilder)b));
        FieldParser.dec(ConfigEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> d.get(Error.class).map(s -> {
            if (s.method().isEmpty()) {
                throw new InvalidConfigEntryFieldAnnotationException(d, "@Error annotation must specify a non empty method name");
            }
            if (FieldParser.cast(b).getErrorSupplier() != null) {
                throw new InvalidConfigEntryFieldAnnotationException(d, "@Error annotation used for field of entry which already has an error supplier");
            }
            BindingContext.MethodWrapper<Optional<Component>> m = c.requireMethod(s.method(), BindingContext.ParametersAdapter.oneOptionalAdapter(FieldParser.getType(b)), ERROR_TYPE_ADAPTERS);
            ConfigEntryBuilder bb = b;
            bb = (ConfigEntryBuilder)bb.error(xva$0 -> (Optional)m.invoke(xva$0));
            return bb;
        }).orElse(b));
        FieldParser.dec(ConfigEntryBuilder.class, (BindingContext c, EntryTypeData d, B b) -> d.get(Bake.class).map(s -> {
            Class<?> declaringClass;
            if (s.method().isEmpty()) {
                throw new InvalidConfigEntryFieldAnnotationException(d, "@Bake annotation must specify a non empty method name");
            }
            if (FieldParser.cast(b).getPresentation() != null) {
                throw new InvalidConfigEntryFieldAnnotationException(d, "@Bake annotation used for field of entry which already has a baking method");
            }
            EntryType<?> type = FieldParser.getType(b);
            Optional<Annotation> pOpt = d.getParent((Annotation)s);
            BindingContext.ParametersAdapter[] pars = pOpt.map(pa -> BindingContext.ParametersAdapter.lastOptionalAdapter(EntryType.unchecked(pa.annotationType()), type)).orElse(BindingContext.ParametersAdapter.singleSignature(type));
            BindingContext ctx = c;
            if (pOpt.isPresent() && (declaringClass = pOpt.get().annotationType().getDeclaringClass()) != null) {
                ctx = new BindingContext(declaringClass, ctx);
            }
            BindingContext.MethodWrapper m = ctx.requireMethod(s.method(), pars, BindingContext.ReturnTypeAdapter.identity(type));
            ConfigEntryBuilder bb = b;
            if (pOpt.isPresent()) {
                Annotation a = pOpt.get();
                bb = bb.baked(v -> m.invoke(v, a));
                return bb;
            }
            bb = bb.baked(xva$0 -> m.invoke(xva$0));
            return bb;
        }).orElse(b));
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> addTooltip(BindingContext c, ConfigEntryBuilder<?, ?, ?, ?> b) {
        BindingContext.MethodWrapper<List<Component>> m = c.findOwnMethod("$tooltip", BindingContext.ParametersAdapter.oneOptionalAdapter(FieldParser.getType(b)), TOOLTIP_TYPE_ADAPTERS);
        if (m != null) {
            return (ConfigEntryBuilder)b.tooltip(v -> (List)m.invoke(v));
        }
        return b;
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> parseInstanceField(BindingContext ctx, Field field, Object instance) {
        try {
            ctx.setContextName(field);
            Object o = field.get(instance);
            return FieldParser.parseType(ctx, field.getAnnotatedType(), EntryTypeData.fromField(ctx, field), null, o);
        }
        catch (IllegalAccessException e) {
            throw new SimpleConfigClassParser.SimpleConfigClassParseException(field.getDeclaringClass(), "Cannot access entry field " + field.getName(), (Exception)e);
        }
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> parseField(BindingContext ctx, Field field) {
        try {
            ctx.setContextName(field);
            Object o = field.get(null);
            return FieldParser.parseType(ctx, field.getAnnotatedType(), EntryTypeData.fromField(ctx, field), null, o);
        }
        catch (IllegalAccessException e) {
            throw new SimpleConfigClassParser.SimpleConfigClassParseException(field.getDeclaringClass(), "Cannot access entry field " + field.getName(), (Exception)e);
        }
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> parseSubType(EntryTypeData parentData, BindingContext ctx, AnnotatedType type, String name) {
        String prevCtx = ctx.getContextName();
        ctx.setContextName(prevCtx + "$" + name);
        ConfigEntryBuilder<?, ?, ?, ?> subType = FieldParser.parseType(ctx, type, null, parentData, null);
        ctx.setContextName(prevCtx);
        return subType;
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> parseType(BindingContext ctx, AnnotatedType aType, @Nullable EntryTypeData data, @Nullable EntryTypeData parentData, @Nullable Object value) {
        Class cls;
        Type type = aType.getType();
        EntryTypeData d = EntryTypeData.fromType(ctx, aType);
        if (data != null) {
            d = EntryTypeData.merge(data, d);
        }
        if (type instanceof Class) {
            cls = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            cls = (Class)t.getRawType();
        } else {
            throw new UnexpectedFieldParsingException(d, "Unexpected type found introspecting config field generic type: " + type.getClass().getCanonicalName());
        }
        try {
            for (FieldTypeParser<?> parser : PARSERS) {
                if (!parser.getFilter().isApplicable(aType)) continue;
                return FieldParser.decorateType(ctx, d, FieldParser.create(parser, d, aType, type, cls, value));
            }
        }
        catch (RuntimeException e) {
            throw new UnsupportedConfigEntryFieldTypeException(d, "Error creating config entry from type: " + EntryType.fromType(type), (Exception)e);
        }
        throw new UnsupportedConfigEntryFieldTypeException(d, "Unsupported config field type: " + EntryType.fromType(type) + "\n  Please, refer to Simple Config's documentation/wiki for supported config field types in the declarative API");
    }

    public static ConfigEntryBuilder<?, ?, ?, ?> decorateType(BindingContext ctx, EntryTypeData data, ConfigEntryBuilder<?, ?, ?, ?> builder) {
        Class<?> cls = builder.getClass();
        Map<Configure, Class<? extends Annotation>> entries2 = data.getConfigureAnnotations();
        List rev = Lists.reverse(new ArrayList<Configure>(entries2.keySet()));
        for (Configure configure : rev) {
            Object obj;
            Class<? extends Annotation> cl = entries2.get(configure);
            String methodName = configure.value();
            if (methodName.isEmpty()) continue;
            BindingContext c = ctx;
            EntryType<?> t = EntryType.unchecked(cls);
            if (cl != null) {
                if (cl.getDeclaringClass() != null) {
                    c = new BindingContext(cl.getDeclaringClass(), ctx);
                }
                m = c.requireCompatibleMethod(methodName, true, BindingContext.ParametersAdapter.lastOptionalAdapter(EntryType.unchecked(cl), t), BindingContext.ReturnTypeAdapter.identity(t));
                obj = m.invoke(builder, data.getOrNull(cl));
            } else {
                m = c.requireCompatibleMethod(methodName, true, cls, cls);
                obj = FieldParser.invoke((Method)m, null, cls, builder);
            }
            if (obj.getClass() != cls) {
                throw new SimpleConfigClassParser.SimpleConfigClassParseException(c.cls, "Configure method " + methodName + " must return " + cls.getName());
            }
            builder = (ConfigEntryBuilder)obj;
        }
        for (FieldBuilderDecorator fieldBuilderDecorator : DECORATORS) {
            if (!fieldBuilderDecorator.isApplicable(builder)) continue;
            builder = FieldParser.decorate(fieldBuilderDecorator, data, builder);
        }
        Optional<Class> opt = Arrays.stream(data.getUnusedAnnotations()).filter(SimpleConfigClassParser.CONFIG_ENTRY_ANNOTATIONS::contains).findFirst();
        if (opt.isPresent()) {
            throw new InvalidConfigEntryFieldAnnotationException(data, "Inapplicable config entry annotation (@" + opt.get().getSimpleName() + ") for entry of type " + SimpleConfigClassParser.SimpleConfigClassParseException.getEntryBuilderName(builder) + " [" + FieldParser.getType(builder) + "]");
        }
        return builder;
    }

    private static <T> ConfigEntryBuilder<?, ?, ?, ?> create(FieldTypeParser<T> parser, EntryTypeData d, AnnotatedType aType, Type type, Class<?> cls, Object value) {
        return parser.create(d, aType, type, cls, value);
    }

    private static <B extends ConfigEntryBuilder<?, ?, ?, B>, FD extends FieldBuilderDecorator<B>> ConfigEntryBuilder<?, ?, ?, ?> decorate(FieldBuilderDecorator<?> decorator, EntryTypeData d, ConfigEntryBuilder<?, ?, ?, ?> builder) {
        return decorator.decorate(d, builder);
    }

    private static <T> AbstractConfigEntryBuilder<T, ?, ?, ?, ?, ?> cast(ConfigEntryBuilder<T, ?, ?, ?> b) {
        return (AbstractConfigEntryBuilder)b;
    }

    @NotNull
    private static AnnotatedParameterizedType requireParameterized(EntryTypeData d, AnnotatedType at) {
        if (!(at instanceof AnnotatedParameterizedType)) {
            throw new UnexpectedFieldParsingException(d, "Unexpected type found introspecting config field type: " + at.getClass().getCanonicalName());
        }
        AnnotatedParameterizedType apt = (AnnotatedParameterizedType)at;
        return apt;
    }

    static EntryType<?> getType(ConfigEntryBuilder<?, ?, ?, ?> b) {
        AbstractConfigEntryBuilder<?, ?, ?, ?, ?, ?> bb = FieldParser.cast(b);
        return bb.getEntryType();
    }

    private static <T> EntryType<T> t(Class<T> cls) {
        return EntryType.unchecked(cls);
    }

    private static <T> void rec(EntryType<T> cls, RecursiveFieldTypeBuilder<T> builder, String ... names) {
        FieldParser.reg(cls, (BindingContext ctx, EntryTypeData a, AnnotatedType at, Type t, Class<?> c, Optional<V> o) -> {
            if (at instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType p = (AnnotatedParameterizedType)at;
                ConfigEntryBuilder<?, ?, ?, ?>[] args = FieldParser.parseSubTypes(ctx, a, p, names);
                return builder.build(ctx, a, args, p, c, o);
            }
            throw new UnexpectedFieldParsingException(a, "Unexpected type found introspecting config field type: " + at.getClass().getCanonicalName());
        });
    }

    private static ConfigEntryBuilder<?, ?, ?, ?>[] parseSubTypes(BindingContext ctx, EntryTypeData d, AnnotatedParameterizedType type, String ... names) {
        AnnotatedType[] subTypes = type.getAnnotatedActualTypeArguments();
        if (subTypes.length != names.length) {
            throw new UnexpectedFieldParsingException(d, "Unexpected number of subtypes (" + subTypes.length + ", expected: " + names.length + ") found introspecting config field generic type: " + type.getType());
        }
        ConfigEntryBuilder[] builders = new ConfigEntryBuilder[names.length];
        for (int i = 0; i < names.length; ++i) {
            builders[i] = FieldParser.parseSubType(d, ctx, subTypes[i], names[i]);
        }
        return builders;
    }

    private static <E extends Enum<E>> ConfigEntryBuilder<?, ?, ?, ?> makeEnum(Object v) {
        return ConfigBuilderFactoryProxy.option((Enum)v);
    }

    private static <T, C, G, B extends ConfigEntryBuilder<T, C, G, B>> ConfigEntryBuilder<?, ?, ?, ?> makeList(ConfigEntryBuilder<T, ?, ?, ?> b, List<?> l) {
        return ConfigBuilderFactoryProxy.list(b, l);
    }

    private static <T, C, G, B extends ConfigEntryBuilder<T, C, G, B>> ConfigEntryBuilder<?, ?, ?, ?> makeSet(ConfigEntryBuilder<T, ?, ?, ?> b, Set<?> l) {
        return ConfigBuilderFactoryProxy.set(b, l);
    }

    private static <K, KC, KG, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, V, VC, VG, VB extends ConfigEntryBuilder<V, VC, VG, VB>> ConfigEntryBuilder<?, ?, ?, ?> makeMap(ConfigEntryBuilder<K, ?, ?, ?> kb, ConfigEntryBuilder<V, ?, ?, ?> b, Map<?, ?> l) {
        if (!(kb instanceof AtomicEntryBuilder)) {
            throw new IllegalArgumentException("Key type in map is not atomic: " + kb.getClass().getName());
        }
        return ConfigBuilderFactoryProxy.map(kb, b, l);
    }

    private static <K, KC, KG, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, V, VC, VG, VB extends ConfigEntryBuilder<V, VC, VG, VB>> ConfigEntryBuilder<?, ?, ?, ?> makePairList(ConfigEntryBuilder<K, ?, ?, ?> kb, ConfigEntryBuilder<V, ?, ?, ?> b, List<?> l) {
        if (!(kb instanceof AtomicEntryBuilder)) {
            throw new IllegalArgumentException("Key type in map is not atomic: " + kb.getClass().getName());
        }
        return ConfigBuilderFactoryProxy.pairList(kb, b, l);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public static <C, CC, CG, CB extends ConfigEntryBuilder<C, CC, CG, CB> & AtomicEntryBuilder, L, LC, LG, LB extends ListEntryBuilder<L, LC, LG, LB>> ConfigEntryBuilder<?, ?, ?, ?> makeCaptionedList(ConfigEntryBuilder<C, ?, ?, ?> cb, ConfigEntryBuilder<?, ?, ?, ?> b, @Nullable Pair<?, ?> v) {
        @NotNull @NotNull CaptionedCollectionEntryBuilder e = ConfigBuilderFactoryProxy.caption(FieldParser.atomic(cb), (ListEntryBuilder)b);
        if (v != null) {
            e = (CaptionedCollectionEntryBuilder)e.withValue(v);
        }
        return e;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public static <CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder, V, C, G, B extends ConfigEntryBuilder<V, C, G, B>, SB extends EntrySetEntryBuilder<V, C, G, B>> ConfigEntryBuilder<?, ?, ?, ?> makeCaptionedSet(ConfigEntryBuilder<CV, ?, ?, ?> cb, ConfigEntryBuilder<V, ?, ?, ?> b, @Nullable Pair<?, ?> v) {
        @NotNull @NotNull CaptionedCollectionEntryBuilder e = ConfigBuilderFactoryProxy.caption(FieldParser.atomic(cb), (EntrySetEntryBuilder)b);
        if (v != null) {
            e = (CaptionedCollectionEntryBuilder)e.withValue(v);
        }
        return e;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public static <CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder, K, KC, KG, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, V, C, G, B extends ConfigEntryBuilder<V, C, G, B>, MB extends EntryMapEntryBuilder<K, V, KC, C, KG, G, B, KB>> ConfigEntryBuilder<?, ?, ?, ?> makeCaptionedMap(ConfigEntryBuilder<CV, ?, ?, ?> cb, ConfigEntryBuilder<?, ?, ?, ?> mb, @Nullable Pair<?, ?> v) {
        @NotNull @NotNull @NotNull CaptionedCollectionEntryBuilder e = ConfigBuilderFactoryProxy.caption(FieldParser.atomic(cb), (EntryMapEntryBuilder)mb);
        if (v != null) {
            e = (CaptionedCollectionEntryBuilder)e.withValue(v);
        }
        return e;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public static <CV, CC, CG, CB extends ConfigEntryBuilder<CV, CC, CG, CB> & AtomicEntryBuilder, K, KC, KG, KB extends ConfigEntryBuilder<K, KC, KG, KB> & AtomicEntryBuilder, V, C, G, B extends ConfigEntryBuilder<V, C, G, B>, PLB extends EntryPairListEntryBuilder<K, V, KC, C, KG, G, B, KB>> ConfigEntryBuilder<?, ?, ?, ?> makeCaptionedPairList(ConfigEntryBuilder<CV, ?, ?, ?> cb, ConfigEntryBuilder<?, ?, ?, ?> b, @Nullable Pair<?, ?> v) {
        @NotNull @NotNull @NotNull @NotNull CaptionedCollectionEntryBuilder e = ConfigBuilderFactoryProxy.caption(FieldParser.atomic(cb), (EntryPairListEntryBuilder)b);
        if (v != null) {
            e = (CaptionedCollectionEntryBuilder)e.withValue(v);
        }
        return e;
    }

    private static <L, LC, LG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, R, RC, RG, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> ConfigEntryBuilder<?, ?, ?, ?> makePair(ConfigEntryBuilder<L, ?, ?, ?> lb, ConfigEntryBuilder<R, ?, ?, ?> rb, Pair<?, ?> p) {
        return ConfigBuilderFactoryProxy.pair(FieldParser.atomic(lb), FieldParser.atomic(rb), p);
    }

    private static <L, LC, LG, LB extends ConfigEntryBuilder<L, LC, LG, LB> & AtomicEntryBuilder, M, MC, MG, MB extends ConfigEntryBuilder<M, MC, MG, MB> & AtomicEntryBuilder, R, RC, RG, RB extends ConfigEntryBuilder<R, RC, RG, RB> & AtomicEntryBuilder> ConfigEntryBuilder<?, ?, ?, ?> makeTriple(ConfigEntryBuilder<L, ?, ?, ?> lb, ConfigEntryBuilder<M, ?, ?, ?> mb, ConfigEntryBuilder<R, ?, ?, ?> rb, Triple<?, ?, ?> p) {
        return ConfigBuilderFactoryProxy.triple(FieldParser.atomic(lb), FieldParser.atomic(mb), FieldParser.atomic(rb), p);
    }

    private static <V, C, G, B extends ConfigEntryBuilder<V, C, G, B> & AtomicEntryBuilder> B atomic(ConfigEntryBuilder<?, ?, ?, ?> b) {
        if (!(b instanceof AtomicEntryBuilder)) {
            throw new IllegalArgumentException("Type is not atomic: " + b.getClass().getName());
        }
        return (B)b;
    }

    private static <T, B extends ConfigEntryBuilder<T, ?, ?, ?>> T adapt(Class<?> cls, double v) {
        if (ByteEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Byte.valueOf(Double.valueOf(v).byteValue());
        }
        if (ShortEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Short.valueOf(Double.valueOf(v).shortValue());
        }
        if (IntegerEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Integer.valueOf(Double.valueOf(v).intValue());
        }
        if (LongEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Long.valueOf(Double.valueOf(v).longValue());
        }
        if (FloatEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Float.valueOf(Double.valueOf(v).floatValue());
        }
        if (DoubleEntryBuilder.class.isAssignableFrom(cls)) {
            return (T)Double.valueOf(v);
        }
        throw new IllegalArgumentException("Unexpected numeric builder type: " + cls);
    }

    private static <V> void reg(EntryType<V> type, FieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeFilter.matching(type), parser);
    }

    private static <V> void reg(EntryType<V> type, FieldEntryBuilder.ClassFieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeFilter.matching(type), parser);
    }

    private static <V> void reg(EntryType<V> type, FieldEntryBuilder.SimpleFieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeFilter.matching(type), parser);
    }

    private static <V> void reg(FieldTypeFilter filter, FieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeParser.of(filter, parser));
    }

    private static <V> void reg(FieldTypeFilter filter, FieldEntryBuilder.ClassFieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeParser.of(filter, parser));
    }

    private static <V> void reg(FieldTypeFilter filter, FieldEntryBuilder.SimpleFieldEntryBuilder<V> parser) {
        FieldParser.reg(FieldTypeParser.of(filter, parser));
    }

    private static <V> void reg(FieldTypeParser<V> parser) {
        PARSERS.add(parser);
    }

    @SafeVarargs
    private static <T, B extends ConfigEntryBuilder<T, ?, ?, BB>, BB extends B> void dec(Class<B> cls, BiFunction<EntryTypeData, B, B> ... parsers) {
        for (BiFunction<EntryTypeData, B, B> p : parsers) {
            DECORATORS.add(FieldBuilderDecorator.of(cls, p));
        }
    }

    private static <B extends ConfigEntryBuilder> void dec(Class<B> cls, FieldBuilderDecorator.FieldDecorator<B> parser) {
        DECORATORS.add(FieldBuilderDecorator.of(cls, parser));
    }

    private static <T, A extends Annotation, B extends ConfigEntryBuilder<T, ?, ?, BB>, BB extends B> void dec(Class<B> cls, Class<A> a, BiFunction<A, B, B> transform) {
        FieldParser.dec(cls, (as, b) -> as.get(a).map(aa -> (ConfigEntryBuilder)transform.apply(aa, b)).orElse((ConfigEntryBuilder)b));
    }

    private static <A extends Annotation, B extends ConfigEntryBuilder> void dec(Class<B> cls, Class<A> a, FieldBuilderDecorator.AnnotationFieldDecorator<A, B> decorator) {
        FieldParser.dec(cls, (BindingContext c, EntryTypeData d, B b) -> d.get(a).map(aa -> decorator.decorate(c, d, aa, b)).orElse(b));
    }

    private static <T, A extends Annotation, B extends ConfigEntryBuilder<T, ?, ?, BB>, BB extends B> void dec(Class<B> cls, Class<A> a, Function<B, B> transform) {
        FieldParser.dec(cls, a, (A aa, B b) -> (ConfigEntryBuilder)transform.apply(b));
    }

    static <T> T invoke(Method method, Object self, Class<T> type, Object ... args) {
        try {
            return type.cast(method.invoke(self, args));
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            throw new SimpleConfig.ConfigReflectiveOperationException("Error accessing config method: " + ReflectionUtil.getMethodName(method) + "\n  Details: " + e.getMessage(), e);
        }
    }

    static {
        FieldParser.registerFieldTypeParsers();
        FieldParser.registerFieldTypeDecorators();
        ERROR_TYPE_ADAPTERS = new BindingContext.ReturnTypeAdapter[]{BindingContext.ReturnTypeAdapter.of(EntryType.from(Optional.class, Component.class), t -> t), BindingContext.ReturnTypeAdapter.of(EntryType.of(Component.class, new EntryType[0]), Optional::ofNullable), BindingContext.ReturnTypeAdapter.of(EntryType.of(String.class, new EntryType[0]), t -> Optional.ofNullable(t).map(Component::m_237115_)), BindingContext.ReturnTypeAdapter.of(EntryType.of(Boolean.TYPE, new EntryType[0]), t -> t != false ? Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_value_generic")) : Optional.empty())};
        TOOLTIP_TYPE_ADAPTERS = new BindingContext.ReturnTypeAdapter[]{BindingContext.ReturnTypeAdapter.of(EntryType.from(List.class, Component.class), t -> t), BindingContext.ReturnTypeAdapter.of(EntryType.of(Component.class, new EntryType[0]), Collections::singletonList), BindingContext.ReturnTypeAdapter.of(EntryType.of(String.class, new EntryType[0]), x$0 -> SimpleConfigTextUtil.optSplitTtc(x$0, new Object[0]))};
    }

    @FunctionalInterface
    public static interface RecursiveFieldTypeBuilder<T> {
        public ConfigEntryBuilder<?, ?, ?, ?> build(BindingContext var1, EntryTypeData var2, ConfigEntryBuilder<?, ?, ?, ?>[] var3, AnnotatedParameterizedType var4, Class<?> var5, Optional<T> var6);
    }

    public static class UnexpectedFieldParsingException
    extends SimpleConfigClassParser.SimpleConfigClassParseException {
        public UnexpectedFieldParsingException(EntryTypeData data, String message) {
            super(data.getContextClass(), message);
        }

        public UnexpectedFieldParsingException(EntryTypeData data, String message, Exception cause) {
            super(data.getContextClass(), message, cause);
        }
    }

    public static class UnsupportedConfigEntryFieldTypeException
    extends SimpleConfigClassParser.SimpleConfigClassParseException {
        public UnsupportedConfigEntryFieldTypeException(EntryTypeData data, String message) {
            super(data.getContextClass(), message);
        }

        public UnsupportedConfigEntryFieldTypeException(EntryTypeData data, String message, Exception cause) {
            super(data.getContextClass(), message, cause);
        }
    }

    public static class InvalidConfigEntryFieldAnnotationException
    extends SimpleConfigClassParser.SimpleConfigClassParseException {
        public InvalidConfigEntryFieldAnnotationException(EntryTypeData data, String message) {
            super(data.getContextClass(), message);
        }

        public InvalidConfigEntryFieldAnnotationException(EntryTypeData data, String message, Exception cause) {
            super(data.getContextClass(), message, cause);
        }
    }
}

