/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.reflection;

import endorh.simpleconfig.api.ConfigEntryBuilder;
import endorh.simpleconfig.core.reflection.BindingContext;
import endorh.simpleconfig.core.reflection.EntryTypeData;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

@FunctionalInterface
public interface FieldEntryBuilder<V> {
    public ConfigEntryBuilder<?, ?, ?, ?> build(BindingContext var1, EntryTypeData var2, AnnotatedType var3, Type var4, Class<?> var5, Optional<V> var6);

    default public ConfigEntryBuilder<?, ?, ?, ?> build(BindingContext ctx, EntryTypeData data, AnnotatedType aType, Type type, Optional<V> v) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return this.build(ctx, data, aType, type, c, v);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            return this.build(ctx, data, aType, type, (Class)t.getRawType(), v);
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    @FunctionalInterface
    public static interface SimpleFieldEntryBuilder<V>
    extends FieldEntryBuilder<V> {
        public ConfigEntryBuilder<?, ?, ?, ?> build(EntryTypeData var1, Optional<V> var2);

        @Override
        default public ConfigEntryBuilder<?, ?, ?, ?> build(BindingContext ctx, EntryTypeData data, AnnotatedType aType, Type t, Class<?> c, Optional<V> v) {
            return this.build(data, v);
        }
    }

    @FunctionalInterface
    public static interface ClassFieldEntryBuilder<V>
    extends FieldEntryBuilder<V> {
        public ConfigEntryBuilder<?, ?, ?, ?> build(EntryTypeData var1, Class<?> var2, Optional<V> var3);

        @Override
        default public ConfigEntryBuilder<?, ?, ?, ?> build(BindingContext ctx, EntryTypeData data, AnnotatedType aType, Type type, Class<?> c, Optional<V> v) {
            return this.build(data, c, v);
        }
    }
}

