/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.reflection;

import endorh.simpleconfig.api.annotation.Configure;
import endorh.simpleconfig.core.reflection.BindingContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntryTypeData
extends Iterable<Annotation> {
    public static EntryTypeData fromField(BindingContext ctx, Field field) {
        return new EntryTypeDataImpl(ctx, field.getAnnotations());
    }

    public static EntryTypeData fromType(BindingContext ctx, AnnotatedType aType) {
        return new EntryTypeDataImpl(ctx, aType.getAnnotations());
    }

    public static EntryTypeData merge(EntryTypeData a, EntryTypeData b) {
        BindingContext bCtx;
        BindingContext aCtx = a.getBindingContext();
        if (aCtx != (bCtx = b.getBindingContext())) {
            throw new IllegalArgumentException("Can't merge two EntryTypeData instances from different contexts");
        }
        EntryTypeDataImpl set = new EntryTypeDataImpl(aCtx, new Annotation[0]);
        for (Annotation an : b) {
            set.map.put(an.annotationType(), an);
        }
        for (Annotation an : a) {
            set.map.put(an.annotationType(), an);
        }
        set.entryAnnotations.putAll(b.getConfigureAnnotations());
        set.entryAnnotations.putAll(a.getConfigureAnnotations());
        set.parents.putAll(a.getParents());
        set.parents.putAll(b.getParents());
        return set;
    }

    public BindingContext getBindingContext();

    default public Class<?> getContextClass() {
        return this.getBindingContext().getContextClass();
    }

    public boolean contains(Class<? extends Annotation> var1);

    public <A extends Annotation> Optional<A> get(Class<A> var1);

    @Nullable
    public <A extends Annotation> A getOrNull(Class<A> var1);

    public Optional<Annotation> getParent(Annotation var1);

    @Nullable
    public Annotation getParentOrNull(Annotation var1);

    public Map<Annotation, Annotation> getParents();

    public Class<? extends Annotation>[] getUnusedAnnotations();

    public Map<Configure, Class<? extends Annotation>> getConfigureAnnotations();

    public static class EntryTypeDataImpl
    implements EntryTypeData {
        private final BindingContext bindingContext;
        private final Map<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        private final Map<Annotation, Annotation> parents = new HashMap<Annotation, Annotation>();
        private final Set<Class<? extends Annotation>> usedAnnotations = new HashSet<Class<? extends Annotation>>();
        private final Map<Configure, Class<? extends Annotation>> entryAnnotations = new LinkedHashMap<Configure, Class<? extends Annotation>>();

        public EntryTypeDataImpl(BindingContext ctx, Annotation ... annotations) {
            this.bindingContext = ctx;
            for (Annotation a : annotations) {
                this.addRecursive(null, a);
            }
        }

        private void addRecursive(Annotation parent, Annotation a) {
            Class<? extends Annotation> ac = a.annotationType();
            this.map.put(ac, a);
            if (parent != null) {
                this.parents.put(a, parent);
            }
            if (a instanceof Configure) {
                Configure e = (Configure)a;
                this.entryAnnotations.put(e, parent != null ? parent.annotationType() : null);
            }
            for (Annotation sub : ac.getAnnotations()) {
                Class<? extends Annotation> sc = sub.annotationType();
                if (sc == Target.class || sc == Retention.class || this.map.containsKey(sc)) continue;
                this.addRecursive(a, sub);
            }
        }

        @Override
        public BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @Override
        public boolean contains(Class<? extends Annotation> cls) {
            return this.map.containsKey(cls);
        }

        @Override
        public <A extends Annotation> Optional<A> get(Class<A> cls) {
            return Optional.ofNullable(this.getOrNull(cls));
        }

        @Override
        public <A extends Annotation> A getOrNull(Class<A> cls) {
            this.usedAnnotations.add(cls);
            return (A)((Annotation)cls.cast(this.map.get(cls)));
        }

        @Override
        public Optional<Annotation> getParent(Annotation annotation) {
            return Optional.ofNullable(this.getParentOrNull(annotation));
        }

        @Override
        @Nullable
        public Annotation getParentOrNull(Annotation annotation) {
            return this.parents.get(annotation);
        }

        @Override
        public Map<Annotation, Annotation> getParents() {
            return this.parents;
        }

        @Override
        public Class<? extends Annotation>[] getUnusedAnnotations() {
            return (Class[])this.map.keySet().stream().filter(a -> !this.usedAnnotations.contains(a)).toArray(Class[]::new);
        }

        @Override
        public Map<Configure, Class<? extends Annotation>> getConfigureAnnotations() {
            return this.entryAnnotations;
        }

        @Override
        @NotNull
        public Iterator<Annotation> iterator() {
            return this.map.values().iterator();
        }
    }
}

