/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.reflection;

import com.google.gson.internal.Primitives;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.ReflectionUtil;
import endorh.simpleconfig.core.SimpleConfigClassParser;
import endorh.simpleconfig.core.reflection.FieldParser;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindingContext {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Class<?> cls;
    @Nullable
    public final BindingContext parent;
    @Nullable
    private String contextName = null;
    @Nullable
    private Set<Method> methodSet;
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z\\d_$]*$");

    public static BindingContext forConfigClass(Class<?> cls, @Nullable BindingContext parent, Set<Method> methodSet) {
        BindingContext ctx = new BindingContext(cls, parent);
        ctx.methodSet = methodSet;
        return ctx;
    }

    public BindingContext(Class<?> cls, @Nullable BindingContext parent) {
        this.cls = cls;
        this.parent = parent;
    }

    private void warnMissTypedMethod(String name) {
        MemberName nm = this.normalizeName(name);
        Arrays.stream(nm.cls.getDeclaredMethods()).filter(m -> nm.name().equals(m.getName())).findFirst().ifPresent(m -> LOGGER.warn("Found method \"" + ReflectionUtil.getMethodName(m) + "\" with invalid type: ", (Object)m.getDeclaringClass().getName(), (Object)m.getName()));
    }

    public Class<?> getContextClass() {
        return this.cls;
    }

    @Nullable
    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(@Nullable String contextName) {
        this.contextName = contextName;
    }

    public void setContextName(Field field) {
        this.setContextName(field.getName());
    }

    @Nullable
    public Method findCompatibleMethod(String name, boolean widen, Class<?> returnType, Class<?> ... paramTypes) {
        MemberName nm = this.normalizeName(name);
        boolean found = false;
        block0: for (Method m : nm.cls().getDeclaredMethods()) {
            Class<?>[] types;
            if (!m.getName().equals(nm.name()) || (types = m.getParameterTypes()).length != paramTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!types[i].isAssignableFrom(paramTypes[i])) continue block0;
            }
            Class<?> rt = m.getReturnType();
            if (returnType.isAssignableFrom(rt)) {
                m.setAccessible(true);
                this.add(m);
                return m;
            }
            if (widen && rt.isAssignableFrom(returnType)) {
                m.setAccessible(true);
                this.add(m);
                return m;
            }
            found = true;
        }
        Method m = null;
        if (this.parent != null) {
            m = this.parent.findCompatibleMethod(name, widen, returnType, paramTypes);
        }
        if (m == null && found) {
            this.warnMissTypedMethod(name);
        }
        return m;
    }

    @NotNull
    public Method requireCompatibleMethod(String name, boolean widen, Class<?> returnType, Class<?> ... paramTypes) {
        Method m = this.findCompatibleMethod(name, widen, returnType, paramTypes);
        if (m == null) {
            throw new MethodBindingException(this.normalizeName(name), widen, returnType, paramTypes);
        }
        return m;
    }

    @SafeVarargs
    public final <R> Pair<@Nullable MethodWrapper.AdapterMethodWrapper<R>, Boolean> doFindCompatibleOwnMethod(String name, boolean warn, boolean widen, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        MemberName nm = this.normalizeName(name);
        MethodWrapper.AdapterMethodWrapper<R> method = null;
        boolean found = false;
        for (ParametersAdapter p : parameters) {
            Class<?>[] paramTypes = p.getParameterTypes();
            block1: for (Method m : nm.cls().getDeclaredMethods()) {
                Class<?>[] types;
                if (!m.getName().equals(nm.name()) || (types = m.getParameterTypes()).length != paramTypes.length) continue;
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (!types[i].isAssignableFrom(paramTypes[i])) continue block1;
                }
                Class<?> rt = m.getReturnType();
                for (ReturnTypeAdapter<?, R> a : adapters) {
                    Class<?> returnType = a.getReturnType().type();
                    if (!returnType.isAssignableFrom(rt) && (!widen || !rt.isAssignableFrom(returnType))) continue;
                    m.setAccessible(true);
                    this.checkStatic(m);
                    MethodWrapper.AdapterMethodWrapper<R> fm = new MethodWrapper.AdapterMethodWrapper<R>(m, p, a);
                    if (method != null && !fm.isMoreSpecificThan(method, true)) continue block1;
                    method = fm;
                    continue block1;
                }
                found = true;
            }
        }
        if (method != null) {
            this.add(method.method);
            return Pair.of(method, (Object)true);
        }
        if (found && warn) {
            this.warnMissTypedMethod(name);
        }
        return Pair.of(null, (Object)found);
    }

    @SafeVarargs
    @Nullable
    public final <R> MethodWrapper.AdapterMethodWrapper<R> findCompatibleOwnMethod(String name, boolean widen, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        return (MethodWrapper.AdapterMethodWrapper)this.doFindCompatibleOwnMethod(name, true, widen, parameters, adapters).getLeft();
    }

    @SafeVarargs
    @Nullable
    public final <R> MethodWrapper.AdapterMethodWrapper<R> findCompatibleMethod(String name, boolean widen, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        Pair<@Nullable MethodWrapper.AdapterMethodWrapper<R>, Boolean> p = this.doFindCompatibleOwnMethod(name, false, widen, parameters, adapters);
        if (p.getLeft() != null) {
            return (MethodWrapper.AdapterMethodWrapper)p.getLeft();
        }
        MethodWrapper.AdapterMethodWrapper<R> method = null;
        if (this.parent != null) {
            method = this.parent.findCompatibleMethod(name, widen, parameters, adapters);
        }
        if (method == null && ((Boolean)p.getRight()).booleanValue()) {
            this.warnMissTypedMethod(name);
        }
        return method;
    }

    @SafeVarargs
    @NotNull
    public final <R> MethodWrapper<R> requireCompatibleMethod(String name, boolean widen, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        MethodWrapper.AdapterMethodWrapper<R> m = this.findCompatibleMethod(name, widen, parameters, adapters);
        if (m == null) {
            throw new MethodBindingException(this.normalizeName(name), true, parameters, adapters);
        }
        return m;
    }

    @SafeVarargs
    @Nullable
    public final <R> MethodWrapper<R> findOwnMethod(String name, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        MemberName nm = this.normalizeName(name);
        Pair<ParametersAdapter, Method> p = this.tryGetMethod(nm.cls(), nm.name(), parameters);
        if (p != null) {
            Method m = (Method)p.getRight();
            ParametersAdapter arg = (ParametersAdapter)p.getLeft();
            for (ReturnTypeAdapter r : adapters) {
                if (!r.getReturnType().matches(EntryType.fromType(m.getGenericReturnType()))) continue;
                this.add(m);
                Class<?> cls = r.getReturnType().type();
                return args -> r.castAdapt(FieldParser.invoke(m, null, cls, arg.adapt(args)));
            }
            this.warnMissTypedMethod(name);
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public final <R> MethodWrapper<R> findMethod(String name, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        MethodWrapper<R> own = this.findOwnMethod(name, parameters, adapters);
        if (own != null) {
            return own;
        }
        if (this.parent != null) {
            return this.parent.findMethod(name, parameters, adapters);
        }
        return null;
    }

    @SafeVarargs
    @NotNull
    public final <R> MethodWrapper<R> requireMethod(String name, ParametersAdapter[] parameters, ReturnTypeAdapter<?, R> ... adapters) {
        MethodWrapper<R> method = this.findMethod(name, parameters, adapters);
        if (method == null) {
            throw new MethodBindingException(this.normalizeName(name), parameters, adapters);
        }
        return method;
    }

    @Nullable
    public Method findOwnMethod(String name, EntryType<?> type, EntryType<?> ... args) {
        return this.findOwnMethod(name, MethodType.of(type, args));
    }

    @Nullable
    public Method findOwnMethod(String name, MethodType<?> type) {
        MemberName nm = this.normalizeName(name);
        Method method = this.tryGetMethod(nm.cls(), nm.name(), type.getParameterClasses());
        if (method != null && type.matches(method)) {
            return this.add(method);
        }
        return null;
    }

    @Nullable
    public Method findMethod(String name, EntryType<?> type, EntryType<?> ... args) {
        return this.findMethod(name, MethodType.of(type, args));
    }

    @Nullable
    public Method findMethod(String name, MethodType<?> type) {
        Method method = this.getMethod(name, type);
        if (method != null) {
            return this.add(method);
        }
        method = this.getMethodNoCheck(name, type);
        if (method != null) {
            LOGGER.warn("Found matching method with invalid signature: " + method.getDeclaringClass().getCanonicalName() + "#" + method.getName() + ", expected signature: " + type);
        }
        return null;
    }

    @NotNull
    public Method requireMethod(String name, EntryType<?> type, EntryType<?> ... args) {
        return this.requireMethod(name, MethodType.of(type, args));
    }

    @NotNull
    public Method requireMethod(String name, MethodType<?> type) {
        Method method = this.getMethod(name, type);
        if (method != null) {
            return this.add(method);
        }
        method = this.getMethodNoCheck(name, type);
        if (method != null) {
            throw new MethodBindingException(method, type);
        }
        throw new MethodBindingException(this.normalizeName(name), type);
    }

    @Nullable
    private Method getMethod(String name, MethodType<?> type) {
        MemberName nm = this.normalizeName(name);
        Method method = this.tryGetMethod(nm.cls(), nm.name(), type.getParameterClasses());
        if (method != null && type.matches(method)) {
            return this.add(method);
        }
        if (this.parent != null) {
            return this.parent.getMethod(name, type);
        }
        return null;
    }

    @Nullable
    private Method getMethodNoCheck(String name, MethodType<?> type) {
        MemberName nm = this.normalizeName(name);
        Method method = this.tryGetMethod(nm.cls(), nm.name(), type.getParameterClasses());
        if (method != null) {
            return method;
        }
        if (this.parent != null) {
            return this.parent.getMethodNoCheck(name, type);
        }
        return null;
    }

    @Nullable
    private Pair<ParametersAdapter, Method> tryGetMethod(Class<?> clazz, String name, ParametersAdapter ... adapters) {
        for (ParametersAdapter a : adapters) {
            Object[] classes = a.getParameterTypes();
            try {
                Method m = this.checkStatic(clazz.getDeclaredMethod(name, (Class<?>[])classes));
                m.setAccessible(true);
                return Pair.of((Object)a, (Object)m);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    Object[] parameterTypesAsPrimitives = (Class[])Arrays.stream(classes).map(Primitives::unwrap).toArray(Class[]::new);
                    if (Arrays.equals(parameterTypesAsPrimitives, classes)) continue;
                    Method m = this.checkStatic(clazz.getDeclaredMethod(name, (Class<?>[])parameterTypesAsPrimitives));
                    m.setAccessible(true);
                    return Pair.of((Object)a, (Object)m);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    private Method tryGetMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        return this.checkStatic(ReflectionUtil.tryGetMethod(clazz, name, paramTypes));
    }

    private Method checkStatic(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new MethodBindingException(method);
        }
        return method;
    }

    protected String checkName(String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new NameBindingException("Invalid Java identifier: " + name);
        }
        return name;
    }

    protected MemberName normalizeName(String name) {
        if (name.startsWith("$")) {
            if (this.contextName != null) {
                return new MemberName(this.cls, this.checkName(this.contextName + name));
            }
            throw new NameBindingException("Cannot use local name without a naming context: " + name);
        }
        if (name.contains("#")) {
            String[] split = name.split("#", 2);
            try {
                Class<?> cls = Class.forName(this.checkName(split[0]));
                return new MemberName(cls, this.checkName(split[1]));
            }
            catch (ClassNotFoundException e) {
                throw new NameBindingException("Class not found: " + split[0]);
            }
        }
        return new MemberName(this.cls, this.checkName(name));
    }

    private Method add(Method method) {
        if (this.methodSet != null) {
            this.methodSet.add(method);
        }
        return method;
    }

    public record MemberName(Class<?> cls, String name) {
        @Override
        public String toString() {
            return this.cls.getCanonicalName() + "#" + this.name;
        }
    }

    private class MethodBindingException
    extends SimpleConfigClassParser.SimpleConfigClassParseException {
        private MethodBindingException(Method method) {
            super(BindingContext.this.cls, "Found matching non-static config entry method: " + ReflectionUtil.getMethodName(method) + "\n  Make this method static, or use a different name if this match is not intended");
        }

        private MethodBindingException(Method method, MethodType<?> type) {
            super(BindingContext.this.cls, "Config entry method " + ReflectionUtil.getMethodName(method) + " has the wrong type: " + MethodType.fromMethod(method) + ", expected: " + type);
        }

        private MethodBindingException(MemberName name, MethodType<?> type) {
            super(BindingContext.this.cls, "Config entry method not found: " + name + "\n  Expected method type: " + type);
        }

        private MethodBindingException(MemberName name, ParametersAdapter[] argAdapters, ReturnTypeAdapter<?, ?> ... adapters) {
            this(name, false, argAdapters, adapters);
        }

        private MethodBindingException(MemberName name, boolean widen, ParametersAdapter[] argAdapters, ReturnTypeAdapter<?, ?> ... adapters) {
            super(BindingContext.this.cls, "Config entry method not found: " + name + "\n  Expected method should accept any of the following signatures" + (widen ? " (or broader):" : ":") + Arrays.stream(argAdapters).map(a -> "\n    (" + StringUtils.join((Object[])a.getGenericParameterTypes(), (String)", ") + ")").collect(Collectors.joining()) + "\n  and any of the following return types:" + Arrays.stream(adapters).map(a -> "\n    " + a.getReturnType()).collect(Collectors.joining()));
        }

        private MethodBindingException(MemberName name, boolean widen, Class<?> returnType, Class<?>[] paramTypes) {
            super(BindingContext.this.cls, "Config entry method not found: " + name + "\n  Expected method should have the following signature or broader:\n    (" + Arrays.stream(paramTypes).map(Class::getCanonicalName).collect(Collectors.joining(", ")) + ")\n  and return type assignable to " + (widen ? "(or implementing): " : ": ") + returnType.getCanonicalName());
        }
    }

    public static interface ParametersAdapter {
        public static ParametersAdapter of(final Function<Object[], Object[]> adapter, final EntryType<?> ... types) {
            final Class[] classes = (Class[])Arrays.stream(types).map(EntryType::type).toArray(Class[]::new);
            return new ParametersAdapter(){

                @Override
                public EntryType<?>[] getGenericParameterTypes() {
                    return types;
                }

                @Override
                public Class<?>[] getParameterTypes() {
                    return classes;
                }

                @Override
                public Object[] adapt(Object[] args) {
                    return (Object[])adapter.apply(args);
                }
            };
        }

        public static ParametersAdapter empty() {
            return ParametersAdapter.of(args -> args, new EntryType[0]);
        }

        public static ParametersAdapter[] emptySignature() {
            return new ParametersAdapter[]{ParametersAdapter.empty()};
        }

        public static ParametersAdapter[] singleSignature(EntryType<?> ... type) {
            return new ParametersAdapter[]{ParametersAdapter.of(args -> args, type)};
        }

        public static ParametersAdapter[] oneOptionalAdapter(EntryType<?> type) {
            return new ParametersAdapter[]{ParametersAdapter.of(p -> p, type), ParametersAdapter.of(p -> new Object[0], new EntryType[0])};
        }

        public static ParametersAdapter[] lastOptionalAdapter(EntryType<?> type, EntryType<?> ... fixed) {
            return new ParametersAdapter[]{ParametersAdapter.of(p -> p, (EntryType[])ArrayUtils.add((Object[])fixed, type)), ParametersAdapter.of(p -> ArrayUtils.subarray((Object[])p, (int)0, (int)(((Object[])p).length - 1)), fixed)};
        }

        public EntryType<?>[] getGenericParameterTypes();

        public Class<?>[] getParameterTypes();

        public Object[] adapt(Object[] var1);
    }

    public static interface ReturnTypeAdapter<T, R> {
        public static <T, R> ReturnTypeAdapter<T, R> of(final EntryType<T> type, final Function<T, R> adapter) {
            return new ReturnTypeAdapter<T, R>(){

                @Override
                public EntryType<T> getReturnType() {
                    return type;
                }

                @Override
                public R adapt(T value) {
                    return adapter.apply(value);
                }
            };
        }

        public static <T> ReturnTypeAdapter<T, T> identity(EntryType<T> type) {
            return ReturnTypeAdapter.of(type, Function.identity());
        }

        public static ReturnTypeAdapter<Void, Void> ofVoid() {
            return ReturnTypeAdapter.identity(EntryType.of(Void.TYPE, new EntryType[0]));
        }

        public EntryType<T> getReturnType();

        public R adapt(T var1);

        default public R castAdapt(Object result) {
            return this.adapt(result);
        }
    }

    public static interface MethodWrapper<R> {
        public R invoke(Object ... var1);

        public static class AdapterMethodWrapper<R>
        implements MethodWrapper<R> {
            public final Method method;
            public final ParametersAdapter paramsAdapter;
            public final ReturnTypeAdapter<?, R> returnTypeAdapter;
            @NotNull
            public final Class<?> cls;

            public AdapterMethodWrapper(Method method, ParametersAdapter paramsAdapter, ReturnTypeAdapter<?, R> returnTypeAdapter) {
                this.paramsAdapter = paramsAdapter;
                this.returnTypeAdapter = returnTypeAdapter;
                this.method = method;
                this.cls = returnTypeAdapter.getReturnType().type();
            }

            @Override
            public R invoke(Object ... args) {
                return this.returnTypeAdapter.castAdapt(FieldParser.invoke(this.method, null, this.cls, this.paramsAdapter.adapt(args)));
            }

            public String getMethodName() {
                return ReflectionUtil.getMethodName(this.method);
            }

            public boolean isMoreSpecificThan(AdapterMethodWrapper<R> other, boolean ignoreExtraParameters) {
                Class<?>[] oTypes;
                Class<?>[] tTypes = this.paramsAdapter.getParameterTypes();
                if (tTypes.length != (oTypes = other.paramsAdapter.getParameterTypes()).length && !ignoreExtraParameters) {
                    return false;
                }
                int l = Math.min(tTypes.length, oTypes.length);
                for (int i = 0; i < l; ++i) {
                    if (oTypes[i].isAssignableFrom(tTypes[i])) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public record MethodType<R>(EntryType<R> returnType, EntryType<?>[] args) {
        public static <R> MethodType<R> of(EntryType<R> returnType, EntryType<?> ... args) {
            return new MethodType<R>(returnType, args);
        }

        public static MethodType<?> fromMethod(Method method) {
            return new MethodType(EntryType.fromMethod(method), (EntryType[])Arrays.stream(method.getGenericParameterTypes()).map(EntryType::fromType).toArray(EntryType[]::new));
        }

        public boolean matches(Method method) {
            if (!this.returnType.matches(EntryType.fromType(method.getGenericReturnType()))) {
                return false;
            }
            if (this.args.length != method.getParameterCount()) {
                return false;
            }
            Type[] a = method.getGenericParameterTypes();
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].matches(EntryType.fromType(a[i]))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodType that = (MethodType)o;
            return this.returnType.equals(that.returnType) && Arrays.equals(this.args, that.args);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.returnType);
            result = 31 * result + Arrays.hashCode(this.args);
            return result;
        }

        public Class<?>[] getParameterClasses() {
            return (Class[])Arrays.stream(this.args).map(EntryType::type).toArray(Class[]::new);
        }

        @Override
        public String toString() {
            return this.returnType + "(" + StringUtils.join((Object[])this.args, (String)", ") + ")";
        }
    }

    private class NameBindingException
    extends SimpleConfigClassParser.SimpleConfigClassParseException {
        private NameBindingException(String message) {
            super(BindingContext.this.cls, message);
        }
    }
}

