/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.google.common.collect.Lists;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.TextEntryBuilder;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.TextDescriptionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TextEntry
extends AbstractConfigEntry<Void, Void, Void> {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    protected Supplier<Component> translationSupplier = null;
    protected boolean own = false;
    protected boolean logged = false;

    public TextEntry(ConfigEntryHolder parent, String name) {
        super(parent, name, null);
        this.nonPersistent = true;
    }

    @Override
    public Optional<Component> getErrorFromGUI(Void value) {
        return Optional.empty();
    }

    @Override
    protected Consumer<Void> createSaveConsumer() {
        return v -> {};
    }

    @Override
    protected void buildSpec(ConfigSpec spec, String parentPath) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.debugTranslations()) {
            return this.nullAsEmpty(this.getDebugDisplayName());
        }
        if (this.translationSupplier != null) {
            return this.nullAsEmpty(this.translationSupplier.get());
        }
        if (this.translation == null) {
            LOGGER.warn("Malformed config text entry " + this.getGlobalPath());
        }
        return this.nullAsEmpty(super.getDisplayName());
    }

    protected Component nullAsEmpty(@Nullable Component text) {
        if (!this.logged && text == null) {
            LOGGER.warn("Malformed config text entry " + this.getGlobalPath());
            this.logged = true;
        }
        return text != null ? text : Component.m_237119_();
    }

    @Override
    protected List<Component> addExtraTooltip(Void value) {
        return Lists.newArrayList();
    }

    @Override
    protected Optional<ForgeConfigSpec.ConfigValue<?>> buildConfigEntry(ForgeConfigSpec.Builder builder) {
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Component getDebugDisplayName() {
        if (this.own) {
            assert (this.translationSupplier != null);
            return Component.m_237113_((String)"").m_7220_((Component)this.translationSupplier.get().m_6879_().m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (this.translation != null) {
            MutableComponent status;
            MutableComponent mutableComponent = status = I18n.m_118936_((String)this.translation) ? Component.m_237113_((String)"\u2714 ") : Component.m_237113_((String)"\u2718 ");
            if (this.tooltip != null) {
                status = status.m_7220_((Component)(I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"\u2714 ").m_130940_(ChatFormatting.DARK_AQUA) : Component.m_237113_((String)"_ ").m_130940_(ChatFormatting.DARK_AQUA)));
            }
            ChatFormatting format = I18n.m_118936_((String)this.translation) ? ChatFormatting.DARK_GREEN : ChatFormatting.RED;
            return Component.m_237113_((String)"").m_7220_((Component)status.m_7220_((Component)Component.m_237113_((String)this.translation)).m_130940_(format));
        }
        return Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)("\u26a0 " + this.name)).m_130940_(ChatFormatting.DARK_RED));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Optional<Component[]> supplyDebugTooltip(Void value) {
        MutableComponent status;
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)"Text entry").m_130940_(ChatFormatting.GRAY));
        if (this.own) {
            lines.add((Component)Component.m_237113_((String)" + Provides its own translation").m_130940_(ChatFormatting.GRAY));
        } else if (this.translation != null) {
            lines.add((Component)Component.m_237113_((String)"Translation key:").m_130940_(ChatFormatting.GRAY));
            status = I18n.m_118936_((String)this.translation) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(\u2718 missing)").m_130940_(ChatFormatting.RED);
            lines.add((Component)Component.m_237113_((String)("   " + this.translation + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
        } else {
            lines.add((Component)Component.m_237113_((String)"Translation key:").m_130940_(ChatFormatting.GRAY));
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map translation key").m_130940_(ChatFormatting.RED));
        }
        if (this.tooltip != null) {
            if (!this.name.startsWith("_text$") || I18n.m_118936_((String)this.tooltip)) {
                lines.add((Component)Component.m_237113_((String)"Tooltip key:").m_130940_(ChatFormatting.GRAY));
                status = I18n.m_118936_((String)this.tooltip) ? Component.m_237113_((String)"(\u2714 present)").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237113_((String)"(not present)").m_130940_(ChatFormatting.GOLD);
                lines.add((Component)Component.m_237113_((String)("   " + this.tooltip + " ")).m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)status));
            }
        } else {
            lines.add((Component)Component.m_237113_((String)"Tooltip key:").m_130940_(ChatFormatting.GRAY));
            lines.add((Component)Component.m_237113_((String)"   Error: couldn't map tooltip translation key").m_130940_(ChatFormatting.RED));
        }
        this.addTranslationsDebugInfo(lines);
        TextEntry.addTranslationsDebugSuffix(lines);
        return Optional.of(lines.toArray(new Component[0]));
    }

    @Override
    protected Void getGUI() {
        throw new IllegalArgumentException("Text entries do not have a value");
    }

    @Override
    public void put(CommentedConfig config, Void value) {
    }

    @Override
    public Void get(CommentedConfig config) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<Void, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        TextDescriptionBuilder valBuilder = (TextDescriptionBuilder)builder.startTextDescription(this::getDisplayName).setTooltipSupplier(() -> this.getTooltip(null));
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<Void, Void, Void, TextEntry, TextEntryBuilder, Builder>
    implements TextEntryBuilder {
        protected Supplier<Component> translationSupplier = null;

        public Builder() {
            super(null, EntryType.of(Void.class, new EntryType[0]));
        }

        public Builder(@Nullable Supplier<Component> supplier) {
            this();
            this.translationSupplier = supplier;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder text(Supplier<Component> supplier) {
            Builder copy = (Builder)this.copy();
            copy.translationSupplier = supplier;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder text(Component text) {
            return this.text(() -> text);
        }

        @Override
        @Deprecated
        @Contract(pure=true)
        @NotNull
        public TextEntryBuilder nameArgs(Object ... args) {
            return (TextEntryBuilder)super.nameArgs(args);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public TextEntryBuilder args(Object ... args) {
            return this.nameArgs(args);
        }

        @Override
        protected TextEntry buildEntry(ConfigEntryHolder parent, String name) {
            this.nonPersistent = true;
            TextEntry e = new TextEntry(parent, name);
            e.translationSupplier = this.translationSupplier;
            e.own = this.translationSupplier != null;
            return e;
        }

        @Override
        protected Builder createCopy(Void value) {
            Builder copy = new Builder();
            copy.translationSupplier = this.translationSupplier;
            return copy;
        }
    }
}

