/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.TagEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.entry.AbstractSerializableEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class TagEntry
extends AbstractSerializableEntry<Tag> {
    @ApiStatus.Internal
    public TagEntry(ConfigEntryHolder parent, String name, Tag value) {
        super(parent, name, value, Tag.class);
    }

    @Override
    protected String serialize(Tag value) {
        return new SnbtPrinterTagVisitor("", 0, (List)Lists.newArrayList()).m_178141_(value);
    }

    @Override
    @Nullable
    protected Tag deserialize(String value) {
        try {
            StringReader reader = new StringReader(value);
            Tag tag = new TagParser(reader).m_129371_();
            reader.skipWhitespace();
            return reader.canRead() ? null : tag;
        }
        catch (CommandSyntaxException ignored) {
            return null;
        }
    }

    @Override
    protected Optional<Component> getErrorMessage(String value) {
        return Optional.of(Component.m_237115_((String)"simpleconfig.config.error.invalid_nbt"));
    }

    @Override
    protected TextFormatter getTextFormatter() {
        return TextFormatter.forLanguageOrDefault("snbt", TextFormatter.DEFAULT);
    }

    public static class Builder
    extends AbstractSerializableEntry.Builder<Tag, TagEntry, TagEntryBuilder, Builder>
    implements TagEntryBuilder {
        public Builder(Tag value) {
            super(value, Tag.class);
        }

        @Override
        protected TagEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new TagEntry(parent, name, (Tag)this.value);
        }

        @Override
        @Contract(value="_ -> new", pure=true)
        protected Builder createCopy(Tag value) {
            return new Builder(value);
        }
    }
}

