/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.StringListEntryBuilder;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.core.entry.AbstractListEntry;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.StringListBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class StringListEntry
extends AbstractListEntry<String, String, String, StringListEntry> {
    public StringListEntry(ConfigEntryHolder parent, String name, List<String> value) {
        super(parent, name, value);
    }

    @Override
    @Nullable
    protected String getListTypeComment() {
        return "Text";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<List<String>, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        StringListBuilder valBuilder = builder.startStrList(this.getDisplayName(), (List)this.get());
        return Optional.of(this.decorate(valBuilder));
    }

    public static class Builder
    extends AbstractListEntry.Builder<String, String, String, StringListEntry, StringListEntryBuilder, Builder>
    implements StringListEntryBuilder {
        public Builder(List<String> value) {
            super(value, EntryType.of(String.class, new EntryType[0]));
        }

        @Override
        protected StringListEntry buildEntry(ConfigEntryHolder parent, String name) {
            return new StringListEntry(parent, name, (List)this.value);
        }

        @Override
        protected Builder createCopy(List<String> value) {
            return new Builder(new ArrayList<String>(value));
        }
    }
}

