/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import com.google.common.collect.Lists;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.StringEntryBuilder;
import endorh.simpleconfig.config.ClientConfig;
import endorh.simpleconfig.core.AbstractConfigEntry;
import endorh.simpleconfig.core.AbstractConfigEntryBuilder;
import endorh.simpleconfig.core.AtomicEntry;
import endorh.simpleconfig.core.EntryType;
import endorh.simpleconfig.ui.api.ConfigFieldBuilder;
import endorh.simpleconfig.ui.gui.widget.combobox.SimpleComboBoxModel;
import endorh.simpleconfig.ui.impl.builders.ComboBoxFieldBuilder;
import endorh.simpleconfig.ui.impl.builders.FieldBuilder;
import endorh.simpleconfig.ui.impl.builders.TextFieldBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class StringEntry
extends AbstractConfigEntry<String, String, String>
implements AtomicEntry<String> {
    protected Supplier<List<String>> choiceSupplier;
    protected SimpleComboBoxModel<String> suggestionProvider = new SimpleComboBoxModel(() -> this.choiceSupplier != null ? this.choiceSupplier.get() : Lists.newArrayList());
    protected boolean restrict;
    protected int maxLength;
    protected int minLength;

    @ApiStatus.Internal
    public StringEntry(ConfigEntryHolder parent, String name, String value) {
        super(parent, name, value);
    }

    public List<String> getChoices() {
        return this.choiceSupplier != null ? this.choiceSupplier.get() : null;
    }

    @Override
    @Nullable
    public String fromConfig(@Nullable String value) {
        List<String> choices;
        if (value == null) {
            return null;
        }
        if (this.restrict && (choices = this.getChoices()) != null && !choices.contains(value)) {
            return null;
        }
        return value;
    }

    @Override
    public Optional<Component> getErrorFromGUI(String value) {
        Optional<Component> opt = super.getErrorFromGUI(value);
        if (opt.isPresent()) {
            return opt;
        }
        if (value.length() < this.minLength) {
            return Optional.of(this.minLength == 1 ? Component.m_237115_((String)"simpleconfig.config.error.string.empty") : Component.m_237110_((String)"simpleconfig.config.error.string.min_length", (Object[])new Object[]{StringEntry.coloredNumber(this.minLength)}));
        }
        if (value.length() > this.maxLength) {
            return Optional.of(Component.m_237110_((String)"simpleconfig.config.error.string.max_length", (Object[])new Object[]{StringEntry.coloredNumber(this.maxLength)}));
        }
        return Optional.empty();
    }

    protected static MutableComponent coloredNumber(int number) {
        return Component.m_237113_((String)String.valueOf(number)).m_130940_(ChatFormatting.DARK_AQUA);
    }

    @Override
    public List<String> getConfigCommentTooltips() {
        List<String> choices;
        List<String> tooltips = super.getConfigCommentTooltips();
        boolean added = false;
        if (this.choiceSupplier != null && !(choices = this.getChoices()).isEmpty()) {
            int max = ClientConfig.advanced.max_options_in_config_comment;
            String omittedSuffix = choices.size() > max ? ", ... (omitted " + (choices.size() - max) + " more)" : "";
            String prefix = this.restrict ? "Options: " : "Suggestions: ";
            tooltips.add(prefix + choices.subList(0, Math.min(max, choices.size())).stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + omittedSuffix);
            added = true;
        }
        if (!added) {
            tooltips.add("Text");
        }
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<FieldBuilder<String, ?, ?>> buildGUIEntry(ConfigFieldBuilder builder) {
        if (this.choiceSupplier == null) {
            TextFieldBuilder valBuilder = builder.startTextField(this.getDisplayName(), (String)this.get()).setMaxLength(this.maxLength);
            return Optional.of(this.decorate(valBuilder));
        }
        ComboBoxFieldBuilder<String> valBuilder = builder.startComboBox(this.getDisplayName(), ComboBoxFieldBuilder.ofString(), (String)this.forGui((String)this.get())).setSuggestionMode(!this.restrict).setSuggestionProvider(this.suggestionProvider).setMaxLength(this.maxLength);
        return Optional.of(this.decorate(valBuilder));
    }

    @Override
    public boolean addCommandSuggestions(SuggestionsBuilder builder) {
        super.addCommandSuggestions(builder);
        Optional<List<String>> opt = this.suggestionProvider.updateSuggestions(ComboBoxFieldBuilder.ofString(), "");
        if (opt.isPresent()) {
            List<String> suggestions = opt.get();
            String current = (String)this.get();
            for (String s : suggestions) {
                if (current.equals(s) || ((String)this.defValue).equals(s)) continue;
                builder.suggest(s);
            }
        }
        return true;
    }

    public static class Builder
    extends AbstractConfigEntryBuilder<String, String, String, StringEntry, StringEntryBuilder, Builder>
    implements StringEntryBuilder {
        protected Supplier<List<String>> choiceSupplier = null;
        protected boolean restrict = false;
        protected int maxLength = Integer.MAX_VALUE;
        protected int minLength = 0;

        public Builder(String value) {
            super(value, EntryType.of(String.class, new EntryType[0]));
        }

        @Override
        @NotNull
        public StringEntryBuilder withValue(String value) {
            List<String> choices;
            if (this.restrict && this.choiceSupplier != null && !(choices = this.choiceSupplier.get()).contains(value)) {
                throw new IllegalArgumentException("New value for String entry (\"" + value + "\") is not in the choice list: [" + choices.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", ")) + "]");
            }
            return (StringEntryBuilder)super.withValue(value);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(String ... suggestions) {
            if (suggestions.length == 0) {
                Builder copy = (Builder)this.copy();
                copy.choiceSupplier = null;
                copy.restrict = false;
                return copy;
            }
            return this.suggest(Arrays.stream(suggestions).collect(Collectors.toList()));
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(@NotNull List<String> suggestions) {
            Builder copy = (Builder)this.copy();
            Objects.requireNonNull(suggestions);
            copy.choiceSupplier = () -> suggestions;
            copy.restrict = false;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder suggest(Supplier<List<String>> suggestionSupplier) {
            Builder copy = (Builder)this.copy();
            copy.choiceSupplier = suggestionSupplier;
            copy.restrict = false;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public StringEntryBuilder restrict(String first, String ... choices) {
            ArrayList<String> list = new ArrayList<String>(choices.length + 1);
            list.add(first);
            list.addAll(Arrays.asList(choices));
            if (!list.contains(this.value)) {
                return this.withValue(first).restrict(list);
            }
            return this.restrict(list);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder restrict(@NotNull List<String> choices) {
            Builder copy = (Builder)this.copy();
            if (choices.isEmpty()) {
                throw new IllegalArgumentException("At least one choice must be specified");
            }
            Objects.requireNonNull(choices);
            if (!choices.contains(this.value)) {
                throw new IllegalArgumentException("Default value is not included in choice list for String entry");
            }
            copy.choiceSupplier = () -> choices;
            copy.restrict = true;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder maxLength(@Range(from=0L, to=0x7FFFFFFFL) int maxLength) {
            Builder copy = (Builder)this.copy();
            copy.maxLength = maxLength;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder minLength(@Range(from=0L, to=0x7FFFFFFFL) int minLength) {
            Builder copy = (Builder)this.copy();
            copy.minLength = minLength;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder notEmpty() {
            return this.minLength(1);
        }

        @Override
        protected StringEntry buildEntry(ConfigEntryHolder parent, String name) {
            StringEntry entry = new StringEntry(parent, name, (String)this.value);
            entry.choiceSupplier = this.choiceSupplier;
            entry.restrict = this.restrict;
            entry.maxLength = this.maxLength;
            entry.minLength = this.minLength;
            return entry;
        }

        @Override
        protected Builder createCopy(String value) {
            Builder copy = new Builder(value);
            copy.choiceSupplier = this.choiceSupplier;
            copy.restrict = this.restrict;
            copy.maxLength = this.maxLength;
            copy.minLength = this.minLength;
            return copy;
        }
    }
}

