/*
 * Decompiled with CFR 0.152.
 */
package endorh.simpleconfig.core.entry;

import endorh.simpleconfig.api.ConfigEntryHolder;
import endorh.simpleconfig.api.entry.ConfigEntrySerializer;
import endorh.simpleconfig.api.entry.ISerializableConfigEntry;
import endorh.simpleconfig.api.entry.ISerializableEntryBuilder;
import endorh.simpleconfig.api.ui.TextFormatter;
import endorh.simpleconfig.core.BackingField;
import endorh.simpleconfig.core.entry.AbstractSerializableEntry;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableEntry<V>
extends AbstractSerializableEntry<V> {
    public Function<V, String> serializer;
    public Function<String, Optional<V>> deserializer;
    public TextFormatter textFormatter = TextFormatter.DEFAULT;

    @ApiStatus.Internal
    public SerializableEntry(ConfigEntryHolder parent, String name, V value, Function<V, String> serializer, Function<String, Optional<V>> deserializer, Class<?> typeClass) {
        super(parent, name, value, typeClass);
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    protected TextFormatter getTextFormatter() {
        return this.textFormatter;
    }

    @Override
    protected String serialize(V value) {
        return this.serializer.apply(value);
    }

    @Override
    @Nullable
    protected V deserialize(String value) {
        return this.deserializer.apply(value).orElse(null);
    }

    public static class SelfSerializableBuilder<V extends ISerializableConfigEntry<V>>
    extends Builder<V> {
        public SelfSerializableBuilder(V value) {
            super(value, value.getConfigSerializer());
        }
    }

    public static class Builder<V>
    extends AbstractSerializableEntry.Builder<V, SerializableEntry<V>, ISerializableEntryBuilder<V>, Builder<V>>
    implements ISerializableEntryBuilder<V> {
        protected Function<V, String> serializer;
        protected Function<String, Optional<V>> deserializer;
        protected TextFormatter formatter = TextFormatter.DEFAULT;

        public Builder(V value, Function<V, String> serializer, Function<String, Optional<V>> deserializer) {
            super(value);
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public Builder(V value, ConfigEntrySerializer<V> serializer) {
            this(value, serializer::serializeConfigEntry, serializer::deserializeConfigEntry);
            this.typeClass = serializer.getClass(value);
            this.backingFieldBuilder = BackingField.field(Function.identity(), this.typeClass).withCommitter(Function.identity());
            this.formatter = serializer.getConfigTextFormatter();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<V> fieldClass(Class<?> fieldClass) {
            Builder copy = (Builder)this.copy();
            copy.typeClass = fieldClass;
            return copy;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public Builder<V> setTextFormatter(TextFormatter formatter) {
            Builder copy = (Builder)this.copy();
            copy.formatter = formatter;
            return copy;
        }

        @Override
        protected SerializableEntry<V> buildEntry(ConfigEntryHolder parent, String name) {
            SerializableEntry<Object> entry = new SerializableEntry<Object>(parent, name, this.value, this.serializer, this.deserializer, this.typeClass);
            entry.textFormatter = this.formatter;
            return entry;
        }

        @Override
        protected Builder<V> createCopy(V value) {
            return new Builder<V>(value, this.serializer, this.deserializer);
        }
    }
}

